/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.aquatic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityTameableAquatic;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class MoCEntitySmallFish
extends MoCEntityTameableAquatic {
    public static final String[] fishNames = new String[]{"Anchovy", "Angelfish", "Goldfish", "Anglerfish", "Mandarin"};
    private int lateralMovCounter;

    public MoCEntitySmallFish(World world) {
        super(world);
        this.func_70105_a(0.3f, 0.3f);
        this.setMoCAge(30 + this.field_70146_Z.nextInt(70));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getType() == 0) {
            this.setType(this.field_70146_Z.nextInt(3) + 1);
        }
    }

    @Override
    public boolean checkSpawningBiome() {
        int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
        int yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v);
        BiomeGenBase currentBiome = MoCTools.biomekind(this.field_70170_p, xCoordinate, yCoordinate, zCoordinate);
        int typeChance = this.field_70146_Z.nextInt(100);
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            if (typeChance <= 30) {
                this.setType(4);
            } else {
                this.setType(5);
            }
            return true;
        }
        return true;
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("smallfish_anchovy.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("smallfish_angelfish.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("smallfish_goldfish.png");
            }
            case 4: {
                return MoCreatures.proxy.getTexture("smallfish_angler.png");
            }
            case 5: {
                return MoCreatures.proxy.getTexture("smallfish_manderin.png");
            }
        }
        return MoCreatures.proxy.getTexture("smallfish_anchovy.png");
    }

    @Override
    protected boolean canBeTrappedInNet() {
        return true;
    }

    protected void func_70628_a(boolean flag, int x) {
        int i = this.field_70146_Z.nextInt(100);
        if (i < 70) {
            this.func_70099_a(new ItemStack(Items.field_151115_aP, 1, 0), 0.0f);
        } else {
            int j = this.field_70146_Z.nextInt(2);
            for (int k = 0; k < j; ++k) {
                this.func_70099_a(new ItemStack(MoCreatures.mocegg, 1, this.getType() + 79), 0.0f);
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (MoCreatures.isServer() && !this.getIsAdult() && this.field_70146_Z.nextInt(500) == 0) {
            EntityLivingBase entityLiving;
            this.setMoCAge(this.getMoCAge() + 1);
            if (this.getMoCAge() >= 100) {
                this.setAdult(true);
            }
            if (!this.isNotScared() && this.field_70146_Z.nextInt(5) == 0 && !this.getIsTamed() && (entityLiving = MoCTools.getScaryEntity((Entity)this, 8.0)) != null && entityLiving.func_70055_a(Material.field_151586_h)) {
                MoCTools.runAway((EntityCreature)this, (Entity)entityLiving);
            }
            if (this.getIsTamed() && this.field_70146_Z.nextInt(100) == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(1.0f);
            }
        }
        if (!this.func_70055_a(Material.field_151586_h)) {
            this.field_70761_aq = this.field_70177_z = this.field_70126_B;
            this.field_70760_ar = this.field_70177_z;
            this.field_70125_A = this.field_70127_C;
        }
    }

    protected boolean isItemPlantMegaPackFishEdibleFreshWaterPlant(Item item) {
        return Item.field_150901_e.func_148750_c((Object)item).equals("plantmegapack:riverAmazonSword") || Item.field_150901_e.func_148750_c((Object)item).equals("plantmegapack:riverCanadianWaterweed") || Item.field_150901_e.func_148750_c((Object)item).equals("plantmegapack:riverCoonsTail") || Item.field_150901_e.func_148750_c((Object)item).equals("plantmegapack:waterCryptWendtii") || Item.field_150901_e.func_148750_c((Object)item).equals("plantmegapack:waterDwarfHairGrass") || Item.field_150901_e.func_148750_c((Object)item).equals("plantmegapack:riverEelgrass") || Item.field_150901_e.func_148750_c((Object)item).equals("plantmegapack:riverWaterWisteria");
    }

    @Override
    protected boolean isMyHealFood(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        List<String> oreDictionaryNameArray = MoCTools.getOreDictionaryEntries(itemStack);
        return item instanceof ItemSeeds || Item.field_150901_e.func_148750_c((Object)item).equals("etfuturum:beetroot_seeds") || Item.field_150901_e.func_148750_c((Object)item).equals("BiomesOPlenty:turnipSeeds") || this.getType() <= 3 && this.isItemPlantMegaPackFishEdibleFreshWaterPlant(item) || this.getType() == 5 && (MoCTools.isItemPlantMegaPackEdibleSaltWaterPlant(item) || Item.field_150901_e.func_148750_c((Object)item).equals("BiomesOPlenty:coral1") && itemStack.func_77960_j() == 11 || Item.field_150901_e.func_148750_c((Object)item).equals("etfuturum:kelp") || Item.field_150901_e.func_148750_c((Object)item).equals("harvestcraft:seaweedItem") || oreDictionaryNameArray.size() > 0 && (oreDictionaryNameArray.contains("cropKelp") || oreDictionaryNameArray.contains("cropSeaweed"))) || MoCreatures.isGregTech6Loaded && oreDictionaryNameArray.size() > 0 && (oreDictionaryNameArray.contains("listAllseed") || oreDictionaryNameArray.contains("foodRaisins"));
    }

    @Override
    public float getSizeFactor() {
        return (float)this.getMoCAge() * 0.01f;
    }

    @Override
    public float getAdjustedYOffset() {
        if (!this.func_70055_a(Material.field_151586_h)) {
            return -0.1f;
        }
        return 0.3f;
    }

    @Override
    protected boolean isFisheable() {
        return !this.getIsTamed();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int yawRotationOffset() {
        if (!this.func_70055_a(Material.field_151586_h)) {
            return 90;
        }
        if (this.field_70146_Z.nextInt(3) == 0 && ++this.lateralMovCounter > 40) {
            this.lateralMovCounter = 0;
        }
        int lateralOffset = 0;
        lateralOffset = this.lateralMovCounter < 21 ? this.lateralMovCounter : -this.lateralMovCounter + 40;
        return 80 + lateralOffset;
    }

    @Override
    public int rollRotationOffset() {
        if (!this.func_70055_a(Material.field_151586_h)) {
            return -90;
        }
        return 0;
    }

    @Override
    public boolean shouldRenderName() {
        return this.getShouldDisplayName() && this.field_70153_n == null;
    }

    @Override
    public int nameYOffset() {
        return -25;
    }

    @Override
    public float getAdjustedXOffset() {
        if (!this.func_70055_a(Material.field_151586_h)) {
            return -0.6f;
        }
        return 0.0f;
    }

    @Override
    public float getMoveSpeed() {
        return 0.3f;
    }
}

