/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.aquatic;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityTameableAquatic;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenOcean;

public class MoCEntityRay
extends MoCEntityTameableAquatic {
    private int poisonCounter;
    private int tailCounter;

    public MoCEntityRay(World world) {
        super(world);
        this.func_70105_a(1.8f, 0.5f);
        this.setMoCAge(50 + this.field_70146_Z.nextInt(50));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getType() == 0) {
            int i = this.field_70146_Z.nextInt(100);
            if (i <= 35) {
                this.setType(1);
                this.setMoCAge(80 + this.field_70146_Z.nextInt(100));
            } else {
                this.setType(1);
                this.setMoCAge(70);
            }
            this.func_110138_aP();
        }
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getType() == 2 ? 10.0 : 20.0);
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("mantray.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("stingray.png");
            }
        }
        return MoCreatures.proxy.getTexture("stingray.png");
    }

    @Override
    public float getMoveSpeed() {
        return 0.3f;
    }

    public boolean isPoisoning() {
        return this.tailCounter != 0;
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityPlayer) {
        if (super.func_70085_c(entityPlayer)) {
            return false;
        }
        if (this.field_70153_n == null && this.getType() == 1) {
            entityPlayer.field_70177_z = this.field_70177_z;
            entityPlayer.field_70125_A = this.field_70125_A;
            entityPlayer.field_70163_u = this.field_70163_u;
            if (!this.field_70170_p.field_72995_K) {
                entityPlayer.func_70078_a((Entity)this);
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (!this.getIsAdult() && this.field_70146_Z.nextInt(50) == 0) {
                this.setMoCAge(this.getMoCAge() + 1);
                if (this.getType() == 1 && this.getMoCAge() >= 180 || this.getType() > 1 && this.getMoCAge() >= 90) {
                    this.setAdult(true);
                }
            }
            if (!this.getIsTamed() && this.getType() > 1 && ++this.poisonCounter > 250 && this.field_70170_p.field_73013_u.func_151525_a() > 0 && this.field_70146_Z.nextInt(30) == 0 && MoCTools.findClosestPlayerAndPoisonThem((Entity)this, true)) {
                MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 1), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
                this.poisonCounter = 0;
            }
        } else if (this.tailCounter > 0 && ++this.tailCounter > 50) {
            this.tailCounter = 0;
        }
    }

    @Override
    public boolean isMyHealFood(ItemStack itemStack) {
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            List<String> oreDictionaryNameArray = MoCTools.getOreDictionaryEntries(itemStack);
            return item == Items.field_151115_aP && itemStack.func_77960_j() != 3 || oreDictionaryNameArray.contains("listAllfishraw");
        }
        return false;
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 1) {
            this.tailCounter = 1;
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        if (super.func_70097_a(damageSource, damageTaken)) {
            if (this.getType() == 1 || this.field_70170_p.field_73013_u.func_151525_a() == 0) {
                return true;
            }
            Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
            if (entityThatAttackedThisCreature != this) {
                this.field_70789_a = entityThatAttackedThisCreature;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean checkSpawningBiome() {
        int zCoordinate;
        int yCoordinate;
        int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
        BiomeGenBase biome = MoCTools.biomekind(this.field_70170_p, xCoordinate, yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v));
        if (!(biome instanceof BiomeGenOcean)) {
            this.setType(2);
        }
        return true;
    }

    @Override
    public float getAdjustedYOffset() {
        if (!this.isSwimming()) {
            return 0.09f;
        }
        if (this.getType() == 1) {
            return 0.15f;
        }
        return 0.25f;
    }

    @Override
    public boolean shouldRenderName() {
        return this.getShouldDisplayName() && this.field_70153_n == null;
    }

    @Override
    public int nameYOffset() {
        return -25;
    }

    @Override
    public boolean canBeTrappedInNet() {
        return true;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.15 * (double)this.getSizeFactor();
    }

    @Override
    public float getSizeFactor() {
        float sizeFactor = (float)this.getMoCAge() * 0.01f;
        if (sizeFactor > 1.5f) {
            sizeFactor = 1.5f;
        }
        return sizeFactor;
    }
}

