/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.aquatic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityTameableAquatic;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class MoCEntityMediumFish
extends MoCEntityTameableAquatic {
    public static final String[] fishNames = new String[]{"Salmon", "Cod", "Bass"};
    private int lateralMoveCounter;

    public MoCEntityMediumFish(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.3f);
        this.setMoCAge(30 + this.field_70146_Z.nextInt(70));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getType() == 0) {
            this.setType(this.field_70146_Z.nextInt(3) + 1);
        }
    }

    @Override
    public boolean checkSpawningBiome() {
        int zCoordinate;
        int yCoordinate;
        int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
        BiomeGenBase currentBiome = MoCTools.biomekind(this.field_70170_p, xCoordinate, yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v));
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            this.setType(3);
            return true;
        }
        int typeChance = this.field_70146_Z.nextInt(100);
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
            if (typeChance <= 40) {
                this.setType(1);
                this.setMoCAge(110);
            } else {
                this.setType(3);
            }
            return true;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            if (typeChance <= 50) {
                this.setType(1);
            } else {
                this.setType(2);
            }
            return true;
        }
        return true;
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("mediumfish_salmon.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("mediumfish_cod.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("mediumfish_bass.png");
            }
        }
        return MoCreatures.proxy.getTexture("mediumfish_salmon.png");
    }

    protected void func_70628_a(boolean flag, int x) {
        int i = this.field_70146_Z.nextInt(100);
        if (i < 70) {
            this.func_70099_a(new ItemStack(Items.field_151115_aP, 1, 0), 0.0f);
        } else if (this.getIsAdult()) {
            int amountOfEggsToDrop = this.field_70146_Z.nextInt(2);
            for (int index = 0; index < amountOfEggsToDrop; ++index) {
                this.func_70099_a(new ItemStack(MoCreatures.mocegg, 1, this.getType() + 69), 0.0f);
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (MoCreatures.isServer() && !this.getIsAdult() && this.field_70146_Z.nextInt(500) == 0) {
            EntityLivingBase entityLiving;
            this.setMoCAge(this.getMoCAge() + 1);
            if (this.getMoCAge() >= 110) {
                this.setAdult(true);
            }
            if (this.field_70146_Z.nextInt(5) == 0 && !this.getIsTamed() && (entityLiving = MoCTools.getScaryEntity((Entity)this, 8.0)) != null && entityLiving.func_70055_a(Material.field_151586_h)) {
                MoCTools.runAway((EntityCreature)this, (Entity)entityLiving);
            }
            if (this.getIsTamed() && this.field_70146_Z.nextInt(100) == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(1.0f);
            }
        }
        if (!this.func_70055_a(Material.field_151586_h)) {
            this.field_70761_aq = this.field_70177_z = this.field_70126_B;
            this.field_70760_ar = this.field_70177_z;
            this.field_70125_A = this.field_70127_C;
        }
    }

    @Override
    public boolean isMyHealFood(ItemStack itemStack) {
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            List<String> oreDictionaryNameArray = MoCTools.getOreDictionaryEntries(itemStack);
            return item == Items.field_151115_aP && itemStack.func_77960_j() != 3 || oreDictionaryNameArray.contains("listAllfishraw");
        }
        return false;
    }

    @Override
    public float getSizeFactor() {
        return (float)this.getMoCAge() * 0.01f;
    }

    @Override
    public float getAdjustedYOffset() {
        if (!this.func_70055_a(Material.field_151586_h)) {
            return -0.1f;
        }
        return 0.7f;
    }

    @Override
    protected boolean isFisheable() {
        return !this.getIsTamed();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int yawRotationOffset() {
        if (!this.func_70055_a(Material.field_151586_h)) {
            return 90;
        }
        if (this.field_70146_Z.nextInt(3) == 0 && ++this.lateralMoveCounter > 40) {
            this.lateralMoveCounter = 0;
        }
        int lateralOffset = 0;
        lateralOffset = this.lateralMoveCounter < 21 ? this.lateralMoveCounter : -this.lateralMoveCounter + 40;
        return 80 + lateralOffset;
    }

    @Override
    public int rollRotationOffset() {
        if (!this.func_70055_a(Material.field_151586_h)) {
            return -90;
        }
        return 0;
    }

    @Override
    public boolean shouldRenderName() {
        return this.getShouldDisplayName() && this.field_70153_n == null;
    }

    @Override
    public int nameYOffset() {
        return -30;
    }

    @Override
    public float getAdjustedZOffset() {
        return 0.0f;
    }

    @Override
    public float getAdjustedXOffset() {
        if (!this.func_70055_a(Material.field_151586_h)) {
            return -0.8f;
        }
        return 0.0f;
    }

    @Override
    protected boolean canBeTrappedInNet() {
        return true;
    }
}

