/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.animal;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.item.MoCEntityEgg;
import drzhark.mocreatures.inventory.MoCAnimalChest;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class MoCEntityWyvern
extends MoCEntityTameableAnimal {
    public MoCAnimalChest localchest;
    public ItemStack localItemstack;
    public int mouthCounter;
    public int wingFlapCounter;
    public int diveCounter;
    public static final String[] wyvernNames = new String[]{"Jungle", "Swamp", "Savanna", "Sand", "Mother", "Undead", "Light", "Dark", "Arctic", "Cave", "Mountain", "Sea"};

    public MoCEntityWyvern(World world) {
        super(world);
        this.func_70105_a(1.9f, 1.7f);
        this.setAdult(false);
        this.field_70138_W = 1.0f;
        if (this.field_70146_Z.nextInt(6) == 0) {
            this.setMoCAge(50 + this.field_70146_Z.nextInt(50));
        } else {
            this.setMoCAge(80 + this.field_70146_Z.nextInt(20));
        }
    }

    @Override
    public boolean isPredator() {
        return true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)0);
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)0);
    }

    public boolean getIsFlying() {
        return this.field_70180_af.func_75683_a(25) == 1;
    }

    public void setIsFlying(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(25, (Object)input);
    }

    @Override
    public byte getArmorType() {
        return this.field_70180_af.func_75683_a(24);
    }

    @Override
    public void setArmorType(byte i) {
        this.field_70180_af.func_75692_b(24, (Object)i);
    }

    @Override
    public boolean getIsRideable() {
        return this.field_70180_af.func_75683_a(22) == 1;
    }

    @Override
    public void setRideable(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(22, (Object)input);
    }

    public boolean getIsChested() {
        return this.field_70180_af.func_75683_a(23) == 1;
    }

    public void setIsChested(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(23, (Object)input);
    }

    public boolean getIsSitting() {
        return this.field_70180_af.func_75683_a(26) == 1;
    }

    public void setSitting(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(26, (Object)input);
    }

    @Override
    public void selectType() {
        if (this.getType() == 0) {
            int typeChance = this.field_70146_Z.nextInt(100);
            if (typeChance <= 12) {
                this.setType(1);
            } else if (typeChance <= 24) {
                this.setType(2);
            } else if (typeChance <= 36) {
                this.setType(3);
            } else if (typeChance <= 48) {
                this.setType(4);
            } else if (typeChance <= 60) {
                this.setType(9);
            } else if (typeChance <= 72) {
                this.setType(10);
            } else if (typeChance <= 84) {
                this.setType(11);
            } else if (typeChance <= 95) {
                this.setType(12);
            } else {
                this.setType(5);
            }
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getType() >= 5 ? 80.0 : 40.0);
            this.func_70606_j(this.func_110138_aP());
        }
    }

    @Override
    public boolean isNotScared() {
        return true;
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("wyvernjungle.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("wyvernmix.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("wyvernsand.png");
            }
            case 4: {
                return MoCreatures.proxy.getTexture("wyvernsun.png");
            }
            case 5: {
                return MoCreatures.proxy.getTexture("wyvernmother.png");
            }
            case 6: {
                return MoCreatures.proxy.getTexture("wyvernundead.png");
            }
            case 7: {
                return MoCreatures.proxy.getTexture("wyvernlight.png");
            }
            case 8: {
                return MoCreatures.proxy.getTexture("wyverndark.png");
            }
            case 9: {
                return MoCreatures.proxy.getTexture("wyvernarctic.png");
            }
            case 10: {
                return MoCreatures.proxy.getTexture("wyverncave.png");
            }
            case 11: {
                return MoCreatures.proxy.getTexture("wyvernmountain.png");
            }
            case 12: {
                return MoCreatures.proxy.getTexture("wyvernsea.png");
            }
        }
        return MoCreatures.proxy.getTexture("wyvernsun.png");
    }

    @Override
    public void func_70636_d() {
        if (!(this.field_70789_a == null || this.field_70789_a != this.field_70153_n || this.field_70153_n instanceof EntityPlayer && this.field_70153_n.func_70005_c_().equals(this.getOwnerName()))) {
            this.field_70153_n.func_70078_a(null);
        }
        if (!this.getIsFlying() && this.isOnAir() && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        if (this.mouthCounter > 0 && ++this.mouthCounter > 30) {
            this.mouthCounter = 0;
        }
        if (this.diveCounter > 0 && ++this.diveCounter > 5) {
            this.diveCounter = 0;
        }
        if (this.jumpPending) {
            if (this.wingFlapCounter == 0) {
                MoCTools.playCustomSound((Entity)this, "wingflap", this.field_70170_p);
            }
            this.wingFlapCounter = 1;
        }
        if (this.isOnAir() && this.field_70146_Z.nextInt(30) == 0) {
            this.wingFlapCounter = 1;
        }
        if (this.wingFlapCounter > 0 && ++this.wingFlapCounter > 20) {
            this.wingFlapCounter = 0;
        }
        if (this.isFlyingAlone()) {
            this.wingFlapCounter = 1;
        }
        if (MoCreatures.isServer()) {
            if (!this.getIsAdult() && this.field_70146_Z.nextInt(500) == 0) {
                this.setMoCAge(this.getMoCAge() + 1);
                if (this.getMoCAge() >= this.getMaxAge()) {
                    this.setAdult(true);
                }
            }
            if (this.isFlyingAlone() && this.field_70146_Z.nextInt(60) == 0 && !this.func_70780_i()) {
                this.wingFlap();
            }
            if (this.isFlyingAlone() && !this.func_70781_l() && !this.func_70780_i() && this.field_70789_a == null && this.field_70146_Z.nextInt(20) == 0) {
                this.func_70779_j();
            }
            if (this.field_70153_n != null) {
                this.setIsFlying(false);
            } else if (this.field_70789_a != null && this.field_70146_Z.nextInt(20) == 0) {
                this.setIsFlying(true);
            } else if (!this.getIsTamed() && this.field_70146_Z.nextInt(300) == 0) {
                this.setIsFlying(!this.getIsFlying());
            }
            if (!this.getIsTamed() && this.field_71093_bK == MoCreatures.wyvernLairDimensionID && this.field_70146_Z.nextInt(50) == 0 && this.field_70163_u < 10.0) {
                this.func_70106_y();
            }
        }
        if (this.field_70181_x > 0.5) {
            this.field_70181_x = 0.5;
        }
        super.func_70636_d();
    }

    public void wingFlap() {
        if (this.wingFlapCounter == 0) {
            MoCTools.playCustomSound((Entity)this, "wyvernwingflap", this.field_70170_p);
        }
        this.wingFlapCounter = 1;
        this.field_70181_x = 0.5;
    }

    @Override
    public float getSizeFactor() {
        return (float)this.getMoCAge() * 0.01f;
    }

    @Override
    public boolean isFlyingAlone() {
        return this.getIsFlying() && this.field_70153_n == null;
    }

    @Override
    public int flyingHeight() {
        return 18;
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityPlayer) {
        if (super.func_70085_c(entityPlayer)) {
            return false;
        }
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (this.getIsTamed() && itemStack != null) {
            Item item = itemStack.func_77973_b();
            if (!(this.getIsRideable() || this.getMoCAge() <= 90 || item != Items.field_151141_av && item != MoCreatures.craftedSaddle)) {
                if (--itemStack.field_77994_a == 0) {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                }
                this.setRideable(true);
                return true;
            }
            if (this.getMoCAge() > 90 && (item == Items.field_151138_bX || item == Items.field_151136_bY || item == Items.field_151125_bZ)) {
                if (this.getArmorType() == 0) {
                    MoCTools.playCustomSound((Entity)this, "armorput", this.field_70170_p);
                }
                byte armorType = 0;
                if (item == Items.field_151138_bX) {
                    armorType = 1;
                }
                if (item == Items.field_151136_bY) {
                    armorType = 2;
                }
                if (item == Items.field_151125_bZ) {
                    armorType = 3;
                }
                this.dropArmor();
                this.setArmorType(armorType);
                if (--itemStack.field_77994_a == 0) {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                }
                return true;
            }
            if (this.getMoCAge() > 90 && !this.getIsChested() && item == Item.func_150898_a((Block)Blocks.field_150486_ae)) {
                if (--itemStack.field_77994_a == 0) {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                }
                this.setIsChested(true);
                return true;
            }
            if (item == MoCreatures.essenceLight && this.getMoCAge() > 90 && this.getType() < 5) {
                if (--itemStack.field_77994_a == 0) {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, new ItemStack(Items.field_151069_bo));
                } else {
                    entityPlayer.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
                }
                if (MoCreatures.isServer()) {
                    int eggType = this.getType() + 49;
                    MoCEntityEgg entityegg = new MoCEntityEgg(this.field_70170_p, eggType);
                    entityegg.func_70107_b(entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v);
                    entityPlayer.field_70170_p.func_72838_d((Entity)entityegg);
                    entityegg.field_70181_x += (double)(this.field_70170_p.field_73012_v.nextFloat() * 0.05f);
                    entityegg.field_70159_w += (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.3f);
                    entityegg.field_70179_y += (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.3f);
                }
                return true;
            }
            if (this.getType() == 5) {
                if (item == MoCreatures.essenceUndead) {
                    if (--itemStack.field_77994_a == 0) {
                        entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, new ItemStack(Items.field_151069_bo));
                    } else {
                        entityPlayer.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
                    }
                    if (MoCreatures.isServer()) {
                        this.setType(6);
                    }
                    return true;
                }
                if (item == MoCreatures.essenceLight) {
                    if (--itemStack.field_77994_a == 0) {
                        entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, new ItemStack(Items.field_151069_bo));
                    } else {
                        entityPlayer.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
                    }
                    if (MoCreatures.isServer()) {
                        this.setType(7);
                    }
                    return true;
                }
                if (item == MoCreatures.essenceDarkness) {
                    if (--itemStack.field_77994_a == 0) {
                        entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, new ItemStack(Items.field_151069_bo));
                    } else {
                        entityPlayer.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
                    }
                    if (MoCreatures.isServer()) {
                        this.setType(8);
                    }
                    return true;
                }
            }
        }
        if (MoCreatures.proxy.emptyHandMountAndPickUpOnly && itemStack == null || !MoCreatures.proxy.emptyHandMountAndPickUpOnly) {
            if (entityPlayer.func_70093_af() && this.getIsChested()) {
                if (this.localchest == null) {
                    this.localchest = new MoCAnimalChest(StatCollector.func_74838_a((String)"container.MoCreatures.WyvernChest"), 14);
                }
                if (MoCreatures.isServer()) {
                    entityPlayer.func_71007_a((IInventory)this.localchest);
                }
                return true;
            }
            if (!entityPlayer.func_70093_af() && this.getIsRideable() && this.getMoCAge() > 90 && this.field_70153_n == null && entityPlayer.field_70153_n == null && MoCreatures.isServer()) {
                entityPlayer.field_70177_z = this.field_70177_z;
                entityPlayer.field_70125_A = this.field_70125_A;
                entityPlayer.func_70078_a((Entity)this);
                this.setSitting(false);
            }
            return true;
        }
        return false;
    }

    @Override
    public void dropArmor() {
        byte armorType;
        if (MoCreatures.isServer() && (armorType = this.getArmorType()) > 0) {
            MoCTools.playCustomSound((Entity)this, "armoroff", this.field_70170_p);
            Item itemToDrop = Items.field_151055_y;
            switch (armorType) {
                case 1: {
                    itemToDrop = Items.field_151138_bX;
                    break;
                }
                case 2: {
                    itemToDrop = Items.field_151136_bY;
                    break;
                }
                case 3: {
                    itemToDrop = Items.field_151125_bZ;
                }
            }
            this.setArmorType((byte)0);
            EntityItem entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(itemToDrop, 1));
            entityItem.field_145804_b = 10;
            this.field_70170_p.func_72838_d((Entity)entityItem);
        }
    }

    @Override
    public boolean rideableEntity() {
        return true;
    }

    protected String func_70673_aS() {
        return "mocreatures:wyverndying";
    }

    protected String func_70621_aR() {
        this.openMouth();
        return "mocreatures:wyvernhurt";
    }

    protected String func_70639_aQ() {
        this.openMouth();
        return "mocreatures:wyverngrunt";
    }

    public int func_70627_aG() {
        return 400;
    }

    protected boolean func_70780_i() {
        return this.field_70153_n != null || this.getIsSitting();
    }

    @Override
    public boolean isFlyer() {
        return true;
    }

    protected void func_70069_a(float f) {
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.9 * (double)this.getSizeFactor();
    }

    public void func_70043_V() {
        double dist = (double)this.getSizeFactor() * 0.3;
        double newPosX = this.field_70165_t - dist * Math.cos(MoCTools.realAngle(this.field_70761_aq - 90.0f) / 57.29578f);
        double newPosZ = this.field_70161_v - dist * Math.sin(MoCTools.realAngle(this.field_70761_aq - 90.0f) / 57.29578f);
        this.field_70153_n.func_70107_b(newPosX, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W(), newPosZ);
    }

    protected void func_70785_a(Entity entity, float distanceToEntity) {
        if (this.field_70724_aR <= 0 && (double)distanceToEntity < 3.0 && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            boolean poisonChance;
            this.field_70724_aR = 20;
            boolean bl = poisonChance = this.field_70146_Z.nextInt(3) == 0;
            if (poisonChance) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 200, 0));
                MoCTools.playCustomSound((Entity)this, "wyvernpoisoning", this.field_70170_p);
            }
            int wyvernAttackDamage = 5;
            if (this.getType() >= 5) {
                wyvernAttackDamage = 10;
            }
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)wyvernAttackDamage);
            this.openMouth();
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        float vanillaHorseArmorProtection = 3.7f * (float)this.getArmorType();
        if ((damageTaken *= 1.0f - vanillaHorseArmorProtection * 0.04f) < 0.0f) {
            damageTaken = 0.0f;
        }
        if (super.func_70097_a(damageSource, damageTaken)) {
            Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
            if (entityThatAttackedThisCreature != null && this.getIsTamed() && entityThatAttackedThisCreature instanceof EntityPlayer && entityThatAttackedThisCreature.func_70005_c_().equals(this.getOwnerName())) {
                return false;
            }
            if (this.field_70153_n != null && entityThatAttackedThisCreature == this.field_70153_n) {
                return false;
            }
            if (entityThatAttackedThisCreature != this && this.field_70170_p.field_73013_u.func_151525_a() > 0) {
                this.field_70789_a = entityThatAttackedThisCreature;
            }
            return true;
        }
        return super.func_70097_a(damageSource, damageTaken);
    }

    @Override
    protected Entity func_70782_k() {
        EntityLivingBase entityThatAttackedOwner;
        double distanceToOwner;
        EntityPlayerMP ownerOfEntityThatIsOnline;
        if (this.field_70170_p.field_73013_u.func_151525_a() > 0 && !this.getIsTamed()) {
            EntityPlayer entityPlayer = this.field_70170_p.func_72856_b((Entity)this, 10.0);
            if (entityPlayer != null) {
                return entityPlayer;
            }
            if (this.field_70146_Z.nextInt(500) == 0) {
                EntityLivingBase entityLiving = MoCTools.getClosestEntityLivingThatCanBeTargetted((Entity)this, 8.0);
                return entityLiving;
            }
        }
        if (MoCreatures.proxy.specialPetsDefendOwner && this.getIsTamed() && this.field_70153_n == null && !this.getIsSitting() && (ownerOfEntityThatIsOnline = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(this.getOwnerName())) != null && (distanceToOwner = MoCTools.getSqDistanceTo((Entity)this, ownerOfEntityThatIsOnline.field_70165_t, ownerOfEntityThatIsOnline.field_70163_u, ownerOfEntityThatIsOnline.field_70161_v)) < 20.0 && (entityThatAttackedOwner = ownerOfEntityThatIsOnline.func_70643_av()) != null) {
            return entityThatAttackedOwner;
        }
        return null;
    }

    @Override
    public boolean shouldEntityBeIgnored(Entity entity) {
        return super.shouldEntityBeIgnored(entity) || entity instanceof MoCEntityWyvern || entity instanceof EntityPlayer;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("Saddle", this.getIsRideable());
        nbtTagCompound.func_74757_a("Chested", this.getIsChested());
        nbtTagCompound.func_74774_a("ArmorType", this.getArmorType());
        nbtTagCompound.func_74757_a("isSitting", this.getIsSitting());
        if (this.getIsChested() && this.localchest != null) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.localchest.func_70302_i_(); ++i) {
                this.localItemstack = this.localchest.func_70301_a(i);
                if (this.localItemstack == null) continue;
                NBTTagCompound nbtTagCompound1 = new NBTTagCompound();
                nbtTagCompound1.func_74774_a("Slot", (byte)i);
                this.localItemstack.func_77955_b(nbtTagCompound1);
                nbttaglist.func_74742_a((NBTBase)nbtTagCompound1);
            }
            nbtTagCompound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setRideable(nbtTagCompound.func_74767_n("Saddle"));
        this.setIsChested(nbtTagCompound.func_74767_n("Chested"));
        this.setArmorType(nbtTagCompound.func_74771_c("ArmorType"));
        this.setSitting(nbtTagCompound.func_74767_n("isSitting"));
        if (this.getIsChested()) {
            NBTTagList nbttaglist = nbtTagCompound.func_150295_c("Items", 10);
            this.localchest = new MoCAnimalChest(StatCollector.func_74838_a((String)"container.MoCreatures.WyvernChest"), 14);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbtTagCompound1 = nbttaglist.func_150305_b(i);
                int j = nbtTagCompound1.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.localchest.func_70302_i_()) continue;
                this.localchest.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound1));
            }
        }
    }

    @Override
    public double roperYOffset() {
        if (this.getIsAdult()) {
            return 0.0;
        }
        return (double)(130 - this.getMoCAge()) * 0.01;
    }

    @Override
    public int nameYOffset() {
        if (this.getIsAdult()) {
            return -120;
        }
        return -80;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isMyHealFood(ItemStack itemStack) {
        if (itemStack == null) return false;
        if (itemStack.func_77973_b() == MoCreatures.ratRaw) return true;
        if (itemStack.func_77973_b() == MoCreatures.turkeyRaw) return true;
        itemStack.func_77973_b();
        if (Item.field_150901_e.func_148750_c((Object)itemStack.func_77973_b()).equals("etfuturum:rabbit_raw")) return true;
        itemStack.func_77973_b();
        if (Item.field_150901_e.func_148750_c((Object)itemStack.func_77973_b()).equals("harvestcraft:rabbitrawItem")) return true;
        if (!MoCreatures.isGregTech6Loaded) return false;
        if (OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)itemStack)) != "foodScrapmeat") return false;
        return true;
    }

    private void openMouth() {
        if (MoCreatures.isServer()) {
            this.mouthCounter = 1;
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 1), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 1) {
            this.mouthCounter = 1;
        }
        if (animationType == 2) {
            this.diveCounter = 1;
        }
    }

    @Override
    public void makeEntityDive() {
        if (MoCreatures.isServer()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 2), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        super.makeEntityDive();
    }

    protected void func_70628_a(boolean flag, int x) {
        int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
        int yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v);
        int eggDropChance = MoCreatures.proxy.wyvernEggDropChance;
        if (this.getType() == 5) {
            eggDropChance = MoCreatures.proxy.motherWyvernEggDropChance;
        }
        MoCTools.biomeName(this.field_70170_p, xCoordinate, yCoordinate, zCoordinate);
        if (this.field_70146_Z.nextInt(100) < eggDropChance) {
            this.func_70099_a(new ItemStack(MoCreatures.mocegg, 1, this.getType() + 49), 0.0f);
        }
    }

    @Override
    public void dropMyStuff() {
        if (MoCreatures.isServer()) {
            this.dropArmor();
            MoCTools.dropSaddle(this, this.field_70170_p);
            if (this.getIsChested()) {
                MoCTools.dropInventory((Entity)this, this.localchest);
                MoCTools.dropCustomItem((Entity)this, this.field_70170_p, new ItemStack((Block)Blocks.field_150486_ae, 1));
                this.setIsChested(false);
            }
        }
    }

    @Override
    public float getAdjustedYOffset() {
        if (this.getIsSitting()) {
            return 0.4f;
        }
        return 0.0f;
    }

    @Override
    public double getCustomSpeed() {
        if (this.field_70153_n != null) {
            if (this.getType() < 5) {
                return 1.46;
            }
            return 1.5;
        }
        return 0.8;
    }

    private int getMaxAge() {
        if (this.getType() >= 5) {
            return 180;
        }
        return 100;
    }

    public EnumCreatureAttribute func_70668_bt() {
        if (this.getType() == 6) {
            return EnumCreatureAttribute.UNDEAD;
        }
        return super.func_70668_bt();
    }

    @Override
    public boolean isSwimmerEntity() {
        return true;
    }
}

