/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.animal;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MoCEntityTurtle
extends MoCEntityTameableAnimal {
    private boolean isSwinging;
    private boolean twistRight;
    private int flopCounter;

    public MoCEntityTurtle(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.4f);
        this.setAdult(false);
        this.setMoCAge(110);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
    }

    @Override
    public ResourceLocation getTexture() {
        String textureName = "turtle.png";
        if (this.isNameLeonardo()) {
            textureName = "turtlel.png";
        }
        if (this.isNameRaphael()) {
            textureName = "turtler.png";
        }
        if (this.isNameDonatello()) {
            textureName = "turtled.png";
        }
        if (this.isNameMichelangelo()) {
            textureName = "turtlem.png";
        }
        return MoCreatures.proxy.getTexture(textureName);
    }

    @Override
    public float getMoveSpeed() {
        return 0.3f;
    }

    public boolean getIsHiding() {
        return this.field_70180_af.func_75683_a(22) == 1;
    }

    public boolean getIsUpsideDown() {
        return this.field_70180_af.func_75683_a(23) == 1;
    }

    public void setIsHiding(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(22, (Object)input);
    }

    public void setIsUpsideDown(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(23, (Object)input);
    }

    public double func_70033_W() {
        if (this.field_70154_o instanceof EntityPlayer && this.field_70154_o == MoCreatures.proxy.getPlayer() && !MoCreatures.isServer()) {
            return this.field_70129_M - (1.0f + (float)this.getMoCAge() * 0.01f / 6.0f);
        }
        if (this.field_70154_o instanceof EntityPlayer && !MoCreatures.isServer()) {
            return this.field_70129_M + 0.3f;
        }
        return this.field_70129_M;
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityPlayer) {
        if (super.func_70085_c(entityPlayer)) {
            return false;
        }
        if (this.getIsTamed()) {
            ItemStack itemStack = entityPlayer.func_70694_bm();
            if (this.getIsUpsideDown()) {
                this.flipFlop(false);
                return true;
            }
            if (this.field_70154_o == null) {
                this.field_70177_z = entityPlayer.field_70177_z;
                if (MoCreatures.isServer() && (MoCreatures.proxy.emptyHandMountAndPickUpOnly && itemStack == null || !MoCreatures.proxy.emptyHandMountAndPickUpOnly) && entityPlayer.field_70154_o == null) {
                    this.func_70078_a((Entity)entityPlayer);
                }
            } else {
                if (MoCreatures.isServer() && (MoCreatures.proxy.emptyHandMountAndPickUpOnly && itemStack == null || !MoCreatures.proxy.emptyHandMountAndPickUpOnly)) {
                    this.func_70078_a(null);
                }
                this.field_70159_w = entityPlayer.field_70159_w * 5.0;
                this.field_70181_x = entityPlayer.field_70181_x / 2.0 + 0.2;
                this.field_70179_y = entityPlayer.field_70179_y * 5.0;
            }
            return true;
        }
        this.flipFlop(!this.getIsUpsideDown());
        return true;
    }

    protected void func_70664_aZ() {
        if (this.func_70055_a(Material.field_151586_h)) {
            this.field_70181_x = 0.3;
            if (this.func_70051_ag()) {
                float f = this.field_70177_z * 0.01745329f;
                this.field_70159_w -= (double)(MathHelper.func_76126_a((float)f) * 0.2f);
                this.field_70179_y += (double)(MathHelper.func_76134_b((float)f) * 0.2f);
            }
            this.field_70160_al = true;
        }
    }

    @Override
    public boolean isNotScared() {
        return true;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.field_70154_o != null) {
            this.func_70626_be();
        }
        if (!this.field_70170_p.field_72995_K) {
            EntityPlayer entityPlayer;
            if (!this.getIsUpsideDown() && !this.getIsTamed()) {
                EntityLivingBase entityLiving = MoCTools.getScaryEntity((Entity)this, 4.0);
                if (entityLiving != null && this.func_70685_l((Entity)entityLiving)) {
                    if (!this.getIsHiding()) {
                        this.func_85030_a("mocreatures:turtlehissing", 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
                        this.setIsHiding(true);
                    }
                    this.func_70778_a(null);
                } else {
                    EntityItem entityItem;
                    this.setIsHiding(false);
                    if (!this.func_70781_l() && this.field_70146_Z.nextInt(50) == 0 && (entityItem = MoCTools.getClosestSpecificEntityItemItemNearby((Entity)this, 10.0, Items.field_151127_ba, Items.field_151120_aE)) != null) {
                        float f = entityItem.func_70032_d((Entity)this);
                        if (f > 2.0f) {
                            this.getMyOwnPath((Entity)entityItem, f);
                        }
                        if (f < 2.0f && entityItem != null && this.field_70725_aQ == 0) {
                            entityItem.func_70106_y();
                            MoCTools.playCustomSound((Entity)this, "eating", this.field_70170_p);
                            EntityPlayer entityPlayer2 = this.field_70170_p.func_72890_a((Entity)this, 24.0);
                            if (entityPlayer2 != null) {
                                MoCTools.tameWithName(entityPlayer2, this);
                            }
                        }
                    }
                }
            }
            if (!this.getIsUpsideDown() && this.getIsTamed() && this.field_70146_Z.nextInt(20) == 0 && (entityPlayer = this.field_70170_p.func_72890_a((Entity)this, 12.0)) != null) {
                PathEntity pathEntity = this.field_70170_p.func_72865_a((Entity)this, (Entity)entityPlayer, 16.0f, true, false, false, true);
                this.func_70778_a(pathEntity);
            }
        }
    }

    @Override
    public boolean isSwimmerEntity() {
        return true;
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        if (this.getIsHiding()) {
            if (this.field_70146_Z.nextInt(10) == 0) {
                this.flipFlop(true);
            }
            return false;
        }
        boolean flag = super.func_70097_a(damageSource, damageTaken);
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.flipFlop(true);
        }
        return flag;
    }

    public void flipFlop(boolean flip) {
        this.field_70788_c = 0;
        this.setIsUpsideDown(flip);
        this.setIsHiding(false);
        this.func_70778_a(null);
    }

    @Override
    protected void func_70626_be() {
        if (this.field_70154_o != null && this.field_70154_o instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)this.field_70154_o;
            if (entityPlayer != null) {
                this.field_70177_z = entityPlayer.field_70177_z;
            }
        } else {
            super.func_70626_be();
        }
    }

    @Override
    public boolean shouldEntityBeIgnored(Entity entity) {
        return entity instanceof MoCEntityTurtle || entity.field_70131_O <= this.field_70131_O && entity.field_70130_N <= this.field_70130_N || super.shouldEntityBeIgnored(entity);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getIsTamed() && this.getMoCAge() < 300 && this.field_70146_Z.nextInt(800) == 0) {
            this.setMoCAge(this.getMoCAge() + 1);
        }
        if (this.getIsUpsideDown() && this.field_70154_o == null && this.field_70146_Z.nextInt(20) == 0) {
            this.setSwinging(true);
            ++this.flopCounter;
        }
        if (this.getIsSwinging()) {
            boolean flag;
            this.field_70733_aJ += 0.2f;
            boolean bl = flag = this.flopCounter > this.field_70146_Z.nextInt(3) + 8;
            if (this.field_70733_aJ > 2.0f && (!flag || this.field_70146_Z.nextInt(20) == 0)) {
                this.setSwinging(false);
                this.field_70733_aJ = 0.0f;
                if (this.field_70146_Z.nextInt(2) == 0) {
                    this.twistRight = !this.twistRight;
                }
            } else if (this.field_70733_aJ > 9.0f && flag) {
                this.setSwinging(false);
                this.field_70733_aJ = 0.0f;
                this.func_85030_a("mob.chicken.plop", 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
                this.setIsUpsideDown(false);
                this.flopCounter = 0;
            }
        }
    }

    public boolean getIsSwinging() {
        return this.isSwinging;
    }

    public void setSwinging(boolean flag) {
        this.isSwinging = flag;
    }

    protected boolean func_70780_i() {
        return this.getIsUpsideDown() || this.getIsHiding();
    }

    @Override
    public boolean shouldRenderName() {
        return this.getShouldDisplayName() && this.field_70154_o == null;
    }

    public int getFlipDirection() {
        if (this.twistRight) {
            return 1;
        }
        return -1;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setIsUpsideDown(nbtTagCompound.func_74767_n("UpsideDown"));
        this.setDisplayName(nbtTagCompound.func_74767_n("DisplayName"));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("UpsideDown", this.getIsUpsideDown());
        nbtTagCompound.func_74757_a("DisplayName", this.getShouldDisplayName());
    }

    protected String func_70621_aR() {
        return "mocreatures:turtlehurt";
    }

    protected String func_70639_aQ() {
        return null;
    }

    protected String func_70673_aS() {
        return "mocreatures:turtledying";
    }

    protected void func_70628_a(boolean hasEntityBeenHitByPlayer, int levelOfLootingEnchantmentUsedToKillThisEntity) {
        if (!this.isTeenageMutantNinjaTurtle()) {
            int randomAmount = this.field_70146_Z.nextInt(3);
            this.func_145779_a(MoCreatures.turtleRaw, randomAmount);
        }
        if (this.isNameLeonardo()) {
            this.func_145779_a(MoCreatures.katana, 1);
        }
        if (this.isNameRaphael()) {
            this.func_145779_a(MoCreatures.sai, 1);
        }
        if (this.isNameDonatello()) {
            this.func_145779_a(MoCreatures.bo, 1);
        }
        if (this.isNameMichelangelo()) {
            this.func_145779_a(MoCreatures.nunchaku, 1);
        }
    }

    private boolean isNameLeonardo() {
        String nameOfTurtle = this.getName();
        String nameOfTurtleAsByteArrayString = Arrays.toString(nameOfTurtle.getBytes(StandardCharsets.UTF_8));
        String leonardoInChineseSimplifiedAsByteArrayString = "[-24, -114, -79, -26, -104, -126, -25, -70, -77, -27, -92, -102]";
        String leonardoInRussianAsByteArrayString = "[-48, -101, -48, -75, -48, -66, -48, -67, -48, -80, -47, -128, -48, -76, -48, -66]";
        return nameOfTurtle.equals("Leonardo") || nameOfTurtleAsByteArrayString.equals(leonardoInChineseSimplifiedAsByteArrayString) || nameOfTurtleAsByteArrayString.equals(leonardoInRussianAsByteArrayString);
    }

    private boolean isNameRaphael() {
        String nameOfTurtle = this.getName();
        String nameOfTurtleAsByteArrayString = Arrays.toString(nameOfTurtle.getBytes(StandardCharsets.UTF_8));
        String rapaelInChineseSimplifiedAsByteArrayString = "[-26, -117, -119, -26, -106, -112, -27, -80, -108]";
        String raphaelInRussianAsByteArrayString = "[-48, -96, -48, -80, -47, -124, -48, -80, -47, -115, -48, -69, -47, -116]";
        return nameOfTurtle.equals("Raphael") || nameOfTurtleAsByteArrayString.equals(rapaelInChineseSimplifiedAsByteArrayString) || nameOfTurtleAsByteArrayString.equals(raphaelInRussianAsByteArrayString);
    }

    private boolean isNameDonatello() {
        String nameOfTurtle = this.getName();
        String nameOfTurtleAsByteArrayString = Arrays.toString(nameOfTurtle.getBytes(StandardCharsets.UTF_8));
        String donatelloInChineseSimplifiedAsByteArrayString = "[-27, -92, -102, -27, -80, -68]";
        String donatelloInRussianAsByteArrayString = "[-48, -108, -48, -66, -48, -67, -48, -80, -47, -126, -48, -75, -48, -69, -48, -69, -48, -66]";
        return nameOfTurtle.equals("Donatello") || nameOfTurtleAsByteArrayString.equals(donatelloInChineseSimplifiedAsByteArrayString) || nameOfTurtleAsByteArrayString.equals(donatelloInRussianAsByteArrayString);
    }

    private boolean isNameMichelangelo() {
        String nameOfTurtle = this.getName();
        String nameOfTurtleAsByteArrayString = Arrays.toString(nameOfTurtle.getBytes(StandardCharsets.UTF_8));
        String michelangeloInChineseSimplifiedAsByteArrayString = "[-25, -79, -77, -27, -68, -128, -26, -100, -105, -25, -112, -86, -25, -67, -105]";
        String michelangeloInRussianAsByteArrayString = "[-48, -100, -48, -72, -48, -70, -48, -75, -48, -69, -48, -80, -48, -67, -48, -76, -48, -74, -48, -75, -48, -69, -48, -66]";
        return nameOfTurtle.equals("Michelangelo") || nameOfTurtleAsByteArrayString.equals(michelangeloInChineseSimplifiedAsByteArrayString) || nameOfTurtleAsByteArrayString.equals(michelangeloInRussianAsByteArrayString);
    }

    public boolean isTeenageMutantNinjaTurtle() {
        return this.isNameLeonardo() || this.isNameRaphael() || this.isNameDonatello() || this.isNameMichelangelo();
    }

    @Override
    public boolean updateMount() {
        return this.getIsTamed();
    }

    @Override
    public boolean forceUpdates() {
        return this.getIsTamed();
    }

    @Override
    public boolean isMyHealFood(ItemStack itemStack) {
        if (itemStack != null) {
            List<String> oreDictionaryNameArray = MoCTools.getOreDictionaryEntries(itemStack);
            return itemStack.func_77973_b() == Items.field_151120_aE || itemStack.func_77973_b() == Items.field_151127_ba || oreDictionaryNameArray.size() > 0 && oreDictionaryNameArray.contains("listAllveggie") || oreDictionaryNameArray.contains("listAllfruit");
        }
        return false;
    }

    public int func_70641_bl() {
        return 2;
    }
}

