/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.animal;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityAnimal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class MoCEntityMouse
extends MoCEntityAnimal {
    public MoCEntityMouse(World world) {
        super(world);
        this.func_70105_a(0.3f, 0.3f);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getType() == 0) {
            this.setType(this.field_70146_Z.nextInt(3) + 1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("miceg.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("miceb.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("micew.png");
            }
        }
        return MoCreatures.proxy.getTexture("miceg.png");
    }

    @Override
    public boolean checkSpawningBiome() {
        int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
        int yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v);
        BiomeGenBase currentBiome = MoCTools.biomekind(this.field_70170_p, xCoordinate, yCoordinate, zCoordinate);
        MoCTools.biomeName(this.field_70170_p, xCoordinate, yCoordinate, zCoordinate);
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            this.setType(3);
        }
        return true;
    }

    @Override
    public float getMoveSpeed() {
        return 0.8f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)0);
    }

    public boolean getIsPicked() {
        return this.field_70180_af.func_75683_a(22) == 1;
    }

    public void setPicked(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(22, (Object)input);
    }

    public boolean climbing() {
        return !this.field_70122_E && this.func_70617_f_();
    }

    @Override
    public boolean entitiesThatAreScary(Entity entity) {
        return !(entity instanceof MoCEntityMouse) && super.entitiesThatAreScary(entity);
    }

    @Override
    public boolean func_70601_bi() {
        int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
        int yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v);
        return MoCreatures.entityMap.get(this.getClass()).getFrequency() > 0 && this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).size() == 0 && !this.field_70170_p.func_72953_d(this.field_70121_D) && (this.field_70170_p.func_147439_a(xCoordinate, yCoordinate - 1, zCoordinate) == Blocks.field_150347_e || this.field_70170_p.func_147439_a(xCoordinate, yCoordinate - 1, zCoordinate) == Blocks.field_150344_f || this.field_70170_p.func_147439_a(xCoordinate, yCoordinate - 1, zCoordinate) == Blocks.field_150346_d || this.field_70170_p.func_147439_a(xCoordinate, yCoordinate - 1, zCoordinate) == Blocks.field_150348_b || this.field_70170_p.func_147439_a(xCoordinate, yCoordinate - 1, zCoordinate) == Blocks.field_150349_c);
    }

    protected String func_70673_aS() {
        return "mocreatures:micedying";
    }

    protected Item func_146068_u() {
        return Items.field_151014_N;
    }

    protected String func_70621_aR() {
        return "mocreatures:micehurt";
    }

    protected String func_70639_aQ() {
        return "mocreatures:micegrunt";
    }

    public double func_70033_W() {
        if (this.field_70154_o instanceof EntityPlayer && this.field_70154_o == MoCreatures.proxy.getPlayer() && !MoCreatures.isServer()) {
            return this.field_70129_M - 1.7f;
        }
        if (this.field_70154_o instanceof EntityPlayer && !MoCreatures.isServer()) {
            return this.field_70129_M - 0.1f;
        }
        return this.field_70129_M;
    }

    public boolean func_70085_c(EntityPlayer entityPlayer) {
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (MoCreatures.proxy.emptyHandMountAndPickUpOnly && itemStack == null || !MoCreatures.proxy.emptyHandMountAndPickUpOnly) {
            this.field_70177_z = entityPlayer.field_70177_z;
            if (this.field_70154_o == null) {
                if (MoCreatures.isServer() && !entityPlayer.func_70093_af() && entityPlayer.field_70154_o == null) {
                    this.func_70078_a((Entity)entityPlayer);
                    this.setPicked(true);
                }
            } else {
                this.setPicked(false);
                if (MoCreatures.isServer()) {
                    this.func_70078_a(null);
                }
                this.field_70143_R = -3.0f;
                return false;
            }
            this.field_70159_w = entityPlayer.field_70159_w * 5.0;
            this.field_70181_x = entityPlayer.field_70181_x / 2.0 + 0.5;
            this.field_70179_y = entityPlayer.field_70179_y * 5.0;
            return true;
        }
        return false;
    }

    public boolean func_70617_f_() {
        return this.field_70123_F;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            EntityLivingBase entityLiving;
            if (this.field_70146_Z.nextInt(15) == 0 && (entityLiving = MoCTools.getScaryEntity((Entity)this, 6.0)) != null) {
                MoCTools.runAway((EntityCreature)this, (Entity)entityLiving);
            }
            if (!this.field_70122_E && this.field_70154_o != null) {
                this.field_70177_z = this.field_70154_o.field_70177_z;
            }
            if (this.field_70154_o instanceof EntityPlayer && MoCreatures.proxy.emptyHandMountAndPickUpOnly && ((EntityPlayer)this.field_70154_o).func_70694_bm() != null) {
                this.func_70078_a(null);
                this.field_70143_R = -3.0f;
                this.setPicked(false);
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        if (MoCreatures.isServer() && this.field_70154_o != null && (damageSource.func_76346_g() == this.field_70154_o || DamageSource.field_76368_d.equals(damageSource))) {
            return false;
        }
        return super.func_70097_a(damageSource, damageTaken);
    }

    public boolean upsideDown() {
        return this.getIsPicked();
    }

    @Override
    public boolean updateMount() {
        return true;
    }

    @Override
    public boolean forceUpdates() {
        return true;
    }

    @Override
    public boolean isSwimmerEntity() {
        return true;
    }
}

