/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.animal;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.achievements.MoCAchievements;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import drzhark.mocreatures.inventory.MoCAnimalChest;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import drzhark.mocreatures.network.message.MoCMessageHeart;
import drzhark.mocreatures.network.message.MoCMessageVanish;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockJukebox;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;

public class MoCEntityHorse
extends MoCEntityTameableAnimal {
    private int gestationTime;
    private int countEating;
    private int textureCounter;
    private int flickerCounter;
    public int shuffleCounter;
    public int wingFlapCounter;
    private float transparencyFloat = 0.2f;
    public MoCAnimalChest localHorseChest;
    public boolean hasEatenBreedingItem;
    private boolean hasReproduced;
    private int nightmareFireTrailCounter;
    public ItemStack localItemstack;
    public int mouthCounter;
    public int standCounter;
    public int tailCounter;
    public int vanishCounter;
    public int sprintCounter;
    public int transformType;
    public int transformCounter;
    private int forwardMovementCounterForWalkingSoundEffect;
    public boolean isJumpKeyDown;
    private int horseJumpPowerCounter;
    private float horseJumpPower;
    static final int JUMP_COUNTER_MARKER_INDICATING_THAT_JUMP_HAS_BEEN_EXECUTED = -100;

    public MoCEntityHorse(World world) {
        super(world);
        this.func_70105_a(1.4f, 1.6f);
        this.gestationTime = 0;
        this.hasEatenBreedingItem = false;
        this.nightmareFireTrailCounter = 0;
        this.setMoCAge(50);
        this.setChestedHorse(false);
        this.roper = null;
        this.field_70138_W = 1.0f;
        if (MoCreatures.isServer()) {
            if (this.field_70146_Z.nextInt(5) == 0) {
                this.setAdult(false);
            } else {
                this.setAdult(true);
            }
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)0);
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)0);
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
        float vanillaMinecraftHorseArmorProtection = 3.7f * (float)this.getArmorType();
        if ((damageTaken *= 1.0f - vanillaMinecraftHorseArmorProtection * 0.04f) < 0.0f) {
            damageTaken = 0.0f;
        }
        if (super.func_70097_a(damageSource, damageTaken) && entityThatAttackedThisCreature != null && this.canThisHorseFightBackAgainstTheAttacker(entityThatAttackedThisCreature)) {
            this.field_70789_a = entityThatAttackedThisCreature;
            return true;
        }
        return super.func_70097_a(damageSource, damageTaken);
    }

    private boolean canThisHorseFightBackAgainstTheAttacker(Entity entityAttacker) {
        return MoCreatures.proxy.specialHorsesFightBack && entityAttacker != null && this.getIsAdult() && this.field_70153_n == null && (!(entityAttacker instanceof EntityPlayer) || !entityAttacker.func_70005_c_().equals(this.getOwnerName())) && !(entityAttacker instanceof MoCEntityHorse) && (this.getType() > 20 && this.getType() < 26 || this.getType() > 25 && this.getType() < 30 || this.getType() >= 30 && this.getType() < 40 || this.getType() >= 40 && this.getType() < 60);
    }

    protected void func_70785_a(Entity entity, float distanceToEntity) {
        if (this.field_70724_aR <= 0 && distanceToEntity < 2.5f && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 20;
            this.stand();
            this.openMouth();
            MoCTools.playCustomSound((Entity)this, this.getMadSound(), this.field_70170_p);
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), this.calculateAttackDamage());
        }
    }

    private float calculateAttackDamage() {
        int horseType = this.getType();
        if (horseType > 20 && horseType < 26 || horseType > 25 && horseType < 30) {
            return 2.0f;
        }
        if (horseType >= 30 && horseType < 40 && horseType != 36 && horseType != 39) {
            return 2.0f;
        }
        if (horseType == 36 || horseType == 39) {
            return 4.0f;
        }
        if (horseType >= 40 && horseType < 60) {
            return 6.0f;
        }
        return 2.0f;
    }

    @Override
    public boolean checkSpawningBiome() {
        int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
        int yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v);
        BiomeGenBase currentBiome = MoCTools.biomekind(this.field_70170_p, xCoordinate, yCoordinate, zCoordinate);
        MoCTools.biomeName(this.field_70170_p, xCoordinate, yCoordinate, zCoordinate);
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA) && !currentBiome.field_76791_y.toLowerCase().contains("outback")) {
            this.setType(60);
        }
        return true;
    }

    public float getColourForFX(int particleColour, int typeInt) {
        if (typeInt == 48) {
            if (particleColour == 1) {
                return 0.69921875f;
            }
            if (particleColour == 2) {
                return 0.625f;
            }
            return 0.0859375f;
        }
        if (typeInt == 49) {
            if (particleColour == 1) {
                return 0.57421875f;
            }
            if (particleColour == 2) {
                return 0.3515625f;
            }
            return 0.76171875f;
        }
        if (typeInt == 51) {
            if (particleColour == 1) {
                return 0.1171875f;
            }
            if (particleColour == 2) {
                return 0.5625f;
            }
            return 0.99609375f;
        }
        if (typeInt == 52) {
            if (particleColour == 1) {
                return 0.99609375f;
            }
            if (particleColour == 2) {
                return 0.41015625f;
            }
            return 0.703125f;
        }
        if (typeInt == 53) {
            if (particleColour == 1) {
                return 0.734375f;
            }
            if (particleColour == 2) {
                return 0.9296875f;
            }
            return 0.40625f;
        }
        if (typeInt == 54) {
            if (particleColour == 1) {
                return 0.4296875f;
            }
            if (particleColour == 2) {
                return 0.48046875f;
            }
            return 0.54296875f;
        }
        if (typeInt == 55) {
            if (particleColour == 1) {
                return 0.7578125f;
            }
            if (particleColour == 2) {
                return 0.11328125f;
            }
            return 0.1328125f;
        }
        if (typeInt == 56) {
            if (particleColour == 1) {
                return 0.24609375f;
            }
            if (particleColour == 2) {
                return 0.17578125f;
            }
            return 0.99609375f;
        }
        if (typeInt == 57) {
            if (particleColour == 1) {
                return 0.26953125f;
            }
            if (particleColour == 2) {
                return 0.5703125f;
            }
            return 0.56640625f;
        }
        if (typeInt == 58) {
            if (particleColour == 1) {
                return 0.3515625f;
            }
            if (particleColour == 2) {
                return 0.53125f;
            }
            return 0.16796875f;
        }
        if (typeInt == 59) {
            if (particleColour == 1) {
                return 0.8515625f;
            }
            if (particleColour == 2) {
                return 0.15625f;
            }
            return 0.0f;
        }
        if (typeInt > 22 && typeInt < 26) {
            if (particleColour == 1) {
                return 0.234375f;
            }
            if (particleColour == 2) {
                return 0.69921875f;
            }
            return 0.4375f;
        }
        if (typeInt == 40) {
            if (particleColour == 1) {
                return 0.54296875f;
            }
            if (particleColour == 2) {
                return 0.0f;
            }
            return 0.0f;
        }
        if (particleColour == 1) {
            return 0.99609375f;
        }
        if (particleColour == 2) {
            return 0.921875f;
        }
        return 0.54296875f;
    }

    public void disappearHorse() {
        this.field_70128_L = true;
    }

    private void drinkingHorse() {
        this.openMouth();
        MoCTools.playCustomSound((Entity)this, "drinking", this.field_70170_p);
    }

    @Override
    public void dropArmor() {
        if (MoCreatures.isServer()) {
            byte armorType = this.getArmorType();
            Item horseArmorToDrop = Items.field_151138_bX;
            if (armorType == 1) {
                horseArmorToDrop = Items.field_151138_bX;
            }
            if (armorType == 2) {
                horseArmorToDrop = Items.field_151136_bY;
            }
            if (armorType == 3) {
                horseArmorToDrop = Items.field_151125_bZ;
            }
            if (armorType == 4) {
                horseArmorToDrop = MoCreatures.horseArmorCrystal;
            }
            if (armorType != 0) {
                MoCTools.playCustomSound((Entity)this, "armoroff", this.field_70170_p);
                EntityItem entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(horseArmorToDrop, 1));
                entityItem.field_145804_b = 10;
                this.field_70170_p.func_72838_d((Entity)entityItem);
                this.setArmorType((byte)0);
            }
        }
    }

    public void dropBags() {
        if (!(this.isBagger() && this.getIsChestedHorse() && MoCreatures.isServer())) {
            return;
        }
        EntityItem entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack((Block)Blocks.field_150486_ae, 1));
        float f3 = 0.05f;
        entityItem.field_70159_w = (float)this.field_70170_p.field_73012_v.nextGaussian() * f3;
        entityItem.field_70181_x = (float)this.field_70170_p.field_73012_v.nextGaussian() * f3 + 0.2f;
        entityItem.field_70179_y = (float)this.field_70170_p.field_73012_v.nextGaussian() * f3;
        this.field_70170_p.func_72838_d((Entity)entityItem);
        this.setChestedHorse(false);
    }

    private void eatingHorse() {
        this.openMouth();
        MoCTools.playCustomSound((Entity)this, "eating", this.field_70170_p);
    }

    protected void func_70069_a(float fallDistance) {
        if (this.isFlyer() || this.isFloater()) {
            return;
        }
        float adjustedFallDistance = (float)(Math.ceil(fallDistance - 3.0f) / 2.0);
        if (MoCreatures.isServer() && adjustedFallDistance > 0.0f) {
            Block block;
            if (this.getType() >= 10) {
                adjustedFallDistance /= 2.0f;
            }
            if (adjustedFallDistance > 1.0f) {
                this.func_70097_a(DamageSource.field_76379_h, adjustedFallDistance);
            }
            if (this.field_70153_n != null && adjustedFallDistance > 1.0f) {
                this.field_70153_n.func_70097_a(DamageSource.field_76379_h, adjustedFallDistance);
            }
            if ((block = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 0.2000000029802322 - (double)this.field_70127_C)), MathHelper.func_76128_c((double)this.field_70161_v))) != Blocks.field_150350_a) {
                Block.SoundType stepSound = block.field_149762_H;
                this.func_85030_a(stepSound.func_150498_e(), stepSound.func_150497_c() * 0.5f, stepSound.func_150494_d() * 0.75f);
            }
        }
    }

    @Override
    public byte getArmorType() {
        return (byte)this.field_70180_af.func_75679_c(25);
    }

    public int getInventorySize() {
        if (this.getType() == 40) {
            return 18;
        }
        if (this.getType() > 64) {
            return 27;
        }
        return 9;
    }

    public boolean getIsChestedHorse() {
        return this.field_70180_af.func_75683_a(23) == 1;
    }

    protected MoCEntityHorse getClosestMotherHorse(Entity entity, double range) {
        double d1 = -1.0;
        MoCEntityHorse closestEntityHorseNearby = null;
        List listOfEntitiesNearby = this.field_70170_p.func_72839_b(entity, entity.field_70121_D.func_72314_b(range, range, range));
        for (int index = 0; index < listOfEntitiesNearby.size(); ++index) {
            Entity entityNearby = (Entity)listOfEntitiesNearby.get(index);
            if (!(entityNearby instanceof MoCEntityHorse) || entityNearby instanceof MoCEntityHorse && !((MoCEntityHorse)entityNearby).getHasBred()) continue;
            double distanceToEntityNearby = entityNearby.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(range < 0.0) && !(distanceToEntityNearby < range * range) || d1 != -1.0 && !(distanceToEntityNearby < d1)) continue;
            d1 = distanceToEntityNearby;
            closestEntityHorseNearby = (MoCEntityHorse)entityNearby;
        }
        return closestEntityHorseNearby;
    }

    @Override
    public double getCustomJump() {
        double horseJump = 0.4;
        int horseType = this.getType();
        if (horseType < 6) {
            horseJump = 0.4;
        } else if (horseType > 5 && horseType < 11) {
            horseJump = 0.45;
        } else if (horseType > 10 && horseType < 16) {
            horseJump = 0.5;
        } else if (horseType > 15 && horseType < 21) {
            horseJump = 0.55;
        } else if (horseType > 20 && horseType < 26) {
            horseJump = 0.45;
        } else if (horseType > 25 && horseType < 30) {
            horseJump = 0.5;
        } else if (horseType >= 30 && horseType < 40) {
            horseJump = 0.55;
        } else if (horseType >= 40 && horseType < 60) {
            horseJump = 0.6;
        } else if (horseType >= 60) {
            horseJump = 0.45;
        }
        if (this.doesHaveHorn() && !this.isFairyHorse()) {
            horseJump = 2.5;
        }
        return horseJump;
    }

    @Override
    public double getCustomSpeed() {
        double horseSpeed = 0.8;
        int horseType = this.getType();
        if (horseType < 6) {
            horseSpeed = 0.9;
        } else if (horseType > 5 && horseType < 11) {
            horseSpeed = 1.0;
        } else if (horseType > 10 && horseType < 16) {
            horseSpeed = 1.1;
        } else if (horseType > 15 && horseType < 21) {
            horseSpeed = 1.2;
        } else if (horseType > 20 && horseType < 26 && !this.isGhostHorse() && horseType != 25) {
            horseSpeed = 1.2;
        } else if (horseType == 21) {
            horseSpeed = 1.37;
        } else if (horseType == 21) {
            horseSpeed = 1.25;
        } else if (horseType > 25 && horseType < 30 && horseType != 28) {
            horseSpeed = 1.2;
        } else if (horseType == 32) {
            horseSpeed = 1.2;
        } else if (horseType == 38) {
            horseSpeed = 1.2;
        } else if ((this.doesHaveHorn() && !this.isFairyHorse() || this.isPegasus()) && horseType != 40) {
            horseSpeed = 1.25;
        } else if (horseType == 40) {
            horseSpeed = 1.28;
        } else if (horseType > 40 && horseType < 60) {
            horseSpeed = 1.37;
        } else if (horseType == 60 || horseType == 61) {
            horseSpeed = 1.1;
        } else if (horseType == 65) {
            horseSpeed = 0.8;
        } else if (horseType > 65) {
            horseSpeed = 1.0;
        }
        if (!this.isFlyer()) {
            if (this.sprintCounter > 0 && this.sprintCounter < 150) {
                return horseSpeed *= 1.3;
            }
            if (this.doesHaveChargeAbility() && this.sprintCounter > 150) {
                return horseSpeed *= 0.9;
            }
        }
        return horseSpeed;
    }

    protected String func_70673_aS() {
        this.openMouth();
        if (this.isUndead()) {
            return "mocreatures:horsedyingundead";
        }
        if (this.isGhostHorse()) {
            return "mocreatures:horsedyingghost";
        }
        if (this.getType() == 60 || this.getType() == 61) {
            return "mocreatures:zebrahurt";
        }
        if (this.getType() >= 65 && this.getType() <= 67) {
            return "mocreatures:donkeydying";
        }
        return "mocreatures:horsedying";
    }

    @Override
    public boolean getShouldDisplayName() {
        if (this.isGhostHorse() && this.getMoCAge() < 10) {
            return false;
        }
        return this.getName() != null && !this.getName().equals("");
    }

    protected void func_70628_a(boolean hasEntityBeenHitByPlayer, int levelOfLootingEnchantmentUsedToKillThisEntity) {
        boolean canDropRareItem = this.field_70146_Z.nextInt(100) < MoCreatures.proxy.rareItemDropChance;
        int randomAmount = this.field_70146_Z.nextInt(3);
        if (canDropRareItem && (this.getType() == 36 || this.getType() >= 50 && this.getType() < 60)) {
            this.func_145779_a(MoCreatures.unicornHorn, 1);
        }
        if (this.getType() == 39 || this.getType() == 40) {
            this.func_145779_a(Items.field_151008_G, randomAmount);
        }
        if (this.getType() == 38 && canDropRareItem && this.field_70170_p.field_73011_w.field_76575_d) {
            this.func_145779_a(MoCreatures.heartFire, 1);
        }
        if (this.getType() == 32 && canDropRareItem) {
            this.func_145779_a(MoCreatures.heartDarkness, 1);
        }
        if (this.getType() == 26) {
            this.func_145779_a(Items.field_151103_aS, randomAmount);
        }
        if (this.getType() == 23 || this.getType() == 24 || this.getType() == 25) {
            if (canDropRareItem) {
                this.func_145779_a(MoCreatures.heartundead, 1);
            } else {
                this.func_145779_a(Items.field_151078_bh, randomAmount);
            }
        }
        if (this.getType() == 21 || this.getType() == 22) {
            this.func_145779_a(Items.field_151073_bk, randomAmount);
        }
        if (!this.isMagicHorse() && !this.doesHaveHorn() && this.getType() != 23 && this.getType() != 24 && this.getType() != 25 && this.getType() != 26 && this.getType() != 21 && this.getType() != 22) {
            if (!MoCreatures.isGregTech6Loaded) {
                if (MoCreatures.isFoodExpansionLoaded) {
                    if (this.func_70027_ad()) {
                        this.func_145779_a(GameRegistry.findItem((String)"FoodExpansion", (String)"ItemCookedHorseMeat"), randomAmount);
                    } else {
                        this.func_145779_a(GameRegistry.findItem((String)"FoodExpansion", (String)"ItemHorseMeat"), randomAmount);
                    }
                } else if (MoCreatures.isLotsOfFoodLoaded) {
                    if (this.func_70027_ad()) {
                        this.func_145779_a(GameRegistry.findItem((String)"LotsOfFood", (String)"chevalcuit"), randomAmount);
                    } else {
                        this.func_145779_a(GameRegistry.findItem((String)"LotsOfFood", (String)"chevalcru"), randomAmount);
                    }
                } else if (MoCreatures.isImprovingMinecraftLoaded) {
                    if (this.func_70027_ad()) {
                        this.func_145779_a(GameRegistry.findItem((String)"imc", (String)"item_cooked_horse"), randomAmount);
                    } else {
                        this.func_145779_a(GameRegistry.findItem((String)"imc", (String)"item_raw_horse"), randomAmount);
                    }
                }
            }
            this.func_145779_a(Items.field_151116_aA, randomAmount);
        }
    }

    public boolean getEating() {
        return this.field_70180_af.func_75683_a(24) == 1;
    }

    public boolean getHasBred() {
        return this.field_70180_af.func_75683_a(26) == 1;
    }

    public boolean getHasReproduced() {
        return this.hasReproduced;
    }

    protected String func_70621_aR() {
        return this.getMadSound();
    }

    @Override
    public boolean getIsRideable() {
        return this.field_70180_af.func_75683_a(22) == 1;
    }

    protected String func_70639_aQ() {
        this.openMouth();
        if (this.field_70146_Z.nextInt(10) == 0 && !this.func_70780_i()) {
            this.stand();
        }
        if (this.isUndead()) {
            return "mocreatures:horsegruntundead";
        }
        if (this.isGhostHorse()) {
            return "mocreatures:horsegruntghost";
        }
        if (this.getType() == 60 || this.getType() == 61) {
            return "mocreatures:zebragrunt";
        }
        if (this.getType() >= 65 && this.getType() <= 67) {
            return "mocreatures:donkeygrunt";
        }
        return "mocreatures:horsegrunt";
    }

    @Override
    protected String getMadSound() {
        this.openMouth();
        if (this.isFlyer() && this.field_70153_n == null) {
            this.wingFlap();
        } else if (this.field_70146_Z.nextInt(3) == 0) {
            this.stand();
        }
        if (this.isUndead()) {
            return "mocreatures:horsehurtundead";
        }
        if (this.isGhostHorse()) {
            return "mocreatures:horsehurtghost";
        }
        if (this.getType() == 60 || this.getType() == 61) {
            return "mocreatures:zebrahurt";
        }
        if (this.getType() >= 65 && this.getType() <= 67) {
            return "mocreatures:donkeyhurt";
        }
        return "mocreatures:horsehurt";
    }

    public double calculateMaxHealth() {
        double maximumHealth = 10.0;
        int horseType = this.getType();
        if (horseType < 6) {
            maximumHealth = 15.0;
        } else if (horseType > 5 && horseType < 11) {
            maximumHealth = 20.0;
        } else if (horseType > 10 && horseType < 16) {
            maximumHealth = 25.0;
        } else if (horseType > 15 && horseType < 21) {
            maximumHealth = 25.0;
        } else if (horseType > 20 && horseType < 26) {
            maximumHealth = 25.0;
        } else if (horseType > 25 && horseType < 30) {
            maximumHealth = 15.0;
        } else if (horseType >= 30 && horseType < 40) {
            maximumHealth = 30.0;
        } else if (horseType == 40) {
            maximumHealth = 40.0;
        } else if (horseType > 40 && horseType < 60) {
            maximumHealth = 35.0;
        } else if (horseType >= 60) {
            maximumHealth = 20.0;
        }
        return maximumHealth;
    }

    @Override
    public int getMaxTemper() {
        if (this.getType() == 60) {
            return 200;
        }
        return 100;
    }

    public int getNightmareFireTrailCounter() {
        return this.nightmareFireTrailCounter;
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    public int func_70627_aG() {
        return 400;
    }

    @Override
    public ResourceLocation getTexture() {
        String tempTexture;
        switch (this.getType()) {
            case 1: {
                tempTexture = "horsewhite.png";
                break;
            }
            case 2: {
                tempTexture = "horsecreamy.png";
                break;
            }
            case 3: {
                tempTexture = "horsebrown.png";
                break;
            }
            case 4: {
                tempTexture = "horsedarkbrown.png";
                break;
            }
            case 5: {
                tempTexture = "horseblack.png";
                break;
            }
            case 6: {
                tempTexture = "horsebrightcreamy.png";
                break;
            }
            case 7: {
                tempTexture = "horsespeckled.png";
                break;
            }
            case 8: {
                tempTexture = "horsepalebrown.png";
                break;
            }
            case 9: {
                tempTexture = "horsegrey.png";
                break;
            }
            case 11: {
                tempTexture = "horsepinto.png";
                break;
            }
            case 12: {
                tempTexture = "horsebrightpinto.png";
                break;
            }
            case 13: {
                tempTexture = "horsepalespeckles.png";
                break;
            }
            case 16: {
                tempTexture = "horsespotted.png";
                break;
            }
            case 17: {
                tempTexture = "horsecow.png";
                break;
            }
            case 21: {
                tempTexture = "horseghost.png";
                break;
            }
            case 22: {
                tempTexture = "horseghostb.png";
                break;
            }
            case 23: {
                tempTexture = "horseundead.png";
                break;
            }
            case 24: {
                tempTexture = "horseundeadunicorn.png";
                break;
            }
            case 25: {
                tempTexture = "horseundeadpegasus.png";
                break;
            }
            case 26: {
                tempTexture = "horseskeleton.png";
                break;
            }
            case 27: {
                tempTexture = "horseunicornskeleton.png";
                break;
            }
            case 28: {
                tempTexture = "horsepegasusskeleton.png";
                break;
            }
            case 30: {
                tempTexture = "horsebug.png";
                break;
            }
            case 32: {
                tempTexture = "horsebat.png";
                break;
            }
            case 36: {
                tempTexture = "horseunicorn.png";
                break;
            }
            case 38: {
                tempTexture = "horsenightmare.png";
                break;
            }
            case 39: {
                tempTexture = "horsepegasus.png";
                break;
            }
            case 40: {
                tempTexture = "horsedarkpegasus.png";
                break;
            }
            case 48: {
                tempTexture = "horsefairyyellow.png";
                break;
            }
            case 49: {
                tempTexture = "horsefairypurple.png";
                break;
            }
            case 50: {
                tempTexture = "horsefairywhite.png";
                break;
            }
            case 51: {
                tempTexture = "horsefairyblue.png";
                break;
            }
            case 52: {
                tempTexture = "horsefairypink.png";
                break;
            }
            case 53: {
                tempTexture = "horsefairylightgreen.png";
                break;
            }
            case 54: {
                tempTexture = "horsefairyblack.png";
                break;
            }
            case 55: {
                tempTexture = "horsefairyred.png";
                break;
            }
            case 56: {
                tempTexture = "horsefairydarkblue.png";
                break;
            }
            case 57: {
                tempTexture = "horsefairycyan.png";
                break;
            }
            case 58: {
                tempTexture = "horsefairygreen.png";
                break;
            }
            case 59: {
                tempTexture = "horsefairyorange.png";
                break;
            }
            case 60: {
                tempTexture = "horsezebra.png";
                break;
            }
            case 61: {
                tempTexture = "horsezorse.png";
                break;
            }
            case 65: {
                tempTexture = "horsedonkey.png";
                break;
            }
            case 66: {
                tempTexture = "horsemule.png";
                break;
            }
            case 67: {
                tempTexture = "horsezonky.png";
                break;
            }
            default: {
                tempTexture = "horsebug.png";
            }
        }
        if ((this.canWearRegularArmor() || this.isMagicHorse()) && this.getArmorType() > 0) {
            String armorTexture = "";
            if (this.getArmorType() == 1) {
                armorTexture = "metal.png";
            }
            if (this.getArmorType() == 2) {
                armorTexture = "gold.png";
            }
            if (this.getArmorType() == 3) {
                armorTexture = "diamond.png";
            }
            if (this.getArmorType() == 4) {
                armorTexture = "crystaline.png";
            }
            return MoCreatures.proxy.getTexture(tempTexture.replace(".png", armorTexture));
        }
        if (this.isUndead() && this.getType() < 26) {
            String baseTex = "horseundead";
            int max = 79;
            if (this.getType() == 25) {
                baseTex = "horseundeadpegasus";
            }
            if (this.getType() == 24) {
                baseTex = "horseundeadunicorn";
                max = 69;
            }
            String iteratorTex = "1";
            if (MoCreatures.proxy.getAnimateTextures()) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    ++this.textureCounter;
                }
                if (this.textureCounter < 10) {
                    this.textureCounter = 10;
                }
                if (this.textureCounter > max) {
                    this.textureCounter = 10;
                }
                iteratorTex = "" + this.textureCounter;
                iteratorTex = iteratorTex.substring(0, 1);
            }
            String decayTex = "" + this.getMoCAge() / 100;
            decayTex = decayTex.substring(0, 1);
            return MoCreatures.proxy.getTexture(baseTex + decayTex + iteratorTex + ".png");
        }
        if (!MoCreatures.proxy.getAnimateTextures()) {
            return MoCreatures.proxy.getTexture(tempTexture);
        }
        if (this.isNightmare()) {
            if (this.field_70146_Z.nextInt(3) == 0) {
                ++this.textureCounter;
            }
            if (this.textureCounter < 10) {
                this.textureCounter = 10;
            }
            if (this.textureCounter > 59) {
                this.textureCounter = 10;
            }
            String NTA = "horsenightmare";
            String NTB = "" + this.textureCounter;
            NTB = NTB.substring(0, 1);
            String NTC = ".png";
            return MoCreatures.proxy.getTexture(NTA + NTB + NTC);
        }
        if (this.transformCounter != 0 && this.transformType != 0) {
            String newTexture = "horseundead.png";
            if (this.transformType == 23) {
                newTexture = "horseundead.png";
            }
            if (this.transformType == 24) {
                newTexture = "horseundeadunicorn.png";
            }
            if (this.transformType == 25) {
                newTexture = "horseundeadpegasus.png";
            }
            if (this.transformType == 36) {
                newTexture = "horseunicorn.png";
            }
            if (this.transformType == 39) {
                newTexture = "horsepegasus.png";
            }
            if (this.transformType == 40) {
                newTexture = "horseblackpegasus.png";
            }
            if (this.transformType == 48) {
                newTexture = "horsefairyyellow.png";
            }
            if (this.transformType == 49) {
                newTexture = "horsefairypurple.png";
            }
            if (this.transformType == 50) {
                newTexture = "horsefairywhite.png";
            }
            if (this.transformType == 51) {
                newTexture = "horsefairyblue.png";
            }
            if (this.transformType == 52) {
                newTexture = "horsefairypink.png";
            }
            if (this.transformType == 53) {
                newTexture = "horsefairylightgreen.png";
            }
            if (this.transformType == 54) {
                newTexture = "horsefairyblack.png";
            }
            if (this.transformType == 55) {
                newTexture = "horsefairyred.png";
            }
            if (this.transformType == 56) {
                newTexture = "horsefairydarkblue.png";
            }
            if (this.transformType == 57) {
                newTexture = "horsefairycyan.png";
            }
            if (this.transformType == 58) {
                newTexture = "horsefairygreen.png";
            }
            if (this.transformType == 59) {
                newTexture = "horsefairyorange.png";
            }
            if (this.transformType == 32) {
                newTexture = "horsebat.png";
            }
            if (this.transformType == 38) {
                newTexture = "horsenightmare1.png";
            }
            if (this.transformCounter % 5 == 0) {
                return MoCreatures.proxy.getTexture(newTexture);
            }
            if (this.transformCounter > 50 && this.transformCounter % 3 == 0) {
                return MoCreatures.proxy.getTexture(newTexture);
            }
            if (this.transformCounter > 75 && this.transformCounter % 4 == 0) {
                return MoCreatures.proxy.getTexture(newTexture);
            }
        }
        return MoCreatures.proxy.getTexture(tempTexture);
    }

    public byte getVanishC() {
        return (byte)this.vanishCounter;
    }

    private int horseGenetics(int parentHorseTypeA, int parentHorseTypeB) {
        boolean shouldBecomeSterile = MoCreatures.proxy.hardHorseBreeding;
        if (parentHorseTypeA == parentHorseTypeB) {
            return parentHorseTypeA;
        }
        if (parentHorseTypeA == 60 && parentHorseTypeB < 21 || parentHorseTypeB == 60 && parentHorseTypeA < 21) {
            return 61;
        }
        if (parentHorseTypeA == 65 && parentHorseTypeB < 21 || parentHorseTypeB == 65 && parentHorseTypeA < 21) {
            return 66;
        }
        if (parentHorseTypeA == 60 && parentHorseTypeB == 65 || parentHorseTypeB == 60 && parentHorseTypeA == 65) {
            return 67;
        }
        if (parentHorseTypeA > 20 && parentHorseTypeB < 21 || parentHorseTypeB > 20 && parentHorseTypeA < 21) {
            if (parentHorseTypeA < parentHorseTypeB) {
                return parentHorseTypeA;
            }
            return parentHorseTypeB;
        }
        if (parentHorseTypeA == 36 && parentHorseTypeB == 39 || parentHorseTypeB == 36 && parentHorseTypeA == 39) {
            return 50;
        }
        if (parentHorseTypeA > 20 && parentHorseTypeB > 20 && parentHorseTypeA != parentHorseTypeB) {
            return this.field_70146_Z.nextInt(5) + 1;
        }
        int chanceInt = this.field_70146_Z.nextInt(4) + 1;
        if (shouldBecomeSterile) {
            if (chanceInt == 1) {
                return parentHorseTypeA;
            }
            if (chanceInt == 2) {
                return parentHorseTypeB;
            }
        }
        if (parentHorseTypeA == 1 && parentHorseTypeB == 2 || parentHorseTypeA == 2 && parentHorseTypeB == 1) {
            return 6;
        }
        if (parentHorseTypeA == 1 && parentHorseTypeB == 3 || parentHorseTypeA == 3 && parentHorseTypeB == 1) {
            return 2;
        }
        if (parentHorseTypeA == 1 && parentHorseTypeB == 4 || parentHorseTypeA == 4 && parentHorseTypeB == 1) {
            return 7;
        }
        if (parentHorseTypeA == 1 && parentHorseTypeB == 5 || parentHorseTypeA == 5 && parentHorseTypeB == 1) {
            return 9;
        }
        if (parentHorseTypeA == 1 && parentHorseTypeB == 7 || parentHorseTypeA == 7 && parentHorseTypeB == 1) {
            return 12;
        }
        if (parentHorseTypeA == 1 && parentHorseTypeB == 8 || parentHorseTypeA == 8 && parentHorseTypeB == 1) {
            return 7;
        }
        if (parentHorseTypeA == 1 && parentHorseTypeB == 9 || parentHorseTypeA == 9 && parentHorseTypeB == 1) {
            return 13;
        }
        if (parentHorseTypeA == 1 && parentHorseTypeB == 11 || parentHorseTypeA == 11 && parentHorseTypeB == 1) {
            return 12;
        }
        if (parentHorseTypeA == 1 && parentHorseTypeB == 12 || parentHorseTypeA == 12 && parentHorseTypeB == 1) {
            return 13;
        }
        if (parentHorseTypeA == 1 && parentHorseTypeB == 17 || parentHorseTypeA == 17 && parentHorseTypeB == 1) {
            return 16;
        }
        if (parentHorseTypeA == 2 && parentHorseTypeB == 4 || parentHorseTypeA == 4 && parentHorseTypeB == 2) {
            return 3;
        }
        if (parentHorseTypeA == 2 && parentHorseTypeB == 5 || parentHorseTypeA == 5 && parentHorseTypeB == 2) {
            return 4;
        }
        if (parentHorseTypeA == 2 && parentHorseTypeB == 7 || parentHorseTypeA == 7 && parentHorseTypeB == 2) {
            return 8;
        }
        if (parentHorseTypeA == 2 && parentHorseTypeB == 8 || parentHorseTypeA == 8 && parentHorseTypeB == 2) {
            return 3;
        }
        if (parentHorseTypeA == 2 && parentHorseTypeB == 12 || parentHorseTypeA == 12 && parentHorseTypeB == 2) {
            return 6;
        }
        if (parentHorseTypeA == 2 && parentHorseTypeB == 16 || parentHorseTypeA == 16 && parentHorseTypeB == 2) {
            return 13;
        }
        if (parentHorseTypeA == 2 && parentHorseTypeB == 17 || parentHorseTypeA == 17 && parentHorseTypeB == 2) {
            return 12;
        }
        if (parentHorseTypeA == 3 && parentHorseTypeB == 4 || parentHorseTypeA == 4 && parentHorseTypeB == 3) {
            return 8;
        }
        if (parentHorseTypeA == 3 && parentHorseTypeB == 5 || parentHorseTypeA == 5 && parentHorseTypeB == 3) {
            return 8;
        }
        if (parentHorseTypeA == 3 && parentHorseTypeB == 6 || parentHorseTypeA == 6 && parentHorseTypeB == 3) {
            return 2;
        }
        if (parentHorseTypeA == 3 && parentHorseTypeB == 7 || parentHorseTypeA == 7 && parentHorseTypeB == 3) {
            return 11;
        }
        if (parentHorseTypeA == 3 && parentHorseTypeB == 9 || parentHorseTypeA == 9 && parentHorseTypeB == 3) {
            return 8;
        }
        if (parentHorseTypeA == 3 && parentHorseTypeB == 12 || parentHorseTypeA == 12 && parentHorseTypeB == 3) {
            return 11;
        }
        if (parentHorseTypeA == 3 && parentHorseTypeB == 16 || parentHorseTypeA == 16 && parentHorseTypeB == 3) {
            return 11;
        }
        if (parentHorseTypeA == 3 && parentHorseTypeB == 17 || parentHorseTypeA == 17 && parentHorseTypeB == 3) {
            return 11;
        }
        if (parentHorseTypeA == 4 && parentHorseTypeB == 6 || parentHorseTypeA == 6 && parentHorseTypeB == 4) {
            return 3;
        }
        if (parentHorseTypeA == 4 && parentHorseTypeB == 7 || parentHorseTypeA == 7 && parentHorseTypeB == 4) {
            return 8;
        }
        if (parentHorseTypeA == 4 && parentHorseTypeB == 9 || parentHorseTypeA == 9 && parentHorseTypeB == 4) {
            return 7;
        }
        if (parentHorseTypeA == 4 && parentHorseTypeB == 11 || parentHorseTypeA == 11 && parentHorseTypeB == 4) {
            return 7;
        }
        if (parentHorseTypeA == 4 && parentHorseTypeB == 12 || parentHorseTypeA == 12 && parentHorseTypeB == 4) {
            return 7;
        }
        if (parentHorseTypeA == 4 && parentHorseTypeB == 13 || parentHorseTypeA == 13 && parentHorseTypeB == 4) {
            return 7;
        }
        if (parentHorseTypeA == 4 && parentHorseTypeB == 16 || parentHorseTypeA == 16 && parentHorseTypeB == 4) {
            return 13;
        }
        if (parentHorseTypeA == 4 && parentHorseTypeB == 17 || parentHorseTypeA == 17 && parentHorseTypeB == 4) {
            return 5;
        }
        if (parentHorseTypeA == 5 && parentHorseTypeB == 6 || parentHorseTypeA == 6 && parentHorseTypeB == 5) {
            return 4;
        }
        if (parentHorseTypeA == 5 && parentHorseTypeB == 7 || parentHorseTypeA == 7 && parentHorseTypeB == 5) {
            return 4;
        }
        if (parentHorseTypeA == 5 && parentHorseTypeB == 8 || parentHorseTypeA == 8 && parentHorseTypeB == 5) {
            return 4;
        }
        if (parentHorseTypeA == 5 && parentHorseTypeB == 11 || parentHorseTypeA == 11 && parentHorseTypeB == 5) {
            return 17;
        }
        if (parentHorseTypeA == 5 && parentHorseTypeB == 12 || parentHorseTypeA == 12 && parentHorseTypeB == 5) {
            return 13;
        }
        if (parentHorseTypeA == 5 && parentHorseTypeB == 13 || parentHorseTypeA == 13 && parentHorseTypeB == 5) {
            return 16;
        }
        if (parentHorseTypeA == 5 && parentHorseTypeB == 16 || parentHorseTypeA == 16 && parentHorseTypeB == 5) {
            return 17;
        }
        if (parentHorseTypeA == 6 && parentHorseTypeB == 8 || parentHorseTypeA == 8 && parentHorseTypeB == 6) {
            return 2;
        }
        if (parentHorseTypeA == 6 && parentHorseTypeB == 17 || parentHorseTypeA == 17 && parentHorseTypeB == 6) {
            return 7;
        }
        if (parentHorseTypeA == 7 && parentHorseTypeB == 16 || parentHorseTypeA == 16 && parentHorseTypeB == 7) {
            return 13;
        }
        if (parentHorseTypeA == 8 && parentHorseTypeB == 11 || parentHorseTypeA == 11 && parentHorseTypeB == 8) {
            return 7;
        }
        if (parentHorseTypeA == 8 && parentHorseTypeB == 12 || parentHorseTypeA == 12 && parentHorseTypeB == 8) {
            return 7;
        }
        if (parentHorseTypeA == 8 && parentHorseTypeB == 13 || parentHorseTypeA == 13 && parentHorseTypeB == 8) {
            return 7;
        }
        if (parentHorseTypeA == 8 && parentHorseTypeB == 16 || parentHorseTypeA == 16 && parentHorseTypeB == 8) {
            return 7;
        }
        if (parentHorseTypeA == 8 && parentHorseTypeB == 17 || parentHorseTypeA == 17 && parentHorseTypeB == 8) {
            return 7;
        }
        if (parentHorseTypeA == 9 && parentHorseTypeB == 16 || parentHorseTypeA == 16 && parentHorseTypeB == 9) {
            return 13;
        }
        if (parentHorseTypeA == 11 && parentHorseTypeB == 16 || parentHorseTypeA == 16 && parentHorseTypeB == 11) {
            return 13;
        }
        if (parentHorseTypeA == 11 && parentHorseTypeB == 17 || parentHorseTypeA == 17 && parentHorseTypeB == 11) {
            return 7;
        }
        if (parentHorseTypeA == 12 && parentHorseTypeB == 16 || parentHorseTypeA == 16 && parentHorseTypeB == 12) {
            return 13;
        }
        if (parentHorseTypeA == 13 && parentHorseTypeB == 17 || parentHorseTypeA == 17 && parentHorseTypeB == 13) {
            return 9;
        }
        return parentHorseTypeA;
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityPlayer) {
        if (super.func_70085_c(entityPlayer)) {
            return false;
        }
        int horseType = this.getType();
        if (horseType == 60 && !this.getIsTamed() && this.isZebraRunningAwayFromPlayer()) {
            return false;
        }
        ItemStack itemStack = entityPlayer.func_70694_bm();
        EntityPlayer owner = this.field_70170_p.func_72924_a(this.getOwnerName());
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            if (!this.getIsRideable() && item == Items.field_151141_av || item == MoCreatures.craftedSaddle) {
                if (--itemStack.field_77994_a == 0) {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                }
                this.setRideable(true);
                return true;
            }
            List<String> oreDictionaryNameArray = MoCTools.getOreDictionaryEntries(itemStack);
            if (this.interactIfThisHorseIsANormalHorseAndItemstackIsHealFood(entityPlayer, horseType, itemStack, item, oreDictionaryNameArray)) {
                return true;
            }
            if (this.interactIfThisHorseIsANormalHorseAndItemstackIsBreedingFood(entityPlayer, itemStack, item)) {
                return true;
            }
            if (this.getIsTamed()) {
                if (this.interactIfItemstackIsAmulet(entityPlayer, horseType, item)) {
                    return true;
                }
                if (this.interactIfItemstackIsHorseArmor(entityPlayer, itemStack, item)) {
                    return true;
                }
                if (this.interactIfItemstackIsEssenceOfDarkness(entityPlayer, horseType, itemStack, owner, item)) {
                    return true;
                }
                if (this.interactIfItemstackisEssenceOfFire(entityPlayer, horseType, itemStack, owner, item)) {
                    return true;
                }
                if (this.interactIfItemstackIsEssenceOfLight(entityPlayer, horseType, itemStack, owner, item)) {
                    return true;
                }
                if (this.interactIfItemstackIsEssenceOfUndead(entityPlayer, horseType, itemStack, owner, item)) {
                    return true;
                }
                if (item == Item.func_150898_a((Block)Blocks.field_150486_ae) && this.isBagger()) {
                    if (this.getIsChestedHorse()) {
                        return false;
                    }
                    if (--itemStack.field_77994_a == 0) {
                        entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                    }
                    this.setChestedHorse(true);
                    return true;
                }
                if (this.interactIfThisHorseIsAZebraAndItemstackIsRecord(entityPlayer, horseType, item)) {
                    return true;
                }
                if (this.interactIfThisHorseIsAFairyAndItemstackIsDye(entityPlayer, horseType, itemStack, item)) {
                    return true;
                }
            }
        }
        if (MoCreatures.proxy.emptyHandMountAndPickUpOnly && itemStack == null || !MoCreatures.proxy.emptyHandMountAndPickUpOnly) {
            if (entityPlayer.func_70093_af() && this.getIsChestedHorse()) {
                if (this.localHorseChest == null) {
                    this.localHorseChest = new MoCAnimalChest(StatCollector.func_74838_a((String)"container.MoCreatures.HorseChest"), this.getInventorySize());
                }
                if (MoCreatures.isServer()) {
                    entityPlayer.func_71007_a((IInventory)this.localHorseChest);
                }
                return true;
            }
            if (!entityPlayer.func_70093_af() && this.getIsRideable() && this.getIsAdult() && this.field_70153_n == null && (!this.isFlyer() || entityPlayer.field_70153_n == null)) {
                entityPlayer.field_70177_z = this.field_70177_z;
                entityPlayer.field_70125_A = this.field_70125_A;
                this.func_70019_c(false);
                if (MoCreatures.isServer()) {
                    entityPlayer.func_70078_a((Entity)this);
                }
                this.gestationTime = 0;
                return true;
            }
        }
        return false;
    }

    private boolean interactIfThisHorseIsANormalHorseAndItemstackIsBreedingFood(EntityPlayer entityPlayer, ItemStack itemStack, Item item) {
        if (item == Item.func_150898_a((Block)Blocks.field_150423_aK) || item == Items.field_151009_A || item == Items.field_151105_aU) {
            if (!this.getIsAdult() || this.isMagicHorse() || this.isUndead()) {
                return false;
            }
            if (item == Items.field_151009_A) {
                if (--itemStack.field_77994_a == 0) {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, new ItemStack(Items.field_151054_z));
                } else {
                    entityPlayer.field_71071_by.func_70441_a(new ItemStack(Items.field_151054_z));
                }
            } else if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
            }
            this.hasEatenBreedingItem = true;
            this.func_70691_i(25.0f);
            this.eatingHorse();
            return true;
        }
        return false;
    }

    private boolean interactIfThisHorseIsANormalHorseAndItemstackIsHealFood(EntityPlayer entityPlayer, int horseType, ItemStack itemStack, Item item, List<String> oreDictionaryNameArray) {
        if (!this.isUndead() && !this.isMagicHorse() && (item == Items.field_151015_O || item == MoCreatures.sugarLump || item == Items.field_151025_P || item == Items.field_151034_e || item == Items.field_151153_ao || item == MoCreatures.haystack || oreDictionaryNameArray.size() > 0 && (oreDictionaryNameArray.contains("listAllwheats") || oreDictionaryNameArray.contains("listAllgrain") || MoCreatures.isGregTech6Loaded && (oreDictionaryNameArray.contains("itemGrass") || oreDictionaryNameArray.contains("itemGrassDry") || oreDictionaryNameArray.contains("cropGrain"))))) {
            int temperIncrease = 0;
            int healAmount = 0;
            int ageIncrease = 0;
            if (item == Items.field_151015_O || oreDictionaryNameArray.contains("listAllwheats") || oreDictionaryNameArray.contains("itemGrass") || oreDictionaryNameArray.contains("itemGrassDry") || oreDictionaryNameArray.contains("cropGrain") || oreDictionaryNameArray.contains("listAllgrain")) {
                temperIncrease = 25;
                healAmount = 5;
                ageIncrease = 1;
            }
            if (item == MoCreatures.sugarLump) {
                temperIncrease = 25;
                healAmount = 10;
                ageIncrease = 2;
            }
            if (item == Items.field_151025_P) {
                temperIncrease = 100;
                healAmount = 20;
                ageIncrease = 3;
            }
            if (item == Items.field_151034_e || item == Items.field_151153_ao) {
                temperIncrease = 0;
                healAmount = 25;
                ageIncrease = 1;
            }
            if (item == MoCreatures.haystack) {
                temperIncrease = 0;
                healAmount = 25;
                ageIncrease = 1;
            }
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
            }
            if (MoCreatures.isServer()) {
                this.setTemper(this.getTemper() + temperIncrease);
                if (this.getTemper() > this.getMaxTemper()) {
                    this.setTemper(this.getMaxTemper() - 5);
                }
            }
            if (item == MoCreatures.haystack && !this.isMagicHorse() && !this.isUndead()) {
                this.func_70019_c(true);
            }
            this.func_70691_i(healAmount);
            this.eatingHorse();
            if (!this.getIsAdult() && this.getMoCAge() < 100) {
                this.setMoCAge(this.getMoCAge() + ageIncrease);
            }
            if (MoCreatures.isServer() && !this.getIsTamed() && (item == Items.field_151034_e || item == Items.field_151153_ao)) {
                MoCTools.tameWithName(entityPlayer, this);
                if (entityPlayer != null && horseType > 5 && horseType < 11) {
                    entityPlayer.func_71064_a((StatBase)MoCAchievements.tier2_horse, 1);
                } else if (entityPlayer != null && horseType == 60) {
                    entityPlayer.func_71064_a((StatBase)MoCAchievements.zebra, 1);
                }
            }
            return true;
        }
        return false;
    }

    private boolean interactIfThisHorseIsAZebraAndItemstackIsRecord(EntityPlayer entityPlayer, int horseType, Item item) {
        if (horseType == 60 && (item == Items.field_151086_cn || item == Items.field_151096_cd || item == Items.field_151093_ce || item == Items.field_151091_cg || item == Items.field_151092_ch || item == Items.field_151089_ci || item == Items.field_151090_cj || item == Items.field_151087_ck || item == Items.field_151088_cl || item == Items.field_151085_cm)) {
            entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
            if (MoCreatures.isServer()) {
                EntityItem entityItem1 = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(MoCreatures.recordShuffle, 1));
                entityItem1.field_145804_b = 20;
                this.field_70170_p.func_72838_d((Entity)entityItem1);
            }
            this.eatingHorse();
            return true;
        }
        return false;
    }

    private boolean interactIfThisHorseIsAFairyAndItemstackIsDye(EntityPlayer entityPlayer, int horseType, ItemStack itemStack, Item item) {
        if (horseType == 50 && item == Items.field_151100_aR) {
            int colorInt = BlockColored.func_150031_c((int)itemStack.func_77960_j());
            switch (colorInt) {
                case 1: {
                    this.transform(59);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.transform(51);
                    break;
                }
                case 4: {
                    this.transform(48);
                    break;
                }
                case 5: {
                    this.transform(53);
                    break;
                }
                case 6: {
                    this.transform(52);
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    this.transform(57);
                    break;
                }
                case 10: {
                    this.transform(49);
                    break;
                }
                case 11: {
                    this.transform(56);
                    break;
                }
                case 12: {
                    break;
                }
                case 13: {
                    this.transform(58);
                    break;
                }
                case 14: {
                    this.transform(55);
                    break;
                }
                case 15: {
                    this.transform(54);
                }
            }
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
            }
            this.eatingHorse();
            return true;
        }
        return false;
    }

    private boolean interactIfItemstackIsAmulet(EntityPlayer entityPlayer, int horseType, Item item) {
        if (this.isAmuletHorse()) {
            if ((horseType == 26 || horseType == 27 || horseType == 28) && item == MoCreatures.amuletBone) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                this.vanishHorse();
                return true;
            }
            if (horseType > 47 && horseType < 60 && item == MoCreatures.amuletFairy) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                this.vanishHorse();
                return true;
            }
            if ((horseType == 39 || horseType == 40) && item == MoCreatures.amuletPegasus) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                this.vanishHorse();
                return true;
            }
            if ((horseType == 21 || horseType == 22) && item == MoCreatures.amuletGhost) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                this.vanishHorse();
                return true;
            }
        }
        return false;
    }

    private boolean interactIfItemstackIsEssenceOfLight(EntityPlayer entityPlayer, int horseType, ItemStack itemStack, EntityPlayer owner, Item item) {
        if (item == MoCreatures.essenceLight) {
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, new ItemStack(Items.field_151069_bo));
            } else {
                entityPlayer.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
            if (this.isMagicHorse()) {
                if (this.getIsAdult() && this.func_110143_aJ() == this.func_110138_aP()) {
                    this.hasEatenBreedingItem = true;
                }
                this.func_70606_j(this.func_110138_aP());
            }
            if (this.isNightmare()) {
                this.transform(36);
                if (owner != null) {
                    owner.func_71064_a((StatBase)MoCAchievements.unicorn, 1);
                }
            }
            if (horseType == 32 && this.field_70163_u > 128.0) {
                this.transform(39);
                if (owner != null) {
                    owner.func_71064_a((StatBase)MoCAchievements.pegasus, 1);
                }
            }
            if (this.isUndead() && this.getIsAdult() && MoCreatures.isServer()) {
                this.setMoCAge(10);
                if (horseType > 26) {
                    this.setType(horseType - 3);
                }
            }
            this.drinkingHorse();
            return true;
        }
        return false;
    }

    private boolean interactIfItemstackIsEssenceOfDarkness(EntityPlayer entityPlayer, int horseType, ItemStack itemStack, EntityPlayer owner, Item item) {
        if (item == MoCreatures.essenceDarkness) {
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, new ItemStack(Items.field_151069_bo));
            } else {
                entityPlayer.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
            if (horseType == 32) {
                if (this.getIsAdult() && this.func_110143_aJ() == this.func_110138_aP()) {
                    this.hasEatenBreedingItem = true;
                }
                this.func_70606_j(this.func_110138_aP());
            }
            if (horseType == 61) {
                this.transform(32);
                if (owner != null) {
                    owner.func_71064_a((StatBase)MoCAchievements.bat_horse, 1);
                }
            }
            if (horseType == 39) {
                this.transform(40);
                this.field_70178_ae = true;
                if (owner != null) {
                    owner.func_71064_a((StatBase)MoCAchievements.dark_pegasus, 1);
                }
            }
            this.drinkingHorse();
            return true;
        }
        return false;
    }

    private boolean interactIfItemstackisEssenceOfFire(EntityPlayer entityPlayer, int horseType, ItemStack itemStack, EntityPlayer owner, Item item) {
        if (item == MoCreatures.essenceFire) {
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, new ItemStack(Items.field_151069_bo));
            } else {
                entityPlayer.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
            if (this.isNightmare()) {
                if (this.getIsAdult() && this.func_110143_aJ() == this.func_110138_aP()) {
                    this.hasEatenBreedingItem = true;
                }
                this.func_70606_j(this.func_110138_aP());
            }
            if (horseType == 61) {
                this.transform(38);
                this.field_70178_ae = true;
                if (owner != null) {
                    owner.func_71064_a((StatBase)MoCAchievements.nightmare_horse, 1);
                }
            }
            this.drinkingHorse();
            return true;
        }
        return false;
    }

    private boolean interactIfItemstackIsEssenceOfUndead(EntityPlayer entityPlayer, int horseType, ItemStack itemStack, EntityPlayer owner, Item item) {
        if (item == MoCreatures.essenceUndead) {
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, new ItemStack(Items.field_151069_bo));
            } else {
                entityPlayer.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
            if (this.isUndead() || this.isGhostHorse()) {
                this.func_70606_j(this.func_110138_aP());
            } else if (owner != null) {
                owner.func_71064_a((StatBase)MoCAchievements.undead_horse, 1);
            }
            if (horseType == 39 || horseType == 32 || horseType == 40) {
                this.transform(25);
            } else if (horseType == 36 || horseType > 47 && horseType < 60) {
                this.transform(24);
            } else if (horseType < 21 || horseType == 60 || horseType == 61) {
                this.transform(23);
            }
            this.drinkingHorse();
            return true;
        }
        return false;
    }

    private boolean interactIfItemstackIsHorseArmor(EntityPlayer entityPlayer, ItemStack itemStack, Item item) {
        if (this.canWearRegularArmor() && (item == Items.field_151138_bX || item == Items.field_151136_bY || item == Items.field_151125_bZ)) {
            if (this.getArmorType() == 0) {
                MoCTools.playCustomSound((Entity)this, "armorput", this.field_70170_p);
            }
            this.dropArmor();
            byte regularArmorType = 0;
            if (item == Items.field_151138_bX) {
                regularArmorType = 1;
            }
            if (item == Items.field_151136_bY) {
                regularArmorType = 2;
            }
            if (item == Items.field_151125_bZ) {
                regularArmorType = 3;
            }
            this.setArmorType(regularArmorType);
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
            }
            return true;
        }
        if (item == MoCreatures.horseArmorCrystal && this.isMagicHorse()) {
            if (this.getArmorType() == 0) {
                MoCTools.playCustomSound((Entity)this, "armorput", this.field_70170_p);
            }
            this.dropArmor();
            this.setArmorType((byte)4);
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
            }
            return true;
        }
        return false;
    }

    public boolean isAmuletHorse() {
        return this.getType() >= 48 && this.getType() < 60 || this.getType() == 40 || this.getType() == 39 || this.getType() == 21 || this.getType() == 22 || this.getType() == 26 || this.getType() == 27 || this.getType() == 28;
    }

    public boolean canWearRegularArmor() {
        return this.getType() < 21;
    }

    public boolean isBagger() {
        return this.getType() == 66 || this.getType() == 65 || this.getType() == 67 || this.getType() == 39 || this.getType() == 40 || this.getType() == 25 || this.getType() == 28 || this.isFairyHorse();
    }

    public boolean isFloater() {
        return this.getType() == 36 || this.getType() == 27 || this.getType() == 24 || this.getType() == 22;
    }

    @Override
    public boolean isFlyer() {
        return this.getType() == 32 || this.isPegasus() || this.isFairyHorse() || this.getType() == 21;
    }

    public boolean isGhostHorse() {
        return this.getType() == 21 || this.getType() == 22;
    }

    public boolean isMagicHorse() {
        return this.getType() == 39 || this.getType() == 36 || this.getType() == 32 || this.getType() == 40 || this.isFairyHorse() || this.getType() == 21 || this.getType() == 22;
    }

    private boolean isPegasus() {
        return this.getType() == 39 || this.getType() == 40 || this.getType() == 25 || this.getType() == 28;
    }

    private boolean isFairyHorse() {
        return this.getType() >= 45 && this.getType() < 60;
    }

    protected void func_145780_a(int xCoord, int yCoord_, int zCoord, Block blockThatThisEntityIsWalkingOn) {
        if (!this.isGhostHorse()) {
            Block.SoundType soundType = blockThatThisEntityIsWalkingOn.field_149762_H;
            if (this.field_70170_p.func_147439_a(xCoord, yCoord_ + 1, zCoord) == Blocks.field_150431_aC) {
                soundType = Blocks.field_150431_aC.field_149762_H;
            }
            if (!blockThatThisEntityIsWalkingOn.func_149688_o().func_76224_d()) {
                if (this.field_70153_n != null) {
                    ++this.forwardMovementCounterForWalkingSoundEffect;
                    if (this.forwardMovementCounterForWalkingSoundEffect > 5 && this.forwardMovementCounterForWalkingSoundEffect % 3 == 0) {
                        this.func_85030_a("mob.horse.gallop", soundType.func_150497_c() * 0.15f, soundType.func_150494_d());
                        if (!this.isUndead() && this.field_70146_Z.nextInt(10) == 0) {
                            this.func_85030_a("mob.horse.breathe", soundType.func_150497_c() * 0.6f, soundType.func_150494_d());
                        }
                    } else if (this.forwardMovementCounterForWalkingSoundEffect <= 5) {
                        this.func_85030_a("mob.horse.wood", soundType.func_150497_c() * 0.15f, soundType.func_150494_d());
                    }
                } else if (soundType == Block.field_149766_f) {
                    this.func_85030_a("mob.horse.wood", soundType.func_150497_c() * 0.15f, soundType.func_150494_d());
                } else {
                    this.func_85030_a("mob.horse.soft", soundType.func_150497_c() * 0.15f, soundType.func_150494_d());
                }
            }
        }
    }

    @Override
    public void func_70612_e(float strafeMovement, float forwardMovement) {
        float movementForward;
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityLivingBase && (movementForward = ((EntityLivingBase)this.field_70153_n).field_70701_bs) <= 0.0f) {
            this.forwardMovementCounterForWalkingSoundEffect = 0;
        }
        super.func_70612_e(strafeMovement, forwardMovement);
    }

    protected boolean func_70780_i() {
        return this.getEating() || this.field_70153_n != null || this.standCounter != 0 || this.shuffleCounter != 0 || this.getVanishC() != 0;
    }

    public boolean isNightmare() {
        return this.getType() == 38;
    }

    public boolean isPureBreed() {
        return this.getType() > 10 && this.getType() < 21;
    }

    public boolean isUndead() {
        return this.isGhostHorse() || this.getType() == 23 || this.getType() == 24 || this.getType() == 25 || this.getType() == 26 || this.getType() == 27 || this.getType() == 28;
    }

    public boolean doesHaveHorn() {
        return this.getType() == 36 || this.isFairyHorse() || this.getType() == 27 || this.getType() == 24;
    }

    public boolean doesHaveChargeAbility() {
        return this.getType() == 38 || this.doesHaveHorn();
    }

    public boolean isZebraRunningAwayFromPlayer() {
        boolean flag = false;
        EntityPlayer entityPlayer = this.field_70170_p.func_72890_a((Entity)this, 8.0);
        if (entityPlayer != null) {
            MoCEntityHorse horseThatPlayerIsRiding;
            flag = true;
            if (entityPlayer.field_70154_o != null && entityPlayer.field_70154_o instanceof MoCEntityHorse && ((horseThatPlayerIsRiding = (MoCEntityHorse)entityPlayer.field_70154_o).getType() == 16 || horseThatPlayerIsRiding.getType() == 17 || horseThatPlayerIsRiding.getType() == 60 || horseThatPlayerIsRiding.getType() == 61)) {
                flag = false;
            }
        }
        if (flag) {
            MoCTools.runAway((EntityCreature)this, (Entity)entityPlayer);
        }
        return flag;
    }

    public void LavaFX() {
        MoCreatures.proxy.LavaFX((Entity)this);
    }

    public void MaterializeFX() {
        MoCreatures.proxy.MaterializeFX(this);
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    @Override
    public int nameYOffset() {
        if (this.getIsAdult()) {
            return -80;
        }
        return -5 - this.getMoCAge();
    }

    private void checkShufflingForTimeOut() {
        if (this.shuffleCounter > 0) {
            BlockJukebox blockjukebox;
            BlockJukebox.TileEntityJukebox jukeboxNearby = MoCTools.nearJukeBoxRecord((Entity)this, 8.0);
            if (this.shuffleCounter > 1000 && jukeboxNearby != null && (blockjukebox = (BlockJukebox)this.field_70170_p.func_147439_a(jukeboxNearby.field_145851_c, jukeboxNearby.field_145848_d, jukeboxNearby.field_145849_e)) != null) {
                blockjukebox.func_149925_e(this.field_70170_p, jukeboxNearby.field_145851_c, jukeboxNearby.field_145848_d, jukeboxNearby.field_145849_e);
            }
            if (this.shuffleCounter > 1000 || jukeboxNearby == null) {
                this.shuffleCounter = 0;
            }
        }
    }

    public void executeNightmareHorseFireTrail() {
        int xCoordinate = Math.round((float)this.field_70165_t);
        int yCoordinate = Math.round((float)this.field_70121_D.field_72338_b);
        int zCoordinate = Math.round((float)this.field_70161_v);
        Block block = this.field_70170_p.func_147439_a(xCoordinate, yCoordinate, zCoordinate);
        int metadata = this.field_70170_p.func_72805_g(xCoordinate, yCoordinate, zCoordinate);
        BlockEvent.BreakEvent event = null;
        if (!this.field_70170_p.field_72995_K) {
            event = new BlockEvent.BreakEvent(xCoordinate, yCoordinate, zCoordinate, this.field_70170_p, block, metadata, (EntityPlayer)FakePlayerFactory.get((WorldServer)DimensionManager.getWorld((int)this.field_70170_p.field_73011_w.field_76574_g), (GameProfile)MoCreatures.MOC_FAKE_PLAYER));
        }
        if (event != null && !event.isCanceled()) {
            this.field_70170_p.func_147465_d(xCoordinate, yCoordinate, zCoordinate, (Block)Blocks.field_150480_ab, 0, 3);
            EntityPlayer entityPlayer = (EntityPlayer)this.field_70153_n;
            if (entityPlayer != null && entityPlayer.func_70027_ad()) {
                entityPlayer.func_70066_B();
            }
            this.setNightmareFireTrailCounter(this.getNightmareFireTrailCounter() - 1);
        }
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        if (MoCreatures.isServer()) {
            if (this.field_70146_Z.nextInt(10) == 0 && this.getType() == 23 || this.getType() == 24 || this.getType() == 25) {
                MoCTools.spawnMaggots(this.field_70170_p, (Entity)this);
            }
            if (this.getIsTamed() && (this.isMagicHorse() || this.isPureBreed()) && !this.isGhostHorse() && this.field_70146_Z.nextInt(4) == 0) {
                MoCEntityHorse newGhostHorse = new MoCEntityHorse(this.field_70170_p);
                newGhostHorse.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)newGhostHorse);
                MoCTools.playCustomSound((Entity)this, "appearmagic", this.field_70170_p);
                EntityPlayer owner = this.field_70170_p.func_72924_a(this.getOwnerName());
                newGhostHorse.setOwner(this.getOwnerName());
                newGhostHorse.setTamed(true);
                if (owner != null) {
                    MoCTools.tameWithName(owner, newGhostHorse);
                    owner.func_71064_a((StatBase)MoCAchievements.ghost_horse, 1);
                }
                newGhostHorse.setAdult(false);
                newGhostHorse.setMoCAge(1);
                int ghostHorseType = 22;
                if (this.isFlyer()) {
                    ghostHorseType = 21;
                }
                newGhostHorse.setType(ghostHorseType);
            }
        }
    }

    @Override
    public void func_70636_d() {
        if (this.isHorseMadeFromEssenseOfLight() && this.func_110143_aJ() < this.func_110138_aP() && this.field_70146_Z.nextInt(100) == 0) {
            this.func_70691_i(1.0f);
        }
        if (!(this.field_70789_a == null || this.field_70789_a != this.field_70153_n || this.field_70153_n instanceof EntityPlayer && this.field_70153_n.func_70005_c_().equals(this.getOwnerName()))) {
            this.field_70153_n.func_70078_a(null);
        }
        if ((this.isFlyer() || this.isFloater()) && !this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        if (this.jumpPending) {
            if (this.isFlyer() && this.wingFlapCounter == 0) {
                MoCTools.playCustomSound((Entity)this, "wingflap", this.field_70170_p);
            }
            this.wingFlapCounter = 1;
        }
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.moveTail();
        }
        if (this.getType() == 38 && this.field_70146_Z.nextInt(50) == 0 && !MoCreatures.isServer()) {
            this.LavaFX();
        }
        if (this.getType() == 36 && this.isOnAir() && !MoCreatures.isServer()) {
            this.StarFX();
        }
        if (this.isOnAir() && this.isFlyer() && this.field_70146_Z.nextInt(30) == 0) {
            this.wingFlapCounter = 1;
        }
        if (this.field_70146_Z.nextInt(300) == 0 && this.field_70725_aQ == 0) {
            this.func_70691_i(1.0f);
        }
        if (this.isUndead() && this.getType() < 26 && this.getIsAdult() && this.field_70146_Z.nextInt(20) == 0) {
            if (MoCreatures.isServer()) {
                if (this.field_70146_Z.nextInt(16) == 0) {
                    this.setMoCAge(this.getMoCAge() + 1);
                }
                if (this.getMoCAge() >= 399) {
                    this.setType(this.getType() + 3);
                }
            } else {
                this.UndeadFX();
            }
        }
        super.func_70636_d();
        if (MoCreatures.isServer()) {
            MoCEntityHorse mommy;
            if (!this.getEating() && !this.getIsTamed() && this.field_70146_Z.nextInt(300) == 0) {
                this.func_70019_c(true);
            }
            if (this.getEating() && ++this.countEating > 50 && !this.getIsTamed()) {
                this.countEating = 0;
                this.func_70019_c(false);
            }
            if (this.getType() == 38 && this.field_70153_n != null && this.getNightmareFireTrailCounter() > 0 && this.field_70146_Z.nextInt(2) == 0) {
                this.executeNightmareHorseFireTrail();
            }
            if (this.getType() == 60 && !this.getIsTamed()) {
                this.isZebraRunningAwayFromPlayer();
            }
            if (!this.getIsAdult() && this.field_70146_Z.nextInt(200) == 0) {
                this.setMoCAge(this.getMoCAge() + 1);
                if (this.getMoCAge() >= 100) {
                    this.setAdult(true);
                    this.setBred(false);
                    MoCEntityHorse mommyHorse = this.getClosestMotherHorse((Entity)this, 16.0);
                    if (mommyHorse != null) {
                        mommyHorse.setBred(false);
                    }
                }
            }
            if (this.sprintCounter > 0 && this.sprintCounter < 150 && this.doesHaveHorn() && this.field_70153_n != null) {
                MoCTools.buckleMobs((EntityLiving)this, 2.0f, 2.0, this.field_70170_p);
            }
            if (this.isFlyer() && this.field_70146_Z.nextInt(100) == 0 && !this.func_70780_i() && !this.getEating()) {
                this.wingFlap();
            }
            if (this.getHasBred() && !this.getIsAdult() && this.roper == null && !this.getEating() && (mommy = this.getClosestMotherHorse((Entity)this, 16.0)) != null && MoCTools.getSqDistanceTo((Entity)mommy, this.field_70165_t, this.field_70163_u, this.field_70161_v) > 4.0) {
                PathEntity pathEntity = this.field_70170_p.func_72865_a((Entity)this, (Entity)mommy, 16.0f, true, false, false, true);
                this.func_70778_a(pathEntity);
            }
            if (!this.isReadyforParenting(this)) {
                return;
            }
            int i = 0;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(8.0, 3.0, 8.0));
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                if (!(entity instanceof MoCEntityHorse) && !(entity instanceof EntityHorse)) continue;
                ++i;
            }
            if (i > 1) {
                return;
            }
            List list1 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(4.0, 2.0, 4.0));
            for (int k = 0; k < list1.size(); ++k) {
                int horsemateType;
                Entity horsemate = (Entity)list1.get(k);
                boolean flag = horsemate instanceof EntityHorse;
                if (!(horsemate instanceof MoCEntityHorse) && !flag || horsemate == this) continue;
                if (!this.isReadyforParenting(this)) {
                    return;
                }
                if (!flag && !this.isReadyforParenting((MoCEntityHorse)horsemate)) {
                    return;
                }
                if (this.field_70146_Z.nextInt(100) == 0) {
                    ++this.gestationTime;
                }
                if (this.gestationTime % 3 == 0) {
                    MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageHeart(this.func_145782_y()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
                }
                if (this.gestationTime <= 50) continue;
                MoCEntityHorse babyHorse = new MoCEntityHorse(this.field_70170_p);
                babyHorse.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)babyHorse);
                this.hasEatenBreedingItem = false;
                this.gestationTime = 0;
                this.setBred(true);
                if (flag) {
                    horsemateType = this.translateVanillaHorseType((EntityHorse)horsemate);
                    if (horsemateType == -1) {
                        return;
                    }
                } else {
                    horsemateType = ((MoCEntityHorse)horsemate).getType();
                    ((MoCEntityHorse)horsemate).hasEatenBreedingItem = false;
                    ((MoCEntityHorse)horsemate).gestationTime = 0;
                }
                int type = this.horseGenetics(this.getType(), horsemateType);
                babyHorse.setOwner(this.getOwnerName());
                babyHorse.setTamed(true);
                babyHorse.setBred(true);
                babyHorse.setAdult(false);
                EntityPlayer owner = this.field_70170_p.func_72924_a(this.getOwnerName());
                if (owner != null) {
                    MoCTools.tameWithName(owner, babyHorse);
                }
                if (type > 10 && type < 16 && owner != null) {
                    owner.func_71064_a((StatBase)MoCAchievements.tier3_horse, 1);
                } else if (type > 15 && type < 21 && owner != null) {
                    owner.func_71064_a((StatBase)MoCAchievements.tier4_horse, 1);
                } else if (type == 67 && owner != null) {
                    owner.func_71064_a((StatBase)MoCAchievements.zonkey, 1);
                } else if (type == 50) {
                    MoCTools.playCustomSound((Entity)this, "appearmagic", this.field_70170_p);
                    if (owner != null) {
                        owner.func_71064_a((StatBase)MoCAchievements.fairy_horse, 1);
                    }
                    if (!flag) {
                        ((MoCEntityHorse)horsemate).disappearHorse();
                    }
                    this.disappearHorse();
                } else if (type == 61 && owner != null) {
                    owner.func_71064_a((StatBase)MoCAchievements.zorse, 1);
                }
                babyHorse.setType(type);
                babyHorse.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.calculateMaxHealth());
                babyHorse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getCustomSpeed());
                break;
            }
        }
    }

    private boolean isHorseMadeFromEssenseOfLight() {
        int horseType = this.getType();
        return horseType == 36 || horseType == 39 || horseType == 40 || this.isFairyHorse();
    }

    private int translateVanillaHorseType(EntityHorse horse) {
        if (horse.func_110265_bP() == 1) {
            return 65;
        }
        if (horse.func_110265_bP() == 0) {
            switch ((byte)horse.func_110202_bQ()) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 5;
                }
                case 5: {
                    return 9;
                }
                case 6: {
                    return 4;
                }
            }
            return 3;
        }
        return -1;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70153_n == null && (this.horseJumpPowerCounter != 0 || this.horseJumpPower != 0.0f)) {
            this.horseJumpPower = 0.0f;
            this.horseJumpPowerCounter = 0;
        }
        if (!this.isFlyer()) {
            if (this.isJumpKeyDown && this.getCustomIsOnGround() && this.horseJumpPowerCounter != -100) {
                ++this.horseJumpPowerCounter;
                this.horseJumpPower = this.horseJumpPowerCounter < 10 ? (float)this.horseJumpPowerCounter * 0.1f : 0.8f + 2.0f / (float)(this.horseJumpPowerCounter - 9) * 0.1f;
            } else if (!this.isJumpKeyDown && this.horseJumpPower > 0.0f) {
                if (this.horseJumpPowerCounter != -100) {
                    this.standCounter = 1;
                    if (MoCreatures.isServer()) {
                        double adjustedJumpStrength = this.getCustomJump() * (double)this.horseJumpPower;
                        this.field_70181_x = this.func_70058_J() ? adjustedJumpStrength : adjustedJumpStrength * 2.0;
                        this.field_70143_R = -25.0f;
                        this.setIsJumping(true);
                        this.jumpPending = false;
                        if (!this.isGhostHorse()) {
                            this.func_85030_a("mob.horse.jump", 0.4f, 1.0f);
                        }
                    }
                    this.horseJumpPowerCounter = -100;
                } else if (this.horseJumpPowerCounter == -100 && this.standCounter == 0) {
                    this.horseJumpPower = 0.0f;
                    this.horseJumpPowerCounter = 0;
                }
            }
        }
        if (!(this.getType() != 38 && this.getType() != 40 || this.field_70178_ae)) {
            this.field_70178_ae = true;
        }
        if (this.shuffleCounter > 0) {
            ++this.shuffleCounter;
            if (!MoCreatures.isServer() && this.getType() == 60 && this.shuffleCounter % 20 == 0) {
                double xVelocity = this.field_70146_Z.nextGaussian() * 0.5;
                double yVelocity = this.field_70146_Z.nextGaussian() * -0.1;
                double zVelocity = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_72869_a("note", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, xVelocity, yVelocity, zVelocity);
            }
        }
        this.checkShufflingForTimeOut();
        if (this.mouthCounter > 0 && ++this.mouthCounter > 30) {
            this.mouthCounter = 0;
        }
        if (this.standCounter > 0 && ++this.standCounter > 20) {
            this.standCounter = 0;
        }
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
        if (this.getVanishC() > 0) {
            this.setVanishC((byte)(this.getVanishC() + 1));
            if (this.getVanishC() < 15 && !MoCreatures.isServer()) {
                this.VanishFX();
            }
            if (this.getVanishC() > 100) {
                this.setVanishC((byte)101);
                MoCTools.dropHorseAmuletWithNewPetInformation(this);
                this.disappearHorse();
            }
            if (this.getVanishC() == 1) {
                MoCTools.playCustomSound((Entity)this, "vanish", this.field_70170_p);
            }
            if (this.getVanishC() == 70) {
                this.stand();
            }
        }
        if (this.sprintCounter > 0) {
            ++this.sprintCounter;
            if (this.sprintCounter < 150 && this.sprintCounter % 2 == 0 && !MoCreatures.isServer()) {
                this.StarFX();
            }
            if (this.sprintCounter > 300) {
                this.sprintCounter = 0;
            }
        }
        if (this.wingFlapCounter > 0) {
            ++this.wingFlapCounter;
            if (this.wingFlapCounter % 5 == 0 && !MoCreatures.isServer()) {
                this.StarFX();
            }
            if (this.wingFlapCounter > 20) {
                this.wingFlapCounter = 0;
            }
        }
        if (this.transformCounter > 0) {
            if (this.transformCounter == 40) {
                MoCTools.playCustomSound((Entity)this, "transform", this.field_70170_p);
            }
            if (++this.transformCounter > 100) {
                this.transformCounter = 0;
                if (this.transformType != 0) {
                    this.dropArmor();
                    this.setType(this.transformType);
                    this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.calculateMaxHealth());
                    this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getCustomSpeed());
                }
            }
        }
        if (this.isGhostHorse() && this.getMoCAge() < 10 && this.field_70146_Z.nextInt(7) == 0) {
            this.setMoCAge(this.getMoCAge() + 1);
        }
        if (this.isGhostHorse() && this.getMoCAge() == 9) {
            this.setMoCAge(100);
            this.setAdult(true);
        }
    }

    private void openMouth() {
        this.mouthCounter = 1;
    }

    public boolean isReadyforParenting(MoCEntityHorse entityhorse) {
        int i = entityhorse.getType();
        return entityhorse.field_70153_n == null && entityhorse.field_70154_o == null && entityhorse.getIsTamed() && entityhorse.hasEatenBreedingItem && entityhorse.getIsAdult() && !entityhorse.isUndead() && !entityhorse.isGhostHorse() && i != 61 && i < 66;
    }

    @Override
    public boolean shouldRenderName() {
        return this.getShouldDisplayName() && this.field_70153_n == null;
    }

    @Override
    public boolean rideableEntity() {
        return true;
    }

    @Override
    public double roperYOffset() {
        if (this.getIsAdult()) {
            return 0.0;
        }
        return (double)(130 - this.getMoCAge()) * 0.01;
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getType() == 0) {
            int typeChance;
            if (this.field_70146_Z.nextInt(5) == 0) {
                this.setAdult(false);
            }
            if ((typeChance = this.field_70146_Z.nextInt(100)) <= 56) {
                this.setType(7);
            } else if (typeChance <= 89) {
                this.setType(8);
            } else {
                this.setType(6);
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.calculateMaxHealth());
    }

    @Override
    public void setArmorType(byte i) {
        this.field_70180_af.func_75692_b(25, (Object)i);
    }

    public void setBred(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(26, (Object)input);
    }

    public void setChestedHorse(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(23, (Object)input);
    }

    public void func_70019_c(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(24, (Object)input);
    }

    public void setNightmareFireTrailCounter(int i) {
        this.nightmareFireTrailCounter = i;
    }

    public void setReproduced(boolean var1) {
        this.hasReproduced = var1;
    }

    @Override
    public void setRideable(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(22, (Object)input);
    }

    public void setRoped(boolean var1) {
    }

    public void setVanishC(byte i) {
        this.vanishCounter = i;
    }

    public void shuffle() {
        EntityPlayer closestEntityPlayer;
        if (this.shuffleCounter == 0) {
            this.shuffleCounter = 1;
        }
        if ((closestEntityPlayer = this.field_70170_p.func_72890_a((Entity)this, 8.0)) != null) {
            this.func_70625_a((Entity)closestEntityPlayer, 30.0f, 30.0f);
        }
    }

    public void stand() {
        if (!this.isFlyer() && this.getIsJumping() || this.field_70153_n == null && !this.isOnAir()) {
            this.standCounter = 1;
        }
    }

    public void func_70043_V() {
        super.func_70043_V();
        if (this.standCounter > 0) {
            float factor = 1.0f;
            float f = MathHelper.func_76126_a((float)(this.field_70761_aq * (float)Math.PI / 180.0f));
            float f1 = MathHelper.func_76134_b((float)(this.field_70761_aq * (float)Math.PI / 180.0f));
            float f2 = 0.7f * factor;
            float f3 = 0.15f * factor;
            this.field_70153_n.func_70107_b(this.field_70165_t + (double)(f2 * f), this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W() + (double)f3, this.field_70161_v - (double)(f2 * f1));
            if (this.field_70153_n instanceof EntityLivingBase) {
                ((EntityLivingBase)this.field_70153_n).field_70761_aq = this.field_70761_aq;
            }
        }
    }

    public void StarFX() {
        MoCreatures.proxy.StarFX(this);
    }

    public float ghostHorseTransparencyFloat() {
        if (++this.flickerCounter > 60) {
            this.flickerCounter = 0;
            this.transparencyFloat = this.field_70146_Z.nextFloat() * 0.3f + 0.3f;
        }
        if (this.isGhostHorse() && this.getMoCAge() < 10) {
            this.transparencyFloat = 0.0f;
        }
        return this.transparencyFloat;
    }

    public void transform(int tType) {
        if (MoCreatures.isServer()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), tType), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        this.transformType = tType;
        if (this.field_70153_n == null && this.transformType != 0) {
            this.dropArmor();
            this.transformCounter = 1;
        }
    }

    public void UndeadFX() {
        MoCreatures.proxy.UndeadFX((Entity)this);
    }

    public void VanishFX() {
        MoCreatures.proxy.VanishFX(this);
    }

    public void vanishHorse() {
        this.func_70778_a(null);
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
        if (this.isBagger()) {
            MoCTools.dropInventory((Entity)this, this.localHorseChest);
            this.dropBags();
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageVanish(this.func_145782_y()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
            this.setVanishC((byte)1);
        }
        MoCTools.playCustomSound((Entity)this, "vanish", this.field_70170_p);
    }

    @Override
    public void dropMyStuff() {
        this.dropArmor();
        MoCTools.dropSaddle(this, this.field_70170_p);
        if (this.isBagger()) {
            MoCTools.dropInventory((Entity)this, this.localHorseChest);
            this.dropBags();
        }
    }

    public void wingFlap() {
        if (this.isFlyer() && this.wingFlapCounter == 0) {
            MoCTools.playCustomSound((Entity)this, "wingflap", this.field_70170_p);
        }
        this.wingFlapCounter = 1;
        this.field_70181_x = 0.5;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("Saddle", this.getIsRideable());
        nbtTagCompound.func_74757_a("EatingHaystack", this.getEating());
        nbtTagCompound.func_74757_a("ChestedHorse", this.getIsChestedHorse());
        nbtTagCompound.func_74757_a("HasReproduced", this.getHasReproduced());
        nbtTagCompound.func_74757_a("Bred", this.getHasBred());
        nbtTagCompound.func_74757_a("DisplayName", this.getShouldDisplayName());
        nbtTagCompound.func_74768_a("ArmorType", (int)this.getArmorType());
        if (this.getIsChestedHorse() && this.localHorseChest != null) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int index = 0; index < this.localHorseChest.func_70302_i_(); ++index) {
                this.localItemstack = this.localHorseChest.func_70301_a(index);
                if (this.localItemstack == null) continue;
                NBTTagCompound nbtTagCompound1 = new NBTTagCompound();
                nbtTagCompound1.func_74774_a("Slot", (byte)index);
                this.localItemstack.func_77955_b(nbtTagCompound1);
                nbttaglist.func_74742_a((NBTBase)nbtTagCompound1);
            }
            nbtTagCompound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setRideable(nbtTagCompound.func_74767_n("Saddle"));
        this.func_70019_c(nbtTagCompound.func_74767_n("EatingHaystack"));
        this.setBred(nbtTagCompound.func_74767_n("Bred"));
        this.setChestedHorse(nbtTagCompound.func_74767_n("ChestedHorse"));
        this.setReproduced(nbtTagCompound.func_74767_n("HasReproduced"));
        this.setDisplayName(nbtTagCompound.func_74767_n("DisplayName"));
        this.setArmorType((byte)nbtTagCompound.func_74762_e("ArmorType"));
        if (this.getIsChestedHorse()) {
            NBTTagList nbtTagList = nbtTagCompound.func_150295_c("Items", 10);
            this.localHorseChest = new MoCAnimalChest(StatCollector.func_74838_a((String)"container.MoCreatures.HorseChest"), this.getInventorySize());
            for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
                NBTTagCompound nbtTagCompound1 = nbtTagList.func_150305_b(i);
                int j = nbtTagCompound1.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.localHorseChest.func_70302_i_()) continue;
                this.localHorseChest.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound1));
            }
        }
    }

    @Override
    public boolean updateMount() {
        return this.getIsTamed();
    }

    @Override
    public boolean forceUpdates() {
        return this.getIsTamed();
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType >= 23 && animationType < 60) {
            this.transformType = animationType;
            this.transformCounter = 1;
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        if (this.isUndead()) {
            return EnumCreatureAttribute.UNDEAD;
        }
        return super.func_70668_bt();
    }

    @Override
    protected boolean canBeTrappedInAmulet() {
        return this.getIsTamed() && !this.isAmuletHorse();
    }

    public int func_70641_bl() {
        return 4;
    }

    public void setJumpKeyDown(boolean flag) {
        this.isJumpKeyDown = flag;
    }

    public boolean getIsJumpKeyDown() {
        return this.isJumpKeyDown;
    }

    public float getHorseJumpPower() {
        return this.horseJumpPower;
    }

    private boolean getCustomIsOnGround() {
        return !this.field_70170_p.func_147437_c((int)Math.round(this.field_70165_t), (int)Math.round(this.field_70163_u - 1.0), (int)Math.round(this.field_70161_v));
    }
}

