/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.animal;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.animal.MoCEntityKomodoDragon;
import drzhark.mocreatures.entity.aquatic.MoCEntityJellyFish;
import drzhark.mocreatures.entity.aquatic.MoCEntityRay;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.oredict.OreDictionary;

public class MoCEntityFox
extends MoCEntityTameableAnimal {
    protected double attackRange;
    protected int attackDamage;

    public MoCEntityFox(World world) {
        super(world);
        this.func_70105_a(0.9f, 1.3f);
        this.attackDamage = 2;
        this.attackRange = 4.0;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
    }

    @Override
    public boolean isPredator() {
        return true;
    }

    @Override
    public boolean doesForageForFood() {
        return true;
    }

    @Override
    protected boolean func_70692_ba() {
        return !this.getIsTamed() && this.field_70173_aa > 2400;
    }

    protected void func_70785_a(Entity entity, float distanceToEntity) {
        if (this.field_70724_aR <= 0 && (double)distanceToEntity < 2.0 && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 20;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.attackDamage);
        }
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getType() == 0) {
            this.setType(1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("fox.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("foxsnow.png");
            }
        }
        return MoCreatures.proxy.getTexture("fox.png");
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        if (super.func_70097_a(damageSource, damageTaken)) {
            Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
            if (entityThatAttackedThisCreature != null && this.getIsTamed() && entityThatAttackedThisCreature instanceof EntityPlayer && entityThatAttackedThisCreature.func_70005_c_().equals(this.getOwnerName())) {
                return false;
            }
            if (this.field_70153_n == entityThatAttackedThisCreature || this.field_70154_o == entityThatAttackedThisCreature) {
                return true;
            }
            if (entityThatAttackedThisCreature != this && this.field_70170_p.field_73013_u.func_151525_a() > 0) {
                this.field_70789_a = entityThatAttackedThisCreature;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityPlayer) {
        if (super.func_70085_c(entityPlayer)) {
            return false;
        }
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (itemStack != null && (itemStack.func_77973_b() == MoCreatures.turkeyRaw || MoCreatures.isGregTech6Loaded && OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)itemStack)) == "foodScrapmeat")) {
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
            }
            if (MoCreatures.isServer() && !this.getIsTamed()) {
                MoCTools.tameWithName(entityPlayer, this);
            }
            this.func_70691_i(5.0f);
            if (MoCreatures.isServer() && !this.getIsAdult() && this.getMoCAge() < 100) {
                this.setMoCAge(this.getMoCAge() + 1);
            }
            MoCTools.playCustomSound((Entity)this, "eating", this.field_70170_p);
            return true;
        }
        return false;
    }

    @Override
    public boolean isNotScared() {
        return true;
    }

    @Override
    public boolean shouldEntityBeIgnored(Entity entity) {
        return super.shouldEntityBeIgnored(entity) || entity instanceof MoCEntityFox || (double)entity.field_70130_N > 0.5 && (double)entity.field_70131_O > 0.5 || entity instanceof MoCEntityKomodoDragon || entity instanceof MoCEntityJellyFish || entity instanceof MoCEntityRay || entity instanceof EntitySquid || this.getIsTamed() && entity instanceof IMoCEntity && ((IMoCEntity)entity).getIsTamed();
    }

    @Override
    protected Entity func_70782_k() {
        if (this.field_70146_Z.nextInt(80) == 0 && this.field_70170_p.field_73013_u.func_151525_a() > 0) {
            EntityLivingBase closestEntityLiving = MoCTools.getClosestEntityLivingThatCanBeTargetted((Entity)this, 8.0);
            if (this.shouldEntityBeIgnored((Entity)closestEntityLiving)) {
                return null;
            }
            if (closestEntityLiving != null && !MoCTools.isEntityAFishThatIsInTheOcean((Entity)closestEntityLiving)) {
                return closestEntityLiving;
            }
        }
        return null;
    }

    @Override
    public boolean checkSpawningBiome() {
        int zCoordinate;
        int yCoordinate;
        int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
        BiomeGenBase currentBiome = MoCTools.biomekind(this.field_70170_p, xCoordinate, yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v));
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            this.setType(2);
        }
        return true;
    }

    protected String func_70673_aS() {
        return "mocreatures:foxdying";
    }

    protected Item func_146068_u() {
        return MoCreatures.fur;
    }

    protected String func_70621_aR() {
        return "mocreatures:foxhurt";
    }

    protected String func_70639_aQ() {
        return "mocreatures:foxcall";
    }

    protected float func_70599_aP() {
        return 0.3f;
    }

    @Override
    public boolean isMyHealFood(ItemStack itemStack) {
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            List<String> oreDictionaryNameArray = MoCTools.getOreDictionaryEntries(itemStack);
            return this.isItemEdible(item) || item == Items.field_151147_al || item == Items.field_151082_bd || item == Items.field_151076_bf || item == Items.field_151115_aP && itemStack.func_77960_j() != 3 || item == MoCreatures.ratRaw || item == MoCreatures.turkeyRaw || item == MoCreatures.ostrichRaw || Item.field_150901_e.func_148750_c((Object)item).equals("etfuturum:rabbit_raw") || oreDictionaryNameArray.contains("listAllmeatraw") || oreDictionaryNameArray.contains("listAllfishraw") || MoCreatures.isGregTech6Loaded && oreDictionaryNameArray.contains("foodScrapmeat");
        }
        return false;
    }

    @Override
    public int nameYOffset() {
        return -50;
    }

    @Override
    public double roperYOffset() {
        return 0.8;
    }

    @Override
    public boolean isSwimmerEntity() {
        return true;
    }
}

