/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.animal;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.achievements.MoCAchievements;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.item.MoCEntityMammothPlatform;
import drzhark.mocreatures.inventory.MoCAnimalChest;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class MoCEntityElephant
extends MoCEntityTameableAnimal {
    public int sprintCounter;
    public int sitCounter;
    public MoCAnimalChest localElephantChest;
    public MoCAnimalChest localElephantChest2;
    public MoCAnimalChest localElephantChest3;
    public MoCAnimalChest localElephantChest4;
    public ItemStack localItemstack;
    boolean hasPlatform;
    public int tailCounter;
    private byte tuskUses;
    private byte temper;

    public MoCEntityElephant(World world) {
        super(world);
        this.setAdult(true);
        this.setTamed(false);
        this.setMoCAge(50);
        this.func_70105_a(1.1f, 3.0f);
        this.field_70138_W = 1.0f;
        if (MoCreatures.isServer()) {
            if (this.field_70146_Z.nextInt(4) == 0) {
                this.setAdult(false);
            } else {
                this.setAdult(true);
            }
        }
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getType() == 0 && this.checkSpawningBiome()) {
            int typeChance = this.field_70146_Z.nextInt(100);
            if (typeChance <= 50) {
                this.setType(1);
            } else {
                this.setType(2);
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getCustomSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.calculateMaxHealth());
        this.func_70606_j(this.func_110138_aP());
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)0);
    }

    public byte getTusks() {
        return this.field_70180_af.func_75683_a(23);
    }

    public void setTusks(byte b) {
        this.field_70180_af.func_75692_b(23, (Object)b);
    }

    @Override
    public byte getArmorType() {
        return this.field_70180_af.func_75683_a(22);
    }

    @Override
    public void setArmorType(byte b) {
        this.field_70180_af.func_75692_b(22, (Object)b);
    }

    public byte getStorage() {
        return this.field_70180_af.func_75683_a(24);
    }

    public void setStorage(byte b) {
        this.field_70180_af.func_75692_b(24, (Object)b);
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("elephantafrican.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("elephantindian.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("mammoth.png");
            }
            case 4: {
                return MoCreatures.proxy.getTexture("mammothsonghua.png");
            }
            case 5: {
                return MoCreatures.proxy.getTexture("elephantindianpretty.png");
            }
        }
        return MoCreatures.proxy.getTexture("elephantafrican.png");
    }

    public float calculateMaxHealth() {
        switch (this.getType()) {
            case 1: {
                return 40.0f;
            }
            case 2: {
                return 30.0f;
            }
            case 3: {
                return 50.0f;
            }
            case 4: {
                return 60.0f;
            }
            case 5: {
                return 40.0f;
            }
        }
        return 30.0f;
    }

    @Override
    public double getCustomSpeed() {
        if (this.sitCounter != 0) {
            return 0.0;
        }
        double speed = 0.5;
        switch (this.getType()) {
            case 1: {
                speed = 0.8;
                break;
            }
            case 2: {
                speed = 0.9;
                break;
            }
            case 3: {
                speed = 0.7;
                break;
            }
            case 4: {
                speed = 0.7;
                break;
            }
            case 5: {
                speed = 0.9;
                break;
            }
            default: {
                speed = 0.6;
            }
        }
        if (this.sprintCounter > 0 && this.sprintCounter < 150) {
            speed *= 1.5;
        }
        return speed;
    }

    @Override
    public void func_70636_d() {
        EntityPlayer entityPlayer;
        if (this.rideableEntity() && this.field_70153_n instanceof EntityPlayer && (entityPlayer = (EntityPlayer)this.field_70153_n).func_70093_af() && MoCreatures.isServer()) {
            if (this.sitCounter == 0) {
                this.sit();
            }
            if (this.sitCounter >= 50) {
                entityPlayer.func_70078_a(null);
            }
        }
        if (!(this.field_70789_a == null || this.field_70789_a != this.field_70153_n || this.field_70153_n instanceof EntityPlayer && this.field_70153_n.func_70005_c_().equals(this.getOwnerName()))) {
            this.field_70153_n.func_70078_a(null);
        }
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.tailCounter = 1;
        }
        super.func_70636_d();
        if (this.sprintCounter > 0) {
            ++this.sprintCounter;
            if (this.sprintCounter > 300) {
                this.sprintCounter = 0;
            }
        }
        if (MoCreatures.isServer()) {
            EntityLivingBase entityThatAttackedOwner;
            double distanceToOwner;
            EntityPlayerMP ownerOfEntityThatIsOnline;
            if (!this.getIsAdult() && this.field_70146_Z.nextInt(1000) == 0) {
                this.setMoCAge(this.getMoCAge() + 1);
                if (this.getMoCAge() >= 100) {
                    this.setAdult(true);
                }
            }
            if (MoCreatures.proxy.specialPetsDefendOwner && this.getIsTamed() && this.field_70153_n == null && (ownerOfEntityThatIsOnline = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(this.getOwnerName())) != null && (distanceToOwner = MoCTools.getSqDistanceTo((Entity)this, ownerOfEntityThatIsOnline.field_70165_t, ownerOfEntityThatIsOnline.field_70163_u, ownerOfEntityThatIsOnline.field_70161_v)) < 20.0 && (entityThatAttackedOwner = ownerOfEntityThatIsOnline.func_70643_av()) != null) {
                this.func_70784_b((Entity)entityThatAttackedOwner);
            }
            if (this.field_70789_a != null && this.getIsAdult() && this.field_70153_n == null && this.sprintCounter == 0) {
                this.sprintCounter = 1;
            }
            if (this.sprintCounter > 0 && this.sprintCounter < 150 && this.field_70153_n != null) {
                float ramAttackDamage = this.calculateAttackDamage() / 2.0f;
                MoCTools.buckleMobsNotPlayers((EntityLiving)this, ramAttackDamage, 3.0, this.field_70170_p);
            }
            if (this.getIsTamed() && this.getArmorType() >= 1 && this.field_70146_Z.nextInt(20) == 0 && this.sprintCounter == 0 && (this.field_70153_n == null || this.getArmorType() >= 3 && this.field_70789_a == null && this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && ((EntityLivingBase)this.field_70153_n).func_70643_av() == null && !this.secondRider())) {
                EntityPlayer playerNearby = this.field_70170_p.func_72890_a((Entity)this, 3.0);
                if (playerNearby != null && (!MoCreatures.proxy.enableStrictOwnership || playerNearby.func_70005_c_().equals(this.getOwnerName())) && playerNearby.func_70093_af()) {
                    this.sit();
                }
                if (this.sitCounter > 0 && this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && this.getArmorType() >= 3 && playerNearby != this.field_70153_n && !this.secondRider() && playerNearby.field_70160_al) {
                    this.mountSecondPlayer((Entity)playerNearby);
                    this.sitCounter = 0;
                }
            }
            if (MoCreatures.proxy.elephantBulldozer && this.getIsTamed() && this.field_70153_n != null && this.getTusks() > 0 && this.sprintCounter > 0) {
                int heightWithinToDestroyBlocks = 2;
                if (this.getType() == 3) {
                    heightWithinToDestroyBlocks = 3;
                }
                if (this.getType() == 4) {
                    heightWithinToDestroyBlocks = 3;
                }
                int dmg = MoCTools.destroyBlocksInFront((Entity)this, 2.0, this.getTusks(), heightWithinToDestroyBlocks);
                this.checkTusks(dmg);
            }
            if (this.field_70153_n == null && this.field_70146_Z.nextInt(100) == 0) {
                this.destroyPlatforms();
            }
        }
        if (this.sitCounter != 0 && ++this.sitCounter > 100) {
            this.sitCounter = 0;
        }
    }

    private boolean secondRider() {
        List entitiesNearbyList = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(3.0, 3.0, 3.0));
        int iterationLength = entitiesNearbyList.size();
        if (iterationLength > 0) {
            for (int index = 0; index < iterationLength; ++index) {
                Entity entityNearby = (Entity)entitiesNearbyList.get(index);
                if (!(entityNearby instanceof MoCEntityMammothPlatform) || entityNearby.field_70153_n == null) continue;
                return true;
            }
        }
        return false;
    }

    private void checkTusks(int dmg) {
        this.tuskUses = (byte)(this.tuskUses + (byte)dmg);
        if (this.getTusks() == 1 && this.tuskUses > 59 || this.getTusks() == 2 && this.tuskUses > 250 || this.getTusks() == 3 && this.tuskUses > 1000) {
            this.func_85030_a("random.break", 1.0f, 1.0f);
            this.setTusks((byte)0);
        }
    }

    private void destroyPlatforms() {
        List entitiesNearbyList = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(3.0, 3.0, 3.0));
        int iterationLength = entitiesNearbyList.size();
        if (iterationLength > 0) {
            for (int index = 0; index < iterationLength; ++index) {
                Entity entityNearby = (Entity)entitiesNearbyList.get(index);
                if (!(entityNearby instanceof MoCEntityMammothPlatform)) continue;
                entityNearby.func_70106_y();
            }
        }
    }

    private void sit() {
        this.sitCounter = 1;
        if (MoCreatures.isServer()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 0), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        this.func_70778_a(null);
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 0) {
            this.sitCounter = 1;
            this.func_70778_a(null);
        }
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityPlayer) {
        if (super.func_70085_c(entityPlayer)) {
            return false;
        }
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (itemStack != null) {
            List<String> oreDictionaryNameArray;
            Item item = itemStack.func_77973_b();
            if (this.interactIfItemIsFoodItem(entityPlayer, itemStack, item, oreDictionaryNameArray = MoCTools.getOreDictionaryEntries(itemStack))) {
                return true;
            }
            if (this.getIsTamed() && this.getIsAdult()) {
                if (this.getArmorType() == 0 && item == MoCreatures.elephantHarness) {
                    if (--itemStack.field_77994_a == 0) {
                        entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                    }
                    MoCTools.playCustomSound((Entity)this, "roping", this.field_70170_p);
                    this.setArmorType((byte)1);
                    return true;
                }
                if (this.getArmorType() >= 1 && item == MoCreatures.elephantChest && this.getStorage() != 2 || item == Item.func_150898_a((Block)Blocks.field_150486_ae) && this.isMammoth() && this.getStorage() != 4) {
                    if (--itemStack.field_77994_a == 0) {
                        entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                    }
                    MoCTools.playCustomSound((Entity)this, "roping", this.field_70170_p);
                    if (item == MoCreatures.elephantChest) {
                        if (this.getStorage() == 0) {
                            this.setStorage((byte)1);
                            entityPlayer.func_71064_a((StatBase)MoCAchievements.elephant_chest, 1);
                            return true;
                        }
                        if (this.getStorage() == 1) {
                            this.setStorage((byte)2);
                            return true;
                        }
                    }
                    if (item == Item.func_150898_a((Block)Blocks.field_150486_ae)) {
                        if (this.getStorage() == 2) {
                            this.setStorage((byte)3);
                            return true;
                        }
                        if (this.getStorage() == 3) {
                            this.setStorage((byte)4);
                            return true;
                        }
                    }
                    return true;
                }
                if (this.getArmorType() == 1 && this.getType() == 2 && item == MoCreatures.elephantGarment) {
                    if (--itemStack.field_77994_a == 0) {
                        entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                    }
                    MoCTools.playCustomSound((Entity)this, "roping", this.field_70170_p);
                    this.setArmorType((byte)2);
                    this.setType(5);
                    entityPlayer.func_71064_a((StatBase)MoCAchievements.elephant_garment, 1);
                    return true;
                }
                if (this.getArmorType() == 2 && this.getType() == 5 && item == MoCreatures.elephantHowdah) {
                    if (--itemStack.field_77994_a == 0) {
                        entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                    }
                    MoCTools.playCustomSound((Entity)this, "roping", this.field_70170_p);
                    this.setArmorType((byte)3);
                    entityPlayer.func_71064_a((StatBase)MoCAchievements.elephant_howdah, 1);
                    return true;
                }
                if (this.getArmorType() == 1 && this.getType() == 4 && item == MoCreatures.mammothPlatform) {
                    if (--itemStack.field_77994_a == 0) {
                        entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                    }
                    MoCTools.playCustomSound((Entity)this, "armoroff", this.field_70170_p);
                    this.setArmorType((byte)3);
                    entityPlayer.func_71064_a((StatBase)MoCAchievements.mammoth_platform, 1);
                    return true;
                }
                if (item == MoCreatures.tusksWood || item == MoCreatures.tusksIron || item == MoCreatures.tusksDiamond) {
                    byte tuskType = 0;
                    if (item == MoCreatures.tusksWood) {
                        tuskType = 1;
                    }
                    if (item == MoCreatures.tusksIron) {
                        tuskType = 2;
                    }
                    if (item == MoCreatures.tusksDiamond) {
                        tuskType = 3;
                    }
                    if (--itemStack.field_77994_a == 0) {
                        entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
                    }
                    MoCTools.playCustomSound((Entity)this, "armoroff", this.field_70170_p);
                    this.dropTusks();
                    this.tuskUses = 0;
                    this.setTusks(tuskType);
                    entityPlayer.func_71064_a((StatBase)MoCAchievements.elephant_tusks, 1);
                    return true;
                }
            }
            if (this.getTusks() > 0 && item == Items.field_151097_aZ) {
                MoCTools.playCustomSound((Entity)this, "armoroff", this.field_70170_p);
                this.dropTusks();
                return true;
            }
        }
        if (MoCreatures.proxy.emptyHandMountAndPickUpOnly && itemStack == null || !MoCreatures.proxy.emptyHandMountAndPickUpOnly) {
            if (entityPlayer.func_70093_af() && this.getStorage() > 0) {
                if (this.tryToOpenElephantChest(entityPlayer)) {
                    return true;
                }
            } else if (this.sitCounter != 0 && this.getIsTamed() && this.getIsAdult() && this.field_70153_n == null && this.getArmorType() >= 1) {
                entityPlayer.field_70177_z = this.field_70177_z;
                entityPlayer.field_70125_A = this.field_70125_A;
                this.sitCounter = 0;
                entityPlayer.func_70078_a((Entity)this);
                entityPlayer.func_71064_a((StatBase)MoCAchievements.mount_elephant, 1);
                return true;
            }
        }
        return false;
    }

    private boolean tryToOpenElephantChest(EntityPlayer entityPlayer) {
        if (this.localElephantChest == null) {
            this.localElephantChest = new MoCAnimalChest(StatCollector.func_74838_a((String)"container.MoCreatures.ElephantChest"), 18);
        }
        if (this.getStorage() == 1) {
            if (MoCreatures.isServer()) {
                entityPlayer.func_71007_a((IInventory)this.localElephantChest);
            }
            return true;
        }
        if (this.getStorage() == 2) {
            if (this.localElephantChest2 == null) {
                this.localElephantChest2 = new MoCAnimalChest(StatCollector.func_74838_a((String)"container.MoCreatures.ElephantChest"), 18);
            }
            InventoryLargeChest doubleChest = new InventoryLargeChest(StatCollector.func_74838_a((String)"container.MoCreatures.ElephantChest"), (IInventory)this.localElephantChest, (IInventory)this.localElephantChest2);
            if (MoCreatures.isServer()) {
                entityPlayer.func_71007_a((IInventory)doubleChest);
            }
            return true;
        }
        if (this.getStorage() == 3) {
            if (this.localElephantChest2 == null) {
                this.localElephantChest2 = new MoCAnimalChest(StatCollector.func_74838_a((String)"container.MoCreatures.ElephantChest"), 18);
            }
            if (this.localElephantChest3 == null) {
                this.localElephantChest3 = new MoCAnimalChest(StatCollector.func_74838_a((String)"container.MoCreatures.ElephantChest"), 9);
            }
            InventoryLargeChest doubleChest = new InventoryLargeChest(StatCollector.func_74838_a((String)"container.MoCreatures.ElephantChest"), (IInventory)this.localElephantChest, (IInventory)this.localElephantChest2);
            InventoryLargeChest tripleChest = new InventoryLargeChest(StatCollector.func_74838_a((String)"container.MoCreatures.ElephantChest"), (IInventory)doubleChest, (IInventory)this.localElephantChest3);
            if (MoCreatures.isServer()) {
                entityPlayer.func_71007_a((IInventory)tripleChest);
            }
            return true;
        }
        if (this.getStorage() == 4) {
            if (this.localElephantChest2 == null) {
                this.localElephantChest2 = new MoCAnimalChest(StatCollector.func_74838_a((String)"container.MoCreatures.ElephantChest"), 18);
            }
            if (this.localElephantChest3 == null) {
                this.localElephantChest3 = new MoCAnimalChest(StatCollector.func_74838_a((String)"container.MoCreatures.ElephantChest"), 9);
            }
            if (this.localElephantChest4 == null) {
                this.localElephantChest4 = new MoCAnimalChest(StatCollector.func_74838_a((String)"container.MoCreatures.ElephantChest"), 9);
            }
            InventoryLargeChest doubleChest = new InventoryLargeChest(StatCollector.func_74838_a((String)"container.MoCreatures.ElephantChest"), (IInventory)this.localElephantChest, (IInventory)this.localElephantChest2);
            InventoryLargeChest doubleChestb = new InventoryLargeChest(StatCollector.func_74838_a((String)"container.MoCreatures.ElephantChest"), (IInventory)this.localElephantChest3, (IInventory)this.localElephantChest4);
            InventoryLargeChest fourChest = new InventoryLargeChest(StatCollector.func_74838_a((String)"container.MoCreatures.ElephantChest"), (IInventory)doubleChest, (IInventory)doubleChestb);
            if (MoCreatures.isServer()) {
                entityPlayer.func_71007_a((IInventory)fourChest);
            }
            return true;
        }
        return false;
    }

    private boolean interactIfItemIsFoodItem(EntityPlayer entityPlayer, ItemStack itemStack, Item item, List<String> oreDictionaryNameArray) {
        if (item == MoCreatures.sugarLump || item == Items.field_151015_O || Item.field_150901_e.func_148750_c((Object)item).equals("tropicraft:coconutChunk") || Item.field_150901_e.func_148750_c((Object)item).equals("tropicraft:pineappleCubes") || Item.field_150901_e.func_148750_c((Object)item).equals("harvestcraft:coconutItem") || oreDictionaryNameArray.size() > 0 && (oreDictionaryNameArray.contains("listAllfruit") || oreDictionaryNameArray.contains("listAllwheats") || oreDictionaryNameArray.contains("listAllgrain") || oreDictionaryNameArray.contains("cropCoconut") || MoCreatures.isGregTech6Loaded && (oreDictionaryNameArray.contains("itemGrass") || oreDictionaryNameArray.contains("itemGrassDry") || oreDictionaryNameArray.contains("cropGrain")))) {
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
            }
            MoCTools.playCustomSound((Entity)this, "eating", this.field_70170_p);
            this.func_70691_i(5.0f);
            if (!this.getIsTamed() && !this.getIsAdult() && item == MoCreatures.sugarLump) {
                this.temper = (byte)(this.temper + 1);
                if (MoCreatures.isServer() && !this.getIsAdult() && !this.getIsTamed() && this.temper >= 10) {
                    this.setTamed(true);
                    MoCTools.tameWithName(entityPlayer, this);
                    entityPlayer.func_71064_a((StatBase)MoCAchievements.tame_elephant, 1);
                }
            }
            return true;
        }
        return false;
    }

    private void mountSecondPlayer(Entity entity) {
        double yOffset = 2.0;
        MoCEntityMammothPlatform platform = new MoCEntityMammothPlatform(this.field_70170_p, this.func_145782_y(), yOffset, 1.25);
        platform.func_70107_b(this.field_70165_t, this.field_70163_u + yOffset, this.field_70161_v);
        this.field_70170_p.func_72838_d((Entity)platform);
        entity.func_70078_a((Entity)platform);
    }

    private void dropTusks() {
        if (!MoCreatures.isServer()) {
            return;
        }
        byte tuskIndex = this.getTusks();
        Object tuskItemToDrop = MoCreatures.tusksWood;
        tuskItemToDrop = tuskIndex == 1 ? MoCreatures.tusksWood : (tuskIndex == 2 ? MoCreatures.tusksIron : (tuskIndex == 3 ? MoCreatures.tusksDiamond : null));
        if (tuskItemToDrop != null) {
            EntityItem entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(tuskItemToDrop, 1, (int)this.tuskUses));
            entityItem.field_145804_b = 10;
            this.field_70170_p.func_72838_d((Entity)entityItem);
        }
        this.setTusks((byte)0);
        this.tuskUses = 0;
    }

    @Override
    public boolean rideableEntity() {
        return true;
    }

    @Override
    public boolean updateMount() {
        return this.getIsTamed();
    }

    @Override
    public boolean forceUpdates() {
        return this.getIsTamed();
    }

    @Override
    public boolean checkSpawningBiome() {
        int zCoordinate;
        int yCoordinate;
        int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
        BiomeGenBase currentBiome = MoCTools.biomekind(this.field_70170_p, xCoordinate, yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v));
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            this.setType(3 + this.field_70146_Z.nextInt(2));
            return true;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA)) {
            if (!currentBiome.field_76791_y.toLowerCase().contains("outback")) {
                this.setType(1);
                return true;
            }
            return false;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            this.setType(2);
            return true;
        }
        return true;
    }

    @Override
    public float getSizeFactor() {
        float size = 1.25f;
        switch (this.getType()) {
            case 4: {
                size *= 1.2f;
                break;
            }
            case 2: 
            case 5: {
                size *= 0.8f;
            }
        }
        if (!this.getIsAdult()) {
            size *= (float)this.getMoCAge() * 0.01f;
        }
        return size;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        int j;
        NBTTagCompound nbtTagCompound1;
        int i;
        NBTTagList nbttaglist;
        super.func_70037_a(nbtTagCompound);
        this.setTusks(nbtTagCompound.func_74771_c("Tusks"));
        this.setArmorType(nbtTagCompound.func_74771_c("Harness"));
        this.setStorage(nbtTagCompound.func_74771_c("Storage"));
        this.tuskUses = nbtTagCompound.func_74771_c("TuskUses");
        if (this.getStorage() > 0) {
            nbttaglist = nbtTagCompound.func_150295_c("Items", 10);
            this.localElephantChest = new MoCAnimalChest(StatCollector.func_74838_a((String)"container.MoCreatures.ElephantChest"), 18);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbtTagCompound1 = nbttaglist.func_150305_b(i);
                j = nbtTagCompound1.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.localElephantChest.func_70302_i_()) continue;
                this.localElephantChest.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound1));
            }
        }
        if (this.getStorage() >= 2) {
            nbttaglist = nbtTagCompound.func_150295_c("Items2", 10);
            this.localElephantChest2 = new MoCAnimalChest(StatCollector.func_74838_a((String)"container.MoCreatures.ElephantChest"), 18);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbtTagCompound1 = nbttaglist.func_150305_b(i);
                j = nbtTagCompound1.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.localElephantChest2.func_70302_i_()) continue;
                this.localElephantChest2.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound1));
            }
        }
        if (this.getStorage() >= 3) {
            nbttaglist = nbtTagCompound.func_150295_c("Items3", 10);
            this.localElephantChest3 = new MoCAnimalChest(StatCollector.func_74838_a((String)"container.MoCreatures.ElephantChest"), 9);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbtTagCompound1 = nbttaglist.func_150305_b(i);
                j = nbtTagCompound1.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.localElephantChest3.func_70302_i_()) continue;
                this.localElephantChest3.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound1));
            }
        }
        if (this.getStorage() >= 4) {
            nbttaglist = nbtTagCompound.func_150295_c("Items4", 10);
            this.localElephantChest4 = new MoCAnimalChest(StatCollector.func_74838_a((String)"container.MoCreatures.ElephantChest"), 9);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbtTagCompound1 = nbttaglist.func_150305_b(i);
                j = nbtTagCompound1.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.localElephantChest4.func_70302_i_()) continue;
                this.localElephantChest4.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound1));
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        NBTTagCompound nbtTagCompound1;
        int i;
        NBTTagList nbttaglist;
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74774_a("Tusks", this.getTusks());
        nbtTagCompound.func_74774_a("Harness", this.getArmorType());
        nbtTagCompound.func_74774_a("Storage", this.getStorage());
        nbtTagCompound.func_74774_a("TuskUses", this.tuskUses);
        if (this.getStorage() > 0 && this.localElephantChest != null) {
            nbttaglist = new NBTTagList();
            for (i = 0; i < this.localElephantChest.func_70302_i_(); ++i) {
                this.localItemstack = this.localElephantChest.func_70301_a(i);
                if (this.localItemstack == null) continue;
                nbtTagCompound1 = new NBTTagCompound();
                nbtTagCompound1.func_74774_a("Slot", (byte)i);
                this.localItemstack.func_77955_b(nbtTagCompound1);
                nbttaglist.func_74742_a((NBTBase)nbtTagCompound1);
            }
            nbtTagCompound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
        if (this.getStorage() >= 2 && this.localElephantChest2 != null) {
            nbttaglist = new NBTTagList();
            for (i = 0; i < this.localElephantChest2.func_70302_i_(); ++i) {
                this.localItemstack = this.localElephantChest2.func_70301_a(i);
                if (this.localItemstack == null) continue;
                nbtTagCompound1 = new NBTTagCompound();
                nbtTagCompound1.func_74774_a("Slot", (byte)i);
                this.localItemstack.func_77955_b(nbtTagCompound1);
                nbttaglist.func_74742_a((NBTBase)nbtTagCompound1);
            }
            nbtTagCompound.func_74782_a("Items2", (NBTBase)nbttaglist);
        }
        if (this.getStorage() >= 3 && this.localElephantChest3 != null) {
            nbttaglist = new NBTTagList();
            for (i = 0; i < this.localElephantChest3.func_70302_i_(); ++i) {
                this.localItemstack = this.localElephantChest3.func_70301_a(i);
                if (this.localItemstack == null) continue;
                nbtTagCompound1 = new NBTTagCompound();
                nbtTagCompound1.func_74774_a("Slot", (byte)i);
                this.localItemstack.func_77955_b(nbtTagCompound1);
                nbttaglist.func_74742_a((NBTBase)nbtTagCompound1);
            }
            nbtTagCompound.func_74782_a("Items3", (NBTBase)nbttaglist);
        }
        if (this.getStorage() >= 4 && this.localElephantChest4 != null) {
            nbttaglist = new NBTTagList();
            for (i = 0; i < this.localElephantChest4.func_70302_i_(); ++i) {
                this.localItemstack = this.localElephantChest4.func_70301_a(i);
                if (this.localItemstack == null) continue;
                nbtTagCompound1 = new NBTTagCompound();
                nbtTagCompound1.func_74774_a("Slot", (byte)i);
                this.localItemstack.func_77955_b(nbtTagCompound1);
                nbttaglist.func_74742_a((NBTBase)nbtTagCompound1);
            }
            nbtTagCompound.func_74782_a("Items4", (NBTBase)nbttaglist);
        }
    }

    @Override
    public boolean isMyHealFood(ItemStack itemStack) {
        return itemStack != null && (itemStack.func_77973_b() == Items.field_151168_bH || itemStack.func_77973_b() == Items.field_151025_P || itemStack.func_77973_b() == MoCreatures.haystack);
    }

    @Override
    public boolean shouldRenderName() {
        return this.getShouldDisplayName() && this.field_70153_n == null && this.field_70154_o == null;
    }

    protected boolean func_70780_i() {
        return this.field_70153_n != null || this.sitCounter != 0;
    }

    @Override
    public void setType(int i) {
        this.field_70180_af.func_75692_b(19, (Object)i);
    }

    public void func_70043_V() {
        double horizontalOffset = 1.0;
        switch (this.getType()) {
            case 1: 
            case 3: {
                horizontalOffset = 0.8;
                break;
            }
            case 2: 
            case 5: {
                horizontalOffset = 0.1;
                break;
            }
            case 4: {
                horizontalOffset = 1.2;
            }
        }
        double newPosX = this.field_70165_t - horizontalOffset * Math.cos(MoCTools.realAngle(this.field_70761_aq - 90.0f) / 57.29578f);
        double newPosZ = this.field_70161_v - horizontalOffset * Math.sin(MoCTools.realAngle(this.field_70761_aq - 90.0f) / 57.29578f);
        this.field_70153_n.func_70107_b(newPosX, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W(), newPosZ);
    }

    public double func_70042_X() {
        double yOffset = 0.0;
        boolean isSitting = this.sitCounter != 0;
        switch (this.getType()) {
            case 1: {
                yOffset = 0.55;
                if (!isSitting) break;
                yOffset = -0.05;
                break;
            }
            case 3: {
                yOffset = 0.55;
                if (!isSitting) break;
                yOffset = -0.05;
                break;
            }
            case 2: 
            case 5: {
                yOffset = 0.0;
                if (!isSitting) break;
                yOffset = -0.5;
                break;
            }
            case 4: {
                yOffset = 1.2;
                if (!isSitting) break;
                yOffset = 0.45;
            }
        }
        return yOffset + (double)this.field_70131_O * 0.75;
    }

    public boolean func_70094_T() {
        return false;
    }

    public int func_70627_aG() {
        return 300;
    }

    protected String func_70673_aS() {
        return "mocreatures:elephantdying";
    }

    protected String func_70621_aR() {
        return "mocreatures:elephanthurt";
    }

    protected String func_70639_aQ() {
        if (!this.getIsAdult() && this.getMoCAge() < 80) {
            return "mocreatures:elephantcalf";
        }
        return "mocreatures:elephantgrunt";
    }

    protected Item func_146068_u() {
        return MoCreatures.hide;
    }

    @Override
    public boolean func_70601_bi() {
        if (!MoCreatures.isBiomesOPlentyLoaded || MoCreatures.isBiomesOPlentyLoaded && this.checkSpawningBiome() && MoCreatures.entityMap.get(this.getClass()).getFrequency() > 0 && this.getCanSpawnHereCreature() && this.getCanSpawnHereLiving()) {
            return super.func_70601_bi();
        }
        return false;
    }

    @Override
    public void dropMyStuff() {
        if (MoCreatures.isServer()) {
            this.dropTusks();
            this.destroyPlatforms();
            if (this.getStorage() > 0) {
                if (this.getStorage() > 0) {
                    MoCTools.dropCustomItem((Entity)this, this.field_70170_p, new ItemStack(MoCreatures.elephantChest, 1));
                    if (this.localElephantChest != null) {
                        MoCTools.dropInventory((Entity)this, this.localElephantChest);
                    }
                }
                if (this.getStorage() >= 2) {
                    if (this.localElephantChest2 != null) {
                        MoCTools.dropInventory((Entity)this, this.localElephantChest2);
                    }
                    MoCTools.dropCustomItem((Entity)this, this.field_70170_p, new ItemStack(MoCreatures.elephantChest, 1));
                }
                if (this.getStorage() >= 3) {
                    if (this.localElephantChest3 != null) {
                        MoCTools.dropInventory((Entity)this, this.localElephantChest3);
                    }
                    MoCTools.dropCustomItem((Entity)this, this.field_70170_p, new ItemStack((Block)Blocks.field_150486_ae, 1));
                }
                if (this.getStorage() >= 4) {
                    if (this.localElephantChest4 != null) {
                        MoCTools.dropInventory((Entity)this, this.localElephantChest4);
                    }
                    MoCTools.dropCustomItem((Entity)this, this.field_70170_p, new ItemStack((Block)Blocks.field_150486_ae, 1));
                }
                this.setStorage((byte)0);
            }
            this.dropArmor();
        }
    }

    @Override
    public void dropArmor() {
        if (!MoCreatures.isServer()) {
            return;
        }
        if (this.getArmorType() >= 1) {
            MoCTools.dropCustomItem((Entity)this, this.field_70170_p, new ItemStack(MoCreatures.elephantHarness, 1));
        }
        if (this.getType() == 5 && this.getArmorType() >= 2) {
            MoCTools.dropCustomItem((Entity)this, this.field_70170_p, new ItemStack(MoCreatures.elephantGarment, 1));
            if (this.getArmorType() == 3) {
                MoCTools.dropCustomItem((Entity)this, this.field_70170_p, new ItemStack(MoCreatures.elephantHowdah, 1));
            }
            this.setType(2);
        }
        if (this.getType() == 4 && this.getArmorType() == 3) {
            MoCTools.dropCustomItem((Entity)this, this.field_70170_p, new ItemStack(MoCreatures.mammothPlatform, 1));
        }
        this.setArmorType((byte)0);
    }

    @Override
    public int nameYOffset() {
        if (this.getIsAdult()) {
            return (int)(this.getSizeFactor() * -110.0f);
        }
        return (int)((float)(100 / this.getMoCAge()) * (this.getSizeFactor() * -110.0f));
    }

    @Override
    public double roperYOffset() {
        if (this.getIsAdult()) {
            return (double)this.getSizeFactor() * -0.5;
        }
        return (double)(100 / this.getMoCAge()) * ((double)this.getSizeFactor() * -0.5);
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        if (super.func_70097_a(damageSource, damageTaken)) {
            Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
            if (entityThatAttackedThisCreature != null && this.getIsTamed() && entityThatAttackedThisCreature instanceof EntityPlayer && entityThatAttackedThisCreature.func_70005_c_().equals(this.getOwnerName())) {
                return false;
            }
            if (this.field_70153_n == entityThatAttackedThisCreature || this.field_70154_o == entityThatAttackedThisCreature) {
                return true;
            }
            if (!this.getIsAdult() && damageSource.func_76346_g() != null) {
                MoCTools.runAway((EntityCreature)this, damageSource.func_76346_g());
                List entitiesNearbyList = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(10.0, 10.0, 10.0));
                for (int index = 0; index < entitiesNearbyList.size(); ++index) {
                    Entity entity1 = (Entity)entitiesNearbyList.get(index);
                    if (!(entity1 instanceof MoCEntityElephant)) continue;
                    MoCEntityElephant elephantEntityNearBy = (MoCEntityElephant)entity1;
                    if (elephantEntityNearBy.getIsAdult()) {
                        // empty if block
                    }
                    if (elephantEntityNearBy.getIsTamed()) continue;
                    elephantEntityNearBy.field_70789_a = damageSource.func_76346_g();
                }
                return false;
            }
            if (entityThatAttackedThisCreature != this && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
                this.field_70789_a = entityThatAttackedThisCreature;
            }
            return true;
        }
        return false;
    }

    protected void func_70785_a(Entity entity, float distanceToEntity) {
        if (this.field_70724_aR <= 0 && (double)distanceToEntity < 2.0 && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 20;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), this.calculateAttackDamage());
        }
    }

    private float calculateAttackDamage() {
        if (this.getIsAdult() && !this.getIsTamed()) {
            return 8.0f;
        }
        if (this.getIsAdult() && this.getIsTamed()) {
            return 8 + this.getTusks();
        }
        return 4.0f;
    }

    private boolean isMammoth() {
        return this.getType() == 3 || this.getType() == 4;
    }

    protected void func_70069_a(float f) {
        int i = (int)Math.ceil(f - 3.0f);
        if (i > 0) {
            Block block;
            if ((i /= 3) > 0) {
                this.func_70097_a(DamageSource.field_76379_h, i);
            }
            if (this.field_70153_n != null && i > 0) {
                this.field_70153_n.func_70097_a(DamageSource.field_76379_h, (float)i);
            }
            if (!(block = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 0.2000000029802322 - (double)this.field_70127_C)), MathHelper.func_76128_c((double)this.field_70161_v))).isAir((IBlockAccess)this.field_70170_p, MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 0.2000000029802322 - (double)this.field_70127_C)), MathHelper.func_76128_c((double)this.field_70161_v))) {
                Block.SoundType stepsound = block.field_149762_H;
                this.func_85030_a(stepsound.func_150498_e(), stepsound.func_150497_c() * 0.5f, stepsound.func_150494_d() * 0.75f);
            }
        }
    }
}

