/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.animal;

import cpw.mods.fml.common.registry.GameRegistry;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.achievements.MoCAchievements;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MoCEntityBird
extends MoCEntityTameableAnimal {
    public boolean isFleeing;
    public float wingB;
    public float wingC;
    public float wingD;
    public float wingE;
    public float wingH;
    public boolean textureSet;
    private boolean isPicked;
    public static final String[] birdNames = new String[]{"Dove", "Crow", "Parrot", "Blue", "Canary", "Red"};

    public MoCEntityBird(World world) {
        super(world);
        this.func_70105_a(0.4f, 0.3f);
        this.field_70124_G = true;
        this.wingB = 0.0f;
        this.wingC = 0.0f;
        this.wingH = 1.0f;
        this.isFleeing = false;
        this.textureSet = false;
        this.setTamed(false);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
    }

    @Override
    public boolean doesForageForFood() {
        return true;
    }

    @Override
    public void selectType() {
        if (this.getType() == 0) {
            this.setType(this.field_70146_Z.nextInt(6) + 1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("birdwhite.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("birdblack.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("birdgreen.png");
            }
            case 4: {
                return MoCreatures.proxy.getTexture("birdblue.png");
            }
            case 5: {
                return MoCreatures.proxy.getTexture("birdyellow.png");
            }
            case 6: {
                return MoCreatures.proxy.getTexture("birdred.png");
            }
        }
        return MoCreatures.proxy.getTexture("birdblue.png");
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)0);
    }

    public boolean getPreTamed() {
        return this.field_70180_af.func_75683_a(22) == 1;
    }

    public void setPreTamed(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(22, (Object)input);
    }

    protected void func_70069_a(float f) {
    }

    private int[] FindTreeTop(int i, int j, int k) {
        int l = i - 5;
        int i1 = k - 5;
        int j1 = i + 5;
        int k1 = j + 7;
        int l1 = k + 5;
        for (int i2 = l; i2 < j1; ++i2) {
            for (int j2 = i1; j2 < l1; ++j2) {
                Block block = this.field_70170_p.func_147439_a(i2, j, j2);
                if (block.isAir((IBlockAccess)this.field_70170_p, i2, j, j2) || block.func_149688_o() != Material.field_151575_d) continue;
                for (int l2 = j; l2 < k1; ++l2) {
                    Block block1 = this.field_70170_p.func_147439_a(i2, l2, j2);
                    if (!block1.isAir((IBlockAccess)this.field_70170_p, i2, l2, j2)) continue;
                    return new int[]{i2, l2 + 2, j2};
                }
            }
        }
        return new int[]{0, 0, 0};
    }

    private boolean FlyToNextTree() {
        int[] coordinatesOfLeaves = this.ReturnNearestMaterialCoord((Entity)this, Material.field_151584_j, 20.0);
        int[] coordinatesOfTreeTop = this.FindTreeTop(coordinatesOfLeaves[0], coordinatesOfLeaves[1], coordinatesOfLeaves[2]);
        if (coordinatesOfTreeTop[1] != 0) {
            int xCoordinate = coordinatesOfTreeTop[0];
            int yCoordinate = coordinatesOfTreeTop[1];
            int zCoordinate = coordinatesOfTreeTop[2];
            MoCTools.faceLocation((Entity)this, xCoordinate, yCoordinate, zCoordinate, 30.0f);
            if (yCoordinate - MathHelper.func_76128_c((double)this.field_70163_u) > 2) {
                this.field_70181_x += 0.15;
            }
            int xDistance = 0;
            int zDistance = 0;
            if (this.field_70165_t < (double)xCoordinate) {
                xDistance = xCoordinate - MathHelper.func_76128_c((double)this.field_70165_t);
                this.field_70159_w += 0.05;
            } else {
                xDistance = MathHelper.func_76128_c((double)this.field_70165_t) - xCoordinate;
                this.field_70159_w -= 0.05;
            }
            if (this.field_70161_v < (double)zCoordinate) {
                zDistance = zCoordinate - MathHelper.func_76128_c((double)this.field_70161_v);
                this.field_70179_y += 0.05;
            } else {
                zDistance = MathHelper.func_76128_c((double)this.field_70165_t) - zCoordinate;
                this.field_70179_y -= 0.05;
            }
            double overallDistance = xDistance + zDistance;
            if (overallDistance < 3.0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean shouldEntityBeIgnored(Entity entity) {
        return entity instanceof MoCEntityBird || entity.field_70131_O <= this.field_70131_O && entity.field_70130_N <= this.field_70130_N || super.shouldEntityBeIgnored(entity);
    }

    protected String func_70673_aS() {
        return null;
    }

    protected void func_70628_a(boolean hasEntityBeenHitByPlayer, int levelOfLootingEnchantmentUsedToKillThisEntity) {
        int randomAmount = this.field_70146_Z.nextInt(3);
        this.func_145779_a(Items.field_151008_G, randomAmount);
        if (MoCreatures.isExoticBirdsLoaded) {
            if (this.func_70027_ad()) {
                this.func_145779_a(GameRegistry.findItem((String)"exoticbirds", (String)"cooked_birdmeat_small"), 1);
            } else {
                this.func_145779_a(GameRegistry.findItem((String)"exoticbirds", (String)"birdmeat_small"), 1);
            }
        }
    }

    protected String func_70621_aR() {
        return null;
    }

    protected String func_70639_aQ() {
        if (this.getType() == 1) {
            return "mocreatures:birdwhite";
        }
        if (this.getType() == 2) {
            return "mocreatures:birdblack";
        }
        if (this.getType() == 3) {
            return "mocreatures:birdgreen";
        }
        if (this.getType() == 4) {
            return "mocreatures:birdblue";
        }
        if (this.getType() == 5) {
            return "mocreatures:birdyellow";
        }
        return "mocreatures:birdred";
    }

    public boolean getPicked() {
        return this.isPicked;
    }

    public double func_70033_W() {
        if (this.field_70154_o instanceof EntityPlayer && this.field_70154_o == MoCreatures.proxy.getPlayer() && !MoCreatures.isServer()) {
            return this.field_70129_M - 1.15f;
        }
        if (this.field_70154_o instanceof EntityPlayer && !MoCreatures.isServer()) {
            return this.field_70129_M + 0.45f;
        }
        return this.field_70129_M;
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityPlayer) {
        if (super.func_70085_c(entityPlayer)) {
            return false;
        }
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (itemStack != null && this.isMyHealFood(itemStack)) {
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
            }
            if (MoCreatures.isServer() && !this.getIsTamed() && this.getPreTamed()) {
                MoCTools.tameWithName(entityPlayer, this);
                entityPlayer.func_71064_a((StatBase)MoCAchievements.tame_bird, 1);
            }
            this.func_70691_i(5.0f);
            return true;
        }
        if (this.getIsTamed() && (MoCreatures.proxy.emptyHandMountAndPickUpOnly && itemStack == null || !MoCreatures.proxy.emptyHandMountAndPickUpOnly)) {
            this.field_70177_z = entityPlayer.field_70177_z;
            if (this.field_70154_o == null && entityPlayer.field_70154_o == null && MoCreatures.isServer()) {
                this.func_70078_a((Entity)entityPlayer);
                this.setPicked(true);
                return true;
            }
            if (this.field_70154_o == entityPlayer && MoCreatures.isServer()) {
                this.func_70078_a(null);
                this.field_70159_w = entityPlayer.field_70159_w * 5.0;
                this.field_70181_x = entityPlayer.field_70181_x / 2.0 + 0.5;
                this.field_70179_y = entityPlayer.field_70179_y * 5.0;
                return true;
            }
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.field_70154_o != null) {
            this.func_70626_be();
        }
        this.wingE = this.wingB;
        this.wingD = this.wingC;
        this.wingC = (float)((double)this.wingC + (double)(this.field_70122_E && !this.isFleeing || this.field_70154_o != null && this.field_70154_o.field_70181_x >= -0.08 ? -1 : 4) * 0.3);
        if (this.wingC < 0.0f) {
            this.wingC = 0.0f;
        }
        if (this.wingC > 1.0f) {
            this.wingC = 1.0f;
        }
        if (!this.field_70122_E && this.wingH < 1.0f) {
            this.wingH = 1.0f;
        }
        this.wingH = (float)((double)this.wingH * 0.9);
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.8;
        }
        this.wingB += this.wingH * 2.0f;
        if (MoCreatures.isServer()) {
            EntityLivingBase entityLiving = MoCTools.getScaryEntity((Entity)this, 5.0);
            if (this.field_70146_Z.nextInt(10) == 0 && entityLiving != null && !this.getIsTamed() && !this.getPreTamed() && this.func_70685_l((Entity)entityLiving)) {
                this.isFleeing = true;
            }
            if (this.field_70146_Z.nextInt(200) == 0) {
                this.isFleeing = true;
            }
            if (this.isFleeing) {
                int[] coordinatesOfLeaves;
                if (this.FlyToNextTree()) {
                    this.isFleeing = false;
                }
                if ((coordinatesOfLeaves = this.ReturnNearestMaterialCoord((Entity)this, Material.field_151584_j, 16.0))[0] == -1) {
                    for (int index = 0; index < 2; ++index) {
                        this.WingFlap();
                    }
                    this.isFleeing = false;
                }
                if (this.field_70146_Z.nextInt(50) == 0) {
                    this.isFleeing = false;
                }
            }
            if (this.field_70146_Z.nextInt(10) == 0 && this.func_70055_a(Material.field_151586_h)) {
                this.WingFlap();
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        if (MoCreatures.isServer()) {
            if (this.field_70154_o != null && (damageSource.func_76346_g() == this.field_70154_o || DamageSource.field_76368_d.equals(damageSource))) {
                return false;
            }
            if (!this.isFleeing) {
                this.isFleeing = true;
            }
        }
        return super.func_70097_a(damageSource, damageTaken);
    }

    public int[] ReturnNearestMaterialCoord(Entity entity, Material material, Double double1) {
        AxisAlignedBB axisalignedbb = entity.field_70121_D.func_72314_b(double1.doubleValue(), double1.doubleValue(), double1.doubleValue());
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(axisalignedbb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(axisalignedbb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(axisalignedbb.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    Block block = this.field_70170_p.func_147439_a(k1, l1, i2);
                    if (block == null || block.isAir((IBlockAccess)this.field_70170_p, k1, l1, i2) || block.func_149688_o() != material) continue;
                    return new int[]{k1, l1, i2};
                }
            }
        }
        return new int[]{-1, 0, 0};
    }

    public void setPicked(boolean var1) {
        this.isPicked = var1;
    }

    @Override
    protected void func_70626_be() {
        EntityPlayer entityPlayer;
        if (this.field_70122_E && this.field_70146_Z.nextInt(10) == 0 && (this.field_70159_w > 0.05 || this.field_70179_y > 0.05 || this.field_70159_w < -0.05 || this.field_70179_y < -0.05)) {
            this.field_70181_x = 0.25;
        }
        if (this.field_70154_o != null && this.field_70154_o instanceof EntityPlayer && (entityPlayer = (EntityPlayer)this.field_70154_o) != null) {
            this.field_70177_z = entityPlayer.field_70177_z;
            entityPlayer.field_70143_R = 0.0f;
            if (entityPlayer.field_70181_x < -0.1) {
                entityPlayer.field_70181_x = -0.1;
            }
        }
        if (!this.isFleeing || !this.getPicked()) {
            super.func_70626_be();
        } else if (this.field_70122_E) {
            this.setPicked(false);
        }
    }

    private void WingFlap() {
        this.field_70181_x += 0.05;
        if (this.field_70146_Z.nextInt(30) == 0) {
            this.field_70159_w += 0.2;
        }
        if (this.field_70146_Z.nextInt(30) == 0) {
            this.field_70159_w -= 0.2;
        }
        if (this.field_70146_Z.nextInt(30) == 0) {
            this.field_70179_y += 0.2;
        }
        if (this.field_70146_Z.nextInt(30) == 0) {
            this.field_70179_y -= 0.2;
        }
    }

    @Override
    public boolean isMyHealFood(ItemStack itemStack) {
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            List<String> oreDictionaryNameArray = MoCTools.getOreDictionaryEntries(itemStack);
            return item instanceof ItemSeeds || Item.field_150901_e.func_148750_c((Object)item).equals("etfuturum:beetroot_seeds") || Item.field_150901_e.func_148750_c((Object)item).equals("BiomesOPlenty:turnipSeeds") || oreDictionaryNameArray.size() > 0 && (oreDictionaryNameArray.contains("listAllseed") || oreDictionaryNameArray.contains("foodRaisins"));
        }
        return false;
    }

    @Override
    public boolean updateMount() {
        return this.getIsTamed();
    }

    @Override
    public boolean forceUpdates() {
        return this.getIsTamed();
    }

    @Override
    public int nameYOffset() {
        return -40;
    }

    @Override
    public double roperYOffset() {
        return 0.9;
    }
}

