/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.animal;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.achievements.MoCAchievements;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.animal.MoCEntityBigCat;
import drzhark.mocreatures.entity.aquatic.MoCEntityJellyFish;
import drzhark.mocreatures.entity.aquatic.MoCEntityRay;
import drzhark.mocreatures.entity.aquatic.MoCEntityShark;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class MoCEntityBear
extends MoCEntityTameableAnimal {
    public int mouthCounter;
    private int attackCounter;
    private int standingCounter;

    public MoCEntityBear(World world) {
        super(world);
        this.func_70105_a(1.2f, 1.5f);
        this.roper = null;
        this.setMoCAge(55);
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.setAdult(false);
        } else {
            this.setAdult(true);
        }
    }

    @Override
    public boolean doesForageForFood() {
        return true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(23, (Object)0);
    }

    @Override
    protected boolean func_70692_ba() {
        return !this.getIsTamed() && this.field_70173_aa > 2400;
    }

    public int getBearState() {
        return this.field_70180_af.func_75683_a(23);
    }

    public void setBearState(int i) {
        this.field_70180_af.func_75692_b(23, (Object)((byte)i));
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getType() == 0) {
            int i = this.field_70146_Z.nextInt(100);
            if (i <= 40) {
                this.setType(1);
            } else {
                this.setType(2);
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.calculateMaxHealth());
        this.func_70606_j(this.func_110138_aP());
    }

    @Override
    public boolean isPredator() {
        return this.getType() != 3 && this.getType() != 5;
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("bearbrowm.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("bearblack.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("bearpanda.png");
            }
            case 4: {
                return MoCreatures.proxy.getTexture("bearpolar.png");
            }
            case 5: {
                return MoCreatures.proxy.getTexture("bearpanda.png");
            }
        }
        return MoCreatures.proxy.getTexture("bearbrowm.png");
    }

    public float getBearSize() {
        switch (this.getType()) {
            case 1: {
                return 1.2f;
            }
            case 2: {
                return 0.9f;
            }
            case 3: {
                return 0.8f;
            }
            case 4: {
                return 1.4f;
            }
            case 5: {
                return 1.2f;
            }
        }
        return 1.0f;
    }

    public float calculateMaxHealth() {
        switch (this.getType()) {
            case 1: {
                return 20.0f;
            }
            case 2: {
                return 15.0f;
            }
            case 3: {
                return 15.0f;
            }
            case 4: {
                return 25.0f;
            }
            case 5: {
                return 20.0f;
            }
        }
        return 20.0f;
    }

    public double getAttackRange() {
        int factor = 1;
        if (this.field_70170_p.field_73013_u.func_151525_a() > 1) {
            factor = 2;
        }
        switch (this.getType()) {
            case 1: {
                return 6.0 * (double)factor;
            }
            case 2: {
                return 6.0 * (double)factor;
            }
            case 3: {
                return 1.0;
            }
            case 4: {
                return 8.0 * (double)factor;
            }
            case 5: {
                return 3.0;
            }
        }
        return 8.0;
    }

    public int getAttackStrength() {
        int worldDifficulty = this.field_70170_p.field_73013_u.func_151525_a();
        switch (this.getType()) {
            case 1: {
                return 2 * worldDifficulty;
            }
            case 2: {
                return 1 * worldDifficulty;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 3 * worldDifficulty;
            }
            case 5: {
                return 2 * worldDifficulty;
            }
        }
        return 2;
    }

    protected void func_70785_a(Entity entity, float distanceToEntity) {
        if (this.field_70724_aR <= 0 && (double)distanceToEntity < 2.5 && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.startAttack();
            this.field_70724_aR = 20;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.getAttackStrength());
        }
    }

    protected boolean func_70780_i() {
        return this.getBearState() == 2;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        if (super.func_70097_a(damageSource, damageTaken)) {
            if (!this.getIsAdult() && damageSource.func_76346_g() != null) {
                if (this.getBearState() == 2) {
                    this.setBearState(0);
                }
                MoCTools.runAway((EntityCreature)this, damageSource.func_76346_g());
                List entitiesNearbyList = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(10.0, 10.0, 10.0));
                int iterationLength = entitiesNearbyList.size();
                if (iterationLength > 0) {
                    for (int index = 0; index < iterationLength; ++index) {
                        Entity entityNearby = (Entity)entitiesNearbyList.get(index);
                        if (!(entityNearby instanceof MoCEntityBear)) continue;
                        MoCEntityBear bearNearby = (MoCEntityBear)entityNearby;
                        if (bearNearby.getIsAdult()) {
                            // empty if block
                        }
                        if (bearNearby.getIsTamed() || bearNearby.getType() != this.getType()) continue;
                        if (bearNearby.getBearState() == 2) {
                            bearNearby.setBearState(0);
                        }
                        bearNearby.field_70789_a = damageSource.func_76346_g();
                    }
                }
                return false;
            }
            Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
            if (entityThatAttackedThisCreature != null && this.getIsTamed() && entityThatAttackedThisCreature instanceof EntityPlayer && entityThatAttackedThisCreature.func_70005_c_().equals(this.getOwnerName())) {
                return false;
            }
            if (this.field_70153_n == entityThatAttackedThisCreature || this.field_70154_o == entityThatAttackedThisCreature) {
                return true;
            }
            if (entityThatAttackedThisCreature != this && this.field_70170_p.field_73013_u.func_151525_a() > 0) {
                this.field_70789_a = entityThatAttackedThisCreature;
                if (this.getBearState() == 2) {
                    this.setBearState(0);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isNotScared() {
        return this.getType() != 3;
    }

    @Override
    public boolean shouldEntityBeIgnored(Entity entity) {
        return super.shouldEntityBeIgnored(entity) || entity instanceof MoCEntityBear || this.getIsAdult() && (double)entity.field_70130_N > 1.3 && (double)entity.field_70131_O > 1.3 || !this.getIsAdult() && (double)entity.field_70130_N > 0.5 && (double)entity.field_70131_O > 0.5 || entity instanceof MoCEntityBigCat || entity instanceof MoCEntityShark || entity instanceof MoCEntityJellyFish || entity instanceof MoCEntityRay || entity instanceof EntitySquid;
    }

    @Override
    protected Entity func_70782_k() {
        if (this.field_70170_p.field_73013_u.func_151525_a() > 0) {
            EntityLivingBase closestEntityLiving;
            EntityPlayer entityPlayer = this.field_70170_p.func_72856_b((Entity)this, this.getAttackRange());
            if (entityPlayer != null) {
                return entityPlayer;
            }
            if (this.field_70146_Z.nextInt(80) == 0 && this.getType() != 3 && (closestEntityLiving = MoCTools.getClosestEntityLivingThatCanBeTargetted((Entity)this, 10.0)) != null && !MoCTools.isEntityAFishThatIsInTheOcean((Entity)closestEntityLiving)) {
                return closestEntityLiving;
            }
        }
        return null;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.mouthCounter > 0 && ++this.mouthCounter > 30) {
            this.mouthCounter = 0;
        }
        if (this.attackCounter > 0 && ++this.attackCounter > 100) {
            this.attackCounter = 0;
        }
        if (MoCreatures.isServer() && !this.getIsAdult() && this.field_70146_Z.nextInt(250) == 0) {
            this.setMoCAge(this.getMoCAge() + 1);
            if (this.getMoCAge() >= 100) {
                this.setAdult(true);
            }
        }
        if (MoCreatures.isServer() && this.getBearState() != 2 && !this.func_70781_l() && !this.func_70090_H() && this.field_70789_a == null && (this.getType() == 3 || this.getType() == 5 || !this.getIsAdult() && this.getMoCAge() < 60) && this.field_70146_Z.nextInt(300) == 0) {
            this.setBearState(2);
        }
        if (MoCreatures.isServer() && this.getBearState() == 2 && (this.field_70146_Z.nextInt(800) == 0 || this.func_70090_H())) {
            this.setBearState(0);
        }
        if (MoCreatures.isServer() && this.standingCounter == 0 && this.getBearState() != 2 && this.getIsAdult() && this.getType() != 3 && this.getType() != 5 && this.field_70146_Z.nextInt(500) == 0) {
            this.standingCounter = 1;
            EntityPlayer closestPlayer = this.field_70170_p.func_72890_a((Entity)this, 8.0);
            if (closestPlayer != null) {
                this.setBearState(1);
            }
        }
        if (MoCreatures.isServer() && this.standingCounter > 0 && ++this.standingCounter > 50) {
            this.standingCounter = 0;
            this.setBearState(0);
        }
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityPlayer) {
        if (super.func_70085_c(entityPlayer)) {
            return false;
        }
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (itemStack != null && (this.getType() == 3 || this.getType() == 5) && this.isItemstackPandaFoodItem(itemStack)) {
            if (--itemStack.field_77994_a == 0) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
            }
            if (MoCreatures.isServer() && !this.getIsTamed()) {
                MoCTools.tameWithName(entityPlayer, this);
                entityPlayer.func_71064_a((StatBase)MoCAchievements.tame_panda, 1);
            }
            this.func_70691_i(5.0f);
            this.eatingAnimal();
            if (MoCreatures.isServer() && !this.getIsAdult() && this.getMoCAge() < 100) {
                this.setMoCAge(this.getMoCAge() + 1);
            }
            return true;
        }
        return false;
    }

    protected Item func_146068_u() {
        return MoCreatures.hide;
    }

    protected String func_70673_aS() {
        if (this.getType() == 3 && !this.getIsAdult()) {
            return "mocreatures:pandacubdeath";
        }
        if (this.getType() == 3 && this.getIsAdult() || this.getType() == 5) {
            return "mocreatures:pandaadultdeath";
        }
        return "mocreatures:beardying";
    }

    protected String func_70621_aR() {
        this.openMouth();
        if (this.getType() == 3 && !this.getIsAdult()) {
            return "mocreatures:pandacubhurt";
        }
        if (this.getType() == 3 && this.getIsAdult() || this.getType() == 5) {
            return "mocreatures:pandaadulthurt";
        }
        return "mocreatures:bearhurt";
    }

    protected String func_70639_aQ() {
        this.openMouth();
        if (this.getType() == 3 && !this.getIsAdult()) {
            return "mocreatures:pandacubgrunt";
        }
        if (this.getType() == 3 && this.getIsAdult() || this.getType() == 5) {
            return "mocreatures:pandaadultgrunt";
        }
        return "mocreatures:beargrunt";
    }

    @Override
    public boolean checkSpawningBiome() {
        int zCoordinate;
        int yCoordinate;
        int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
        BiomeGenBase currentBiome = MoCTools.biomekind(this.field_70170_p, xCoordinate, yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v));
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            this.setType(4);
            return true;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) || currentBiome.field_76791_y.toLowerCase().contains("bamboo")) {
            this.setType(3);
            if (MoCreatures.proxy.enableRareGiantPandaVariant && this.field_70146_Z.nextInt(100) <= 10) {
                this.setType(5);
                this.setMoCAge(100);
            }
            return true;
        }
        return true;
    }

    private void openMouth() {
        this.mouthCounter = 1;
    }

    public float getAttackSwing() {
        return 0.0f;
    }

    private void startAttack() {
        if (this.attackCounter == 0 && this.getBearState() == 1) {
            this.attackCounter = 1;
        }
    }

    private void eatingAnimal() {
        this.openMouth();
        MoCTools.playCustomSound((Entity)this, "eating", this.field_70170_p);
    }

    @Override
    public double roperYOffset() {
        if (this.getIsAdult()) {
            return 0.0;
        }
        return (double)(130 - this.getMoCAge()) * 0.01;
    }

    @Override
    public boolean isMyFollowFood(ItemStack itemStack) {
        return (this.getType() == 3 || this.getType() == 5) && itemStack != null && this.isItemstackPandaFoodItem(itemStack);
    }

    @Override
    public boolean isMyHealFood(ItemStack itemStack) {
        if (itemStack != null) {
            if (this.getType() == 3 || this.getType() == 5) {
                return this.isItemstackPandaFoodItem(itemStack);
            }
            return this.isItemEdible(itemStack.func_77973_b());
        }
        return false;
    }

    private boolean isItemstackPandaFoodItem(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        List<String> oreDictionaryNameArray = MoCTools.getOreDictionaryEntries(itemStack);
        return item == Items.field_151120_aE || item == Items.field_151102_aT || Item.field_150901_e.func_148750_c((Object)item).equals("BiomesOPlenty:bamboo") || Item.field_150901_e.func_148750_c((Object)item).equals("etfuturum:bamboo") || Item.field_150901_e.func_148750_c((Object)item).equals("tropicraft:bambooChute") || Item.field_150901_e.func_148750_c((Object)item).equals("harvestcraft:bambooshootItem") || Item.field_150901_e.func_148750_c((Object)item).equals("Growthcraft|Bamboo:grc.bamboo") || Item.field_150901_e.func_148750_c((Object)item).equals("plantmegapack:bambooFargesiaRobusta") || Item.field_150901_e.func_148750_c((Object)item).equals("plantmegapack:bambooShortTassled") || Item.field_150901_e.func_148750_c((Object)item).equals("plantmegapack:bambooTimorBlack") || Item.field_150901_e.func_148750_c((Object)item).equals("plantmegapack:bambooGolden") || Item.field_150901_e.func_148750_c((Object)item).equals("plantmegapack:bambooWetForest") || Item.field_150901_e.func_148750_c((Object)item).equals("plantmegapack:bambooAsper") || Item.field_150901_e.func_148750_c((Object)item).equals("plantmegapack:bambooTropicalBlue") || Item.field_150901_e.func_148750_c((Object)item).equals("plantmegapack:bambooMoso") || Item.field_150901_e.func_148750_c((Object)item).equals("plantmegapack:bambooGiantTimber") || Item.field_150901_e.func_148750_c((Object)item).equals("BambooMod:itembamboo") || oreDictionaryNameArray.size() > 0 && (oreDictionaryNameArray.contains("bamboo") || oreDictionaryNameArray.contains("cropBamboo") || oreDictionaryNameArray.contains("cropBambooshoot"));
    }

    @Override
    public int nameYOffset() {
        if (this.getIsAdult()) {
            if (this.getType() == 3) {
                return -55;
            }
            return -70;
        }
        return 100 / this.getMoCAge() * -40;
    }

    @Override
    public double getCustomSpeed() {
        if (this.getBearState() == 2) {
            return 0.0;
        }
        return super.getCustomSpeed();
    }
}

