/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.achievements.MoCAchievements;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.IMoCTameable;
import drzhark.mocreatures.entity.aquatic.MoCEntityDolphin;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class MoCEntityAquatic
extends EntityWaterMob
implements IMoCEntity {
    protected boolean divePending;
    protected boolean jumpPending;
    protected boolean isEntityJumping;
    private int outOfWater = 0;
    private boolean diving;
    private int divingCount;
    private int mountCount;
    public EntityLiving roper;
    public boolean isCaughtOnHook;
    protected boolean riderIsDisconnecting;
    protected float moveSpeed;
    protected String texture;
    private boolean hasKilledPrey = false;
    EntityPlayer playerThatHookedThisFish;
    EntityFishHook hookThatThisFishIsHookedTo;
    EntityFishHook closestFishHook;
    float distanceToHook;

    public MoCEntityAquatic(World world) {
        super(world);
        this.setTamed(false);
        this.setTemper(50);
        this.riderIsDisconnecting = false;
        this.texture = "blank.jpg";
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.getMoveSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6.0);
    }

    @Override
    public ResourceLocation getTexture() {
        return MoCreatures.proxy.getTexture(this.texture);
    }

    public IEntityLivingData func_110161_a(IEntityLivingData entityLivingData) {
        this.selectType();
        return super.func_110161_a(entityLivingData);
    }

    @Override
    public void selectType() {
        this.setType(1);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(15, (Object)50);
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)String.valueOf(""));
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)String.valueOf(""));
    }

    public boolean func_70067_L() {
        return this.field_70153_n == null;
    }

    public boolean func_70104_M() {
        return this.func_70067_L();
    }

    public int getTemper() {
        return this.field_70180_af.func_75679_c(15);
    }

    @Override
    public boolean getIsTamed() {
        return this.field_70180_af.func_75683_a(16) == 1;
    }

    @Override
    public String getName() {
        return this.field_70180_af.func_75681_e(17);
    }

    @Override
    public boolean getIsAdult() {
        return this.field_70180_af.func_75683_a(18) == 1;
    }

    @Override
    public int getMoCAge() {
        return this.field_70180_af.func_75679_c(19);
    }

    @Override
    public int getType() {
        return this.field_70180_af.func_75679_c(20);
    }

    public void setTemper(int i) {
        this.field_70180_af.func_75692_b(15, (Object)i);
    }

    @Override
    public void setTamed(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(16, (Object)input);
    }

    @Override
    public void setName(String name) {
        this.field_70180_af.func_75692_b(17, (Object)String.valueOf(name));
    }

    @Override
    public void setAdult(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(18, (Object)input);
    }

    @Override
    public void setMoCAge(int i) {
        this.field_70180_af.func_75692_b(19, (Object)i);
    }

    @Override
    public void setType(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    public int getMaxTemper() {
        return 100;
    }

    public float func_70663_b(float currentRotation, float intendedRotation, float maxIncrement) {
        float amountToChangeRotationBy = intendedRotation;
        for (amountToChangeRotationBy = intendedRotation - currentRotation; amountToChangeRotationBy < -180.0f; amountToChangeRotationBy += 360.0f) {
        }
        while (amountToChangeRotationBy >= 180.0f) {
            amountToChangeRotationBy -= 360.0f;
        }
        if (amountToChangeRotationBy > maxIncrement) {
            amountToChangeRotationBy = maxIncrement;
        }
        if (amountToChangeRotationBy < -maxIncrement) {
            amountToChangeRotationBy = -maxIncrement;
        }
        return currentRotation + amountToChangeRotationBy;
    }

    protected boolean func_70692_ba() {
        return !this.getIsTamed();
    }

    @Override
    public boolean checkSpawningBiome() {
        return true;
    }

    protected void func_145780_a(int par1, int par2, int par3, Block par4) {
    }

    protected void func_70069_a(float f) {
    }

    public boolean isPredator() {
        return false;
    }

    public void func_70074_a(EntityLivingBase entityLiving) {
        if (this.isPredator() && MoCreatures.proxy.destroyDrops && !(entityLiving instanceof EntityPlayer) && !(entityLiving instanceof EntityMob)) {
            this.hasKilledPrey = true;
        }
    }

    protected String func_70673_aS() {
        return null;
    }

    protected String func_70621_aR() {
        return null;
    }

    protected String func_70639_aQ() {
        return null;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public boolean gettingOutOfWater() {
        int x = (int)this.field_70165_t;
        int y = (int)this.field_70163_u;
        int z = (int)this.field_70161_v;
        return this.field_70170_p.func_147437_c(x, y + 1, z);
    }

    protected String getUpsetSound() {
        return null;
    }

    public double getCustomJump() {
        return 0.4;
    }

    public void setIsJumping(boolean flag) {
        this.isEntityJumping = flag;
    }

    public boolean getIsJumping() {
        return this.isEntityJumping;
    }

    public boolean getShouldDisplayName() {
        return this.getName() != null && !this.getName().equals("");
    }

    @Override
    public void makeEntityJump() {
        this.jumpPending = true;
    }

    public boolean func_70072_I() {
        return this.field_70170_p.func_72918_a(this.field_70121_D, Material.field_151586_h, (Entity)this);
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.field_70153_n == null) {
            super.func_70612_e(strafe, forward);
        }
        float movementSideways = strafe;
        float movementForward = forward;
        if (this.field_70153_n != null && !this.getIsTamed() && !this.isSwimming()) {
            this.field_70153_n.func_70078_a(null);
            return;
        }
        if (this.field_70153_n != null && !this.getIsTamed()) {
            if (this.field_70146_Z.nextInt(5) == 0 && !this.getIsJumping() && this.jumpPending) {
                this.field_70181_x += this.getCustomJump();
                this.setIsJumping(true);
                this.jumpPending = false;
            }
            if (this.field_70146_Z.nextInt(10) == 0) {
                this.field_70159_w += this.field_70146_Z.nextDouble() / 30.0;
                this.field_70179_y += this.field_70146_Z.nextDouble() / 10.0;
            }
            if (MoCreatures.isServer()) {
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            if (MoCreatures.isServer() && this.field_70146_Z.nextInt(50) == 0) {
                if (this.getUpsetSound() != null) {
                    this.func_85030_a(this.getUpsetSound(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
                }
                this.field_70153_n.field_70181_x += 0.9;
                this.field_70153_n.field_70179_y -= 0.3;
                this.field_70153_n.func_70078_a(null);
                this.field_70154_o = null;
            }
            if (this.field_70122_E) {
                this.setIsJumping(false);
            }
            if (MoCreatures.isServer() && this instanceof IMoCTameable) {
                int tameChance = this.getMaxTemper() - this.getTemper();
                if (tameChance <= 0) {
                    tameChance = 1;
                }
                if (this.field_70146_Z.nextInt(tameChance * 8) == 0) {
                    MoCTools.tameWithName((EntityPlayer)this.field_70153_n, (IMoCTameable)((Object)this));
                    if (this instanceof MoCEntityDolphin) {
                        ((EntityPlayer)this.field_70153_n).func_71064_a((StatBase)MoCAchievements.tame_dolphin, 1);
                    }
                }
            }
        } else if (this.field_70153_n != null && this.getIsTamed()) {
            this.field_70159_w += this.field_70153_n.field_70159_w * (this.getCustomSpeed() / 5.0);
            this.field_70179_y += this.field_70153_n.field_70179_y * (this.getCustomSpeed() / 5.0);
            movementSideways = ((EntityLivingBase)this.field_70153_n).field_70702_br * 0.5f;
            movementForward = ((EntityLivingBase)this.field_70153_n).field_70701_bs;
            if (this.jumpPending && this.isSwimming()) {
                this.field_70181_x += this.getCustomJump();
                this.jumpPending = false;
            }
            if (this.divePending) {
                this.divePending = false;
                this.field_70181_x -= 0.3;
            }
            if (this.field_70181_x > 0.01 && !this.isSwimming() && !this.getIsJumping()) {
                this.field_70181_x = -0.01;
            }
            this.field_70125_A = this.field_70153_n.field_70125_A * 0.5f;
            this.field_70126_B = this.field_70177_z = this.field_70153_n.field_70177_z;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            if (this instanceof MoCEntityDolphin && !this.field_70122_E) {
                float acceleration = 0.0f;
                acceleration = 1.0f + (float)this.getCustomSpeed() * 0.029f;
                if (this.field_70159_w < this.getCustomSpeed()) {
                    this.field_70159_w *= (double)acceleration;
                }
                if (this.field_70179_y < this.getCustomSpeed()) {
                    this.field_70179_y *= (double)acceleration;
                }
            }
            if (MoCreatures.isServer()) {
                super.func_70612_e(movementSideways, movementForward);
            }
        }
        this.field_70722_aY = this.field_70721_aZ;
        double xDistanceTravelled = this.field_70165_t - this.field_70169_q;
        double zDistanceTravelled = this.field_70161_v - this.field_70166_s;
        float overallHorizontalDistanceTravelledSquared = MathHelper.func_76133_a((double)(xDistanceTravelled * xDistanceTravelled + zDistanceTravelled * zDistanceTravelled)) * 4.0f;
        if (overallHorizontalDistanceTravelledSquared > 1.0f) {
            overallHorizontalDistanceTravelledSquared = 1.0f;
        }
        this.field_70721_aZ += (overallHorizontalDistanceTravelledSquared - this.field_70721_aZ) * 0.4f;
        this.field_70754_ba += this.field_70721_aZ;
    }

    protected boolean moveToNextEntity(Entity entity) {
        if (entity != null) {
            int entityPosX = MathHelper.func_76128_c((double)entity.field_70165_t);
            int entityPosY = MathHelper.func_76128_c((double)entity.field_70163_u);
            int entityPosZ = MathHelper.func_76128_c((double)entity.field_70161_v);
            MoCTools.faceItem((Entity)this, entityPosX, entityPosY, entityPosZ, 30.0f);
            if (this.field_70165_t < (double)entityPosX) {
                double distance = entity.field_70165_t - this.field_70165_t;
                if (distance > 0.5) {
                    this.field_70159_w += 0.05;
                }
            } else {
                double currentMinimumDistance = this.field_70165_t - entity.field_70165_t;
                if (currentMinimumDistance > 0.5) {
                    this.field_70159_w -= 0.05;
                }
            }
            if (this.field_70161_v < (double)entityPosZ) {
                double distance2 = entity.field_70161_v - this.field_70161_v;
                if (distance2 > 0.5) {
                    this.field_70179_y += 0.05;
                }
            } else {
                double distance3 = this.field_70161_v - entity.field_70161_v;
                if (distance3 > 0.5) {
                    this.field_70179_y -= 0.05;
                }
            }
            return true;
        }
        return false;
    }

    public double getCustomSpeed() {
        return 1.5;
    }

    public boolean func_70090_H() {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean isDiving() {
        return this.diving;
    }

    protected void func_70664_aZ() {
    }

    public void moveVerticallyInWater() {
        float yDistanceToSurfaceOfWater = MoCTools.distanceToWaterSurface((Entity)this);
        if (this.field_70153_n != null) {
            this.field_70181_x = this.divePending ? -0.008 : 0.0;
            return;
        }
        if (this.field_70789_a != null && this.field_70789_a.field_70163_u < this.field_70163_u - 0.5 && this.func_70032_d(this.field_70789_a) < 10.0f) {
            if (this.field_70181_x < -0.1) {
                this.field_70181_x = -0.1;
            }
            return;
        }
        if (yDistanceToSurfaceOfWater < 1.0f || this.isDiving()) {
            if (this.field_70181_x < -0.05) {
                this.field_70181_x = -0.05;
            }
        } else {
            if (this.field_70181_x < 0.0) {
                this.field_70181_x = 0.0;
            }
            this.field_70181_x += 0.001;
            if (yDistanceToSurfaceOfWater > 1.0f) {
                this.field_70181_x += (double)yDistanceToSurfaceOfWater * 0.02;
                if (this.field_70181_x > 0.2) {
                    this.field_70181_x = 0.2;
                }
            }
        }
    }

    protected boolean func_70780_i() {
        return !this.isSwimming() && this.field_70153_n == null || this.field_70153_n != null;
    }

    public void func_70636_d() {
        if (MoCreatures.isServer()) {
            Entity entityNearby;
            int index;
            List entitiesNearbyList;
            int iterationLength;
            if (this.field_70153_n != null) {
                this.mountCount = 1;
            }
            if (this.mountCount > 0 && ++this.mountCount > 50) {
                this.mountCount = 0;
            }
            if (this.isPredator() && this.hasKilledPrey) {
                if (MoCreatures.proxy.destroyDrops && (iterationLength = (entitiesNearbyList = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(3.0, 3.0, 3.0))).size()) > 0) {
                    for (index = 0; index < iterationLength; ++index) {
                        EntityItem entityItemNearby;
                        entityNearby = (Entity)entitiesNearbyList.get(index);
                        if (!(entityNearby instanceof EntityItem) || (entityItemNearby = (EntityItem)entityNearby) == null || entityItemNearby.field_70292_b >= 5) continue;
                        entityItemNearby.func_70106_y();
                    }
                }
                this.func_70691_i(5.0f);
                MoCTools.playCustomSound((Entity)this, "eating", this.field_70170_p);
                this.hasKilledPrey = false;
            }
            if (this.forceUpdates() && this.field_70146_Z.nextInt(500) == 0) {
                MoCTools.forceDataSync(this);
            }
            if (this.isFisheable() && !this.isCaughtOnHook && this.field_70146_Z.nextInt(30) == 0) {
                this.lookForHookToGetCaughtOn();
            }
            if (this.isCaughtOnHook && this.hookThatThisFishIsHookedTo != null) {
                boolean isHookNearby = true;
                float distanceToHook1 = this.hookThatThisFishIsHookedTo.func_70032_d((Entity)this);
                if (distanceToHook1 > 2.0f) {
                    isHookNearby = false;
                }
                if (!isHookNearby && this.playerThatHookedThisFish != null && this.hookThatThisFishIsHookedTo != null) {
                    if (this.playerThatHookedThisFish.func_70694_bm() != null && this.playerThatHookedThisFish.func_70694_bm().func_77973_b() == Items.field_151112_aM) {
                        this.exectuteReelInByFishinRodAction();
                    } else {
                        this.isCaughtOnHook = false;
                    }
                }
            }
            if (this.isCaughtOnHook && this.field_70146_Z.nextInt(200) == 0) {
                this.isCaughtOnHook = false;
                entitiesNearbyList = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(2.0, 2.0, 2.0));
                iterationLength = entitiesNearbyList.size();
                if (iterationLength > 0) {
                    for (index = 0; index < iterationLength; ++index) {
                        entityNearby = (Entity)entitiesNearbyList.get(index);
                        if (!(entityNearby instanceof EntityFishHook) || ((EntityFishHook)entityNearby).field_146043_c != this) continue;
                        ((EntityFishHook)entityNearby).field_146043_c = null;
                    }
                }
            }
        }
        if (this.isNotScared() && this.field_70788_c > 0) {
            this.field_70788_c = 0;
        }
        this.moveSpeed = this.getMoveSpeed();
        if (this.isSwimming()) {
            this.moveVerticallyInWater();
            this.outOfWater = 0;
            this.func_70050_g(300);
        } else {
            if (this.field_70153_n != null && this.field_70153_n.func_70093_af()) {
                this.field_70153_n.func_70078_a(null);
            }
            ++this.outOfWater;
            if (this.outOfWater > 10) {
                this.func_70778_a(null);
            }
            if (this.outOfWater > 100 && this.outOfWater % 20 == 0) {
                this.field_70181_x += 0.3;
                this.field_70159_w = (float)(Math.random() * 0.2 - 0.1);
                this.field_70179_y = (float)(Math.random() * 0.2 - 0.1);
                this.func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
        }
        if (!this.func_70781_l() && this.field_70153_n == null && !this.func_70780_i() && this.field_70789_a == null) {
            this.func_70779_j();
        }
        if (!this.diving) {
            if (this.field_70153_n == null && this.field_70789_a == null && this.func_70781_l() && this.field_70146_Z.nextInt(500) == 0) {
                this.diving = true;
            }
        } else {
            ++this.divingCount;
            if (this.divingCount > 100 || this.field_70153_n != null) {
                this.diving = false;
                this.divingCount = 0;
            }
        }
        super.func_70636_d();
    }

    private void exectuteReelInByFishinRodAction() {
        ItemStack itemstackToBeFished = new ItemStack(Items.field_151115_aP, 1, 0);
        EntityItem entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, itemstackToBeFished);
        double xDistance = this.playerThatHookedThisFish.field_70165_t - this.hookThatThisFishIsHookedTo.field_70165_t;
        double yDistance = this.playerThatHookedThisFish.field_70163_u - this.hookThatThisFishIsHookedTo.field_70163_u;
        double zDistance = this.playerThatHookedThisFish.field_70161_v - this.hookThatThisFishIsHookedTo.field_70161_v;
        this.func_70106_y();
        double overallDistanceSquared = MathHelper.func_76133_a((double)(xDistance * xDistance + yDistance * yDistance + zDistance * zDistance));
        double distanceOffset = 0.1;
        entityItem.field_70159_w = xDistance * distanceOffset;
        entityItem.field_70181_x = yDistance * distanceOffset + (double)MathHelper.func_76133_a((double)overallDistanceSquared) * 0.08;
        entityItem.field_70179_y = zDistance * distanceOffset;
        this.field_70170_p.func_72838_d((Entity)entityItem);
        this.playerThatHookedThisFish.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.playerThatHookedThisFish.field_70170_p, this.playerThatHookedThisFish.field_70165_t, this.playerThatHookedThisFish.field_70163_u + 0.5, this.playerThatHookedThisFish.field_70161_v + 0.5, this.field_70146_Z.nextInt(6) + 1));
    }

    public boolean isSwimming() {
        return this.func_70055_a(Material.field_151586_h);
    }

    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("Tamed", this.getIsTamed());
        nbtTagCompound.func_74757_a("Adult", this.getIsAdult());
        nbtTagCompound.func_74768_a("Age", this.getMoCAge());
        nbtTagCompound.func_74778_a("Name", this.getName());
        nbtTagCompound.func_74768_a("TypeInt", this.getType());
        nbtTagCompound.func_74778_a("Owner", this.getOwnerName());
    }

    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setTamed(nbtTagCompound.func_74767_n("Tamed"));
        this.setAdult(nbtTagCompound.func_74767_n("Adult"));
        this.setMoCAge(nbtTagCompound.func_74762_e("Age"));
        this.setName(nbtTagCompound.func_74779_i("Name"));
        this.setType(nbtTagCompound.func_74762_e("TypeInt"));
        this.setOwner(nbtTagCompound.func_74779_i("Owner"));
    }

    public boolean func_70094_T() {
        if (this.getIsTamed()) {
            return false;
        }
        return super.func_70094_T();
    }

    public void setDisplayName(boolean flag) {
    }

    public void setTypeInt(int i) {
        this.setType(i);
        this.selectType();
    }

    @Override
    public void performAnimation(int attackType) {
    }

    protected void func_70623_bb() {
        EntityPlayer distanceToPlayer = this.field_70170_p.func_72890_a((Entity)this, -1.0);
        if (distanceToPlayer != null) {
            double xDistance = distanceToPlayer.field_70165_t - this.field_70165_t;
            double yDistance = distanceToPlayer.field_70163_u - this.field_70163_u;
            double zDistance = distanceToPlayer.field_70161_v - this.field_70161_v;
            double overallDistanceSquared = xDistance * xDistance + yDistance * yDistance + zDistance * zDistance;
            if (this.func_70692_ba() && overallDistanceSquared > 16384.0) {
                this.func_70106_y();
            }
            if (this.field_70708_bq > 1800 && this.field_70146_Z.nextInt(800) == 0 && overallDistanceSquared > 1024.0 && this.func_70692_ba()) {
                this.func_70106_y();
            } else if (overallDistanceSquared < 1024.0) {
                this.field_70708_bq = 0;
            }
        }
    }

    public float getMoveSpeed() {
        return 0.7f;
    }

    @Override
    public int nameYOffset() {
        return 0;
    }

    @Override
    public double roperYOffset() {
        return 0.0;
    }

    @Override
    public boolean shouldRenderName() {
        return false;
    }

    @Override
    public Entity getRoper() {
        return this.roper;
    }

    @Override
    public boolean updateMount() {
        return false;
    }

    @Override
    public boolean forceUpdates() {
        return false;
    }

    @Override
    public void makeEntityDive() {
        this.divePending = true;
    }

    @Override
    public float getSizeFactor() {
        return 1.0f;
    }

    @Override
    public float getAdjustedYOffset() {
        return 0.0f;
    }

    public boolean func_70601_bi() {
        return MoCreatures.entityMap.get(this.getClass()).getFrequency() > 0 && this.field_70170_p.func_72855_b(this.field_70121_D);
    }

    @Override
    public String getOwnerName() {
        return this.field_70180_af.func_75681_e(21);
    }

    @Override
    public void setOwner(String par1Str) {
        this.field_70180_af.func_75692_b(21, (Object)par1Str);
    }

    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
        if (MoCreatures.proxy.enableStrictOwnership && this.getOwnerName() != null && !this.getOwnerName().equals("") && entityThatAttackedThisCreature != null && entityThatAttackedThisCreature instanceof EntityPlayer && !((EntityPlayer)entityThatAttackedThisCreature).func_70005_c_().equals(this.getOwnerName()) && !MoCTools.isThisPlayerAnOP((EntityPlayer)entityThatAttackedThisCreature)) {
            return false;
        }
        if (this.isFisheable() && entityThatAttackedThisCreature != null && entityThatAttackedThisCreature instanceof EntityPlayer && ((EntityPlayer)entityThatAttackedThisCreature).func_70694_bm() != null && ((EntityPlayer)entityThatAttackedThisCreature).func_70694_bm().func_77973_b() == Items.field_151112_aM) {
            this.lookForHookToGetCaughtOn();
        }
        if (this.getIsTamed() && damageSource.func_76355_l().equalsIgnoreCase("inWall")) {
            return false;
        }
        return super.func_70097_a(damageSource, damageTaken);
    }

    protected boolean canBeTrappedInNet() {
        return this instanceof IMoCTameable && this.getIsTamed();
    }

    protected void dropMyStuff() {
    }

    protected boolean isMyHealFood(ItemStack itemStack) {
        return false;
    }

    @Override
    public void setArmorType(byte i) {
    }

    @Override
    public void dismountEntity() {
        if (MoCreatures.isServer() && this.field_70153_n != null) {
            this.field_70153_n.func_70078_a(null);
            this.field_70153_n = null;
        }
    }

    @Override
    public int pitchRotationOffset() {
        return 0;
    }

    @Override
    public int rollRotationOffset() {
        return 0;
    }

    private void lookForHookToGetCaughtOn() {
        EntityPlayer closestEntityPlayer = this.field_70170_p.func_72890_a((Entity)this, 18.0);
        if (closestEntityPlayer != null) {
            this.closestFishHook = closestEntityPlayer.field_71104_cf;
            if (this.closestFishHook != null && this.closestFishHook.field_146043_c == null) {
                this.distanceToHook = this.closestFishHook.func_70032_d((Entity)this);
                if (this.distanceToHook > 1.0f) {
                    MoCTools.getPathToEntity((EntityCreature)this, (Entity)this.closestFishHook, this.distanceToHook);
                } else if (!closestEntityPlayer.func_70055_a(Material.field_151586_h)) {
                    this.closestFishHook.field_146043_c = this;
                    this.isCaughtOnHook = true;
                    if (this.outOfWater == 0) {
                        this.closestFishHook.field_70181_x -= (double)0.2f;
                        this.func_85030_a("random.splash", 0.25f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                    }
                    this.playerThatHookedThisFish = closestEntityPlayer;
                    this.hookThatThisFishIsHookedTo = this.closestFishHook;
                }
            }
        }
    }

    protected boolean isFisheable() {
        return false;
    }

    @Override
    public int yawRotationOffset() {
        return 0;
    }

    @Override
    public float getAdjustedZOffset() {
        return 0.0f;
    }

    @Override
    public float getAdjustedXOffset() {
        return 0.0f;
    }

    @Override
    public boolean entitiesThatAreScary(Entity entity) {
        return entity.getClass() != this.getClass() && entity instanceof EntityLivingBase && ((double)entity.field_70130_N >= 0.5 || (double)entity.field_70131_O >= 0.5);
    }

    public boolean isNotScared() {
        return false;
    }

    @Override
    public void riderIsDisconnecting(boolean flag) {
        this.riderIsDisconnecting = true;
    }
}

