/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.IMoCTameable;
import drzhark.mocreatures.entity.MoCEntityAnimal;
import drzhark.mocreatures.entity.animal.MoCEntityHorse;
import drzhark.mocreatures.entity.item.MoCEntityEgg;
import drzhark.mocreatures.entity.item.MoCEntityKittyBed;
import drzhark.mocreatures.entity.item.MoCEntityLitterBox;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageHealth;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class MoCEntityAmbient
extends EntityAnimal
implements IMoCEntity {
    protected float moveSpeed;
    protected boolean riderIsDisconnecting;
    protected String texture;

    public MoCEntityAmbient(World world) {
        super(world);
        this.setTamed(false);
        this.setAdult(true);
        this.riderIsDisconnecting = false;
        this.texture = "blank.png";
    }

    @Override
    public ResourceLocation getTexture() {
        return MoCreatures.proxy.getTexture(this.texture);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.getMoveSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.func_110138_aP());
    }

    public IEntityLivingData func_110161_a(IEntityLivingData entityLivingData) {
        this.selectType();
        return super.func_110161_a(entityLivingData);
    }

    @Override
    public void selectType() {
        this.setType(1);
    }

    public EntityAgeable func_90011_a(EntityAgeable var1) {
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(15, (Object)0);
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)String.valueOf(""));
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)String.valueOf(""));
    }

    @Override
    public void setType(int i) {
        this.field_70180_af.func_75692_b(19, (Object)i);
    }

    @Override
    public int getType() {
        return this.field_70180_af.func_75679_c(19);
    }

    public void setDisplayName(boolean flag) {
    }

    @Override
    public boolean getIsAdult() {
        return this.field_70180_af.func_75683_a(15) == 1;
    }

    @Override
    public boolean getIsTamed() {
        return this.field_70180_af.func_75683_a(16) == 1;
    }

    @Override
    public String getName() {
        return this.field_70180_af.func_75681_e(17);
    }

    @Override
    public int getMoCAge() {
        return this.field_70180_af.func_75679_c(18);
    }

    @Override
    public void setMoCAge(int i) {
        this.field_70180_af.func_75692_b(18, (Object)i);
    }

    @Override
    public void setAdult(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(15, (Object)input);
    }

    @Override
    public void setName(String name) {
        this.field_70180_af.func_75692_b(17, (Object)String.valueOf(name));
    }

    @Override
    public void setTamed(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(16, (Object)input);
    }

    protected boolean func_70692_ba() {
        return true;
    }

    @Override
    public boolean checkSpawningBiome() {
        return true;
    }

    public void func_70636_d() {
        if (this.isSwimming() && this.isSwimmerEntity()) {
            this.floatOnWater();
        }
        this.moveSpeed = this.getMoveSpeed();
        super.func_70636_d();
    }

    public boolean isSwimmerEntity() {
        return false;
    }

    public boolean isSwimming() {
        return this.func_70055_a(Material.field_151586_h);
    }

    public void floatOnWater() {
        if (this.field_70181_x < 0.0) {
            this.field_70181_x = 0.0;
        }
        this.field_70181_x += 0.001;
        int yDistanceToSurfaceOfWater = (int)MoCTools.distanceToWaterSurface((Entity)this);
        if (yDistanceToSurfaceOfWater > 1) {
            this.field_70181_x += (double)yDistanceToSurfaceOfWater * 0.07;
        }
        if (this.func_70781_l() && this.field_70123_F) {
            this.func_70664_aZ();
        }
    }

    public boolean isItemEdible(Item item) {
        return item instanceof ItemFood || item instanceof ItemSeeds || item == Items.field_151015_O || item == Items.field_151102_aT || item == Items.field_151105_aU || item == Items.field_151110_aK;
    }

    public boolean isMyAphrodisiac(Item item1) {
        return false;
    }

    public void dropMyStuff() {
    }

    protected boolean isMyHealFood(ItemStack itemStack) {
        return false;
    }

    public boolean func_70090_H() {
        if (this.isSwimmerEntity()) {
            return false;
        }
        return super.func_70090_H();
    }

    public boolean func_70648_aU() {
        return this.isSwimmerEntity();
    }

    public EntityItem getClosestEntityItem(Entity entity, double distance) {
        double currentMinimumDistance = -1.0;
        EntityItem entityItem = null;
        List entitiesNearbyList = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(distance, distance, distance));
        int iterationLength = entitiesNearbyList.size();
        if (iterationLength > 0) {
            for (int index = 0; index < iterationLength; ++index) {
                Entity entityNearby = (Entity)entitiesNearbyList.get(index);
                if (!(entityNearby instanceof EntityItem)) continue;
                EntityItem entityItemNearby = (EntityItem)entityNearby;
                double overallDistanceSquared = entityItemNearby.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                if (!(distance < 0.0) && !(overallDistanceSquared < distance * distance) || currentMinimumDistance != -1.0 && !(overallDistanceSquared < currentMinimumDistance)) continue;
                currentMinimumDistance = overallDistanceSquared;
                entityItem = entityItemNearby;
            }
        }
        return entityItem;
    }

    public EntityItem getClosestFood(Entity entity, double distance) {
        double currentMinimumDistance = -1.0;
        EntityItem entityItem = null;
        List entitiesNearbyList = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(distance, distance, distance));
        int iterationLength = entitiesNearbyList.size();
        if (iterationLength > 0) {
            for (int index = 0; index < iterationLength; ++index) {
                EntityItem entityItemNearby;
                Entity entityNearby = (Entity)entitiesNearbyList.get(index);
                if (!(entityNearby instanceof EntityItem) || !this.isItemEdible((entityItemNearby = (EntityItem)entityNearby).func_92059_d().func_77973_b())) continue;
                double overallDistanceSquared = entityItemNearby.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                if (!(distance < 0.0) && !(overallDistanceSquared < distance * distance) || currentMinimumDistance != -1.0 && !(overallDistanceSquared < currentMinimumDistance)) continue;
                currentMinimumDistance = overallDistanceSquared;
                entityItem = entityItemNearby;
            }
        }
        return entityItem;
    }

    public void getMyOwnPath(Entity entity, float f) {
        PathEntity pathEntity = this.field_70170_p.func_72865_a((Entity)this, entity, 16.0f, true, false, false, true);
        if (pathEntity != null) {
            this.func_70778_a(pathEntity);
        }
    }

    public void Riding() {
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)this.field_70153_n;
            List entitiesNearbyList = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(1.0, 0.0, 1.0));
            int interationLength = entitiesNearbyList.size();
            if (interationLength > 0 && entitiesNearbyList != null) {
                for (int index = 0; index < interationLength; ++index) {
                    float distance;
                    Entity entityNearby = (Entity)entitiesNearbyList.get(index);
                    if (entityNearby.field_70128_L) continue;
                    entityNearby.func_70100_b_(entityPlayer);
                    if (entityNearby instanceof EntityMob && (distance = this.func_70032_d(entityNearby)) < 2.0f && this.field_70146_Z.nextInt(10) != 0) continue;
                }
            }
            if (entityPlayer.func_70093_af() && !this.field_70170_p.field_72995_K) {
                entityPlayer.func_70078_a(null);
            }
        }
    }

    protected void getPathOrWalkableBlock(Entity entity, float f) {
        PathEntity pathEntity = this.field_70170_p.func_72865_a((Entity)this, entity, 16.0f, true, false, false, true);
        if (pathEntity == null && f > 8.0f) {
            int x = MathHelper.func_76128_c((double)entity.field_70165_t) - 2;
            int y = MathHelper.func_76128_c((double)entity.field_70161_v) - 2;
            int z = MathHelper.func_76128_c((double)entity.field_70121_D.field_72338_b);
            for (int index = 0; index <= 4; ++index) {
                for (int index1 = 0; index1 <= 4; ++index1) {
                    if (index >= 1 && index1 >= 1 && index <= 3 && index1 <= 3 || !this.field_70170_p.func_147439_a(x + index, z - 1, y + index1).func_149721_r() || this.field_70170_p.func_147439_a(x + index, z, y + index1).func_149721_r() || this.field_70170_p.func_147439_a(x + index, z + 1, y + index1).func_149721_r()) continue;
                    this.func_70012_b((float)(x + index) + 0.5f, z, (float)(y + index1) + 0.5f, this.field_70177_z, this.field_70125_A);
                    return;
                }
            }
        } else {
            this.func_70778_a(pathEntity);
        }
    }

    public boolean getCanSpawnHereAnimal() {
        int zCoordinate;
        int yCoordinate;
        int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
        return this.field_70170_p.func_147439_a(xCoordinate, (yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b)) - 1, zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v)) == Blocks.field_150349_c && this.field_70170_p.func_72883_k(xCoordinate, yCoordinate, zCoordinate) > 8;
    }

    public boolean getCanSpawnHereCreature() {
        int zCoordinate;
        int yCoordinate;
        int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
        return this.func_70783_a(xCoordinate, yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v)) >= 0.0f;
    }

    public boolean getCanSpawnHereLiving() {
        return this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).size() == 0 && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }

    public boolean getCanSpawnHereAquatic() {
        return this.field_70170_p.func_72855_b(this.field_70121_D);
    }

    public boolean func_70601_bi() {
        int zCoordinate;
        int yCoordinate;
        if (MoCreatures.entityMap.get(this.getClass()).getFrequency() <= 0) {
            return false;
        }
        int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
        String biomeName = MoCTools.biomeName(this.field_70170_p, xCoordinate, yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v));
        if (biomeName.equals("Jungle") || biomeName.equals("JungleHills")) {
            return this.getCanSpawnHereJungle();
        }
        return super.func_70601_bi();
    }

    public boolean getCanSpawnHereJungle() {
        if (this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D)) {
            int xCoordinate = MathHelper.func_76128_c((double)this.field_70165_t);
            int yCoordinate = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            int zCoordinate = MathHelper.func_76128_c((double)this.field_70161_v);
            if (yCoordinate < 63) {
                return false;
            }
            Block block = this.field_70170_p.func_147439_a(xCoordinate, yCoordinate - 1, zCoordinate);
            if (block == Blocks.field_150349_c || block == Blocks.field_150362_t || block != null && block.isLeaves((IBlockAccess)this.field_70170_p, xCoordinate, yCoordinate - 1, zCoordinate)) {
                return true;
            }
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("Tamed", this.getIsTamed());
        nbtTagCompound.func_74757_a("Adult", this.getIsAdult());
        nbtTagCompound.func_74768_a("Age", this.getMoCAge());
        nbtTagCompound.func_74778_a("Name", this.getName());
        nbtTagCompound.func_74768_a("TypeInt", this.getType());
        nbtTagCompound.func_74778_a("Owner", this.getOwnerName());
    }

    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setTamed(nbtTagCompound.func_74767_n("Tamed"));
        this.setAdult(nbtTagCompound.func_74767_n("Adult"));
        this.setMoCAge(nbtTagCompound.func_74762_e("Age"));
        this.setName(nbtTagCompound.func_74779_i("Name"));
        this.setType(nbtTagCompound.func_74762_e("TypeInt"));
        this.setOwner(nbtTagCompound.func_74779_i("Owner"));
    }

    public void func_70612_e(float strafeMovement, float forwardMovement) {
        if (!(this.isFlyer() || this.rideableEntity() && this.field_70153_n != null)) {
            super.func_70612_e(strafeMovement, forwardMovement);
            return;
        }
        if (this.func_70072_I()) {
            if (this.field_70153_n != null) {
                this.field_70159_w += this.field_70153_n.field_70159_w * (this.getCustomSpeed() / 2.0);
                this.field_70179_y += this.field_70153_n.field_70179_y * (this.getCustomSpeed() / 2.0);
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                this.field_70125_A = this.field_70153_n.field_70125_A * 0.5f;
                if (this.field_70146_Z.nextInt(20) == 0) {
                    this.field_70177_z = this.field_70153_n.field_70177_z;
                }
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                if (MoCreatures.isServer() && !this.getIsTamed()) {
                    this.func_85030_a("mocreatures:" + this.getMadSound(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
                    this.field_70153_n.field_70181_x += 0.3;
                    this.field_70153_n.field_70179_y -= 0.3;
                    this.field_70153_n.func_70078_a(null);
                    this.field_70153_n = null;
                }
            }
            double yCoordinate = this.field_70163_u;
            if (!this.field_70170_p.field_72995_K) {
                this.func_70060_a(strafeMovement, forwardMovement, 0.02f);
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
            this.field_70181_x -= 0.02;
            if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + yCoordinate, this.field_70179_y)) {
                this.field_70181_x = 0.300000011920929;
            }
        } else if (this.func_70058_J()) {
            if (this.field_70153_n != null) {
                this.field_70159_w += this.field_70153_n.field_70159_w * (this.getCustomSpeed() / 2.0);
                this.field_70179_y += this.field_70153_n.field_70179_y * (this.getCustomSpeed() / 2.0);
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70125_A = this.field_70153_n.field_70125_A * 0.5f;
                if (this.field_70146_Z.nextInt(20) == 0) {
                    this.field_70177_z = this.field_70153_n.field_70177_z;
                }
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                if (MoCreatures.isServer() && !this.getIsTamed()) {
                    this.func_85030_a("mocreatures:" + this.getMadSound(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
                    this.field_70153_n.field_70181_x += 0.3;
                    this.field_70153_n.field_70179_y -= 0.3;
                    this.field_70153_n.func_70078_a(null);
                    this.field_70153_n = null;
                }
            }
            double yCoordinate1 = this.field_70163_u;
            this.func_70060_a(strafeMovement, forwardMovement, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
            this.field_70181_x -= 0.02;
            if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + yCoordinate1, this.field_70179_y)) {
                this.field_70181_x = 0.300000011920929;
            }
        } else {
            float movement = 0.91f;
            if (this.field_70122_E) {
                movement = 0.5460001f;
                Block block = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                if (block != Blocks.field_150350_a) {
                    movement = block.field_149765_K * 0.91f;
                }
            }
            float f3 = 0.162771f / (movement * movement * movement);
            this.func_70060_a(strafeMovement, forwardMovement, this.field_70122_E ? 0.1f * f3 : 0.02f);
            if (this.func_70617_f_()) {
                this.field_70143_R = 0.0f;
                if (this.field_70181_x < -0.15) {
                    this.field_70181_x = -0.15;
                }
            }
            if (this.field_70153_n != null && !this.getIsTamed()) {
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.field_70159_w += this.field_70146_Z.nextDouble() / 30.0;
                    this.field_70179_y += this.field_70146_Z.nextDouble() / 10.0;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                if (MoCreatures.isServer() && this.field_70146_Z.nextInt(50) == 0) {
                    this.func_85030_a("mocreatures:" + this.getMadSound(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
                    this.field_70153_n.field_70181_x += 0.9;
                    this.field_70153_n.field_70179_y -= 0.3;
                    this.field_70153_n.func_70078_a(null);
                    this.field_70153_n = null;
                }
            }
            if (this.field_70153_n != null && this.getIsTamed()) {
                this.field_70121_D.field_72337_e = this.field_70153_n.field_70121_D.field_72337_e;
                if (!this.selfPropelledFlyer() || this.selfPropelledFlyer() && !this.isOnAir()) {
                    this.field_70159_w += this.field_70153_n.field_70159_w * this.getCustomSpeed();
                    this.field_70179_y += this.field_70153_n.field_70179_y * this.getCustomSpeed();
                }
                if (MoCreatures.isServer()) {
                    this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                this.field_70126_B = this.field_70177_z = this.field_70153_n.field_70177_z;
                this.field_70125_A = this.field_70153_n.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            if (this.isFlyingAlone()) {
                int distY = MoCTools.distanceToWaterFloor((Entity)this);
                if (distY <= this.flyingHeight()) {
                    this.field_70181_x *= (double)movement;
                }
                if (distY <= this.flyingHeight() && (this.field_70123_F || this.field_70146_Z.nextInt(100) == 0)) {
                    this.field_70181_x += 0.1;
                }
                if (distY > this.flyingHeight() || this.field_70146_Z.nextInt(150) == 0) {
                    this.field_70181_x -= 0.1;
                }
                if (this.isOnAir()) {
                    double xVelocity = (double)0.05f * Math.cos(MoCTools.realAngle(this.field_70177_z - 90.0f) / 57.29578f);
                    double zVelocity = (double)0.05f * Math.sin(MoCTools.realAngle(this.field_70177_z - 90.0f) / 57.29578f);
                    this.field_70159_w -= xVelocity;
                    this.field_70179_y -= zVelocity;
                }
            }
            if (this.isFlyer() && this.field_70153_n == null && this.field_70789_a != null && this.field_70789_a.field_70163_u < this.field_70163_u && this.field_70146_Z.nextInt(30) == 0) {
                this.field_70181_x = -0.25;
            }
            if (this.isFlyer() && this.field_70153_n != null && this.getIsTamed()) {
                this.field_70181_x -= 0.08;
                this.field_70181_x *= this.myFallSpeed();
            } else if (!this.isFlyingAlone()) {
                this.field_70181_x -= 0.08;
                this.field_70181_x *= (double)0.98f;
            }
            if (this.field_70153_n != null && this.isOnAir()) {
                movement = this.flyerFriction();
            }
            this.field_70159_w *= (double)movement;
            this.field_70179_y *= (double)movement;
        }
        this.field_70722_aY = this.field_70721_aZ;
        double xDistanceTravelled = this.field_70165_t - this.field_70169_q;
        double zDistanceTravelled = this.field_70161_v - this.field_70166_s;
        float overallHorizontalDistanceTravelledSquared = MathHelper.func_76133_a((double)(xDistanceTravelled * xDistanceTravelled + zDistanceTravelled * zDistanceTravelled)) * 4.0f;
        if (overallHorizontalDistanceTravelledSquared > 1.0f) {
            overallHorizontalDistanceTravelledSquared = 1.0f;
        }
        this.field_70721_aZ += (overallHorizontalDistanceTravelledSquared - this.field_70721_aZ) * 0.4f;
        this.field_70754_ba += this.field_70721_aZ;
    }

    public int flyingHeight() {
        return 5;
    }

    protected double myFallSpeed() {
        return 0.6;
    }

    protected double flyerThrust() {
        return 0.3;
    }

    protected float flyerFriction() {
        return 0.91f;
    }

    protected boolean selfPropelledFlyer() {
        return false;
    }

    @Override
    public void makeEntityJump() {
    }

    public boolean isFlyer() {
        return false;
    }

    public int getMaxTemper() {
        return 100;
    }

    public double getCustomSpeed() {
        return 0.8;
    }

    public double getCustomJump() {
        return 0.4;
    }

    protected String getMadSound() {
        return null;
    }

    @Override
    public void makeEntityDive() {
    }

    public boolean rideableEntity() {
        return false;
    }

    @Override
    public boolean shouldRenderName() {
        return this.getShouldDisplayName() && this.field_70153_n == null;
    }

    public boolean getShouldDisplayName() {
        return this.getName() != null && !this.getName().equals("");
    }

    @Override
    public int nameYOffset() {
        return -80;
    }

    @Override
    public double roperYOffset() {
        return 0.0;
    }

    protected Entity func_70782_k() {
        return null;
    }

    public boolean isFlyingAlone() {
        return false;
    }

    public float getMoveSpeed() {
        return 0.7f;
    }

    @Override
    public void performAnimation(int attackType) {
    }

    public boolean isMyFollowFood(ItemStack itemStack) {
        return false;
    }

    @Override
    public Entity getRoper() {
        return null;
    }

    @Override
    public boolean updateMount() {
        return false;
    }

    @Override
    public boolean forceUpdates() {
        return false;
    }

    public boolean isOnAir() {
        return this.field_70170_p.func_147437_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 0.2)), MathHelper.func_76128_c((double)this.field_70161_v)) && this.field_70170_p.func_147437_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.2)), MathHelper.func_76128_c((double)this.field_70161_v));
    }

    @Override
    public float getSizeFactor() {
        return 1.0f;
    }

    @Override
    public float getAdjustedYOffset() {
        return 0.0f;
    }

    @Override
    public String getOwnerName() {
        return this.field_70180_af.func_75681_e(20);
    }

    @Override
    public void setOwner(String par1Str) {
        this.field_70180_af.func_75692_b(20, (Object)par1Str);
    }

    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
        if (MoCreatures.proxy.enableStrictOwnership && this.getOwnerName() != null && !this.getOwnerName().equals("") && entityThatAttackedThisCreature != null && entityThatAttackedThisCreature instanceof EntityPlayer && !((EntityPlayer)entityThatAttackedThisCreature).func_70005_c_().equals(this.getOwnerName()) && !MoCTools.isThisPlayerAnOP((EntityPlayer)entityThatAttackedThisCreature)) {
            return false;
        }
        if (MoCreatures.isServer() && this.getIsTamed()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageHealth(this.func_145782_y(), this.func_110143_aJ()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        return super.func_70097_a(damageSource, damageTaken);
    }

    public boolean getIsRideable() {
        return false;
    }

    public void setRideable(boolean b) {
    }

    @Override
    public boolean shouldEntityBeIgnored(Entity entity) {
        return !(entity instanceof EntityLiving) || entity instanceof EntityMob || entity instanceof EntityPlayer && this.getIsTamed() || entity instanceof MoCEntityKittyBed || entity instanceof MoCEntityLitterBox || this.getIsTamed() && entity instanceof MoCEntityAnimal && ((MoCEntityAnimal)entity).getIsTamed() || entity instanceof EntityWolf && !MoCreatures.proxy.attackWolves || entity instanceof MoCEntityHorse && !MoCreatures.proxy.attackHorses || entity.field_70130_N > this.field_70130_N && entity.field_70131_O > this.field_70131_O || entity instanceof MoCEntityEgg;
    }

    @Override
    public void setArmorType(byte i) {
    }

    @Override
    public void dismountEntity() {
    }

    @Override
    public boolean entitiesThatAreScary(Entity entity) {
        return entity instanceof EntityLivingBase && ((double)entity.field_70130_N >= 0.5 || (double)entity.field_70131_O >= 0.5);
    }

    public void runLikeHell(Entity entity) {
        double xDistance = this.field_70165_t - entity.field_70165_t;
        double zDistance = this.field_70161_v - entity.field_70161_v;
        double angleInRadiansToNewLocation = Math.atan2(xDistance, zDistance);
        double tempNewPosX = this.field_70165_t + Math.sin(angleInRadiansToNewLocation += (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.75) * 8.0;
        double tempNewPosZ = this.field_70161_v + Math.cos(angleInRadiansToNewLocation) * 8.0;
        int temp1NewPosX = MathHelper.func_76128_c((double)tempNewPosX);
        int temp1NewPosY = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int temp1NewPosZ = MathHelper.func_76128_c((double)tempNewPosZ);
        for (int index = 0; index < 16; ++index) {
            int newPosX = temp1NewPosX + this.field_70146_Z.nextInt(4) - this.field_70146_Z.nextInt(4);
            int newPosY = temp1NewPosY + this.field_70146_Z.nextInt(3) - this.field_70146_Z.nextInt(3);
            int newPosZ = temp1NewPosZ + this.field_70146_Z.nextInt(4) - this.field_70146_Z.nextInt(4);
            if (newPosY <= 4 || !this.field_70170_p.func_147437_c(newPosX, newPosY, newPosZ) && this.field_70170_p.func_147439_a(newPosX, newPosY, newPosZ) != Blocks.field_150433_aE || this.field_70170_p.func_147437_c(newPosX, newPosY - 1, newPosZ)) continue;
            PathEntity pathEntity = this.field_70170_p.func_72844_a((Entity)this, newPosX, newPosY, newPosZ, 16.0f, true, false, false, true);
            this.func_70778_a(pathEntity);
            break;
        }
    }

    @Override
    public int pitchRotationOffset() {
        return 0;
    }

    @Override
    public int rollRotationOffset() {
        return 0;
    }

    @Override
    public int yawRotationOffset() {
        return 0;
    }

    @Override
    public float getAdjustedZOffset() {
        return 0.0f;
    }

    @Override
    public float getAdjustedXOffset() {
        return 0.0f;
    }

    protected boolean canBeTrappedInNet() {
        return this instanceof IMoCTameable && this.getIsTamed();
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        return type == EnumCreatureType.ambient;
    }

    @Override
    public void riderIsDisconnecting(boolean flag) {
        this.riderIsDisconnecting = true;
    }
}

