/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.command;

import cpw.mods.fml.common.FMLCommonHandler;
import drzhark.mocreatures.MoCPetData;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCTameable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class CommandMoCTP
extends CommandBase {
    private static List<String> commands = new ArrayList<String>();
    private static List aliases = new ArrayList();

    public String func_71517_b() {
        return "moctp";
    }

    public List func_71514_a() {
        return aliases;
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender par1ICommandSender) {
        return "commands.moctp.usage";
    }

    public void func_71515_b(ICommandSender par1ICommandSender, String[] charArray) {
        int petId = 0;
        if (charArray == null || charArray.length == 0) {
            par1ICommandSender.func_145747_a((IChatComponent)new ChatComponentTranslation(EnumChatFormatting.RED + "Error" + EnumChatFormatting.WHITE + ": You must enter a valid entity ID.", new Object[0]));
            return;
        }
        try {
            petId = Integer.parseInt(charArray[0]);
        }
        catch (NumberFormatException e) {
            petId = -1;
        }
        String playername = par1ICommandSender.func_70005_c_();
        EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152612_a(playername);
        MoCPetData ownerPetData = MoCreatures.instance.mapData.getPetData(playername);
        if (player != null & ownerPetData != null) {
            for (int i = 0; i < ownerPetData.getTamedList().func_74745_c(); ++i) {
                NBTTagCompound nbt = ownerPetData.getTamedList().func_150305_b(i);
                if (!nbt.func_74764_b("PetId") || nbt.func_74762_e("PetId") != petId) continue;
                String petName = nbt.func_74779_i("Name");
                WorldServer world = DimensionManager.getWorld((int)nbt.func_74762_e("Dimension"));
                if (this.teleportLoadedPet(world, player, petId, petName, par1ICommandSender)) break;
                double posX = nbt.func_150295_c("Pos", 6).func_150309_d(0);
                double posY = nbt.func_150295_c("Pos", 6).func_150309_d(1);
                double posZ = nbt.func_150295_c("Pos", 6).func_150309_d(2);
                int x = MathHelper.func_76128_c((double)posX);
                int y = MathHelper.func_76128_c((double)posY);
                int z = MathHelper.func_76128_c((double)posZ);
                par1ICommandSender.func_145747_a((IChatComponent)new ChatComponentTranslation("Found unloaded pet " + EnumChatFormatting.GREEN + nbt.func_74779_i("id") + EnumChatFormatting.WHITE + " with name " + EnumChatFormatting.AQUA + nbt.func_74779_i("Name") + EnumChatFormatting.WHITE + " at location " + EnumChatFormatting.LIGHT_PURPLE + x + EnumChatFormatting.WHITE + ", " + EnumChatFormatting.LIGHT_PURPLE + y + EnumChatFormatting.WHITE + ", " + EnumChatFormatting.LIGHT_PURPLE + z + EnumChatFormatting.WHITE + " with Pet ID " + EnumChatFormatting.BLUE + nbt.func_74762_e("PetId"), new Object[0]));
                world.func_72964_e(x >> 4, z >> 4);
                boolean result = this.teleportLoadedPet(world, player, petId, petName, par1ICommandSender);
                if (!result) {
                    par1ICommandSender.func_145747_a((IChatComponent)new ChatComponentTranslation("Unable to transfer entity ID " + EnumChatFormatting.GREEN + petId + EnumChatFormatting.WHITE + ". It may only be transferred to " + EnumChatFormatting.AQUA + player.func_70005_c_(), new Object[0]));
                }
                break;
            }
        } else {
            par1ICommandSender.func_145747_a((IChatComponent)new ChatComponentTranslation("Tamed entity could not be located.", new Object[0]));
        }
    }

    protected List getSortedPossibleCommands(ICommandSender par1ICommandSender) {
        Collections.sort(commands);
        return commands;
    }

    public boolean teleportLoadedPet(WorldServer world, EntityPlayerMP player, int petId, String petName, ICommandSender par1ICommandSender) {
        for (int j = 0; j < world.field_72996_f.size(); ++j) {
            Entity entity = (Entity)world.field_72996_f.get(j);
            if (!IMoCTameable.class.isAssignableFrom(entity.getClass()) || ((IMoCTameable)entity).getName().equals("") || ((IMoCTameable)entity).getOwnerPetId() != petId) continue;
            NBTTagCompound compound = new NBTTagCompound();
            entity.func_70109_d(compound);
            if (compound == null || compound.func_74779_i("Owner") == null) continue;
            String owner = compound.func_74779_i("Owner");
            String name = compound.func_74779_i("Name");
            if (owner == null || !owner.equalsIgnoreCase(player.func_70005_c_())) continue;
            if (entity.field_71093_bK == player.field_71093_bK) {
                entity.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            } else if (!player.field_70170_p.field_72995_K) {
                Entity newEntity = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)entity), (World)player.field_70170_p);
                if (newEntity != null) {
                    newEntity.func_82141_a(entity, true);
                    newEntity.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    DimensionManager.getWorld((int)player.field_71093_bK).func_72838_d(newEntity);
                }
                if (entity.field_70153_n == null) {
                    entity.field_70128_L = true;
                } else {
                    entity.field_70153_n.func_70078_a(null);
                    entity.field_70128_L = true;
                }
                world.func_82742_i();
                DimensionManager.getWorld((int)player.field_71093_bK).func_82742_i();
            }
            par1ICommandSender.func_145747_a((IChatComponent)new ChatComponentTranslation(EnumChatFormatting.GREEN + name + EnumChatFormatting.WHITE + " has been tp'd to location " + Math.round(player.field_70165_t) + ", " + Math.round(player.field_70163_u) + ", " + Math.round(player.field_70161_v) + " in dimension " + player.field_71093_bK, new Object[0]));
            return true;
        }
        return false;
    }

    public void sendCommandHelp(ICommandSender sender) {
        sender.func_145747_a((IChatComponent)new ChatComponentTranslation("\u00a72Listing MoCreatures commands", new Object[0]));
        for (int i = 0; i < commands.size(); ++i) {
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation(commands.get(i), new Object[0]));
        }
    }

    static {
        commands.add("/moctp <entityid> <playername>");
        commands.add("/moctp <petname> <playername>");
        aliases.add("moctp");
    }
}

