/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.turboasm;

import com.falsepattern.lib.turboasm.ClassNodeHandle;
import com.falsepattern.lib.turboasm.TurboClassTransformer;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class TransformerUtil {
    private static final boolean DEBUG_VERBOSE_TRANSFORMERS = Boolean.parseBoolean(System.getProperty("falsepatternlib.debug.verboseTransformers", "false"));
    private static final Logger LOG = LogManager.getLogger((String)"ASM");

    public static boolean executeTransformers(String transformedName, ClassNodeHandle handle, List<TurboClassTransformer> transformers) {
        boolean modified = false;
        for (TurboClassTransformer transformer : transformers) {
            try {
                if (!transformer.shouldTransformClass(transformedName, handle)) continue;
                if (DEBUG_VERBOSE_TRANSFORMERS) {
                    LOG.trace("Transforming {} with {}, owner: {}", new Object[]{transformedName, transformer.name(), transformer.owner()});
                }
                if (transformer.transformClass(transformedName, handle)) {
                    if (DEBUG_VERBOSE_TRANSFORMERS) {
                        LOG.trace("Transformed.");
                    }
                    modified = true;
                    continue;
                }
                if (!DEBUG_VERBOSE_TRANSFORMERS) continue;
                LOG.trace("No change.");
            }
            catch (Exception e) {
                LOG.error("Failed to transform class {} with {}, owner: {}", new Object[]{transformedName, transformer.name(), transformer.owner()});
                LOG.error("Exception stacktrace:", (Throwable)e);
            }
        }
        if (DEBUG_VERBOSE_TRANSFORMERS && modified) {
            LOG.trace("Transformed class {}", new Object[]{transformedName});
        }
        return modified;
    }
}

