/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.toasts;

import com.falsepattern.lib.internal.impl.toast.GuiToastImpl;
import com.falsepattern.lib.toasts.IToast;
import com.falsepattern.lib.toasts.icon.ToastBG;
import com.falsepattern.lib.toasts.icon.ToastIcon;
import com.falsepattern.lib.util.MathUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.IChatComponent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class SimpleToast
implements IToast {
    private final ToastBG background;
    private final ToastIcon icon;
    private final String title;
    private final String subtitle;
    private final boolean hasProgressBar;
    private final long timeout;
    private IToast.Visibility visibility = IToast.Visibility.SHOW;
    private long lastDelta;
    private float displayedProgress;
    private float currentProgress;

    public SimpleToast(@NonNull ToastBG background, @Nullable ToastIcon icon, IChatComponent titleComponent, @Nullable IChatComponent subtitleComponent, boolean drawProgressBar, long timeout) {
        if (background == null) {
            throw new NullPointerException("background is marked non-null but is null");
        }
        this.background = background;
        this.icon = icon;
        this.title = titleComponent.func_150254_d();
        this.subtitle = subtitleComponent == null ? null : subtitleComponent.func_150254_d();
        this.hasProgressBar = drawProgressBar;
        this.timeout = timeout;
    }

    @Override
    public IToast.Visibility draw(GuiToastImpl toastGui, long delta) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.background.draw(toastGui, 0, 0);
        if (this.icon != null) {
            this.icon.draw(toastGui, 6, 6);
        }
        int x = this.icon == null ? 5 : 5 + this.icon.getIcon().func_94211_a();
        int bgHeight = this.background.getIcon().func_94216_b();
        FontRenderer fontRenderer = toastGui.getMinecraft().field_71466_p;
        if (this.subtitle == null) {
            fontRenderer.func_78276_b(this.title, x, bgHeight / 2 - 5, -1);
        } else {
            fontRenderer.func_78276_b(this.title, x, 7, -1);
            fontRenderer.func_78276_b(this.subtitle, x, bgHeight - 14, -1);
        }
        if (this.hasProgressBar) {
            int bgWidth = this.background.getIcon().func_94211_a();
            Gui.func_73734_a((int)3, (int)(bgHeight - 4), (int)(bgWidth - 3), (int)(bgHeight - 3), (int)-1);
            float f = (float)MathUtil.clampedLerp(this.displayedProgress, this.currentProgress, (float)(delta - this.lastDelta) / 100.0f);
            int i = this.currentProgress >= this.displayedProgress ? -16755456 : -11206656;
            int barLength = bgWidth - 6;
            Gui.func_73734_a((int)3, (int)(bgHeight - 4), (int)((int)(3.0f + (float)barLength * f)), (int)(bgHeight - 3), (int)i);
            this.displayedProgress = f;
            this.lastDelta = delta;
        }
        if (this.timeout > 0L && delta >= this.timeout) {
            this.hide();
        }
        return this.visibility;
    }

    @Override
    public int width() {
        return this.background.getIcon().func_94211_a();
    }

    @Override
    public int height() {
        return this.background.getIcon().func_94216_b();
    }

    public void hide() {
        this.visibility = IToast.Visibility.HIDE;
    }

    public void setProgress(float progress) {
        this.currentProgress = progress;
    }
}

