/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.logging;

import com.falsepattern.lib.internal.FPLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.spi.LoggerContextFactory;

public class NotEnoughVerbosity {
    public static final Logger LOGGER = FPLog.LOG;

    public static void apply() {
        try {
            if (NotEnoughVerbosity.needsToRun()) {
                NotEnoughVerbosity.reconfigureLog4j();
            }
        }
        catch (Throwable t) {
            LOGGER.error("NotEnoughVerbosity failed to apply!", t);
        }
    }

    private static boolean needsToRun() {
        try {
            Class.forName("io.github.legacymoddingmc.notenoughverbosity.NotEnoughVerbosity");
            return false;
        }
        catch (Throwable throwable) {
            if (Launch.blackboard.containsKey("notenoughverbosity")) {
                return false;
            }
            boolean foundBadRoot = false;
            for (LoggerContext context : NotEnoughVerbosity.getLoggerContexts()) {
                LoggerConfig rootConfig = (LoggerConfig)context.getConfiguration().getLoggers().get("");
                if (rootConfig != null) {
                    if (rootConfig.getLevel().intLevel() < Level.ALL.intLevel()) {
                        LOGGER.warn(NotEnoughVerbosity.jvmdowngrader$concat$needsToRun$1(String.valueOf(rootConfig.getLevel())));
                        foundBadRoot = true;
                        break;
                    }
                    LOGGER.debug(NotEnoughVerbosity.jvmdowngrader$concat$needsToRun$2(String.valueOf(rootConfig.getLevel())));
                    continue;
                }
                throw new RuntimeException("Couldn't find root logger.");
            }
            if (!foundBadRoot) {
                LOGGER.debug("Root config seems fine, log4j will not be reconfigured.");
            }
            return foundBadRoot;
        }
    }

    public static void reconfigureLog4j() {
        URI log4jUri = NotEnoughVerbosity.findForgeLog4j();
        if (log4jUri != null) {
            LOGGER.info(NotEnoughVerbosity.jvmdowngrader$concat$reconfigureLog4j$1(String.valueOf(log4jUri)));
            LOGGER.info("New messages will go to fml-x-latest.log");
            String cookie = UUID.randomUUID().toString();
            LOGGER.info(NotEnoughVerbosity.jvmdowngrader$concat$reconfigureLog4j$2(cookie));
            NotEnoughVerbosity.setLog4jConfig(log4jUri);
            int count = NotEnoughVerbosity.getLoggerContexts().size();
            LOGGER.info(NotEnoughVerbosity.jvmdowngrader$concat$reconfigureLog4j$1(count, count != 1 ? "s" : "", String.valueOf(log4jUri)));
            LOGGER.info("Earlier messages may be located in latest.log");
            List<String> latestLogLines = NotEnoughVerbosity.readLatestLog(cookie);
            if (latestLogLines != null) {
                LOGGER.info(NotEnoughVerbosity.jvmdowngrader$concat$reconfigureLog4j$3(String.join((CharSequence)"\n", latestLogLines)));
            }
            Launch.blackboard.put("notenoughverbosity", "falsepatternlib");
        } else {
            LOGGER.warn("Could not find Forge's log4j2.xml on classpath, doing nothing");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> readLatestLog(String cookie) {
        File latestLog = new File(Launch.minecraftHome, "logs/latest.log");
        if (!latestLog.exists()) {
            LOGGER.debug(NotEnoughVerbosity.jvmdowngrader$concat$readLatestLog$1(latestLog.getAbsolutePath()));
            return null;
        }
        long lastModified = latestLog.lastModified();
        if (lastModified < System.currentTimeMillis() - 60000L) {
            LOGGER.debug(NotEnoughVerbosity.jvmdowngrader$concat$readLatestLog$1(latestLog.getAbsolutePath(), lastModified));
            return null;
        }
        try (FileInputStream is = new FileInputStream(latestLog);){
            List<String> lines = NotEnoughVerbosity.readLines(is);
            if (lines.stream().anyMatch(l -> l.contains(cookie))) {
                List<String> list = lines;
                return list;
            }
            LOGGER.debug(NotEnoughVerbosity.jvmdowngrader$concat$readLatestLog$2(latestLog.getAbsolutePath()));
            return null;
        }
        catch (IOException e) {
            LOGGER.error(NotEnoughVerbosity.jvmdowngrader$concat$readLatestLog$3(latestLog.getAbsolutePath()), (Throwable)e);
        }
        return null;
    }

    private static void setLog4jConfig(URI uri) {
        for (LoggerContext context : NotEnoughVerbosity.getLoggerContexts()) {
            context.setConfigLocation(uri);
            context.reconfigure();
        }
    }

    private static Collection<LoggerContext> getLoggerContexts() {
        LoggerContextFactory loggerContextFactory = LogManager.getFactory();
        if (loggerContextFactory instanceof Log4jContextFactory) {
            return ((Log4jContextFactory)loggerContextFactory).getSelector().getLoggerContexts();
        }
        throw new IllegalStateException("Logger context factory is not a Log4jContextFactory");
    }

    private static URI findForgeLog4j() {
        try {
            ArrayList<URL> candidates = Collections.list(NotEnoughVerbosity.class.getClassLoader().getResources("log4j2.xml"));
            LOGGER.info(NotEnoughVerbosity.jvmdowngrader$concat$findForgeLog4j$1(String.valueOf(candidates)));
            for (URL url : candidates) {
                try {
                    if (!NotEnoughVerbosity.readLines(url.openStream()).stream().anyMatch(l -> l.contains("Root level=\"all\""))) continue;
                    return url.toURI();
                }
                catch (Exception e) {
                    LOGGER.error(NotEnoughVerbosity.jvmdowngrader$concat$findForgeLog4j$2(String.valueOf(url)), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception enumerating logger configs", (Throwable)e);
        }
        return null;
    }

    private static List<String> readLines(InputStream stream) {
        return new BufferedReader(new InputStreamReader(stream)).lines().collect(Collectors.toList());
    }

    private static /* synthetic */ String jvmdowngrader$concat$needsToRun$1(String string) {
        return "Found root logger with verbosity " + string + ", will try to switch to Forge config.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$needsToRun$2(String string) {
        return "Found root logger with verbosity " + string + ", this is fine.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$reconfigureLog4j$1(String string) {
        return "Reconfiguring logger to use config at " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$reconfigureLog4j$2(String string) {
        return "Magic cookie: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$reconfigureLog4j$1(int n, String string, String string2) {
        return "Reconfigured logger (" + n + " context" + string + ") to use config at " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$reconfigureLog4j$3(String string) {
        return "Found earlier messages:\n-----Begin latest.log-----\n" + string + "\n-----End latest.log-----";
    }

    private static /* synthetic */ String jvmdowngrader$concat$readLatestLog$1(String string) {
        return "Couldn't find latest.log at " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$readLatestLog$1(String string, long l) {
        return "latest.log at " + string + " is too old (timestamp: " + l + ")";
    }

    private static /* synthetic */ String jvmdowngrader$concat$readLatestLog$2(String string) {
        return "Failed to find magic cookie in latest.log at " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$readLatestLog$3(String string) {
        return "Failed to read latest.log at " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$findForgeLog4j$1(String string) {
        return "Logger configs on classpath: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$findForgeLog4j$2(String string) {
        return "Failed to read inspect logger config at URL " + string;
    }
}

