/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.fields;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.ConfigException;
import com.falsepattern.lib.internal.impl.config.ConfigFieldParameters;
import com.falsepattern.lib.internal.impl.config.fields.AListConfigField;
import com.falsepattern.lib.internal.impl.config.fields.StringConfigField;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraftforge.common.config.Property;

public class StringListConfigField
extends AListConfigField<String[], Config.DefaultStringList> {
    private final Pattern pattern;
    private final int maxStringLength;

    public StringListConfigField(ConfigFieldParameters params) throws ConfigException {
        super(params, Property.Type.STRING, Config.DefaultStringList.class, Config.DefaultStringList::value, Property::setDefaultValues);
        this.pattern = Optional.ofNullable(this.field.getAnnotation(Config.Pattern.class)).map(ptr -> Pattern.compile(ptr.value())).orElse(null);
        this.maxStringLength = Optional.ofNullable(this.field.getAnnotation(Config.StringMaxLength.class)).map(Config.StringMaxLength::value).orElse(-1);
        Property property = this.getProperty();
        if (!property.isList()) {
            this.setToDefault();
        }
        property.comment = StringListConfigField.jvmdowngrader$concat$$init$$1(property.comment, StringConfigField.generateStringComment(this.maxStringLength, this.pattern, StringListConfigField.stringify((String[])this.defaultValue)));
    }

    private static String stringify(String[] arr) {
        StringBuilder result = new StringBuilder("[");
        if (arr.length > 0) {
            result.append('\"').append(arr[0]).append('\"');
            for (int i = 1; i < arr.length; ++i) {
                result.append(", \"").append(arr[i]).append('\"');
            }
        }
        return result.append(']').toString();
    }

    @Override
    protected int length(String[] arr) {
        return arr.length;
    }

    @Override
    protected String[] arrayCopy(String[] arr) {
        return Arrays.copyOf(arr, arr.length);
    }

    @Override
    protected void transmitElements(DataOutput output, String[] arr) throws IOException {
        for (String str : arr) {
            StringConfigField.transmitString(output, str);
        }
    }

    @Override
    protected void receiveElements(DataInput input, String[] arr) throws IOException {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = StringConfigField.receiveString(input, this.maxStringLength, this.field.getName(), this.field.getDeclaringClass().getName());
        }
    }

    @Override
    public boolean validateField() {
        if (!super.validateField()) {
            return false;
        }
        String[] strings = (String[])this.getField();
        boolean valid = true;
        for (int i = 0; i < strings.length; ++i) {
            String str = strings[i];
            if (StringConfigField.validateString(str, this.maxStringLength, this.pattern, this.field, i)) continue;
            valid = false;
        }
        return valid;
    }

    @Override
    protected String[] createArray(int length) {
        return new String[length];
    }

    @Override
    protected String[] getConfig() {
        return this.getProperty().getStringList();
    }

    @Override
    protected void putConfig(String[] value) {
        this.getProperty().set(value);
    }

    @Override
    protected String[] getDefault() {
        return Arrays.copyOf((String[])this.defaultValue, ((String[])this.defaultValue).length);
    }

    private static /* synthetic */ String jvmdowngrader$concat$$init$$1(String string, String string2) {
        return string + string2;
    }
}

