/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.asm.transformers;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.internal.impl.config.DeclOrderInternal;
import com.falsepattern.lib.turboasm.ClassNodeHandle;
import com.falsepattern.lib.turboasm.TurboClassTransformer;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class ConfigOrderTransformer
implements TurboClassTransformer {
    private static final String DESC_CONFIG = Type.getDescriptor(Config.class);
    private static final String DESC_CONFIG_IGNORE = Type.getDescriptor(Config.Ignore.class);
    private static final String DESC_ORDER = Type.getDescriptor(DeclOrderInternal.class);

    @Override
    public String name() {
        return "ConfigOrderTransformer";
    }

    @Override
    public String owner() {
        return "FalsePatternLib";
    }

    @Override
    public boolean shouldTransformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode cn = classNode.getNode();
        if (cn == null) {
            return false;
        }
        if (cn.visibleAnnotations != null) {
            for (AnnotationNode ann : cn.visibleAnnotations) {
                if (!DESC_CONFIG.equals(ann.desc)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean transformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode cn = classNode.getNode();
        if (cn == null) {
            return false;
        }
        int order = 0;
        boolean changed = false;
        block0: for (FieldNode field : cn.fields) {
            if ((field.access & 1) == 0 || (field.access & 8) == 0 || (field.access & 0x10) != 0) continue;
            if (field.visibleAnnotations != null) {
                for (AnnotationNode ann : field.visibleAnnotations) {
                    if (!DESC_CONFIG_IGNORE.equals(ann.desc)) continue;
                    continue block0;
                }
            }
            AnnotationVisitor annVisitor = field.visitAnnotation(DESC_ORDER, true);
            annVisitor.visit("value", (Object)order++);
            annVisitor.visitEnd();
            changed = true;
        }
        return changed;
    }
}

