/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.compat;

import com.falsepattern.lib.compat.BlockPos;
import javax.annotation.concurrent.Immutable;
import lombok.Generated;
import lombok.NonNull;
import net.minecraft.entity.Entity;

@Immutable
public class ChunkPos {
    public final int x;
    public final int z;

    public ChunkPos(@NonNull BlockPos blockPos) {
        if (blockPos == null) {
            throw new NullPointerException("blockPos is marked non-null but is null");
        }
        this.x = blockPos.getX() >> 4;
        this.z = blockPos.getZ() >> 4;
    }

    public static long asLong(int x, int z) {
        return (long)x & 0xFFFFFFFFL | ((long)z & 0xFFFFFFFFL) << 32;
    }

    public double getDistanceSq(@NonNull Entity entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        double dX = (double)((this.x << 4) + 8) - entity.field_70165_t;
        double dY = (double)((this.z << 4) + 8) - entity.field_70161_v;
        return dX * dX + dY * dY;
    }

    public int getXStart() {
        return this.x << 4;
    }

    public int getZStart() {
        return this.z << 4;
    }

    public int getXEnd() {
        return (this.x << 4) + 15;
    }

    public int getZEnd() {
        return (this.z << 4) + 15;
    }

    public BlockPos getBlock(int x, int y, int z) {
        return new BlockPos((this.x << 4) + x, y, (this.z << 4) + z);
    }

    public String toString() {
        return String.format("[%d, %d]", this.x, this.z);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChunkPos)) {
            return false;
        }
        ChunkPos other = (ChunkPos)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        return this.z == other.z;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChunkPos;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.x;
        result = result * 59 + this.z;
        return result;
    }

    @Generated
    public ChunkPos(int x, int z) {
        this.x = x;
        this.z = z;
    }
}

