/*
 * Decompiled with CFR 0.152.
 */
package net.vademdev.solarfluxreboot.gui;

import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.vademdev.solarfluxreboot.core.gui.GuiContainerBase;
import net.vademdev.solarfluxreboot.gui.ContainerSolarPanel;
import net.vademdev.solarfluxreboot.init.tileentity.TileEntitySolarPanel;
import org.lwjgl.opengl.GL11;

public class GuiSolarPanel
extends GuiContainerBase {
    private final ResourceLocation background = new ResourceLocation("SolarFluxReboot".toLowerCase(), "textures/gui/background.png");
    private final ResourceLocation elements = new ResourceLocation("SolarFluxReboot".toLowerCase(), "textures/gui/elements.png");
    private TileEntitySolarPanel solarPanel;
    private InventoryPlayer playerInventory;

    public GuiSolarPanel(TileEntitySolarPanel solarPanel, InventoryPlayer inventoryPlayer) {
        super(new ContainerSolarPanel(solarPanel, inventoryPlayer));
        this.solarPanel = solarPanel;
        this.playerInventory = inventoryPlayer;
        this.field_147000_g = 180;
    }

    protected void func_146979_b(int mX, int mY) {
        this.field_146289_q.func_78276_b(this.playerInventory.func_145818_k_() ? this.playerInventory.func_145825_b() : I18n.func_135052_a((String)this.playerInventory.func_145825_b(), (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        this.field_146289_q.func_78276_b(String.format("%s: %,d %s", "Generation", this.solarPanel.getCurrentEnergyGeneration(), "RF/T"), 8, 18, 0x404040);
        this.field_146289_q.func_78276_b(String.format("%s: %,d %s", "Transfer", this.solarPanel.getSolarTier().getEnergyTransfer(), "RF/T"), 8, 28, 0x404040);
    }

    protected void func_146976_a(float partialRenderTick, int mX, int mY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int oX = (this.field_146294_l - this.field_146999_f) / 2;
        int oY = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146297_k.func_110434_K().func_110577_a(this.background);
        this.func_73729_b(oX, oY, 0, 0, this.field_146999_f, this.field_147000_g);
        this.field_146297_k.func_110434_K().func_110577_a(this.elements);
        GL11.glDisable((int)2896);
        for (int i = 0; i < 5; ++i) {
            this.func_73729_b(oX + 17 + i * 18 - 1, oY + 59 - 1, 18, 0, 18, 18);
        }
        this.drawPowerGauge(oX + 150, oY + 12);
        this.drawSunIntencityGauge(oX + 150, oY + 61);
    }

    private void drawPowerGauge(int x, int y) {
        int energyStored = this.solarPanel.getEnergyStored();
        int maxEnergyStored = this.solarPanel.getSolarTier().getEnergyCapacity();
        this.func_73729_b(x, y, 16, 36, 14, 42);
        this.func_73729_b(x, y, 0, 36, 14, (int)(42L - (long)energyStored * 42L / (long)maxEnergyStored));
        this.addHoveringText(energyStored + " / " + maxEnergyStored + " RF", x, y, x + 14, y + 42);
    }

    private void drawSunIntencityGauge(int x, int y) {
        float dayAlpha = this.solarPanel.getSunIntensity();
        if ((double)dayAlpha <= 0.11) {
            this.func_73729_b(x, y, 33, 38, 14, 14);
        } else {
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)dayAlpha);
            this.func_73729_b(x, y, 49, 38, 14, 14);
            GL11.glPopMatrix();
        }
        this.addHoveringText("Sun Intencity: " + Math.round(dayAlpha * 100.0f) + "%", x, y, x + 14, y + 14);
    }
}

