/*
 * Decompiled with CFR 0.152.
 */
package net.vademdev.solarfluxreboot.gui;

import com.google.common.collect.Maps;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.vademdev.solarfluxreboot.init.tileentity.TileEntitySolarPanel;

public class ContainerSolarPanel
extends Container {
    private final Map<Integer, Integer> progressBarsValues = Maps.newHashMap();
    private TileEntitySolarPanel solarPanel;

    public ContainerSolarPanel(TileEntitySolarPanel solarPanel, InventoryPlayer inventoryPlayer) {
        this.solarPanel = solarPanel;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 98 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, k, 8 + k * 18, 156));
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.solarPanel.func_70300_a(player);
    }

    public void func_75142_b() {
        super.func_75142_b();
        boolean forceUpdate = this.solarPanel.func_145831_w().func_72820_D() % 40L == 0L;
        this.sendProgressBarUpdateIfChanged(0, this.solarPanel.getEnergyStored() & 0xFFFF, forceUpdate);
        this.sendProgressBarUpdateIfChanged(1, this.solarPanel.getEnergyStored() >>> 16, forceUpdate);
        this.sendProgressBarUpdateIfChanged(2, this.solarPanel.getCurrentEnergyGeneration() & 0xFFFF, false);
        this.sendProgressBarUpdateIfChanged(3, this.solarPanel.getCurrentEnergyGeneration() >>> 16, false);
        this.sendProgressBarUpdateIfChanged(4, (int)(100.0f * this.solarPanel.getSunIntensity()) & 0xFFFF, false);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int index, int value) {
        if (index == 0) {
            this.solarPanel.setEnergyStored(this.solarPanel.getEnergyStored() & 0xFFFF0000 | value);
        } else if (index == 1) {
            this.solarPanel.setEnergyStored(this.solarPanel.getEnergyStored() & 0xFFFF | value << 16);
        } else if (index == 2) {
            this.solarPanel.setCurrentEnergyGeneration(this.solarPanel.getCurrentEnergyGeneration() & 0xFFFF0000 | value);
        } else if (index == 3) {
            this.solarPanel.setCurrentEnergyGeneration(this.solarPanel.getCurrentEnergyGeneration() & 0xFFFF | value << 16);
        } else if (index == 4) {
            this.solarPanel.setSunIntensity((float)value / 100.0f);
        }
    }

    protected void sendProgressBarUpdateIfChanged(int type, int value, boolean force) {
        if (force || !this.progressBarsValues.containsKey(type) || !this.progressBarsValues.get(type).equals(value)) {
            for (ICrafting crafting : this.getCraftings()) {
                crafting.func_71112_a((Container)this, type, value);
            }
            this.progressBarsValues.put(type, value);
        }
    }

    protected List<ICrafting> getCraftings() {
        return this.field_75149_d;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (slotIndex < this.solarPanel.func_70302_i_() ? !this.func_75135_a(itemstack1, this.solarPanel.func_70302_i_(), this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, this.solarPanel.func_70302_i_(), false)) {
                return null;
            }
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }
}

