/*
 * Decompiled with CFR 0.152.
 */
package net.vademdev.solarfluxreboot.core.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;

public abstract class GuiContainerBase
extends GuiContainer {
    private List<HoveringText> hoveringTexts = new ArrayList<HoveringText>();

    public GuiContainerBase(Container container) {
        super(container);
    }

    public void func_73863_a(int mX, int mY, float opacity) {
        this.hoveringTexts.clear();
        super.func_73863_a(mX, mY, opacity);
        for (HoveringText hoveringText : this.hoveringTexts) {
            if (!hoveringText.canRender(mX, mY)) continue;
            this.drawHoveringText(Collections.singletonList(hoveringText.getText()), mX, mY, this.field_146289_q);
        }
    }

    protected void addHoveringText(String text, int xStart, int yStart, int xEnd, int yEnd) {
        this.hoveringTexts.add(new HoveringText(text, xStart, yStart, xEnd, yEnd));
    }

    protected boolean inBounds(int xStart, int yStart, int xEnd, int yEnd, int mX, int mY) {
        return mX <= xEnd && mX >= xStart && mY <= yEnd && mY >= yStart;
    }

    private class HoveringText {
        private int xStart;
        private int yStart;
        private int xEnd;
        private int yEnd;
        private String text;

        public HoveringText(String text, int xStart, int yStart, int xEnd, int yEnd) {
            this.xStart = xStart;
            this.yStart = yStart;
            this.xEnd = xEnd;
            this.yEnd = yEnd;
            this.text = text;
        }

        public boolean canRender(int mX, int mY) {
            return GuiContainerBase.this.inBounds(this.xStart, this.yStart, this.xEnd, this.yEnd, mX, mY);
        }

        public String getText() {
            return this.text;
        }
    }
}

