/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import com.enderio.core.api.client.render.IRenderFace;
import com.enderio.core.client.render.ConnectedTextureRenderer;
import com.enderio.core.client.render.CustomCubeRenderer;
import com.enderio.core.client.render.RenderUtil;
import com.gtnewhorizons.angelica.api.ThreadSafeISBRH;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.render.ConduitBundleRenderer;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.painter.PainterUtil;
import crazypants.enderio.machine.painter.TileEntityPaintedBlock;
import crazypants.enderio.material.BlockFusedQuartz;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

@ThreadSafeISBRH(perThread=false)
public class FusedQuartzRenderer
implements ISimpleBlockRenderingHandler {
    static int renderPass;
    private ConnectedTextureRenderer connectedTextureRenderer = new ConnectedTextureRenderer(){

        public boolean matchesMetadata(int meta1, int meta2) {
            return super.matchesMetadata(meta1, meta2) || BlockFusedQuartz.Type.byMeta(meta1).connectTo(meta2);
        }
    };

    public FusedQuartzRenderer() {
        this.connectedTextureRenderer.setMatchMeta(!Config.clearGlassConnectToFusedQuartz);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        renderer.func_147757_a(EnderIO.blockFusedQuartz.getItemIcon(metadata));
        renderer.func_147800_a(Blocks.field_150359_w, 0, 1.0f);
        renderer.func_147771_a();
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return BlockFusedQuartz.renderId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renderWorldBlock(IBlockAccess blockAccess, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int meta = blockAccess.func_72805_g(x, y, z);
        TileEntityPaintedBlock tecb = null;
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te instanceof TileEntityPaintedBlock) {
            tecb = (TileEntityPaintedBlock)te;
        }
        if (renderer.func_147744_b()) {
            renderer.func_147784_q(block, x, y, z);
        } else {
            IBlockAccess origBa = renderer.field_147845_a;
            renderer.field_147845_a = new ConduitBundleRenderer.FacadeAccessWrapper(origBa);
            try {
                this.renderFrame(renderer.field_147845_a, x, y, z, tecb, false, meta);
            }
            finally {
                renderer.field_147845_a = origBa;
            }
        }
        return true;
    }

    public void renderFrameItem(ItemStack stack) {
        RenderUtil.bindBlockTexture();
        Tessellator.field_78398_a.func_78382_b();
        TileEntityPaintedBlock tecb = new TileEntityPaintedBlock();
        tecb.setSourceBlock(PainterUtil.getSourceBlock(stack));
        tecb.setSourceBlockMetadata(PainterUtil.getSourceBlockMetadata(stack));
        this.renderFrame(null, 0, 0, 0, tecb, true, stack.func_77960_j());
        Tessellator.field_78398_a.func_78381_a();
    }

    private void renderFrame(IBlockAccess blockAccess, int x, int y, int z, TileEntityPaintedBlock tecb, boolean forceAllEdges, int meta) {
        if (blockAccess == null) {
            IIcon texture = EnderIO.blockFusedQuartz.getItemIcon(meta);
            for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
                if (tecb != null && tecb.getSourceBlock() != null) {
                    texture = tecb.getSourceBlock().func_149691_a(face.ordinal(), tecb.getSourceBlockMetadata());
                }
                RenderUtil.renderConnectedTextureFace((IBlockAccess)blockAccess, (Block)EnderIO.blockFusedQuartz, (int)x, (int)y, (int)z, (ForgeDirection)face, (IIcon)texture, (boolean)forceAllEdges);
            }
            return;
        }
        CustomCubeRenderer ccr = CustomCubeRenderer.get();
        ccr.setOverrideTexture(EnderIO.blockFusedQuartz.func_149691_a(0, meta));
        if (tecb != null && tecb.getSourceBlock() != null) {
            this.connectedTextureRenderer.setEdgeTexureCallback((ConnectedTextureRenderer.TextureCallback)new ConnectedTextureRenderer.DefaultTextureCallback(tecb.getSourceBlock(), tecb.getSourceBlockMetadata()));
            ccr.renderBlock(blockAccess, (Block)EnderIO.blockFusedQuartz, x, y, z, (IRenderFace)this.connectedTextureRenderer);
        } else {
            this.connectedTextureRenderer.setEdgeTexture(EnderIO.blockFusedQuartz.getDefaultFrameIcon(meta));
            ccr.renderBlock(blockAccess, (Block)EnderIO.blockFusedQuartz, x, y, z, (IRenderFace)this.connectedTextureRenderer);
        }
        ccr.setOverrideTexture(null);
    }
}

