/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel.server;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import crazypants.enderio.machine.invpanel.server.AbstractInventory;
import crazypants.enderio.machine.invpanel.server.InventoryDatabaseServer;
import crazypants.enderio.machine.invpanel.server.ItemEntry;
import net.minecraft.item.ItemStack;

public class DrawerGroupInventory
extends AbstractInventory {
    final IDrawerGroup dg;

    public DrawerGroupInventory(IDrawerGroup dg) {
        this.dg = dg;
    }

    @Override
    int scanInventory(InventoryDatabaseServer db) {
        int count = this.dg.getDrawerCount();
        if (count == 0) {
            this.setEmpty(db);
            return 0;
        }
        if (count != this.slotKeys.length) {
            this.reset(db, count);
        }
        for (int i = 0; i < count; ++i) {
            ItemStack stack;
            int quantity;
            IDrawer drawer = this.dg.getDrawer(i);
            if (drawer != null && (quantity = drawer.getStoredItemCount()) > 0 && (stack = drawer.getStoredItemPrototype()) != null && drawer.canItemBeExtracted(stack)) {
                this.updateSlot(db, i, stack, quantity);
                continue;
            }
            this.emptySlot(db, i);
        }
        return count;
    }

    @Override
    int extractItem(InventoryDatabaseServer db, ItemEntry entry, int slot, int count) {
        if (slot >= this.dg.getDrawerCount()) {
            return 0;
        }
        IDrawer drawer = this.dg.getDrawer(slot);
        if (drawer == null) {
            return 0;
        }
        int remaining = drawer.getStoredItemCount();
        if (remaining <= 0) {
            return 0;
        }
        ItemStack stack = drawer.getStoredItemPrototype();
        if (db.lookupItem(stack, entry, false) != entry) {
            return 0;
        }
        if (count > remaining) {
            count = remaining;
        }
        drawer.setStoredItemCount(remaining -= count);
        this.updateCount(db, slot, entry, remaining);
        return count;
    }
}

