/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

public class SlotDefinition {
    public final int minUpgradeSlot;
    public final int maxUpgradeSlot;
    public final int minInputSlot;
    public final int maxInputSlot;
    public final int minOutputSlot;
    public final int maxOutputSlot;

    public SlotDefinition(int numInputs, int numOutputs, int numUpgradeSlots) {
        this.minInputSlot = 0;
        this.maxInputSlot = numInputs - 1;
        this.minOutputSlot = numOutputs > 0 ? numInputs : -10;
        this.maxOutputSlot = this.minOutputSlot + (numOutputs - 1);
        this.minUpgradeSlot = numUpgradeSlots > 0 ? numInputs + numOutputs : -1;
        this.maxUpgradeSlot = this.minUpgradeSlot + (numUpgradeSlots - 1);
    }

    public SlotDefinition(int numInputs, int numOutputs) {
        this.minInputSlot = 0;
        this.maxInputSlot = numInputs - 1;
        this.minOutputSlot = numOutputs > 0 ? numInputs : -10;
        this.maxOutputSlot = this.minOutputSlot + (numOutputs - 1);
        this.maxUpgradeSlot = this.minUpgradeSlot = Math.max(this.maxInputSlot, this.maxOutputSlot) + 1;
    }

    public SlotDefinition(int minInputSlot, int maxInputSlot, int minOutputSlot, int maxOutputSlot, int minUpgradeSlot, int maxUpgradeSlot) {
        this.minInputSlot = minInputSlot;
        this.maxInputSlot = maxInputSlot;
        this.minOutputSlot = minOutputSlot;
        this.maxOutputSlot = maxOutputSlot;
        this.minUpgradeSlot = minUpgradeSlot;
        this.maxUpgradeSlot = maxUpgradeSlot;
    }

    public boolean isUpgradeSlot(int slot) {
        return slot >= this.minUpgradeSlot && slot <= this.maxUpgradeSlot;
    }

    public boolean isInputSlot(int slot) {
        return slot >= this.minInputSlot && slot <= this.maxInputSlot;
    }

    public boolean isOutputSlot(int slot) {
        return slot >= this.minOutputSlot && slot <= this.maxOutputSlot;
    }

    public int getNumUpgradeSlots() {
        if (this.minUpgradeSlot < 0) {
            return 0;
        }
        return Math.max(0, this.maxUpgradeSlot - this.minUpgradeSlot + 1);
    }

    public int getNumInputSlots() {
        if (this.minInputSlot < 0) {
            return 0;
        }
        return Math.max(0, this.maxInputSlot - this.minInputSlot + 1);
    }

    public int getNumOutputSlots() {
        if (this.minOutputSlot < 0) {
            return 0;
        }
        return Math.max(0, this.maxOutputSlot - this.minOutputSlot + 1);
    }

    public int getNumSlots() {
        return Math.max(Math.max(this.getMaxInputSlot(), this.getMaxOutputSlot()), this.getMaxUpgradeSlot()) + 1;
    }

    public int getMinUpgradeSlot() {
        return this.minUpgradeSlot;
    }

    public int getMaxUpgradeSlot() {
        return this.maxUpgradeSlot;
    }

    public int getMinInputSlot() {
        return this.minInputSlot;
    }

    public int getMaxInputSlot() {
        return this.maxInputSlot;
    }

    public int getMinOutputSlot() {
        return this.minOutputSlot;
    }

    public int getMaxOutputSlot() {
        return this.maxOutputSlot;
    }

    public String toString() {
        return "SlotDefinition [minUpgradeSlot=" + this.minUpgradeSlot + ", maxUpgradeSlot=" + this.maxUpgradeSlot + ", minInputSlot=" + this.minInputSlot + ", maxInputSlot=" + this.maxInputSlot + ", minOutputSlot=" + this.minOutputSlot + ", maxOutputSlot=" + this.maxOutputSlot + ", nunSlots=" + this.getNumSlots() + " ]";
    }
}

