/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.fluid;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.config.Config;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import org.apache.commons.lang3.StringUtils;

public class BlockFluidEio
extends BlockFluidClassic {
    protected Fluid fluid;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] icons;

    public static BlockFluidEio create(Fluid fluid, Material material) {
        BlockFluidEio res = new BlockFluidEio(fluid, material);
        res.init();
        fluid.setBlock((Block)res);
        return res;
    }

    protected BlockFluidEio(Fluid fluid, Material material) {
        super(fluid, material);
        this.fluid = fluid;
        this.func_149663_c(fluid.getUnlocalizedName());
    }

    protected void init() {
        GameRegistry.registerBlock((Block)this, (String)("block" + StringUtils.capitalize((String)this.fluidName)));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side != 0 && side != 1 ? this.icons[1] : this.icons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[]{iconRegister.func_94245_a("enderio:" + this.fluidName + "_still"), iconRegister.func_94245_a("enderio:" + this.fluidName + "_flow")};
        this.fluid.setIcons(this.icons[0], this.icons[1]);
    }

    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, x, y, z);
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, x, y, z);
    }

    public static class VapourOfLevity
    extends BlockFluidEio {
        private static final int[] COLORS = new int[]{819920, 9488620, 5338349, 864101, 4902126};

        protected VapourOfLevity(Fluid fluid, Material material, int fogColor) {
            super(fluid, material);
        }

        public void func_149670_a(World world, int x, int y, int z, Entity entity) {
            if (entity instanceof EntityPlayer || !world.field_72995_K && entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).field_70181_x += 0.1;
            }
            super.func_149670_a(world, x, y, z, entity);
        }

        public void func_149734_b(World world, int x, int y, int z, Random rand) {
            if (rand.nextFloat() < 0.5f) {
                int col = COLORS[rand.nextInt(COLORS.length)];
                world.func_72869_a("reddust", (double)x, (double)y, (double)z, (double)(col >> 16 & 0xFF) / 255.0, (double)(col >> 8 & 0xFF) / 255.0, (double)(col & 0xFF) / 255.0);
            }
        }
    }

    public static class CloudSeedConcentrated
    extends BlockFluidEio {
        protected CloudSeedConcentrated(Fluid fluid, Material material) {
            super(fluid, material);
        }

        public void func_149670_a(World world, int x, int y, int z, Entity entity) {
            if (!world.field_72995_K && entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 40, 0, true));
            }
            super.func_149670_a(world, x, y, z, entity);
        }
    }

    public static class NutrientDistillation
    extends BlockFluidEio {
        private static final String EIO_LAST_FOOD_BOOST = "eioLastFoodBoost";

        protected NutrientDistillation(Fluid fluid, Material material) {
            super(fluid, material);
        }

        public void func_149670_a(World world, int x, int y, int z, Entity entity) {
            if (!world.field_72995_K && entity instanceof EntityLivingBase) {
                long time = entity.field_70170_p.func_82737_E();
                EntityPlayerMP player = (EntityPlayerMP)entity;
                if (time % Config.nutrientFoodBoostDelay == 0L && player.getEntityData().func_74763_f(EIO_LAST_FOOD_BOOST) != time) {
                    player.func_71024_bL().func_75122_a(1, 0.1f);
                    player.getEntityData().func_74772_a(EIO_LAST_FOOD_BOOST, time);
                }
                super.func_149670_a(world, x, y, z, entity);
            }
        }
    }

    public static class RocketFuel
    extends BlockFluidEio {
        protected RocketFuel(Fluid fluid, Material material) {
            super(fluid, material);
        }

        public void func_149670_a(World world, int x, int y, int z, Entity entity) {
            if (!world.field_72995_K && entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 150, 3, true));
            }
            super.func_149670_a(world, x, y, z, entity);
        }

        public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
            return true;
        }

        public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
            return true;
        }

        public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
            return 1;
        }

        public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
            return 60;
        }
    }

    public static class Hootch
    extends BlockFluidEio {
        protected Hootch(Fluid fluid, Material material) {
            super(fluid, material);
        }

        public void func_149670_a(World world, int x, int y, int z, Entity entity) {
            if (!world.field_72995_K && entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 150, 0, true));
            }
            super.func_149670_a(world, x, y, z, entity);
        }

        public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
            return true;
        }

        public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
            return true;
        }

        public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
            return 1;
        }

        public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
            return 60;
        }
    }

    public static class FireWater
    extends BlockFluidEio {
        protected FireWater(Fluid fluid, Material material) {
            super(fluid, material);
        }

        public void func_149670_a(World world, int x, int y, int z, Entity entity) {
            if (!world.field_72995_K) {
                entity.func_70015_d(50);
                super.func_149670_a(world, x, y, z, entity);
            }
        }

        public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
            return true;
        }

        public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
            return true;
        }

        public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
            return 60;
        }
    }
}

