/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.comp;

import ic2.core.block.TileEntityBlock;
import ic2.core.block.comp.TileEntityComponent;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class Redstone
extends TileEntityComponent {
    private Iterable<IRedstoneModifier> modifiers;
    private int redstoneInput;

    public Redstone(TileEntityBlock parent) {
        super(parent);
    }

    @Override
    public String getDefaultName() {
        return "redstone";
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.update();
    }

    @Override
    public void onNeighborUpdate(Block srcBlock) {
        super.onNeighborUpdate(srcBlock);
        this.update();
    }

    public void update() {
        World world = this.parent.func_145831_w();
        if (world == null) {
            return;
        }
        int input = world.func_94572_D(this.parent.field_145851_c, this.parent.field_145848_d, this.parent.field_145849_e);
        if (this.modifiers != null) {
            for (IRedstoneModifier modifier : this.modifiers) {
                input = modifier.getRedstoneInput(input);
            }
        }
        this.redstoneInput = input;
    }

    public int getRedstoneInput() {
        return this.redstoneInput;
    }

    public boolean hasRedstoneInput() {
        return this.redstoneInput > 0;
    }

    public void setRedstoneModifier(Iterable<IRedstoneModifier> modifiers) {
        this.modifiers = modifiers;
        this.update();
    }

    public static interface IRedstoneModifier {
        public int getRedstoneInput(int var1);
    }
}

