/*
 * Decompiled with CFR 0.152.
 */
package portablejim.bbw.shims;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import portablejim.bbw.basics.Point3d;
import portablejim.bbw.shims.IWorldShim;

public class BasicWorldShim
implements IWorldShim {
    private final World world;

    public BasicWorldShim(World world) {
        this.world = world;
    }

    @Override
    public Block getBlock(Point3d point) {
        if (this.world != null) {
            return this.world.func_147439_a(point.x, point.y, point.z);
        }
        return null;
    }

    @Override
    public TileEntity getTile(Point3d point) {
        return this.world.func_147438_o(point.x, point.y, point.z);
    }

    @Override
    public boolean blockIsAir(Point3d point) {
        Block block = this.world.func_147439_a(point.x, point.y, point.z);
        return block.isAir((IBlockAccess)this.world, point.x, point.y, point.z);
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public boolean copyBlock(Point3d originalBlock, Point3d blockPos) {
        Block block = this.world.func_147439_a(originalBlock.x, originalBlock.y, originalBlock.z);
        int meta = this.world.func_72805_g(originalBlock.x, originalBlock.y, originalBlock.z);
        boolean retval = this.world.func_147465_d(blockPos.x, blockPos.y, blockPos.z, block, meta, 3);
        this.world.func_72921_c(blockPos.x, blockPos.y, blockPos.z, meta, 3);
        return retval;
    }

    @Override
    public void setBlockToAir(Point3d blockPos) {
        this.world.func_147449_b(blockPos.x, blockPos.y, blockPos.z, Blocks.field_150350_a);
    }

    @Override
    public int getMetadata(Point3d point) {
        if (this.world != null) {
            return this.world.func_72805_g(point.x, point.y, point.z);
        }
        return 0;
    }

    @Override
    public boolean entitiesInBox(AxisAlignedBB box) {
        if (box == null) {
            return false;
        }
        List entitiesWithinAABB = this.world.func_72872_a(EntityLivingBase.class, box);
        return !entitiesWithinAABB.isEmpty();
    }

    @Override
    public void playPlaceAtBlock(Point3d position, Block blockType) {
        if (position != null && blockType != null) {
            this.world.func_72908_a((double)position.x + 0.5, (double)position.y + 0.5, (double)position.z + 0.5, blockType.field_149762_H.func_150496_b(), (blockType.field_149762_H.func_150497_c() + 1.0f) / 2.0f, blockType.field_149762_H.func_150494_d() * 0.8f);
        }
    }

    @Override
    public boolean setBlock(Point3d originalPosition, Point3d position, Block block, int meta, boolean shouldCopyTileNBT) {
        boolean retVal = this.world.func_147465_d(position.x, position.y, position.z, block, meta, 3);
        if (shouldCopyTileNBT) {
            TileEntity oldTileEntity = this.getTile(originalPosition);
            TileEntity newTileEntity = this.getTile(position);
            if (oldTileEntity != null && newTileEntity != null) {
                NBTTagCompound nbt = new NBTTagCompound();
                oldTileEntity.func_145841_b(nbt);
                newTileEntity.func_145839_a(nbt);
                newTileEntity.field_145851_c = position.x;
                newTileEntity.field_145848_d = position.y;
                newTileEntity.field_145849_e = position.z;
            }
        }
        return retVal;
    }
}

