/*
 * Decompiled with CFR 0.152.
 */
package portablejim.bbw.shims;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.data.IAEItemStack;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.util.item.AEItemStack;
import com.glodblock.github.util.Util;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import portablejim.bbw.BetterBuildersWandsMod;
import portablejim.bbw.basics.Point3d;
import portablejim.bbw.core.MEHandler;
import portablejim.bbw.network.SynchronizeAEItemQuantity;
import portablejim.bbw.shims.IPlayerShim;
import vazkii.botania.api.item.IBlockProvider;

public class BasicPlayerShim
implements IPlayerShim {
    private final EntityPlayer player;
    private final boolean providersEnabled;
    private final boolean aeEnabled;
    private final boolean ae2fcEnabled;
    public static int AEItemSize = 0;

    public BasicPlayerShim(EntityPlayer player) {
        this.player = player;
        this.providersEnabled = BasicPlayerShim.areProvidersEnabled();
        this.aeEnabled = Loader.isModLoaded((String)"appliedenergistics2");
        this.ae2fcEnabled = Loader.isModLoaded((String)"ae2fc");
    }

    private static Block getBlock(ItemStack stack) {
        return Block.func_149634_a((Item)stack.func_77973_b());
    }

    private static int getBlockMeta(ItemStack stack) {
        return stack.func_77981_g() ? stack.func_77960_j() : 0;
    }

    private static boolean areProvidersEnabled() {
        try {
            boolean disable = new Object() instanceof IBlockProvider;
            return true;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    @Override
    public double getReach() {
        if (this.player instanceof EntityPlayerMP) {
            return ((EntityPlayerMP)this.player).field_71134_c.getBlockReachDistance();
        }
        return 5.0;
    }

    @Override
    public int countItems(ItemStack itemStack, boolean isNBTSensitive) {
        if (itemStack == null || this.player.field_71071_by == null || this.player.field_71071_by.field_70462_a == null) {
            return 0;
        }
        int total = 0;
        Block block = BasicPlayerShim.getBlock(itemStack);
        int meta = BasicPlayerShim.getBlockMeta(itemStack);
        for (ItemStack inventoryStack : this.player.field_71071_by.field_70462_a) {
            if (inventoryStack != null && itemStack.func_77969_a(inventoryStack) && (!isNBTSensitive || ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)inventoryStack))) {
                total += Math.max(0, inventoryStack.field_77994_a);
                continue;
            }
            if (!this.providersEnabled || inventoryStack == null || !(inventoryStack.func_77973_b() instanceof IBlockProvider)) continue;
            IBlockProvider prov = (IBlockProvider)inventoryStack.func_77973_b();
            int provCount = prov.getBlockCount(this.player, itemStack, inventoryStack, block, meta);
            if (provCount == -1) {
                return Integer.MAX_VALUE;
            }
            total += provCount;
        }
        if (this.aeEnabled) {
            total += this.getAEItem(itemStack, Integer.MAX_VALUE - total, false);
        }
        return itemStack.field_77994_a > 0 ? total / itemStack.field_77994_a : 0;
    }

    @Override
    public int useItem(ItemStack itemStack, boolean isNBTSensitive) {
        if (itemStack == null || this.player.field_71071_by == null || this.player.field_71071_by.field_70462_a == null) {
            return 0;
        }
        int toUse = 0;
        int needUse = itemStack.field_77994_a;
        ArrayList<ItemStack> providers = new ArrayList<ItemStack>();
        for (int i = this.player.field_71071_by.field_70462_a.length - 1; i >= 0; --i) {
            ItemStack inventoryStack = this.player.field_71071_by.field_70462_a[i];
            int need = needUse - toUse;
            if (inventoryStack != null && itemStack.func_77969_a(inventoryStack) && (!isNBTSensitive || ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)inventoryStack))) {
                if (inventoryStack.field_77994_a < need) {
                    toUse += inventoryStack.field_77994_a;
                    inventoryStack.field_77994_a = 0;
                } else {
                    inventoryStack.field_77994_a -= need;
                    toUse = needUse;
                }
                if (inventoryStack.field_77994_a == 0) {
                    this.player.field_71071_by.func_70299_a(i, null);
                }
                this.player.field_71069_bz.func_75142_b();
                if (toUse < needUse) continue;
                return needUse;
            }
            if (!this.providersEnabled || inventoryStack == null || !(inventoryStack.func_77973_b() instanceof IBlockProvider)) continue;
            providers.add(inventoryStack);
        }
        Block block = BasicPlayerShim.getBlock(itemStack);
        int meta = BasicPlayerShim.getBlockMeta(itemStack);
        if (!providers.isEmpty()) {
            IBlockProvider prov = (IBlockProvider)((ItemStack)providers.get(0)).func_77973_b();
            for (ItemStack provStack : providers) {
                assert (prov != null);
                int available = prov.getBlockCount(this.player, itemStack, provStack, block, meta);
                if (available == 0) continue;
                while (prov.provideBlock(this.player, itemStack, provStack, block, meta, true) && needUse > toUse) {
                    ++toUse;
                }
                this.player.field_71069_bz.func_75142_b();
            }
        }
        if (this.aeEnabled) {
            toUse += this.getAEItem(itemStack, needUse - toUse, true);
        }
        return toUse;
    }

    @Optional.Method(modid="appliedenergistics2")
    public int getAEItem(ItemStack item, int size, boolean MODULATE) {
        if (MODULATE) {
            WirelessTerminalGuiObject obj = MEHandler.getTerminalGuiObject(this.player);
            if (obj != null && (obj.rangeCheck() || this.ae2fcEnabled && Util.hasInfinityBoosterCard((ItemStack)obj.getItemStack())) && MEHandler.securityCheck(this.player, obj.getGrid(), SecurityPermissions.EXTRACT)) {
                IAEItemStack stack = obj.extractItems((IAEItemStack)AEItemStack.create((ItemStack)item).setStackSize((long)size), Actionable.MODULATE, (BaseActionSource)new PlayerSource(this.player, (IActionHost)obj));
                if (stack == null) {
                    return 0;
                }
                return (int)stack.getStackSize();
            }
        } else if (this.player.field_70170_p.field_72995_K) {
            if (MEHandler.hasTerminal(this.player)) {
                if (!LastItem.equls(item)) {
                    BetterBuildersWandsMod.instance.networkWrapper.sendToServer((IMessage)new SynchronizeAEItemQuantity.SyncServer(item));
                    LastItem.set(item);
                    return Math.min(AEItemSize, size);
                }
                if (this.player.field_70170_p.func_82737_E() % 10L == 0L) {
                    BetterBuildersWandsMod.instance.networkWrapper.sendToServer((IMessage)new SynchronizeAEItemQuantity.SyncServer(item));
                    return Math.min(AEItemSize, size);
                }
            } else {
                AEItemSize = 0;
            }
        }
        return Math.min(AEItemSize, size);
    }

    @Override
    public ItemStack getNextItem(Block block, int meta) {
        for (int i = this.player.field_71071_by.field_70462_a.length - 1; i >= 0; --i) {
            ItemStack itemStack = this.player.field_71071_by.field_70462_a[i];
        }
        return null;
    }

    @Override
    public Point3d getPlayerPosition() {
        return new Point3d((int)this.player.field_70165_t, (int)this.player.field_70163_u, (int)this.player.field_70161_v);
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Override
    public boolean isCreative() {
        return this.player.field_71075_bZ.field_75098_d;
    }

    private static class LastItem {
        private static Item item;
        private static int meta;
        private static NBTTagCompound nbt;

        private LastItem() {
        }

        public static boolean equls(ItemStack stack) {
            if (item != stack.func_77973_b()) {
                return false;
            }
            if (meta != stack.func_77960_j()) {
                return false;
            }
            return Objects.equals(nbt, stack.func_77978_p());
        }

        public static void set(ItemStack stack) {
            item = stack.func_77973_b();
            meta = stack.func_77960_j();
            nbt = stack.func_77978_p();
        }
    }
}

