/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.item.impl.mfr;

import com.gtnewhorizon.gtnhlib.item.AbstractInventoryIterator;
import com.gtnewhorizon.gtnhlib.item.ImmutableItemStack;
import com.gtnewhorizon.gtnhlib.util.ItemUtil;
import net.minecraft.item.ItemStack;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class DSUInventoryIterator
extends AbstractInventoryIterator {
    private static final int[] SLOTS = new int[]{0};
    public final IDeepStorageUnit dsu;

    public DSUInventoryIterator(IDeepStorageUnit dsu, int[] allowedSlots) {
        super(SLOTS, allowedSlots);
        this.dsu = dsu;
    }

    @Override
    protected ItemStack getStackInSlot(int slot) {
        if (slot != 0) {
            return null;
        }
        return ItemUtil.copy(this.dsu.getStoredItemType());
    }

    @Override
    public ItemStack extract(int amount, boolean forced) {
        ItemStack stored = this.dsu.getStoredItemType();
        if (stored == null) {
            return null;
        }
        int toExtract = Math.min(amount, stored.field_77994_a);
        this.dsu.setStoredItemCount(stored.field_77994_a - toExtract);
        return ItemUtil.copyAmount(toExtract, stored);
    }

    @Override
    public int insert(ImmutableItemStack stack, boolean forced) {
        ItemStack stored = this.dsu.getStoredItemType();
        if (stored != null && !stack.matches(stored)) {
            return stack.getStackSize();
        }
        int storedAmount = stored == null ? 0 : stored.field_77994_a;
        int toInsert = Math.min(stack.getStackSize(), this.dsu.getMaxStoredCount() - storedAmount);
        if (stored == null) {
            this.dsu.setStoredItemType(stack.toStack(1), 1);
        }
        this.dsu.setStoredItemCount(storedAmount + toInsert);
        return stack.getStackSize() - toInsert;
    }
}

