/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.postprocessing.shaders;

import com.gtnewhorizon.gtnhlib.ClientProxy;
import com.gtnewhorizon.gtnhlib.client.renderer.postprocessing.CustomFramebuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.postprocessing.PostProcessingHelper;
import com.gtnewhorizon.gtnhlib.client.renderer.postprocessing.SharedDepthFramebuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.postprocessing.shaders.PostProcessingRenderer;
import com.gtnewhorizon.gtnhlib.client.renderer.shader.ShaderProgram;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import org.lwjgl.opengl.GL20;

public class BloomShader
extends PostProcessingRenderer {
    private static BloomShader instance;
    private CustomFramebuffer[] framebuffers;
    private final ShaderProgram downscaleProgram = new ShaderProgram("gtnhlib", "shaders/bloom/downscale.vert.glsl", "shaders/bloom/downscale.frag.glsl");
    private final int uTexelSize_downscale = this.downscaleProgram.getUniformLocation("texelSize");
    private final ShaderProgram upscaleProgram = new ShaderProgram("gtnhlib", "shaders/bloom/upscale.vert.glsl", "shaders/bloom/upscale.frag.glsl");
    private final int uTexelSize_upscale = this.upscaleProgram.getUniformLocation("texelSize");
    private float multiplier;

    public BloomShader() {
        this.createFramebuffers();
    }

    private void createFramebuffers() {
        float width = ClientProxy.mc.field_71443_c;
        float height = ClientProxy.mc.field_71440_d;
        ArrayList<SharedDepthFramebuffer> framebufferList = new ArrayList<SharedDepthFramebuffer>();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        DisplayMode dm = gd.getDisplayMode();
        int screenWidth = dm.getWidth();
        int screenHeight = dm.getHeight();
        this.multiplier = 0.5f;
        if (width < (float)screenWidth || height < (float)screenHeight) {
            float widthMultiplier = width / (float)screenWidth;
            float heightMultiplier = height / (float)screenHeight;
            float avg = (float)Math.sqrt((widthMultiplier + heightMultiplier) / 2.0f);
            this.multiplier *= avg;
        }
        while (framebufferList.size() < 8 && width + height > 5.0f) {
            CustomFramebuffer framebuffer = framebufferList.isEmpty() ? new SharedDepthFramebuffer(Math.round(width), Math.round(height), 56) : new CustomFramebuffer(Math.round(width), Math.round(height), 56);
            framebufferList.add((SharedDepthFramebuffer)framebuffer);
            width /= 2.0f;
            height /= 2.0f;
        }
        this.framebuffers = framebufferList.toArray(new CustomFramebuffer[0]);
    }

    public static BloomShader getInstance() {
        if (instance == null) {
            instance = new BloomShader();
        }
        return instance;
    }

    public void bindFramebuffer() {
        CustomFramebuffer mainFramebuffer = this.framebuffers[0];
        if (ClientProxy.mc.field_71443_c != mainFramebuffer.framebufferWidth || ClientProxy.mc.field_71440_d != mainFramebuffer.framebufferHeight) {
            for (CustomFramebuffer framebuffer : this.framebuffers) {
                framebuffer.checkDeleteFramebuffer();
            }
            this.createFramebuffers();
            mainFramebuffer = this.framebuffers[0];
        }
        this.needsRendering = true;
        mainFramebuffer.bindFramebuffer();
    }

    @Override
    public void render(float partialTicks) {
        CustomFramebuffer framebuffer;
        int i;
        PostProcessingHelper.setupPostProcessingGL();
        CustomFramebuffer mainFramebuffer = this.framebuffers[0];
        mainFramebuffer.bindFramebuffer();
        mainFramebuffer.bindFramebufferTexture();
        this.downscaleProgram.use();
        for (i = 1; i < this.framebuffers.length; ++i) {
            framebuffer = this.framebuffers[i];
            framebuffer.clearBindFramebuffer(true);
            GL20.glUniform2f((int)this.uTexelSize_downscale, (float)(1.0f / (float)framebuffer.framebufferWidth), (float)(1.0f / (float)framebuffer.framebufferHeight));
            PostProcessingHelper.drawFullscreenQuad();
            framebuffer.bindFramebufferTexture();
        }
        this.upscaleProgram.use();
        for (i = this.framebuffers.length - 1; i >= 1; --i) {
            framebuffer = this.framebuffers[i];
            CustomFramebuffer upscaledFramebuffer = this.framebuffers[i - 1];
            framebuffer.bindFramebufferTexture();
            upscaledFramebuffer.bindFramebuffer(true);
            GL20.glUniform2f((int)this.uTexelSize_upscale, (float)(1.0f / (float)framebuffer.framebufferWidth), (float)(1.0f / (float)framebuffer.framebufferHeight));
            PostProcessingHelper.drawFullscreenQuad();
        }
        ClientProxy.mc.func_147110_a().func_147610_a(false);
        mainFramebuffer.applyTonemapping(this.multiplier);
        mainFramebuffer.clearBindFramebuffer();
        ClientProxy.mc.func_147110_a().func_147610_a(false);
        ShaderProgram.clear();
        PostProcessingHelper.clearPostProcessingGL();
    }
}

