/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad;

import com.gtnewhorizon.gtnhlib.client.renderer.CapturingTessellator;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuadViewMutable;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.properties.ModelQuadFacing;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.util.ModelQuadUtil;
import org.jetbrains.annotations.ApiStatus;

public class ModelQuad
implements ModelQuadViewMutable {
    private final int[] data = new int[32];
    private int flags;
    private int normal;
    private Object sprite;
    private int colorIdx;
    private ModelQuadFacing direction;
    private boolean hasAmbientOcclusion = true;
    private int shaderBlockId;

    @Override
    public void setX(int idx, float x) {
        this.data[ModelQuadUtil.vertexOffset((int)idx) + 0] = Float.floatToRawIntBits(x);
        this.normal = 0;
    }

    @Override
    public void setY(int idx, float y) {
        this.data[ModelQuadUtil.vertexOffset((int)idx) + 0 + 1] = Float.floatToRawIntBits(y);
        this.normal = 0;
    }

    @Override
    public void setZ(int idx, float z) {
        this.data[ModelQuadUtil.vertexOffset((int)idx) + 0 + 2] = Float.floatToRawIntBits(z);
        this.normal = 0;
    }

    @Override
    public void setColor(int idx, int color) {
        this.data[ModelQuadUtil.vertexOffset((int)idx) + 5] = color;
    }

    @Override
    public void setTexU(int idx, float u) {
        this.data[ModelQuadUtil.vertexOffset((int)idx) + 3] = Float.floatToRawIntBits(u);
    }

    @Override
    public void setTexV(int idx, float v) {
        this.data[ModelQuadUtil.vertexOffset((int)idx) + 3 + 1] = Float.floatToRawIntBits(v);
    }

    @Override
    public void setLight(int idx, int light) {
        this.data[ModelQuadUtil.vertexOffset((int)idx) + 7] = light;
    }

    @Override
    public void setFlags(int flags) {
        this.flags = flags;
    }

    @Override
    public void setSprite(Object sprite) {
        this.sprite = sprite;
    }

    @Override
    public void setColorIndex(int index) {
        this.colorIdx = index;
    }

    @Override
    public void setLightFace(ModelQuadFacing face) {
        if (!face.isDirection()) {
            throw new IllegalArgumentException();
        }
        this.direction = face;
    }

    @Override
    public void setHasAmbientOcclusion(boolean hasAmbientOcclusion) {
        this.hasAmbientOcclusion = hasAmbientOcclusion;
    }

    @Override
    public void setForgeNormal(int idx, int normal) {
        this.data[ModelQuadUtil.vertexOffset((int)idx) + 6] = normal;
    }

    @Override
    public void setShaderBlockId(int shaderBlockId) {
        this.shaderBlockId = shaderBlockId;
    }

    @Override
    public int getColorIndex() {
        return this.colorIdx;
    }

    @Override
    public float getX(int idx) {
        return Float.intBitsToFloat(this.data[ModelQuadUtil.vertexOffset(idx) + 0]);
    }

    @Override
    public float getY(int idx) {
        return Float.intBitsToFloat(this.data[ModelQuadUtil.vertexOffset(idx) + 0 + 1]);
    }

    @Override
    public float getZ(int idx) {
        return Float.intBitsToFloat(this.data[ModelQuadUtil.vertexOffset(idx) + 0 + 2]);
    }

    @Override
    public int getColor(int idx) {
        return this.data[ModelQuadUtil.vertexOffset(idx) + 5];
    }

    @Override
    public float getTexU(int idx) {
        return Float.intBitsToFloat(this.data[ModelQuadUtil.vertexOffset(idx) + 3]);
    }

    @Override
    public float getTexV(int idx) {
        return Float.intBitsToFloat(this.data[ModelQuadUtil.vertexOffset(idx) + 3 + 1]);
    }

    @Override
    public int getLight(int idx) {
        return this.data[ModelQuadUtil.vertexOffset(idx) + 7];
    }

    @Override
    public int getForgeNormal(int idx) {
        return this.data[ModelQuadUtil.vertexOffset(idx) + 6];
    }

    @Override
    public int getComputedFaceNormal() {
        int n = this.normal;
        if (n == 0) {
            this.normal = n = ModelQuadUtil.calculateNormal(this);
        }
        return n;
    }

    @Override
    public ModelQuadFacing getNormalFace() {
        return ModelQuadUtil.findNormalFace(this.getComputedFaceNormal());
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public Object celeritas$getSprite() {
        return this.sprite;
    }

    @Override
    public ModelQuadFacing getLightFace() {
        return this.direction;
    }

    @Override
    public boolean hasAmbientOcclusion() {
        return this.hasAmbientOcclusion;
    }

    @Override
    public int getShaderBlockId() {
        return this.shaderBlockId;
    }

    @ApiStatus.Internal
    public void setState(int[] rawBuffer, int srcOffset, CapturingTessellator.Flags flags, int drawMode, int offsetX, int offsetY, int offsetZ) {
        System.arraycopy(rawBuffer, srcOffset, this.data, 0, this.data.length);
        if (!flags.hasColor) {
            this.clearColors();
        }
        if (!flags.hasNormals) {
            this.clearNormals();
        }
        if (!flags.hasBrightness) {
            this.clearLightmap();
        }
        this.setHasAmbientOcclusion(flags.hasBrightness);
        this.offsetPos(0, offsetX);
        this.offsetPos(1, offsetY);
        this.offsetPos(2, offsetZ);
        if (drawMode == 4) {
            this.quadrangulate();
        }
        this.setLightFace(ModelQuadUtil.findLightFace(this.getComputedFaceNormal()));
    }

    private void quadrangulate() {
        System.arraycopy(this.data, ModelQuadUtil.vertexOffset(2), this.data, ModelQuadUtil.vertexOffset(3), 8);
    }

    private void offsetPos(int idx, float offset) {
        int i = 0 + idx;
        this.setData(0, i, this.getData(0, i) + offset);
        this.setData(1, i, this.getData(1, i) + offset);
        this.setData(2, i, this.getData(2, i) + offset);
        this.setData(3, i, this.getData(3, i) + offset);
    }

    private float getData(int vi, int i) {
        return Float.intBitsToFloat(this.data[ModelQuadUtil.vertexOffset(vi) + i]);
    }

    private void setData(int vi, int i, float val) {
        this.data[ModelQuadUtil.vertexOffset((int)vi) + i] = Float.floatToIntBits(val);
    }

    private void clearColors() {
        this.setColor(0, -1);
        this.setColor(1, -1);
        this.setColor(2, -1);
        this.setColor(3, -1);
    }

    private void clearNormals() {
        this.normal = 0;
        this.data[ModelQuadUtil.vertexOffset((int)0) + 6] = 0;
        this.data[ModelQuadUtil.vertexOffset((int)1) + 6] = 0;
        this.data[ModelQuadUtil.vertexOffset((int)2) + 6] = 0;
        this.data[ModelQuadUtil.vertexOffset((int)3) + 6] = 0;
    }

    private void clearLightmap() {
        this.setLight(0, 0xF000F0);
        this.setLight(0, 0xF000F0);
        this.setLight(0, 0xF000F0);
        this.setLight(0, 0xF000F0);
    }
}

