/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.core.util.fluid.FluidTankAdv;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.core.UtilInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiBlockSmasher;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerBlockSmasher;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;
import powercrystals.minefactoryreloaded.world.SmashingWorld;

public class TileEntityBlockSmasher
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    public static final int MAX_FORTUNE = 3;
    private int _fortune = 0;
    private ItemStack _lastInput;
    private List<ItemStack> _lastOutput;
    private SmashingWorld _smashingWorld;
    private boolean _shouldWork = true;

    public TileEntityBlockSmasher() {
        super(Machine.BlockSmasher);
        this.setManageSolids(true);
        this._tanks[0].setLock(FluidRegistry.getFluid((String)"mobessence"));
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        this._smashingWorld = new SmashingWorld(this.field_145850_b);
    }

    public int func_70302_i_() {
        return 2;
    }

    @Override
    public ContainerBlockSmasher getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerBlockSmasher(this, inventoryPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiBlockSmasher(this.getContainer(inventoryPlayer), this);
    }

    @Override
    protected boolean activateMachine() {
        if (this._shouldWork && this._inventory[0] == null) {
            this.setWorkDone(0);
            return false;
        }
        if (!(this._inventory[0] == null || this._lastInput != null && UtilInventory.stacksEqual(this._lastInput, this._inventory[0]))) {
            this._lastInput = this._inventory[0].func_77946_l();
            this._lastOutput = this.getOutput(this._lastInput);
        }
        if (this._lastOutput == null) {
            this.setWorkDone(0);
            return false;
        }
        if (this._shouldWork && this._fortune > 0 && this.drain(this._tanks[0], this._fortune, false) != this._fortune) {
            return false;
        }
        ItemStack itemStack = this._inventory[1];
        ItemStack itemStack2 = TileEntityBlockSmasher.getEqualStack(itemStack, this._lastOutput);
        if (itemStack2 == null) {
            if (this._shouldWork) {
                this.setWorkDone(0);
            }
            return false;
        }
        if (itemStack != null && itemStack.func_77976_d() - itemStack.field_77994_a < itemStack2.field_77994_a) {
            return false;
        }
        if (this.getWorkDone() >= this.getWorkMax()) {
            if (this._shouldWork) {
                --this._inventory[0].field_77994_a;
                if (this._inventory[0].field_77994_a == 0) {
                    this._inventory[0] = null;
                }
            }
            this._shouldWork = false;
            if (this._inventory[1] == null) {
                this._inventory[1] = itemStack2.func_77946_l();
            } else {
                this._inventory[1].field_77994_a += itemStack2.field_77994_a;
            }
            this._lastOutput.remove(itemStack2);
            if (this._lastOutput.size() == 0) {
                this.setWorkDone(0);
                this._shouldWork = true;
                this._lastInput = null;
                this._lastOutput = null;
            }
        } else {
            if (!this.incrementWorkDone()) {
                return false;
            }
            this.drain(this._tanks[0], this._fortune, true);
        }
        return true;
    }

    private static ItemStack getEqualStack(ItemStack itemStack, List<ItemStack> list) {
        if (itemStack != null & list != null && itemStack.field_77994_a > 0 && list.size() > 0) {
            for (ItemStack itemStack2 : list) {
                if (!UtilInventory.stacksEqual(itemStack, itemStack2)) continue;
                return itemStack2;
            }
        }
        return itemStack == null && list.size() > 0 ? list.get(0) : null;
    }

    private List<ItemStack> getOutput(ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ItemBlock)) {
            return null;
        }
        ItemBlock itemBlock = (ItemBlock)itemStack.func_77973_b();
        Block block = itemBlock.field_150939_a;
        if (block == null) {
            return null;
        }
        ArrayList<ItemStack> arrayList = this._smashingWorld.smashBlock(itemStack, block, itemBlock.func_77647_b(itemStack.func_77960_j()), this._fortune);
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList;
        }
        return null;
    }

    public int getFortune() {
        return this._fortune;
    }

    public void setFortune(int n) {
        if (n >= 0 && n <= 3) {
            if (this._fortune < n) {
                this.setWorkDone(0);
            }
            this._fortune = n;
        }
    }

    @Override
    public int getWorkMax() {
        return 60;
    }

    @Override
    public int getIdleTicksMax() {
        return 1;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return n == 0;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return n == 1;
    }

    @Override
    public boolean allowBucketFill(ItemStack itemStack) {
        return true;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return this.fill(fluidStack, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return this.drain(n, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return this.drain(fluidStack, bl);
    }

    @Override
    protected FluidTankAdv[] createTanks() {
        return new FluidTankAdv[]{new FluidTankAdv(4000)};
    }

    @Override
    public void writePortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74768_a("fortune", this._fortune);
    }

    @Override
    public void readPortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        this.setFortune(nBTTagCompound.func_74762_e("fortune"));
    }

    @Override
    public void writeItemNBT(NBTTagCompound nBTTagCompound) {
        super.writeItemNBT(nBTTagCompound);
        if (this._fortune > 0) {
            nBTTagCompound.func_74768_a("fortune", this._fortune);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("shouldWork", this._shouldWork);
        if (this._lastInput != null) {
            nBTTagCompound.func_74782_a("stack", (NBTBase)this._lastInput.func_77955_b(new NBTTagCompound()));
        }
        if (this._lastOutput != null) {
            NBTTagList nBTTagList = new NBTTagList();
            for (ItemStack itemStack : this._lastOutput) {
                NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
                itemStack.func_77955_b(nBTTagCompound2);
                nBTTagList.func_74742_a((NBTBase)nBTTagCompound2);
            }
            nBTTagCompound.func_74782_a("SmashedItems", (NBTBase)nBTTagList);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this._fortune = nBTTagCompound.func_74762_e("fortune");
        boolean bl = this._shouldWork = nBTTagCompound.func_74764_b("shouldWork") ? nBTTagCompound.func_74767_n("shouldWork") : true;
        if (nBTTagCompound.func_74764_b("stack")) {
            this._lastInput = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound.func_74775_l("stack"));
        }
        if (nBTTagCompound.func_74764_b("SmashedItems")) {
            ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
            NBTTagList nBTTagList = nBTTagCompound.func_150295_c("SmashedItems", 10);
            int n = nBTTagList.func_74745_c();
            while (n-- > 0) {
                NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(n);
                ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound2);
                if (itemStack == null || itemStack.field_77994_a <= 0) continue;
                arrayList.add(itemStack);
            }
            if (arrayList.size() != 0) {
                this._lastOutput = arrayList;
            }
        }
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }
}

