/*
 * Decompiled with CFR 0.152.
 */
package tehnut.resourceful.crops.api.registry;

import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import tehnut.resourceful.crops.api.ResourcefulAPI;
import tehnut.resourceful.crops.api.base.Seed;
import tehnut.resourceful.crops.api.util.cache.PermanentCache;

public class SeedRegistry {
    public static GsonBuilder seedBuilder;
    public static ArrayList<Seed> seedList;
    public static int badSeeds;

    public static void registerSeed(Seed seed) {
        SeedRegistry.registerSeed(seed, seed.getName());
    }

    public static void registerSeed(Seed seed, String name) {
        try {
            ResourcefulAPI.seedCache.addObject(seed, name);
        }
        catch (IllegalArgumentException e) {
            if (ResourcefulAPI.forceAddDuplicates) {
                ResourcefulAPI.logger.error("Seed { " + name + " } has been registered twice. Force adding the copy.");
                ResourcefulAPI.seedCache.addObject(seed, name + badSeeds);
            } else {
                ResourcefulAPI.logger.error("Seed { " + name + " } has been registered twice. Skipping the copy and continuing.");
            }
            ++badSeeds;
        }
    }

    public static Seed getSeed(int index) {
        return (Seed)ResourcefulAPI.seedCache.getObject(index);
    }

    public static Seed getSeed(String name) {
        return (Seed)ResourcefulAPI.seedCache.getObject(name);
    }

    public static int getIndexOf(Seed seed) {
        return ResourcefulAPI.seedCache.getID(seed);
    }

    public static int getIndexOf(String name) {
        return ResourcefulAPI.seedCache.getID(SeedRegistry.getSeed(name));
    }

    public static String getNameOf(Seed seed) {
        return ResourcefulAPI.seedCache.getName(seed);
    }

    public static int getSize() {
        return SeedRegistry.getSeedList().size();
    }

    public static boolean isEmpty() {
        return SeedRegistry.getSeedList().isEmpty();
    }

    public static List<Seed> getSeedList() {
        return new ArrayList<Seed>(seedList);
    }

    public static void setSeedList(ArrayList<Seed> list) {
        seedList = list;
    }

    public static ItemStack getItemStackForSeed(Seed seed) {
        return new ItemStack(ResourcefulAPI.seed, 1, SeedRegistry.getIndexOf(seed));
    }

    public static void dump() {
        ResourcefulAPI.seedCache = new PermanentCache("ResourcefulCropsCache");
    }

    static {
        badSeeds = 0;
    }
}

