/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.renderers.blocks;

import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.init.Blocks;
import com.InfinityRaider.AgriCraft.renderers.blocks.RenderBlockBase;
import com.InfinityRaider.AgriCraft.renderers.models.ModelSeedAnalyzer;
import com.InfinityRaider.AgriCraft.renderers.models.ModelSeedAnalyzerBook;
import com.InfinityRaider.AgriCraft.tileentity.TileEntitySeedAnalyzer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderSeedAnalyzer
extends RenderBlockBase {
    private ResourceLocation texture = new ResourceLocation("AgriCraft".toLowerCase() + ":textures/blocks/seedAnalyzer.png");
    private ResourceLocation bookTexture = new ResourceLocation("AgriCraft".toLowerCase() + ":textures/blocks/seedAnalyzerBook.png");
    private final ModelSeedAnalyzer modelSeedAnalyzer = new ModelSeedAnalyzer();
    private final ModelSeedAnalyzerBook modelBook = new ModelSeedAnalyzerBook();
    private TileEntitySeedAnalyzer seedAnalyzerDummy = new TileEntitySeedAnalyzer();

    public RenderSeedAnalyzer() {
        super(Blocks.blockSeedAnalyzer, new TileEntitySeedAnalyzer(), true);
        this.seedAnalyzerDummy.setOrientation(ForgeDirection.SOUTH);
    }

    @Override
    protected void doInventoryRender(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.doWorldRender(Tessellator.field_78398_a, (IBlockAccess)Minecraft.func_71410_x().field_71441_e, 0.0, 0.0, 0.0, this.seedAnalyzerDummy, Blocks.blockSeedAnalyzer, 0.0f, 0, RenderBlocks.getInstance(), false);
    }

    @Override
    protected boolean doWorldRender(Tessellator tessellator, IBlockAccess world, double x, double y, double z, TileEntity tile, Block block, float f, int modelId, RenderBlocks renderer, boolean callFromTESR) {
        if (tile == null || !(tile instanceof TileEntitySeedAnalyzer)) {
            return false;
        }
        TileEntitySeedAnalyzer analyzer = (TileEntitySeedAnalyzer)tile;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)1.5f, (float)0.5f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.modelSeedAnalyzer.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        if (analyzer.hasJournal() && ConfigurationHandler.renderBookInAnalyzer) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.bookTexture);
            this.modelBook.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        }
        GL11.glPopMatrix();
        if (analyzer.hasSeed() || analyzer.hasTrowel()) {
            this.renderSeed(analyzer);
        }
        return false;
    }

    private void renderSeed(TileEntitySeedAnalyzer analyzer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        ItemStack stack = analyzer.func_70301_a(36);
        IIcon icon = stack.func_77973_b().func_77617_a(stack.func_77960_j());
        if (icon == null) {
            return;
        }
        float angle = (float)(720.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.5, (double)0.25, (double)0.5);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)0.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)icon.func_94209_e(), (float)icon.func_94206_g(), (float)icon.func_94212_f(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
        GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(-angle), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        GL11.glPopMatrix();
    }

    @Override
    public boolean shouldBehaveAsTESR() {
        return true;
    }

    @Override
    public boolean shouldBehaveAsISBRH() {
        return false;
    }
}

