/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.init;

import com.InfinityRaider.AgriCraft.api.v1.BlockWithMeta;
import com.InfinityRaider.AgriCraft.api.v1.RenderMethod;
import com.InfinityRaider.AgriCraft.api.v1.RequirementType;
import com.InfinityRaider.AgriCraft.blocks.BlockModPlant;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.items.ItemModSeed;
import com.InfinityRaider.AgriCraft.utility.IOHelper;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;

public class CustomCrops {
    public static BlockModPlant[] customCrops;
    public static ItemModSeed[] customSeeds;

    public static void init() {
        if (ConfigurationHandler.customCrops) {
            String[] cropsRawData = IOHelper.getLinesArrayFromData(ConfigurationHandler.readCustomCrops());
            customCrops = new BlockModPlant[cropsRawData.length];
            customSeeds = new ItemModSeed[cropsRawData.length];
            for (int i = 0; i < cropsRawData.length; ++i) {
                String[] cropData = IOHelper.getData(cropsRawData[i]);
                boolean success = cropData.length == 7 || cropData.length == 8;
                String errorMsg = "Incorrect amount of arguments, arguments should be: (name, fruit:fruitMeta, soil, baseBlock:baseBlockMeta, tier, renderType, information, shearable (optional) )";
                LogHelper.debug(new StringBuffer("parsing ").append(cropsRawData[i]));
                if (success) {
                    ItemStack fruitStack = IOHelper.getStack(cropData[1], false);
                    errorMsg = "Invalid fruit";
                    boolean bl = success = fruitStack != null && fruitStack.func_77973_b() != null || cropData[1].equals("null");
                    if (success) {
                        String name = cropData[0];
                        BlockWithMeta soil = IOHelper.getBlock(cropData[2]);
                        BlockWithMeta base = IOHelper.getBlock(cropData[3]);
                        int tier = Integer.parseInt(cropData[4]);
                        RenderMethod renderType = RenderMethod.getRenderMethod(Integer.parseInt(cropData[5]));
                        ItemStack shearable = cropData.length > 7 ? IOHelper.getStack(cropData[7], false) : null;
                        shearable = shearable != null && shearable.func_77973_b() != null ? shearable : null;
                        String info = cropData[6];
                        try {
                            CustomCrops.customCrops[i] = new BlockModPlant(new Object[]{name, fruitStack, soil, RequirementType.BELOW, base, tier, renderType, shearable});
                        }
                        catch (Exception e) {
                            if (!ConfigurationHandler.debug) break;
                            LogHelper.printStackTrace(e);
                            break;
                        }
                        CustomCrops.customSeeds[i] = customCrops[i].getSeed();
                        LanguageRegistry.addName((Object)customCrops[i], (String)(Character.toUpperCase(name.charAt(0)) + name.substring(1)));
                        LanguageRegistry.addName((Object)customSeeds[i], (String)(Character.toUpperCase(name.charAt(0)) + name.substring(1) + " Seeds"));
                        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                            customSeeds[i].setInformation(info);
                        }
                    }
                }
                if (success) continue;
                LogHelper.info(new StringBuffer("Error when adding custom crop: ").append(errorMsg).append(" (line: ").append(cropsRawData[i]).append(")"));
            }
            LogHelper.info("Custom crops registered");
        }
    }

    public static void initGrassSeeds() {
        String[] rawData;
        if (ConfigurationHandler.wipeTallGrassDrops) {
            List seedList = null;
            boolean error = false;
            try {
                Field fieldSeedList = ForgeHooks.class.getDeclaredField("seedList");
                fieldSeedList.setAccessible(true);
                seedList = (List)fieldSeedList.get(null);
            }
            catch (NoSuchFieldException e) {
                error = true;
            }
            catch (IllegalAccessException e) {
                error = true;
            }
            if (error) {
                LogHelper.info("Error when wiping tall grass drops: couldn't get seed list");
            } else {
                seedList.clear();
                LogHelper.info("Wiped seed entries");
            }
        }
        for (String data : rawData = IOHelper.getLinesArrayFromData(ConfigurationHandler.readGrassDrops())) {
            String[] dropData = IOHelper.getData(data);
            boolean success = dropData.length == 2;
            String errorMsg = "Incorrect amount of arguments";
            LogHelper.debug("parsing " + data);
            if (success) {
                ItemStack seedStack = IOHelper.getStack(dropData[0], false);
                Item drop = seedStack != null ? seedStack.func_77973_b() : null;
                success = drop != null;
                errorMsg = "Invalid fruit";
                if (success) {
                    int meta = seedStack.func_77960_j();
                    int weight = Integer.parseInt(dropData[1]);
                    MinecraftForge.addGrassSeed((ItemStack)new ItemStack(drop, 1, meta), (int)weight);
                    LogHelper.info(new StringBuffer("Registered ").append(Item.field_150901_e.func_148750_c((Object)drop)).append(":").append(meta).append(" as a drop from grass (weight: ").append(weight).append(')'));
                }
            }
            if (success) continue;
            LogHelper.info(new StringBuffer("Error when adding grass drop: ").append(errorMsg).append(" (line: ").append(data).append(")"));
        }
    }
}

