/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.handler;

import com.InfinityRaider.AgriCraft.utility.IOHelper;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigurationHandler {
    public static Configuration config;
    private static String directory;
    private static Property propGenerateDefaults;
    public static boolean debug;
    public static boolean generateDefaults;
    public static boolean customCrops;
    public static int cropsPerCraft;
    public static int cropStatCap;
    public static boolean resourcePlants;
    public static boolean wipeTallGrassDrops;
    public static boolean renderBookInAnalyzer;
    public static boolean registerCropProductsToOreDict;
    public static boolean onlyCreateWaterPadWhileSneaking;
    public static boolean disableVanillaFarming;
    public static double mutationChance;
    public static boolean singleSpreadsIncrement;
    public static int validParents;
    public static boolean otherCropsAffectStatsNegatively;
    public static boolean hardCoreStats;
    public static int cropStatDivisor;
    public static boolean enableWeeds;
    public static boolean weedsWipePlants;
    public static int weedGrowthMultiplier;
    public static int weedGrowthRate;
    public static float weedSpawnChance;
    public static boolean bonemealMutation;
    public static boolean onlyMatureDropSeeds;
    public static boolean weedsDestroyCropSticks;
    public static float growthMultiplier;
    public static boolean rakingDrops;
    public static boolean modSpecifDrops;
    public static boolean enableHandRake;
    public static boolean enableTrowel;
    public static boolean enableMagnifyingGlass;
    public static boolean enableClipper;
    public static boolean disableWorldGen;
    public static int greenhouseWeight;
    public static int greenhouseLimit;
    public static int greenhouseIrrigatedWeight;
    public static int greenhouseIrrigatedLimit;
    public static boolean villagerEnabled;
    public static int greenHouseMaxTier;
    public static boolean disableSeedStorage;
    public static boolean disableSeedWarehouse;
    public static boolean disableIrrigation;
    public static int sprinklerRatePerSecond;
    public static int sprinklerRatePerHalfSecond;
    public static int sprinklerGrowthChance;
    public static float sprinklerGrowthChancePercent;
    public static int sprinklerGrowthInterval;
    public static int sprinklerGrowthIntervalTicks;
    public static boolean placeWater;
    public static boolean fillFromFlowingWater;
    public static int channelCapacity;
    public static boolean disableFences;
    public static boolean disableGrates;
    public static boolean renderCropPlantsAsTESR;
    public static boolean condenseCustomWoodInNei;
    public static boolean disableParticles;
    public static String statDisplay;
    public static boolean disableSounds;

    public static void init(FMLPreInitializationEvent event) {
        ConfigurationHandler.checkAndCreateConfig(event);
        ConfigurationHandler.loadConfiguration();
        LogHelper.debug("Configuration Loaded");
    }

    private static void checkAndCreateConfig(FMLPreInitializationEvent event) {
        if (config == null) {
            directory = event.getModConfigurationDirectory().toString() + '/' + "AgriCraft".toLowerCase() + '/';
            config = new Configuration(new File(directory, "Configuration.cfg"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void initClientConfigs(FMLPreInitializationEvent event) {
        ConfigurationHandler.checkAndCreateConfig(event);
        condenseCustomWoodInNei = config.getBoolean("condense custom wood blocks in NEI", "clientside config", true, "set to true to condense all entries for custom wood blocks into one entry in NEI");
        disableParticles = config.getBoolean("Disable particles", "clientside config", false, "set to true to disable particles for the sprinklers");
        statDisplay = config.getString("Stat Display", "clientside config", "NUMBER", "This defines how to display the stats of plants. Possible settings are 'NUMBER': just display a simple number (ex: \"6\"), 'FRACTION': number/maximum (ex: \"6/10\"), 'CHARACTER-'char'': number of characters equal to the stats (ex: CHARACTER-\u2022 will give \"\u2022\u2022\u2022\u2022\u2022\u2022\") and 'KEYWORD-'type'-'keyword'': keyword followed by the type and then the stat, type is any of the previous types (ex: KEYWORD-FRACTION-Rank will give \"Rank: 6/10\") . Invalid entries will default to NUMBER ");
        disableSounds = config.getBoolean("Disable sounds", "clientside config", false, "Set to true to disable sounds.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static void loadConfiguration() {
        resourcePlants = config.getBoolean("Resource Crops", "agricraft", true, "set to true if you wish to enable resource crops");
        cropsPerCraft = config.getInt("Crops per craft", "agricraft", 4, 1, 4, "The number of crops you get per crafting operation");
        cropStatCap = config.getInt("Crop stat cap", "agricraft", 10, 1, 10, "The maximum attainable value of the stats on a crop");
        propGenerateDefaults = config.get("agricraft", "GenerateDefaults", false, "set to true to regenerate a default mutations file (will turn back to false afterwards)");
        generateDefaults = propGenerateDefaults.getBoolean();
        customCrops = config.getBoolean("Custom crops", "agricraft", false, "set to true if you wish to create your own crops");
        wipeTallGrassDrops = config.getBoolean("Clear tall grass drops", "agricraft", false, "set to true to clear the list of items dropping from tall grass (Will run before adding seeds defined in the grass drops config).");
        renderBookInAnalyzer = config.getBoolean("Render journal in analyzer", "agricraft", true, "set to false to not render the journal on the analyzer");
        registerCropProductsToOreDict = config.getBoolean("Register crop products in the ore dict", "agricraft", true, "set to false to not register crop products to the ore dictionary if you are experiencing issues with GregTech (note that disabling this will have the side effect that seeds will no longer work with the Phytogenic Insulator");
        onlyCreateWaterPadWhileSneaking = config.getBoolean("Only create water pad while sneaking", "agricraft", false, "set to true to only create water pads while sneaking");
        disableVanillaFarming = config.getBoolean("Disable Vanilla Farming", "farming", false, "set to true to disable vanilla farming, meaning you can only grow plants on crops");
        mutationChance = config.getFloat("Mutation Chance", "farming", 0.2f, 0.0f, 1.0f, "Define mutation chance (0.0 means no mutations, only spreading and 1.0 means only mutations no spreading");
        singleSpreadsIncrement = config.getBoolean("Single spread stat increase", "farming", false, "Set to true to allow crops that spread from one single crop to increase stats");
        validParents = config.getInt("Valid parents", "farming", 2, 1, 3, "What are considered valid parents for stat increasing: 1 = Any. 2 = Mutation parents and identical crops. 3 = Only identical crops");
        otherCropsAffectStatsNegatively = config.getBoolean("Non parent crops affect stats negatively", "farming", true, "True means any crop that is not considered a valid parent will affect stat gain negatively");
        hardCoreStats = config.getBoolean("Hardcore stats", "farming", false, "Set to true to enable hardcore mode for stat increasing: 1 parent: 3/4 decrement, 1/4 nothing.\n 2 parents: 2/4 decrement, 1/4 nothing, 1/4 increment.\n 3 parents: 1/4 decrement, 1/2 nothing, 1/4 increment.\n 4 parents: 1/4 decrement, 1/4 nothing, 1/2 increment.");
        cropStatDivisor = config.getInt("Crop stat divisor", "farming", 2, 1, 3, "On a mutation the stats on the crop will be divided by this number");
        enableWeeds = config.getBoolean("Enable weeds", "farming", true, "set to false if you wish to disable weeds");
        weedGrowthMultiplier = config.getInt("Weed Growth Multiplier", "farming", 2, 1, 2, "Ranges from 1-2 inclusive.");
        weedGrowthRate = config.getInt("Weed Growth Rate", "farming", 50, 10, 50, "The average number of growth ticks for the weed to grow.");
        weedSpawnChance = config.getFloat("Weed Spawn Chance", "farming", 0.15f, 0.05f, 0.95f, "The percent chance of weeds to spawn or spread. At 95% abandon all hope of farming. Range 0.05-0.95.");
        weedsWipePlants = enableWeeds && config.getBoolean("Weeds can overtake plants", "farming", true, "set to false if you don't want weeds to be able to overgrow other plants");
        bonemealMutation = config.getBoolean("Bonemeal Mutations", "farming", false, "set to false if you wish to disable using bonemeal on a cross crop to force a mutation");
        onlyMatureDropSeeds = config.getBoolean("Only mature crops drop seeds", "farming", false, "set this to true to make only mature crops drop seeds (to encourage trowel usage)");
        weedsDestroyCropSticks = config.getBoolean("Weeds destroy crop sticks", "farming", false, "set this to true to have weeds destroy the crop sticks when they are broken with weeds (to encourage rake usage)");
        growthMultiplier = config.getFloat("Growth rate multiplier", "farming", 1.0f, 0.0f, 2.0f, "This is a global growth rate multiplier");
        rakingDrops = config.getBoolean("Raking weeds drops items", "farming", true, "set to false if you wish to disable drops from raking weeds");
        modSpecifDrops = config.getBoolean("Mod specific drops", "farming", true, "set to false to disable mod specific drops, this will (for instance) cause Natura berries to drop from Harvestcraft berry crops");
        enableHandRake = config.getBoolean("Enable Hand Rake", "tools", true, "Set to false to disable the Hand Rake");
        enableMagnifyingGlass = config.getBoolean("Enable Magnifying Glass", "tools", true, "Set to false to disable the Magnifying Glass");
        enableTrowel = config.getBoolean("Enable Trowel", "tools", true, "Set to false to disable the Trowel");
        enableClipper = config.getBoolean("Enable Clipper", "tools", true, "Set to false to disable the Clipper");
        disableWorldGen = config.getBoolean("Disable World Gen", "world gen", false, "set to true to disable world gen, no greenhouses will spawn in villages");
        greenhouseWeight = config.getInt("Greenhouse weight", "world gen", 10, 0, 100, "The weight for a greenhouse to be generated in a village");
        greenhouseLimit = config.getInt("Greenhouse limit", "world gen", 1, 0, 2, "The maximum number of greenhouses per village");
        greenhouseIrrigatedWeight = config.getInt("Irrigated greenhouse weight", "world gen", 2, 0, 100, "The weight for an irrigated greenhouse to be generated in a village");
        greenhouseIrrigatedLimit = config.getInt("Irrigated greenhouse limit", "world gen", 1, 0, 2, "The maximum number of irrigated greenhouses per village");
        villagerEnabled = config.getBoolean("Enable villagers", "world gen", true, "Set to false if you wish to disable villagers spawning in the AgriCraft greenhouses");
        greenHouseMaxTier = config.getInt("Maximum crop tier", "world gen", 3, 1, 5, "The maximum tier of plants that will spawn in greenhouses");
        disableSeedStorage = config.getBoolean("Disable seed storage system", "storage", false, "set to true to disable the seed storage systems");
        disableSeedWarehouse = config.getBoolean("Disable seed storage warehouses", "storage", false, "set to true to disable the seed storage warehouse blocks");
        disableIrrigation = config.getBoolean("Disable Irrigation", "irrigation", false, "set to true if you want to disable irrigation systems");
        sprinklerRatePerSecond = config.getInt("Sprinkler water usage", "irrigation", 10, 0, 10000, "Water usage of the sprinkler in mB per second");
        sprinklerRatePerHalfSecond = Math.round(sprinklerRatePerSecond / 2);
        sprinklerGrowthChance = config.getInt("Sprinkler growth chance", "irrigation", 20, 0, 100, "Every x seconds each plant in sprinkler range has this chance to growth tick");
        sprinklerGrowthChancePercent = (float)sprinklerGrowthChance / 100.0f;
        sprinklerGrowthInterval = config.getInt("Sprinkler growth interval", "irrigation", 5, 1, 300, "Every x seconds each plant in sprinkler range has y chance to growth tick");
        sprinklerGrowthIntervalTicks = sprinklerGrowthInterval * 20;
        placeWater = config.getBoolean("Spawn water after breaking tank", "irrigation", true, "set to false to disable placing a source block when breaking non-empty tanks");
        fillFromFlowingWater = config.getBoolean("Fill tank from flowing water", "irrigation", false, "set to true to let tanks fill up when water flows above them");
        channelCapacity = config.getInt("Channel capacity", "irrigation", 500, 100, 2000, "The amount of water in mb that an irrigation channel can hold");
        disableFences = config.getBoolean("Disable fences", "decoration", false, "Set to true to disable the decorative custom wood fences");
        disableGrates = config.getBoolean("Disable grates", "decoration", false, "Set to true to disable the decorative custom wood grates");
        debug = config.getBoolean("debug", "debug", false, "Set to true if you wish to enable debug mode");
        renderCropPlantsAsTESR = config.getBoolean("Crop rendering setting", "rendering", false, "When rendering crops, the default (false) is that the plants will only be re-rendered whenever the chunk updates, this basically means that whenever a crop grows it causes the chunk containing the plant to re-rendered.\nFor small farms this is the suggested approach, however for large farms, it is possible that a crop grows almost every tick, resulting in  re-rendering the chunk every tick, possibly causing huge FPS drops.\nWhen setting this to true, there will no longer be chunk updates when a crop grows, but the rendering will be different: The plant will be rendered every tick (the sticks itself will still be rendered the default way), for small farms this is a bad approach,for large farms as well, but it might result in better FPS compared to the default.\nI recommend leaving this on false, if you have FPS problems, set this to true and see for yourself if it is an improvement or not.\nThis config setting must match on server and client, the server should know if it should cause block updates and the client has to know how to render the crops");
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static boolean enableModCompatibility(String modId) {
        boolean flag = config.getBoolean(modId, "compatibility", true, "set to false to disable compatibility for " + modId);
        if (config.hasChanged()) {
            config.save();
        }
        return flag;
    }

    public static String readGrassDrops() {
        return IOHelper.readOrWrite(directory, "GrassDrops", IOHelper.getGrassDrops());
    }

    public static String readCustomCrops() {
        return IOHelper.readOrWrite(directory, "CustomCrops", IOHelper.getCustomCropInstructions());
    }

    public static String readMutationData() {
        String data = IOHelper.readOrWrite(directory, "Mutations", IOHelper.getDefaultMutations(), generateDefaults);
        if (generateDefaults) {
            propGenerateDefaults.setToDefault();
            config.save();
        }
        return data;
    }

    public static String readSpreadChances() {
        return IOHelper.readOrWrite(directory, "SpreadChancesOverrides", IOHelper.getSpreadChancesOverridesInstructions());
    }

    public static String readSeedTiers() {
        return IOHelper.readOrWrite(directory, "SeedTiers", IOHelper.getSeedTierOverridesInstructions());
    }

    public static String readSeedBlackList() {
        return IOHelper.readOrWrite(directory, "SeedBlackList", IOHelper.getSeedBlackListInstructions());
    }

    public static String readVanillaOverrides() {
        return IOHelper.readOrWrite(directory, "VanillaPlantingExceptions", IOHelper.getPlantingExceptionsInstructions());
    }

    public static String readSoils() {
        return IOHelper.readOrWrite(directory, "SoilWhitelist", IOHelper.getSoilWhitelistData());
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("AgriCraft")) {
            ConfigurationHandler.loadConfiguration();
            LogHelper.debug("Configuration reloaded.");
        }
    }

    static {
        propGenerateDefaults = new Property("RegenDefaults", "false", Property.Type.BOOLEAN);
        sprinklerGrowthIntervalTicks = 100;
    }

    public static class Categories {
        public static final String CATEGORY_AGRICRAFT = "agricraft";
        public static final String CATEGORY_FARMING = "farming";
        public static final String CATEGORY_TOOLS = "tools";
        public static final String CATEGORY_DEBUG = "debug";
        public static final String CATEGORY_WORLDGEN = "world gen";
        public static final String CATEGORY_IRRIGATION = "irrigation";
        public static final String CATEGORY_STORAGE = "storage";
        public static final String CATEGORY_DECORATION = "decoration";
        public static final String CATEGORY_COMPATIBILITY = "compatibility";
        public static final String CATEGORY_CLIENT = "clientside config";
        public static final String CATEGORY_RENDERING = "rendering";
    }
}

