/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.compatibility.resourcefulcrops;

import com.InfinityRaider.AgriCraft.api.v1.BlockWithMeta;
import com.InfinityRaider.AgriCraft.api.v1.IGrowthRequirement;
import com.InfinityRaider.AgriCraft.api.v1.RequirementType;
import com.InfinityRaider.AgriCraft.api.v2.IGrowthRequirementBuilder;
import com.InfinityRaider.AgriCraft.compatibility.resourcefulcrops.CropPlantResourcefulCrops;
import com.InfinityRaider.AgriCraft.compatibility.resourcefulcrops.ResourcefulCropsAPIwrapper;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.farming.growthrequirement.GrowthRequirementHandler;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import tehnut.resourceful.crops.api.ResourcefulAPI;
import tehnut.resourceful.crops.api.base.Seed;
import tehnut.resourceful.crops.api.base.SeedReq;
import tehnut.resourceful.crops.api.registry.SeedRegistry;
import tehnut.resourceful.crops.api.util.BlockStack;

public class ResourcefulCropsAPI
extends ResourcefulCropsAPIwrapper {
    protected ResourcefulCropsAPI() {
    }

    @Override
    protected void init() {
        for (int i = 0; i < SeedRegistry.getSize(); ++i) {
            CropPlantResourcefulCrops cropPlant = new CropPlantResourcefulCrops(i, this.getGrowthRequirement(i));
            try {
                CropPlantHandler.registerPlant(cropPlant);
                continue;
            }
            catch (Exception e) {
                LogHelper.printStackTrace(e);
            }
        }
    }

    @Override
    protected Block getPlantBlock() {
        return ResourcefulAPI.crop;
    }

    @Override
    protected Item getSeed() {
        return ResourcefulAPI.seed;
    }

    @Override
    protected int getTier(int meta) {
        return SeedRegistry.getSeed(meta).getTier() + 1;
    }

    @Override
    protected ArrayList<ItemStack> getAllFruits(int meta) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemStack fruit = new ItemStack(ResourcefulAPI.shard, 1, meta);
        list.add(fruit);
        return list;
    }

    @Override
    protected IGrowthRequirement getGrowthRequirement(int meta) {
        IGrowthRequirementBuilder builder = GrowthRequirementHandler.getNewBuilder();
        Seed seed = SeedRegistry.getSeed(meta);
        if (seed != null) {
            SeedReq seedReq = seed.getSeedReq();
            builder.brightnessRange(seedReq.getLightLevelMin(), seedReq.getLightLevelMax());
            BlockStack growthReq = seedReq.getGrowthReq();
            if (growthReq != null) {
                builder.requiredBlock(new BlockWithMeta(growthReq.getBlock(), growthReq.getMeta()), RequirementType.BELOW, false);
            }
        }
        return builder.build();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected Color getColor(int meta) {
        return SeedRegistry.getSeed(meta).getColor();
    }
}

