/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.compatibility.minetweaker;

import com.InfinityRaider.AgriCraft.items.ItemHandRake;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.agricraft.WeedRaking")
public class WeedRaking {
    @ZenMethod
    public static void add(IItemStack drop, int weight) {
        MineTweakerAPI.apply((IUndoableAction)new AddAction(MineTweakerMC.getItemStack((IItemStack)drop), weight));
    }

    @ZenMethod
    public static void remove(IItemStack drop) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveAction(MineTweakerMC.getItemStack((IItemStack)drop)));
    }

    private static class AddAction
    implements IUndoableAction {
        private final ItemStack entry;
        private final int weight;

        public AddAction(ItemStack drop, int weight) {
            this.entry = drop;
            this.weight = weight;
        }

        public void apply() {
            ItemHandRake.ItemDropRegistry.instance().registerDrop(this.entry, this.weight);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            ItemHandRake.ItemDropRegistry.instance().removeDrop(this.entry);
        }

        public String describe() {
            return "Adding drop for raking '" + this.entry.func_82833_r() + "', with weight " + this.weight;
        }

        public String describeUndo() {
            return "Removing previously added rake drop '" + this.entry.func_82833_r() + "'";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class RemoveAction
    implements IUndoableAction {
        private final ItemStack drop;
        private final int weight;

        public RemoveAction(ItemStack drop) {
            this.drop = drop;
            this.weight = ItemHandRake.ItemDropRegistry.instance().getWeight(drop);
        }

        public void apply() {
            if (this.weight > 0) {
                ItemHandRake.ItemDropRegistry.instance().removeDrop(this.drop);
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            if (this.weight > 0) {
                ItemHandRake.ItemDropRegistry.instance().registerDrop(this.drop, this.weight);
            }
        }

        public String describe() {
            return "Removing drop for raking '" + this.drop.func_82833_r() + "',";
        }

        public String describeUndo() {
            return "Restoring previously removed rake drop '" + this.drop.func_82833_r() + "', with weight " + this.weight;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

