/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.compatibility.minetweaker;

import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.agricraft.SeedBlacklist")
public class SeedBlacklist {
    @ZenMethod
    public static void add(IItemStack seed) {
        SeedBlacklist.add(new IItemStack[]{seed});
    }

    @ZenMethod
    public static void add(IItemStack[] seeds) {
        ItemStack[] seedsToAdd = MineTweakerMC.getItemStacks((IItemStack[])seeds);
        if (SeedBlacklist.areValidSeeds(seedsToAdd)) {
            MineTweakerAPI.apply((IUndoableAction)new AddAction(seedsToAdd));
        } else {
            MineTweakerAPI.logError((String)"Error adding seeds to the blacklist. All provided items must be of type ItemSeeds.");
        }
    }

    @ZenMethod
    public static void remove(IItemStack seed) {
        SeedBlacklist.remove(new IItemStack[]{seed});
    }

    @ZenMethod
    public static void remove(IItemStack[] seeds) {
        ItemStack[] seedsToRemove = MineTweakerMC.getItemStacks((IItemStack[])seeds);
        if (SeedBlacklist.areValidSeeds(seedsToRemove)) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveAction(seedsToRemove));
        } else {
            MineTweakerAPI.logError((String)"Error removing seeds from the blacklist. All provided items must be of type ItemSeeds.");
        }
    }

    private static boolean areValidSeeds(ItemStack[] seeds) {
        for (ItemStack stack : seeds) {
            if (stack.func_77973_b() instanceof ItemSeeds) continue;
            return false;
        }
        return true;
    }

    private static class AddAction
    implements IUndoableAction {
        private final List<ItemStack> seeds;

        public AddAction(ItemStack[] seeds) {
            this.seeds = Arrays.asList(seeds);
        }

        public void apply() {
            CropPlantHandler.addAllToSeedBlacklist(this.seeds);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            CropPlantHandler.removeAllFromSeedBlacklist(this.seeds);
        }

        public String describe() {
            return "Adding seeds [" + Joiner.on((String)", ").join(this.seeds) + "] to the blacklist.";
        }

        public String describeUndo() {
            return "Removing previously added seeds [" + Joiner.on((String)", ").join(this.seeds) + "] from the blacklist.";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class RemoveAction
    implements IUndoableAction {
        private final List<ItemStack> seeds;

        public RemoveAction(ItemStack[] seeds) {
            this.seeds = Arrays.asList(seeds);
        }

        public void apply() {
            CropPlantHandler.removeAllFromSeedBlacklist(this.seeds);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            CropPlantHandler.addAllToSeedBlacklist(this.seeds);
        }

        public String describe() {
            return "Removing seeds [" + Joiner.on((String)", ").join(this.seeds) + "] from the blacklist.";
        }

        public String describeUndo() {
            return "Adding previously removed seeds [" + Joiner.on((String)", ").join(this.seeds) + "] to the blacklist.";
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

