/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.blocks;

import com.InfinityRaider.AgriCraft.api.v1.IFertiliser;
import com.InfinityRaider.AgriCraft.api.v2.IClipper;
import com.InfinityRaider.AgriCraft.api.v2.IRake;
import com.InfinityRaider.AgriCraft.api.v2.ITrowel;
import com.InfinityRaider.AgriCraft.blocks.BlockAgriCraft;
import com.InfinityRaider.AgriCraft.blocks.BlockContainerAgriCraft;
import com.InfinityRaider.AgriCraft.compatibility.ModHelper;
import com.InfinityRaider.AgriCraft.compatibility.applecore.AppleCoreHelper;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.farming.cropplant.CropPlant;
import com.InfinityRaider.AgriCraft.farming.growthrequirement.GrowthRequirementHandler;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.items.ItemDebugger;
import com.InfinityRaider.AgriCraft.network.MessageFertiliserApplied;
import com.InfinityRaider.AgriCraft.network.NetworkWrapperAgriCraft;
import com.InfinityRaider.AgriCraft.renderers.blocks.RenderBlockBase;
import com.InfinityRaider.AgriCraft.renderers.blocks.RenderCrop;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityAgricraft;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityCrop;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.shadowmage.ancientwarfare.api.IAncientWarfareFarmable;
import powercrystals.minefactoryreloaded.api.FertilizerType;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizable;
import vazkii.botania.api.item.IHornHarvestable;

@Optional.InterfaceList(value={@Optional.Interface(modid="Botania", iface="vazkii.botania.api.item.IHornHarvestable"), @Optional.Interface(modid="AncientWarfare", iface="net.shadowmage.ancientwarfare.api.IAncientWarfareFarmable"), @Optional.Interface(modid="MineFactoryReloaded", iface="powercrystals.minefactoryreloaded.api.IFactoryFertilizable")})
public class BlockCrop
extends BlockContainerAgriCraft
implements IGrowable,
IPlantable,
IHornHarvestable,
IAncientWarfareFarmable,
IFactoryFertilizable {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] weedIcons;

    public BlockCrop() {
        super(Material.field_151585_k);
        this.func_149675_a(true);
        this.field_149758_A = true;
        this.func_149672_a(field_149779_h);
        this.func_149711_c(0.0f);
        this.func_149649_H();
        this.field_149755_E = 0.875;
        this.field_149759_B = 0.125;
        this.field_149757_G = this.field_149755_E;
        this.field_149754_D = this.field_149759_B;
        this.field_149756_F = 0.8125;
        this.field_149760_C = 0.0;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCrop();
    }

    @Override
    protected String getTileEntityName() {
        return "crop";
    }

    public void func_149674_a(World world, int x, int y, int z, Random rnd) {
        TileEntityCrop crop = (TileEntityCrop)world.func_147438_o(x, y, z);
        if (crop.hasPlant() || crop.hasWeed()) {
            Event.Result allowGrowthResult = AppleCoreHelper.validateGrowthTick(this, world, x, y, z, rnd);
            if (allowGrowthResult != Event.Result.DENY) {
                if (crop.isMature() && crop.hasWeed() && ConfigurationHandler.enableWeeds) {
                    crop.spreadWeed();
                } else if (crop.isFertile()) {
                    boolean shouldGrow;
                    double growthBonus = 1.0 + (double)crop.getGrowth() / 10.0;
                    float global = ConfigurationHandler.growthMultiplier;
                    float growthRate = crop.getGrowthRate();
                    boolean bl = shouldGrow = rnd.nextDouble() <= (double)growthRate * growthBonus * (double)global / 100.0;
                    if (shouldGrow) {
                        crop.applyGrowthTick();
                    }
                }
            }
        } else if (ConfigurationHandler.enableWeeds && Math.random() < (double)ConfigurationHandler.weedSpawnChance) {
            crop.spawnWeed();
        } else if (crop.isCrossCrop()) {
            crop.crossOver();
        }
    }

    public boolean harvest(World world, int x, int y, int z, EntityPlayer player, TileEntityCrop crop) {
        if (!world.field_72995_K) {
            TileEntityCrop tileEntityCrop = crop = crop == null ? (TileEntityCrop)world.func_147438_o(x, y, z) : crop;
            if (crop.hasWeed()) {
                crop.clearWeed();
                return false;
            }
            if (crop.isCrossCrop()) {
                crop.setCrossCrop(false);
                this.func_149642_a(world, x, y, z, new ItemStack(com.InfinityRaider.AgriCraft.init.Items.crops, 1));
                return false;
            }
            if (crop.isMature() && crop.allowHarvest(player)) {
                crop.func_145831_w().func_72921_c(crop.field_145851_c, crop.field_145848_d, crop.field_145849_e, 2, 2);
                ArrayList<ItemStack> drops = crop.getFruits();
                for (ItemStack drop : drops) {
                    if (drop == null || drop.func_77973_b() == null) continue;
                    this.func_149642_a(world, x, y, z, drop);
                }
                return true;
            }
        }
        return false;
    }

    public boolean harvest(World world, int x, int y, int z, EntityPlayer player) {
        return this.harvest(world, x, y, z, player, null);
    }

    public boolean harvest(World world, int x, int y, int z, TileEntityCrop crop) {
        return this.harvest(world, x, y, z, null, crop);
    }

    public boolean harvest(World world, int x, int y, int z) {
        return this.harvest(world, x, y, z, null, null);
    }

    public void setCrossCrop(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.field_72995_K) {
            TileEntityCrop crop = (TileEntityCrop)world.func_147438_o(x, y, z);
            if (!(crop.hasWeed() || crop.isCrossCrop() || crop.hasPlant())) {
                crop.setCrossCrop(true);
                player.func_71045_bC().field_77994_a = player.field_71075_bZ.field_75098_d ? player.func_71045_bC().field_77994_a : player.func_71045_bC().field_77994_a - 1;
            } else {
                this.harvest(world, x, y, z, player, crop);
            }
        }
    }

    public boolean plantSeed(ItemStack stack, World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            TileEntityCrop crop = (TileEntityCrop)world.func_147438_o(x, y, z);
            if (crop.isCrossCrop() || crop.hasPlant() || !CropPlantHandler.isValidSeed(stack)) {
                return false;
            }
            if (!CropPlantHandler.getGrowthRequirement(stack).isValidSoil(world, x, y - 1, z)) {
                return false;
            }
            if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("growth")) {
                crop.setPlant(stack.field_77990_d.func_74762_e("growth"), stack.field_77990_d.func_74762_e("gain"), stack.field_77990_d.func_74762_e("strength"), stack.field_77990_d.func_74767_n("analyzed"), stack.func_77973_b(), stack.func_77960_j());
            } else {
                crop.setPlant(1, 1, 1, false, stack.func_77973_b(), stack.func_77960_j());
            }
            return true;
        }
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float fX, float fY, float fZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)te;
            ItemStack heldItem = player.func_71045_bC();
            if (ConfigurationHandler.enableHandRake && crop.hasWeed() && (heldItem == null || heldItem.func_77973_b() == null || !(heldItem.func_77973_b() instanceof IRake))) {
                return false;
            }
            if (player.func_70093_af()) {
                this.harvest(world, x, y, z, player, crop);
            } else if (heldItem == null || heldItem.func_77973_b() == null) {
                this.harvest(world, x, y, z, player, crop);
            } else if (heldItem.func_77973_b() == Items.field_151120_aE) {
                CropPlant sugarcane;
                if (crop.hasPlant()) {
                    this.harvest(world, x, y, z, player, crop);
                } else if (!crop.isCrossCrop() && !crop.hasWeed() && (sugarcane = CropPlantHandler.getPlantFromStack(new ItemStack((Item)((ItemSeeds)Item.field_150901_e.func_82594_a("AgriCraft:seedSugarcane"))))) != null && sugarcane.getGrowthRequirement().canGrow(world, x, y, z)) {
                    crop.setPlant(1, 1, 1, false, sugarcane);
                    if (!player.field_71075_bZ.field_75098_d) {
                        --heldItem.field_77994_a;
                    }
                }
            } else if (heldItem.func_77973_b() == com.InfinityRaider.AgriCraft.init.Items.crops) {
                this.setCrossCrop(world, x, y, z, player);
            } else if (heldItem.func_77973_b() instanceof ITrowel) {
                crop.onTrowelUsed((ITrowel)heldItem.func_77973_b(), heldItem);
            } else if (heldItem.func_77973_b() instanceof IClipper) {
                this.onClipperUsed(world, x, y, z, crop);
                ((IClipper)heldItem.func_77973_b()).onClipperUsed(world, x, y, z, player);
            } else if (heldItem.func_77973_b() instanceof IRake) {
                if (crop.hasPlant()) {
                    return this.upRoot(world, x, y, z);
                }
                if (crop.hasWeed()) {
                    ((IRake)heldItem.func_77973_b()).removeWeeds(crop, heldItem);
                }
            } else {
                if (heldItem.func_77973_b() == Items.field_151100_aR && heldItem.func_77960_j() == 15) {
                    return !crop.canBonemeal();
                }
                if (heldItem.func_77973_b() instanceof IFertiliser) {
                    IFertiliser fertiliser = (IFertiliser)heldItem.func_77973_b();
                    if (crop.allowFertiliser(fertiliser)) {
                        crop.applyFertiliser(fertiliser, world.field_73012_v);
                        NetworkWrapperAgriCraft.wrapper.sendToAllAround((IMessage)new MessageFertiliserApplied(heldItem, x, y, z), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)y, (double)z, 32.0));
                        if (!player.field_71075_bZ.field_75098_d) {
                            --heldItem.field_77994_a;
                        }
                    }
                    return false;
                }
                if (heldItem.func_77973_b() instanceof ItemDebugger) {
                    return false;
                }
                if (ModHelper.isRightClickHandled(heldItem.func_77973_b())) {
                    return ModHelper.handleRightClickOnCrop(world, x, y, z, player, heldItem, this, crop);
                }
                this.harvest(world, x, y, z, player, crop);
                if (CropPlantHandler.isValidSeed(heldItem) && this.plantSeed(player.func_71045_bC(), world, x, y, z)) {
                    player.func_71045_bC().field_77994_a = player.field_71075_bZ.field_75098_d ? player.func_71045_bC().field_77994_a : player.func_71045_bC().field_77994_a - 1;
                }
            }
        }
        return true;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.field_72995_K) {
            CropPlant plant = ((TileEntityCrop)world.func_147438_o(x, y, z)).getPlant();
            if (!player.field_71075_bZ.field_75098_d) {
                this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            }
            world.func_147468_f(x, y, z);
            world.func_147475_p(x, y, z);
            if (plant != null) {
                plant.onPlantRemoved(world, x, y, z);
            }
        }
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        this.func_149699_a(world, x, y, z, player);
    }

    public void func_149690_a(World world, int x, int y, int z, int meta, float f, int i) {
        TileEntityCrop crop;
        if (!world.field_72995_K && (crop = (TileEntityCrop)world.func_147438_o(x, y, z)) != null) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            if (crop.isCrossCrop()) {
                drops.add(new ItemStack(com.InfinityRaider.AgriCraft.init.Items.crops, 2));
            } else {
                if (!crop.hasWeed() || !ConfigurationHandler.weedsDestroyCropSticks) {
                    drops.add(new ItemStack(com.InfinityRaider.AgriCraft.init.Items.crops, 1));
                }
                if (crop.hasPlant()) {
                    if (crop.isMature()) {
                        drops.addAll(crop.getFruits());
                        drops.add(crop.getSeedStack());
                    } else if (!ConfigurationHandler.onlyMatureDropSeeds) {
                        drops.add(crop.getSeedStack());
                    }
                }
            }
            for (ItemStack drop : drops) {
                if (drop == null || drop.func_77973_b() == null) continue;
                this.func_149642_a(world, x, y, z, drop);
            }
        }
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean isRemote) {
        return world.func_72805_g(x, y, z) < 7 && this.isFertile(world, x, y, z);
    }

    public boolean func_149852_a(World world, Random rand, int x, int y, int z) {
        return true;
    }

    public void func_149853_b(World world, Random rand, int x, int y, int z) {
        TileEntityCrop crop = (TileEntityCrop)world.func_147438_o(x, y, z);
        if (crop.hasPlant() || crop.hasWeed()) {
            int l = world.func_72805_g(x, y, z) + MathHelper.func_76136_a((Random)world.field_73012_v, (int)2, (int)5);
            if (l > 7) {
                l = 7;
            }
            world.func_72921_c(x, y, z, l, 2);
        } else if (crop.isCrossCrop() && ConfigurationHandler.bonemealMutation) {
            crop.crossOver();
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
            world.func_147475_p(x, y, z);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return GrowthRequirementHandler.isSoilValid(world, x, y - 1, z);
    }

    public boolean isFertile(World world, int x, int y, int z) {
        return world.func_147438_o(x, y, z) != null && world.func_147438_o(x, y, z) instanceof TileEntityCrop && ((TileEntityCrop)world.func_147438_o(x, y, z)).isFertile();
    }

    @Override
    public boolean isMature(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) >= 7;
    }

    @Override
    public List<ItemStack> doHarvest(World world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        TileEntityCrop crop = (TileEntityCrop)world.func_147438_o(x, y, z);
        if (crop.hasWeed()) {
            crop.clearWeed();
        } else if (crop.isCrossCrop()) {
            crop.setCrossCrop(false);
            drops.add(new ItemStack(com.InfinityRaider.AgriCraft.init.Items.crops, 1));
        } else if (crop.isMature() && crop.allowHarvest(null)) {
            crop.func_145831_w().func_72921_c(crop.field_145851_c, crop.field_145848_d, crop.field_145849_e, 2, 2);
            for (ItemStack stack : crop.getFruits()) {
                if (stack == null || stack.func_77973_b() == null) continue;
                drops.add(stack);
            }
        }
        return drops;
    }

    public void onClipperUsed(World world, int x, int y, int z, TileEntityCrop crop) {
        if (!crop.hasPlant()) {
            return;
        }
        int growthStage = world.func_72805_g(x, y, z);
        if (growthStage <= 0) {
            return;
        }
        ItemStack clipping = new ItemStack(com.InfinityRaider.AgriCraft.init.Items.clipping, 1, 0);
        clipping.func_77982_d(crop.getSeedStack().func_77955_b(new NBTTagCompound()));
        this.func_149642_a(world, x, y, z, clipping);
        world.func_72921_c(x, y, z, growthStage - 1, 3);
    }

    public Item func_149650_a(int meta, Random rand, int side) {
        return com.InfinityRaider.AgriCraft.init.Items.crops;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (world.func_147438_o(x, y, z) != null && world.func_147438_o(x, y, z) instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)world.func_147438_o(x, y, z);
            if (crop.isCrossCrop()) {
                items.add(new ItemStack(com.InfinityRaider.AgriCraft.init.Items.crops, 2));
            } else {
                items.add(new ItemStack(com.InfinityRaider.AgriCraft.init.Items.crops, 1));
            }
            if (crop.hasPlant()) {
                ItemStack seedStack = crop.getSeedStack().func_77946_l();
                items.add(seedStack);
                if (crop.isMature()) {
                    items.addAll(crop.getFruits());
                }
            }
        }
        return items;
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        super.func_149749_a(world, x, y, z, block, meta);
        world.func_147475_p(x, y, z);
    }

    public boolean upRoot(World world, int x, int y, int z) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_147438_o(x, y, z)) != null && te instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)te;
            if (crop.hasPlant()) {
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                if (crop.isMature()) {
                    drops.addAll(crop.getFruits());
                }
                drops.add(crop.getSeedStack());
                for (ItemStack drop : drops) {
                    this.func_149642_a(world, x, y, z, drop);
                }
            }
            crop.clearPlant();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return com.InfinityRaider.AgriCraft.init.Items.crops;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        TileEntityCrop crop = (TileEntityCrop)world.func_147438_o(x, y, z);
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + (double)crop.getCropHeight()), (double)((double)z + this.field_149757_G));
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int i) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a(this.func_149739_a().substring(this.func_149739_a().indexOf(46) + 1));
        this.weedIcons = new IIcon[4];
        for (int i = 0; i < this.weedIcons.length; ++i) {
            this.weedIcons[i] = reg.func_94245_a(this.func_149739_a().substring(this.func_149739_a().indexOf(46) + 1) + "WeedTexture" + (i + 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getWeedIcon(int meta) {
        int index = 0;
        switch (meta) {
            case 0: 
            case 1: {
                index = 0;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                index = 1;
                break;
            }
            case 5: 
            case 6: {
                index = 2;
                break;
            }
            case 7: {
                index = 3;
            }
        }
        return this.weedIcons[index];
    }

    @Override
    public boolean func_149696_a(World world, int x, int y, int z, int id, int data) {
        super.func_149696_a(world, x, y, z, id, data);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        return tileEntity != null && tileEntity.func_145842_c(id, data);
    }

    @Override
    public boolean isMultiBlock() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderBlockBase getRenderer() {
        return new RenderCrop();
    }

    @Override
    protected Class<? extends ItemBlock> getItemBlockClass() {
        return null;
    }

    @Override
    protected String getInternalName() {
        return "crops";
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Crop;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity == null || !(tileEntity instanceof TileEntityCrop)) {
            return this;
        }
        TileEntityCrop crop = (TileEntityCrop)tileEntity;
        if (crop.hasPlant()) {
            return crop.getPlantBlock();
        }
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    @Override
    public ItemStack getWailaStack(BlockAgriCraft block, TileEntityAgricraft tea) {
        return new ItemStack(com.InfinityRaider.AgriCraft.init.Items.crops, 1, 0);
    }

    @Override
    @Optional.Method(modid="Botania")
    public boolean canHornHarvest(World world, int x, int y, int z, ItemStack stack, IHornHarvestable.EnumHornType hornType) {
        return hornType.ordinal() == 0 && this.isMature(world, x, y, z);
    }

    @Override
    @Optional.Method(modid="Botania")
    public boolean hasSpecialHornHarvest(World world, int x, int y, int z, ItemStack stack, IHornHarvestable.EnumHornType hornType) {
        return hornType.ordinal() == 0;
    }

    @Override
    @Optional.Method(modid="Botania")
    public void harvestByHorn(World world, int x, int y, int z, ItemStack stack, IHornHarvestable.EnumHornType hornType) {
        if (hornType.ordinal() != 0) {
            return;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null || !(tile instanceof TileEntityCrop)) {
            return;
        }
        TileEntityCrop crop = (TileEntityCrop)tile;
        if (crop.hasPlant() && this.harvest(world, x, y, z, null, crop) && stack != null && stack.func_77973_b() != null) {
            stack.func_96631_a(1, world.field_73012_v);
        }
    }

    @Override
    @Optional.Method(modid="MineFactoryReloaded")
    public Block getPlant() {
        return this;
    }

    @Override
    @Optional.Method(modid="MineFactoryReloaded")
    public boolean canFertilize(World world, int x, int y, int z, FertilizerType type) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null || !(te instanceof TileEntityCrop)) {
            return false;
        }
        TileEntityCrop crop = (TileEntityCrop)te;
        if (this.isMature(world, x, y, z) || !crop.isFertile()) {
            return false;
        }
        if (crop.isCrossCrop()) {
            return ConfigurationHandler.bonemealMutation && type != FertilizerType.None;
        }
        if (!crop.hasPlant()) {
            return false;
        }
        switch (type) {
            case GrowPlant: {
                return crop.canBonemeal();
            }
            case GrowMagicalCrop: {
                return true;
            }
        }
        return false;
    }

    @Override
    @Optional.Method(modid="MineFactoryReloaded")
    public boolean fertilize(World world, Random rand, int x, int y, int z, FertilizerType type) {
        boolean success = this.canFertilize(world, x, y, z, type);
        if (success) {
            this.func_149853_b(world, rand, x, y, z);
        }
        return success;
    }
}

