/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem.storm;

import CoroUtil.util.ChunkCoordinatesBlock;
import CoroUtil.util.CoroUtilBlock;
import CoroUtil.util.CoroUtilEntity;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extendedrenderer.ExtendedRenderer;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.behavior.ParticleBehaviorFog;
import extendedrenderer.particle.entity.EntityRotFX;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import weather2.ServerTickHandler;
import weather2.Weather;
import weather2.client.entity.RenderCubeCloud;
import weather2.config.ConfigMisc;
import weather2.entity.EntityIceBall;
import weather2.entity.EntityLightningBolt;
import weather2.player.PlayerData;
import weather2.util.WeatherUtil;
import weather2.util.WeatherUtilConfig;
import weather2.util.WeatherUtilEntity;
import weather2.weathersystem.WeatherManagerBase;
import weather2.weathersystem.WeatherManagerServer;
import weather2.weathersystem.storm.TornadoHelper;
import weather2.weathersystem.storm.WeatherEntityConfig;
import weather2.weathersystem.storm.WeatherTypes;

public class StormObject {
    public static long lastUsedStormID = 0L;
    public long ID;
    public WeatherManagerBase manager;
    public String userSpawnedFor = "";
    @SideOnly(value=Side.CLIENT)
    public List<EntityRotFX> listParticlesCloud;
    @SideOnly(value=Side.CLIENT)
    public List<EntityRotFX> listParticlesGround;
    @SideOnly(value=Side.CLIENT)
    public List<EntityRotFX> listParticlesFunnel;
    @SideOnly(value=Side.CLIENT)
    public ParticleBehaviorFog particleBehaviorFog;
    public int sizeMaxFunnelParticles = 600;
    public static int static_YPos_layer0 = ConfigMisc.Cloud_Layer0_Height;
    public static int static_YPos_layer1 = 350;
    public static int static_YPos_layer2 = 500;
    public static List<Integer> layers = new ArrayList<Integer>(Arrays.asList(static_YPos_layer0, static_YPos_layer1, static_YPos_layer2));
    public int layer = 0;
    public Vec3 pos = Vec3.func_72443_a((double)0.0, (double)static_YPos_layer0, (double)0.0);
    public Vec3 posGround = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    public Vec3 motion = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    public boolean angleIsOverridden = false;
    public float angleMovementTornadoOverride = 0.0f;
    public int size = 50;
    public int maxSize = ConfigMisc.Storm_MaxRadius;
    public boolean isGrowing = true;
    public int levelWater = 0;
    public float levelWindMomentum = 0.0f;
    public float levelTemperature = 0.0f;
    public int levelWaterStartRaining = 100;
    public int levelCurIntensityStage = 0;
    public float levelCurStagesIntensity = 0.0f;
    public boolean hasStormPeaked = false;
    public int maxIntensityStage = STATE_STAGE5;
    public int stormType = TYPE_LAND;
    public static int TYPE_LAND = 0;
    public static int TYPE_WATER = 1;
    public static int STATE_NORMAL = 0;
    public static int STATE_THUNDER = 1;
    public static int STATE_HIGHWIND = 2;
    public static int STATE_HAIL = 3;
    public static int STATE_FORMING = 4;
    public static int STATE_STAGE1 = 5;
    public static int STATE_STAGE2 = 6;
    public static int STATE_STAGE3 = 7;
    public static int STATE_STAGE4 = 8;
    public static int STATE_STAGE5 = 9;
    public static float levelStormIntensityFormingStartVal = STATE_FORMING;
    public double spinSpeed = 0.02;
    public boolean attrib_precipitation = false;
    public boolean attrib_waterSpout = false;
    public float scale = 1.0f;
    public float strength = 100.0f;
    public int maxHeight = 60;
    public int currentTopYBlock = -1;
    public TornadoHelper tornadoHelper = new TornadoHelper(this);
    public Set<ChunkCoordIntPair> doneChunks = new HashSet<ChunkCoordIntPair>();
    public int updateLCG = new Random().nextInt();
    public float formingStrength = 0.0f;
    public Vec3 posBaseFormationPos;
    public boolean naturallySpawned;
    public boolean canSnowFromCloudTemperature;
    public boolean alwaysProgresses;
    public boolean isDead;
    @SideOnly(value=Side.CLIENT)
    public RenderCubeCloud renderBlock;
    public long ticksSinceLastPacketReceived;
    private NBTTagCompound cachedClientNBTState;

    public StormObject(WeatherManagerBase parManager) {
        this.posBaseFormationPos = Vec3.func_72443_a((double)this.pos.field_72450_a, (double)this.pos.field_72448_b, (double)this.pos.field_72449_c);
        this.naturallySpawned = true;
        this.canSnowFromCloudTemperature = false;
        this.alwaysProgresses = false;
        this.isDead = false;
        this.ticksSinceLastPacketReceived = 0L;
        this.manager = parManager;
        if (parManager.getWorld().field_72995_K) {
            this.listParticlesCloud = new ArrayList<EntityRotFX>();
            this.listParticlesFunnel = new ArrayList<EntityRotFX>();
            this.listParticlesGround = new ArrayList<EntityRotFX>();
            this.renderBlock = new RenderCubeCloud();
        }
    }

    public void initFirstTime() {
        this.ID = lastUsedStormID++;
        BiomeGenBase bgb = this.manager.getWorld().func_72807_a(MathHelper.func_76128_c((double)this.pos.field_72450_a), MathHelper.func_76128_c((double)this.pos.field_72449_c));
        float temp = 1.0f;
        if (bgb != null) {
            temp = bgb.func_150564_a(MathHelper.func_76128_c((double)this.pos.field_72450_a), MathHelper.func_76128_c((double)this.pos.field_72448_b), MathHelper.func_76128_c((double)this.pos.field_72449_c));
        }
        if (this.naturallySpawned) {
            this.levelTemperature = this.getTemperatureMCToWeatherSys(temp);
        }
        this.levelWindMomentum = 0.0f;
    }

    public boolean isPrecipitating() {
        return this.attrib_precipitation;
    }

    public void setPrecipitating(boolean parVal) {
        this.attrib_precipitation = parVal;
    }

    public boolean isRealStorm() {
        return this.levelCurIntensityStage > STATE_NORMAL;
    }

    public boolean isTornadoFormingOrGreater() {
        return this.stormType == TYPE_LAND && this.levelCurIntensityStage >= STATE_FORMING;
    }

    public boolean isCycloneFormingOrGreater() {
        return this.stormType == TYPE_WATER && this.levelCurIntensityStage >= STATE_FORMING;
    }

    public boolean isSpinning() {
        return this.levelCurIntensityStage >= STATE_HIGHWIND;
    }

    public boolean isTropicalCyclone() {
        return this.levelCurIntensityStage >= STATE_STAGE1;
    }

    public boolean isHurricane() {
        return this.levelCurIntensityStage >= STATE_STAGE5;
    }

    public void readFromNBT(NBTTagCompound var1) {
        this.nbtSyncFromServer(var1);
        this.motion = Vec3.func_72443_a((double)var1.func_74769_h("vecX"), (double)var1.func_74769_h("vecY"), (double)var1.func_74769_h("vecZ"));
        this.angleIsOverridden = var1.func_74767_n("angleIsOverridden");
        this.angleMovementTornadoOverride = var1.func_74760_g("angleMovementTornadoOverride");
    }

    public NBTTagCompound writeToNBT() {
        this.nbtSyncForClient();
        NBTTagCompound nbt = this.cachedClientNBTState;
        nbt.func_74780_a("vecX", this.motion.field_72450_a);
        nbt.func_74780_a("vecY", this.motion.field_72448_b);
        nbt.func_74780_a("vecZ", this.motion.field_72449_c);
        nbt.func_74757_a("angleIsOverridden", this.angleIsOverridden);
        nbt.func_74776_a("angleMovementTornadoOverride", this.angleMovementTornadoOverride);
        return nbt;
    }

    public void nbtSyncFromServer(NBTTagCompound parNBT) {
        CachedNBTTagCompound newData = new CachedNBTTagCompound(parNBT);
        newData.setCachedNBT(this.cachedClientNBTState);
        this.ID = newData.getLong("ID");
        this.pos = Vec3.func_72443_a((double)newData.getInteger("posX"), (double)newData.getInteger("posY"), (double)newData.getInteger("posZ"));
        this.size = newData.getInteger("size");
        this.maxSize = newData.getInteger("maxSize");
        this.attrib_precipitation = newData.getBoolean("attrib_rain");
        this.attrib_waterSpout = newData.getBoolean("attrib_waterSpout");
        this.currentTopYBlock = newData.getInteger("currentTopYBlock");
        this.levelTemperature = newData.getFloat("levelTemperature");
        this.levelWater = newData.getInteger("levelWater");
        this.layer = newData.getInteger("layer");
        this.levelCurIntensityStage = newData.getInteger("levelCurIntensityStage");
        this.levelCurStagesIntensity = newData.getFloat("levelCurStagesIntensity");
        this.stormType = newData.getInteger("stormType");
        this.hasStormPeaked = newData.getBoolean("hasStormPeaked");
        this.isDead = newData.getBoolean("isDead");
        this.cachedClientNBTState = newData.getNewNBT();
        this.ticksSinceLastPacketReceived = 0L;
    }

    public NBTTagCompound nbtSyncForClient() {
        CachedNBTTagCompound data = new CachedNBTTagCompound();
        data.setCachedNBT(this.cachedClientNBTState);
        data.setUpdateForced(true);
        data.setLong("ID", this.ID);
        data.setUpdateForced(false);
        data.setInteger("posX", (int)this.pos.field_72450_a);
        data.setInteger("posY", (int)this.pos.field_72448_b);
        data.setInteger("posZ", (int)this.pos.field_72449_c);
        data.setInteger("size", this.size);
        data.setInteger("maxSize", this.maxSize);
        data.setBoolean("attrib_rain", this.attrib_precipitation);
        data.setBoolean("attrib_waterSpout", this.attrib_waterSpout);
        data.setInteger("currentTopYBlock", this.currentTopYBlock);
        data.setFloat("levelTemperature", this.levelTemperature);
        data.setInteger("levelWater", this.levelWater);
        data.setInteger("layer", this.layer);
        data.setInteger("levelCurIntensityStage", this.levelCurIntensityStage);
        data.setFloat("levelCurStagesIntensity", this.levelCurStagesIntensity);
        data.setInteger("stormType", this.stormType);
        data.setBoolean("hasStormPeaked", this.hasStormPeaked);
        data.setBoolean("isDead", this.isDead);
        this.cachedClientNBTState = data.getCachedNBT();
        return data.getNewNBT();
    }

    public NBTTagCompound nbtForIMC() {
        return this.nbtSyncForClient();
    }

    @SideOnly(value=Side.CLIENT)
    public void tickRender(float partialTick) {
        if (this.layer == 1) {
            this.renderBlock.doRenderClouds(this, this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c, 0.0f, partialTick);
        }
    }

    public void tick() {
        this.posGround = Vec3.func_72443_a((double)this.pos.field_72450_a, (double)this.pos.field_72448_b, (double)this.pos.field_72449_c);
        this.posGround.field_72448_b = this.currentTopYBlock;
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.CLIENT) {
            if (!WeatherUtil.isPaused()) {
                ++this.ticksSinceLastPacketReceived;
                if (this.layer == 0) {
                    this.tickClient();
                }
                if (this.isTornadoFormingOrGreater() || this.isCycloneFormingOrGreater()) {
                    this.tornadoHelper.tick(this.manager.getWorld());
                }
                if (this.levelCurIntensityStage >= STATE_HIGHWIND && this.manager.getWorld().field_72995_K) {
                    this.tornadoHelper.soundUpdates(true, this.isTornadoFormingOrGreater() || this.isCycloneFormingOrGreater());
                }
            }
        } else {
            if (this.isTornadoFormingOrGreater() || this.isCycloneFormingOrGreater()) {
                this.tornadoHelper.tick(this.manager.getWorld());
            }
            if (this.levelCurIntensityStage >= STATE_HIGHWIND && this.manager.getWorld().field_72995_K) {
                this.tornadoHelper.soundUpdates(true, this.isTornadoFormingOrGreater() || this.isCycloneFormingOrGreater());
            }
            this.tickMovement();
            if (this.layer == 0) {
                this.tickWeatherEvents();
                this.tickProgression();
                this.tickSnowFall();
            }
        }
        if (this.layer == 0) {
            this.posBaseFormationPos = Vec3.func_72443_a((double)this.pos.field_72450_a, (double)this.pos.field_72448_b, (double)this.pos.field_72449_c);
            if ((float)this.levelCurIntensityStage >= levelStormIntensityFormingStartVal) {
                if ((float)this.levelCurIntensityStage >= levelStormIntensityFormingStartVal + 1.0f) {
                    this.formingStrength = 1.0f;
                    this.posBaseFormationPos.field_72448_b = this.posGround.field_72448_b;
                } else {
                    float val;
                    float intensityAdj = Math.min(1.0f, this.levelCurStagesIntensity * 2.0f);
                    this.formingStrength = val = (float)this.levelCurIntensityStage + intensityAdj - levelStormIntensityFormingStartVal;
                    double yDiff = this.pos.field_72448_b - this.posGround.field_72448_b;
                    this.posBaseFormationPos.field_72448_b = this.pos.field_72448_b - yDiff * (double)this.formingStrength;
                }
            } else if (this.levelCurIntensityStage == STATE_HIGHWIND) {
                this.formingStrength = 1.0f;
                this.posBaseFormationPos.field_72448_b = this.posGround.field_72448_b;
            } else {
                this.formingStrength = 0.0f;
                this.posBaseFormationPos.field_72448_b = this.pos.field_72448_b;
            }
        }
    }

    public void tickMovement() {
        float angle = this.getAdjustedAngle();
        if (this.angleIsOverridden) {
            angle = this.angleMovementTornadoOverride;
        }
        double vecX = -Math.sin(Math.toRadians(angle));
        double vecZ = Math.cos(Math.toRadians(angle));
        float cloudSpeedAmp = 0.2f;
        float finalSpeed = this.getAdjustedSpeed() * cloudSpeedAmp;
        if (this.levelCurIntensityStage >= STATE_FORMING) {
            finalSpeed = 0.2f;
        } else if (this.levelCurIntensityStage >= STATE_THUNDER) {
            finalSpeed = 0.05f;
        }
        if ((float)this.levelCurIntensityStage >= levelStormIntensityFormingStartVal) {
            finalSpeed /= (float)this.levelCurIntensityStage - levelStormIntensityFormingStartVal + 1.0f;
        }
        if (finalSpeed < 0.03f) {
            finalSpeed = 0.03f;
        }
        if (finalSpeed > 0.3f) {
            finalSpeed = 0.3f;
        }
        if (this.manager.getWorld().func_82737_E() % 100L != 0L || this.levelCurIntensityStage >= STATE_FORMING) {
            // empty if block
        }
        this.motion.field_72450_a = vecX * (double)finalSpeed;
        this.motion.field_72449_c = vecZ * (double)finalSpeed;
        double max = 0.2;
        this.pos.field_72450_a += this.motion.field_72450_a;
        this.pos.field_72449_c += this.motion.field_72449_c;
    }

    public void tickWeatherEvents() {
        int z;
        int y;
        int x;
        Random rand = new Random();
        World world = this.manager.getWorld();
        if (this.size == 0) {
            this.size = 1;
        }
        if (this.maxSize == 0) {
            this.maxSize = 1;
        }
        this.currentTopYBlock = world.func_72976_f(MathHelper.func_76128_c((double)this.pos.field_72450_a), MathHelper.func_76128_c((double)this.pos.field_72449_c));
        if (this.levelCurIntensityStage >= STATE_THUNDER && rand.nextInt(Math.max(1, ConfigMisc.Storm_LightningStrikeBaseValueOddsTo1 - this.levelCurIntensityStage * 10)) == 0 && world.func_72904_c(x = (int)(this.pos.field_72450_a + (double)rand.nextInt(this.size) - (double)rand.nextInt(this.size)), y = world.func_72874_g(x, z = (int)(this.pos.field_72449_c + (double)rand.nextInt(this.size) - (double)rand.nextInt(this.size))), z, x, y, z)) {
            this.addWeatherEffectLightning(new EntityLightningBolt(world, x, y, z));
        }
        if (this.isPrecipitating() && this.levelCurIntensityStage == STATE_HAIL && this.stormType == TYPE_LAND) {
            for (int i = 0; i < Math.max(1, ConfigMisc.Storm_HailPerTick * (this.size / this.maxSize)); ++i) {
                int z2;
                int x2 = (int)(this.pos.field_72450_a + (double)rand.nextInt(this.size) - (double)rand.nextInt(this.size));
                if (!world.func_72904_c(x2, static_YPos_layer0, z2 = (int)(this.pos.field_72449_c + (double)rand.nextInt(this.size) - (double)rand.nextInt(this.size)), x2, static_YPos_layer0, z2) || world.func_72977_a((double)x2, 50.0, (double)z2, 80.0) == null) continue;
                EntityIceBall hail = new EntityIceBall(world);
                hail.func_70107_b(x2, layers.get(this.layer).intValue(), z2);
                world.func_72838_d((Entity)hail);
            }
        }
    }

    public void tickSnowFall() {
        if (!ConfigMisc.Snow_PerformSnowfall) {
            return;
        }
        if (!this.isPrecipitating()) {
            return;
        }
        World world = this.manager.getWorld();
        long startTime = System.nanoTime();
        int xx = 0;
        int zz = 0;
        if (this.size == 0) {
            this.size = 1;
        }
        xx = (int)(this.pos.field_72450_a - (double)(this.size / 2));
        while ((double)xx < this.pos.field_72450_a + (double)(this.size / 2)) {
            zz = (int)(this.pos.field_72449_c - (double)(this.size / 2));
            while ((double)zz < this.pos.field_72449_c + (double)(this.size / 2)) {
                Chunk chunk;
                int chunkX = xx / 16;
                int chunkZ = zz / 16;
                int x = chunkX * 16;
                int z = chunkZ * 16;
                if (world.func_72899_e(xx, 0, zz) && world.field_73011_w.canDoRainSnowIce(chunk = world.func_72964_e(chunkX, chunkZ)) && (ConfigMisc.Snow_RarityOfBuildup == 0 || world.field_73012_v.nextInt(ConfigMisc.Snow_RarityOfBuildup) == 0)) {
                    this.updateLCG = this.updateLCG * 3 + 1013904223;
                    int i1 = this.updateLCG >> 2;
                    int xxx = i1 & 0xF;
                    double d0 = this.pos.field_72450_a - (double)(xx + xxx);
                    int zzz = i1 >> 8 & 0xF;
                    double d2 = this.pos.field_72449_c - (double)(zz + zzz);
                    if (!((double)MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) > (double)this.size)) {
                        int snowMetaMax = 7;
                        int setBlockHeight = world.func_72874_g(xxx + x, zzz + z);
                        if (this.canSnowAtBody(xxx + x, setBlockHeight, zzz + z) && Blocks.field_150433_aE.func_149742_c(world, xxx + x, setBlockHeight, zzz + z)) {
                            int origMeta;
                            boolean perform = false;
                            Block id = world.func_147439_a(xxx + x, setBlockHeight, zzz + z);
                            int meta = 0;
                            if (id.func_149688_o() == Material.field_151597_y) {
                                if (ConfigMisc.Snow_ExtraPileUp) {
                                    meta = world.func_72805_g(xxx + x, setBlockHeight, zzz + z);
                                    if (meta < snowMetaMax) {
                                        perform = true;
                                        ++meta;
                                    } else if (ConfigMisc.Snow_MaxBlockBuildupHeight > 1) {
                                        int i;
                                        int originalSetBlockHeight = setBlockHeight;
                                        for (i = 0; i < ConfigMisc.Snow_MaxBlockBuildupHeight; ++i) {
                                            Block checkID = world.func_147439_a(xxx + x, originalSetBlockHeight + i, zzz + z);
                                            if (checkID.func_149688_o() == Material.field_151597_y) {
                                                meta = world.func_72805_g(xxx + x, originalSetBlockHeight + i, zzz + z);
                                                if (meta >= snowMetaMax) continue;
                                                setBlockHeight = originalSetBlockHeight + i;
                                                perform = true;
                                                ++meta;
                                                break;
                                            }
                                            if (!CoroUtilBlock.isAir((Block)checkID)) continue;
                                            meta = 0;
                                            setBlockHeight = originalSetBlockHeight + i;
                                            perform = true;
                                            break;
                                        }
                                        if (i == ConfigMisc.Snow_MaxBlockBuildupHeight) {
                                            perform = false;
                                        }
                                    }
                                }
                            } else {
                                perform = true;
                            }
                            if (perform && ConfigMisc.Snow_SmoothOutPlacement && (origMeta = Math.max(0, meta - 1)) > snowMetaMax - 4) {
                                ChunkCoordinatesBlock coords = this.getSnowfallEvenOutAdjustCheck(xxx + x, setBlockHeight, zzz + z, origMeta);
                                if (coords.field_71574_a != 0 || coords.field_71573_c != 0) {
                                    if (meta != coords.meta + 1) {
                                        xxx = coords.field_71574_a;
                                        zzz = coords.field_71573_c;
                                        meta = coords.meta + 1;
                                    } else {
                                        perform = false;
                                    }
                                }
                            }
                            if (perform) {
                                world.func_147465_d(xxx + x, setBlockHeight, zzz + z, Blocks.field_150431_aC, meta, 3);
                            }
                        }
                    }
                }
                zz += 16;
            }
            xx += 16;
        }
    }

    public ChunkCoordinatesBlock getSnowfallEvenOutAdjustCheck(int x, int y, int z, int sourceMeta) {
        ChunkCoordinatesBlock attempt = this.getSnowfallEvenOutAdjust(x - 1, y, z, sourceMeta);
        if (attempt.field_71574_a != 0 || attempt.field_71573_c != 0) {
            return attempt;
        }
        attempt = this.getSnowfallEvenOutAdjust(x + 1, y, z, sourceMeta);
        if (attempt.field_71574_a != 0 || attempt.field_71573_c != 0) {
            return attempt;
        }
        attempt = this.getSnowfallEvenOutAdjust(x, y, z - 1, sourceMeta);
        if (attempt.field_71574_a != 0 || attempt.field_71573_c != 0) {
            return attempt;
        }
        attempt = this.getSnowfallEvenOutAdjust(x, y, z + 1, sourceMeta);
        if (attempt.field_71574_a != 0 || attempt.field_71573_c != 0) {
            return attempt;
        }
        return new ChunkCoordinatesBlock(0, 0, 0, Blocks.field_150350_a, 0);
    }

    public ChunkCoordinatesBlock getSnowfallEvenOutAdjust(int x, int y, int z, int sourceMeta) {
        boolean metaToSet = false;
        World world = this.manager.getWorld();
        Block checkID = world.func_147439_a(x, y, z);
        if (CoroUtilBlock.isAir((Block)checkID)) {
            Block checkID2 = world.func_147439_a(x, y - 1, z);
            if (CoroUtilBlock.isAir((Block)checkID2)) {
                return new ChunkCoordinatesBlock(0, 0, 0, Blocks.field_150350_a, 0);
            }
            return new ChunkCoordinatesBlock(x, y, z, Blocks.field_150350_a, 0);
        }
        if (checkID == Blocks.field_150433_aE) {
            int checkMeta = world.func_72805_g(x, y, z);
            if (checkMeta < sourceMeta) {
                return new ChunkCoordinatesBlock(x, y, z, checkID, checkMeta);
            }
        } else {
            return new ChunkCoordinatesBlock(0, 0, 0, Blocks.field_150350_a, 0);
        }
        return new ChunkCoordinatesBlock(0, 0, 0, Blocks.field_150350_a, 0);
    }

    public boolean canSnowAtBody(int par1, int par2, int par3) {
        Block block;
        World world = this.manager.getWorld();
        BiomeGenBase biomegenbase = world.func_72807_a(par1, par3);
        if (biomegenbase == null) {
            return false;
        }
        float f = biomegenbase.func_150564_a(par1, par2, par3);
        if (this.canSnowFromCloudTemperature && this.levelTemperature > 0.0f || !this.canSnowFromCloudTemperature && biomegenbase.func_150564_a(par1, par2, par3) > 0.15f) {
            return false;
        }
        return par2 >= 0 && par2 < 256 && world.func_72972_b(EnumSkyBlock.Block, par1, par2, par3) < 10 && ((block = world.func_147439_a(par1, par2, par3)).isAir((IBlockAccess)world, par1, par2, par3) || block == Blocks.field_150431_aC) && Blocks.field_150431_aC.func_149742_c(world, par1, par2, par3);
    }

    public void tickProgression() {
        World world = this.manager.getWorld();
        if (world.func_82737_E() % 3L == 0L && this.isGrowing && this.size < this.maxSize) {
            ++this.size;
        }
        float tempAdjustRate = (float)ConfigMisc.Storm_TemperatureAdjustRate;
        int levelWaterBuildRate = ConfigMisc.Storm_Rain_WaterBuildUpRate;
        int levelWaterSpendRate = ConfigMisc.Storm_Rain_WaterSpendRate;
        int randomChanceOfWaterBuildFromWater = ConfigMisc.Storm_Rain_WaterBuildUpOddsTo1FromSource;
        int randomChanceOfWaterBuildFromNothing = ConfigMisc.Storm_Rain_WaterBuildUpOddsTo1FromNothing;
        boolean isInOcean = false;
        boolean isOverWater = false;
        if (world.func_82737_E() % (long)ConfigMisc.Storm_AllTypes_TickRateDelay == 0L) {
            Block blockID;
            NBTTagCompound playerNBT = PlayerData.getPlayerNBT(this.userSpawnedFor);
            long lastStormDeadlyTime = playerNBT.func_74763_f("lastStormDeadlyTime");
            BiomeGenBase bgb = world.func_72807_a(MathHelper.func_76128_c((double)this.pos.field_72450_a), MathHelper.func_76128_c((double)this.pos.field_72449_c));
            if (bgb != null) {
                isInOcean = bgb.field_76791_y.contains("Ocean") || bgb.field_76791_y.contains("ocean");
                float biomeTempAdj = this.getTemperatureMCToWeatherSys(bgb.func_150564_a(MathHelper.func_76128_c((double)this.pos.field_72450_a), MathHelper.func_76128_c((double)this.pos.field_72448_b), MathHelper.func_76128_c((double)this.pos.field_72449_c)));
                this.levelTemperature = this.levelTemperature > biomeTempAdj ? (this.levelTemperature -= tempAdjustRate) : (this.levelTemperature += tempAdjustRate);
            }
            boolean performBuildup = false;
            Random rand = new Random();
            if (!this.isPrecipitating() && rand.nextInt(randomChanceOfWaterBuildFromNothing) == 0) {
                performBuildup = true;
            }
            if (!CoroUtilBlock.isAir((Block)(blockID = world.func_147439_a(MathHelper.func_76128_c((double)this.pos.field_72450_a), this.currentTopYBlock - 1, MathHelper.func_76128_c((double)this.pos.field_72449_c)))) && blockID.func_149688_o() instanceof MaterialLiquid) {
                isOverWater = true;
            }
            if (!performBuildup && !this.isPrecipitating() && rand.nextInt(randomChanceOfWaterBuildFromWater) == 0) {
                if (isOverWater) {
                    performBuildup = true;
                }
                if (!performBuildup && bgb != null && (isInOcean || bgb.field_76791_y.contains("Swamp") || bgb.field_76791_y.contains("Jungle") || bgb.field_76791_y.contains("River"))) {
                    performBuildup = true;
                }
            }
            if (performBuildup) {
                this.levelWater += levelWaterBuildRate;
            }
            if (this.isPrecipitating()) {
                this.levelWater -= levelWaterSpendRate;
                if (this.levelWater < 0) {
                    this.levelWater = 0;
                }
                if (this.levelWater <= 0) {
                    this.setPrecipitating(false);
                    Weather.dbg("ending raining for: " + this.ID);
                }
            } else if ((!ConfigMisc.overcastMode || this.manager.getWorld().func_72896_J()) && this.levelWater >= this.levelWaterStartRaining && ConfigMisc.Player_Storm_Rain_OddsTo1 != -1 && rand.nextInt(ConfigMisc.Player_Storm_Rain_OddsTo1) == 0) {
                this.setPrecipitating(true);
                Weather.dbg("starting raining for: " + this.ID);
            }
            WeatherManagerServer wm = ServerTickHandler.lookupDimToWeatherMan.get(world.field_73011_w.field_76574_g);
            boolean tryFormStorm = false;
            if (ConfigMisc.Server_Storm_Deadly_UseGlobalRate) {
                if (ConfigMisc.Server_Storm_Deadly_TimeBetweenInTicks != -1 && (wm.lastStormFormed == 0L || wm.lastStormFormed + (long)ConfigMisc.Server_Storm_Deadly_TimeBetweenInTicks < world.func_82737_E())) {
                    tryFormStorm = true;
                }
            } else if (ConfigMisc.Player_Storm_Deadly_TimeBetweenInTicks != -1 && (lastStormDeadlyTime == 0L || lastStormDeadlyTime + (long)ConfigMisc.Player_Storm_Deadly_TimeBetweenInTicks < world.func_82737_E())) {
                tryFormStorm = true;
            }
            if ((ConfigMisc.overcastMode && this.manager.getWorld().func_72896_J() || !ConfigMisc.overcastMode) && WeatherUtilConfig.listDimensionsStorms.contains(this.manager.getWorld().field_73011_w.field_76574_g) && tryFormStorm) {
                int stormFrontCollideDist = ConfigMisc.Storm_Deadly_CollideDistance;
                int randomChanceOfCollide = ConfigMisc.Player_Storm_Deadly_OddsTo1;
                if (isInOcean && ConfigMisc.Storm_OddsTo1OfOceanBasedStorm > 0 && rand.nextInt(ConfigMisc.Storm_OddsTo1OfOceanBasedStorm) == 0) {
                    EntityPlayer entP = world.func_72924_a(this.userSpawnedFor);
                    if (entP != null) {
                        this.initRealStorm(entP, null);
                    } else {
                        this.initRealStorm(null, null);
                    }
                    if (ConfigMisc.Server_Storm_Deadly_UseGlobalRate) {
                        wm.lastStormFormed = world.func_82737_E();
                    } else {
                        playerNBT.func_74772_a("lastStormDeadlyTime", world.func_82737_E());
                    }
                } else if (!isInOcean && ConfigMisc.Storm_OddsTo1OfLandBasedStorm > 0 && rand.nextInt(ConfigMisc.Storm_OddsTo1OfLandBasedStorm) == 0) {
                    EntityPlayer entP = world.func_72924_a(this.userSpawnedFor);
                    if (entP != null) {
                        this.initRealStorm(entP, null);
                    } else {
                        this.initRealStorm(null, null);
                    }
                    if (ConfigMisc.Server_Storm_Deadly_UseGlobalRate) {
                        wm.lastStormFormed = world.func_82737_E();
                    } else {
                        playerNBT.func_74772_a("lastStormDeadlyTime", world.func_82737_E());
                    }
                } else if (rand.nextInt(randomChanceOfCollide) == 0) {
                    for (int i = 0; i < this.manager.getStormObjects().size(); ++i) {
                        StormObject so = this.manager.getStormObjects().get(i);
                        boolean startStorm = false;
                        if (so.ID != this.ID && so.levelCurIntensityStage <= 0 && so.pos.func_72438_d(this.pos) < (double)stormFrontCollideDist) {
                            if (this.levelTemperature < 0.0f) {
                                if (so.levelTemperature > 0.0f) {
                                    startStorm = true;
                                }
                            } else if (this.levelTemperature > 0.0f && so.levelTemperature < 0.0f) {
                                startStorm = true;
                            }
                        }
                        if (!startStorm) continue;
                        playerNBT.func_74772_a("lastStormDeadlyTime", world.func_82737_E());
                        EntityPlayer entP = world.func_72924_a(this.userSpawnedFor);
                        if (entP != null) {
                            this.initRealStorm(entP, so);
                            break;
                        }
                        this.initRealStorm(null, so);
                        break;
                    }
                }
            }
            if (this.isRealStorm()) {
                if (ConfigMisc.overcastMode && !this.manager.getWorld().func_72896_J()) {
                    this.hasStormPeaked = true;
                }
                if (!this.hasStormPeaked) {
                    this.levelWater = this.levelWaterStartRaining;
                    this.setPrecipitating(true);
                }
                if ((this.levelCurIntensityStage == STATE_HIGHWIND || this.levelCurIntensityStage == STATE_HAIL) && isOverWater) {
                    if (ConfigMisc.Storm_OddsTo1OfHighWindWaterSpout != 0 && rand.nextInt(ConfigMisc.Storm_OddsTo1OfHighWindWaterSpout) == 0) {
                        this.attrib_waterSpout = true;
                    }
                } else {
                    this.attrib_waterSpout = false;
                }
                float levelStormIntensityRate = 0.02f;
                float minIntensityToProgress = 0.6f;
                int oddsTo1OfIntensityProgressionBase = ConfigMisc.Storm_OddsTo1OfProgressionBase;
                if ((float)this.levelCurIntensityStage >= levelStormIntensityFormingStartVal) {
                    levelStormIntensityRate *= 3.0f;
                    oddsTo1OfIntensityProgressionBase /= 3;
                }
                int oddsTo1OfIntensityProgression = oddsTo1OfIntensityProgressionBase + this.levelCurIntensityStage * ConfigMisc.Storm_OddsTo1OfProgressionStageMultiplier;
                if (!this.hasStormPeaked) {
                    this.levelCurStagesIntensity += levelStormIntensityRate;
                    if (!(this.levelCurIntensityStage >= this.maxIntensityStage || ConfigMisc.Storm_NoTornadosOrCyclones && this.levelCurIntensityStage >= STATE_FORMING - 1 || !(this.levelCurStagesIntensity >= minIntensityToProgress) || !this.alwaysProgresses && rand.nextInt(oddsTo1OfIntensityProgression) != 0)) {
                        this.stageNext();
                        Weather.dbg("storm ID: " + this.ID + " - growing, stage: " + this.levelCurIntensityStage);
                        if (isInOcean && this.levelCurIntensityStage == STATE_FORMING) {
                            Weather.dbg("storm ID: " + this.ID + " marked as tropical cyclone!");
                            this.stormType = TYPE_WATER;
                        }
                    }
                    if (this.levelCurStagesIntensity >= 1.0f) {
                        Weather.dbg("storm peaked at: " + this.levelCurIntensityStage);
                        this.hasStormPeaked = true;
                    }
                } else {
                    this.levelCurStagesIntensity = ConfigMisc.overcastMode && this.manager.getWorld().func_72896_J() ? (this.levelCurStagesIntensity -= levelStormIntensityRate * 0.9f) : (this.levelCurStagesIntensity -= levelStormIntensityRate * 0.3f);
                    if (this.levelCurStagesIntensity <= 0.0f) {
                        this.stagePrev();
                        Weather.dbg("storm ID: " + this.ID + " - dying, stage: " + this.levelCurIntensityStage);
                        if (this.levelCurIntensityStage <= 0) {
                            this.setNoStorm();
                        }
                    }
                }
            } else if (ConfigMisc.overcastMode && !this.manager.getWorld().func_72896_J() && this.attrib_precipitation) {
                this.setPrecipitating(false);
            }
        }
    }

    public WeatherEntityConfig getWeatherEntityConfigForStorm() {
        WeatherEntityConfig weatherConfig = WeatherTypes.weatherEntTypes.get(0);
        if (this.levelCurIntensityStage >= STATE_STAGE5) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(5);
        } else if (this.levelCurIntensityStage >= STATE_STAGE4) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(4);
        } else if (this.levelCurIntensityStage >= STATE_STAGE3) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(3);
        } else if (this.levelCurIntensityStage >= STATE_STAGE2) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(2);
        } else if (this.levelCurIntensityStage >= STATE_STAGE1) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(1);
        } else if (this.levelCurIntensityStage >= STATE_FORMING) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(0);
        }
        return weatherConfig;
    }

    public void stageNext() {
        ++this.levelCurIntensityStage;
        this.levelCurStagesIntensity = 0.0f;
        if (ConfigMisc.Storm_Tornado_aimAtPlayerOnSpawn && !this.hasStormPeaked && this.levelCurIntensityStage == STATE_FORMING) {
            this.aimStormAtClosestOrProvidedPlayer(null);
        }
    }

    public void stagePrev() {
        --this.levelCurIntensityStage;
        this.levelCurStagesIntensity = 1.0f;
    }

    public void initRealStorm(EntityPlayer entP, StormObject stormToAbsorb) {
        this.levelCurIntensityStage = STATE_THUNDER;
        float diff = 4.0f;
        if (stormToAbsorb != null) {
            diff = this.levelTemperature - stormToAbsorb.levelTemperature;
        }
        if (this.naturallySpawned) {
            this.levelWater = this.levelWaterStartRaining * 2;
        }
        this.attrib_precipitation = true;
        if (stormToAbsorb != null) {
            Weather.dbg("stormfront collision happened between ID " + this.ID + " and " + stormToAbsorb.ID);
            this.manager.removeStormObject(stormToAbsorb.ID);
            ((WeatherManagerServer)this.manager).syncStormRemove(stormToAbsorb);
        } else {
            Weather.dbg("ocean storm happened, ID " + this.ID);
        }
        if (ConfigMisc.Storm_Tornado_aimAtPlayerOnSpawn && entP != null) {
            this.aimStormAtClosestOrProvidedPlayer(entP);
        }
    }

    public void aimStormAtClosestOrProvidedPlayer(EntityPlayer entP) {
        if (entP == null) {
            entP = this.manager.getWorld().func_72977_a(this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c, -1.0);
        }
        if (entP != null) {
            Random rand = new Random();
            double var11 = entP.field_70165_t - this.pos.field_72450_a;
            double var15 = entP.field_70161_v - this.pos.field_72449_c;
            float yaw = -((float)(Math.atan2(var11, var15) * 180.0 / Math.PI));
            int size = ConfigMisc.Storm_Tornado_aimAtPlayerAngleVariance;
            if (size > 0) {
                yaw += (float)(rand.nextInt(size) - size / 2);
            }
            this.angleIsOverridden = true;
            this.angleMovementTornadoOverride = yaw;
            Weather.dbg("stormfront aimed at player " + CoroUtilEntity.getName((Entity)entP));
        }
    }

    public void setNoStorm() {
        Weather.dbg("storm ID: " + this.ID + " - ended storm event");
        this.levelCurIntensityStage = STATE_NORMAL;
        this.levelCurStagesIntensity = 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void tickClient() {
        EntityRotFX ent;
        int i;
        EntityRotFX particle;
        Vec3 tryPos;
        double spawnRad;
        int i2;
        if (this.particleBehaviorFog == null) {
            this.particleBehaviorFog = new ParticleBehaviorFog(Vec3.func_72443_a((double)this.pos.field_72450_a, (double)this.pos.field_72448_b, (double)this.pos.field_72449_c));
        } else if (!Minecraft.func_71410_x().func_71356_B() || !(Minecraft.func_71410_x().field_71462_r instanceof GuiIngameMenu)) {
            this.particleBehaviorFog.tickUpdateList();
        }
        EntityClientPlayerMP entP = Minecraft.func_71410_x().field_71439_g;
        this.spinSpeed = 0.02;
        double spinSpeedMax = 0.4;
        this.spinSpeed = this.isCycloneFormingOrGreater() ? spinSpeedMax * 0.0 + (double)((float)this.levelCurIntensityStage - levelStormIntensityFormingStartVal + 1.0f) * spinSpeedMax * 0.2 : (this.isTornadoFormingOrGreater() ? spinSpeedMax * 0.2 : (this.levelCurIntensityStage >= STATE_HIGHWIND ? spinSpeedMax * 0.05 : spinSpeedMax * 0.02));
        if (this.isHurricane()) {
            this.spinSpeed += 0.1;
        }
        if (this.size == 0) {
            this.size = 1;
        }
        int delay = Math.max(1, (int)(100.0f / (float)this.size * 1.0f));
        int loopSize = 1;
        int extraSpawning = 0;
        if (this.isSpinning()) {
            loopSize += 4;
            extraSpawning = 300;
        }
        if (this.stormType == TYPE_WATER) {
            if (this.levelCurIntensityStage >= STATE_STAGE5) {
                loopSize = 10;
                extraSpawning = 800;
            } else if (this.levelCurIntensityStage >= STATE_STAGE4) {
                loopSize = 8;
                extraSpawning = 700;
            } else if (this.levelCurIntensityStage >= STATE_STAGE3) {
                loopSize = 6;
                extraSpawning = 500;
            } else if (this.levelCurIntensityStage >= STATE_STAGE2) {
                loopSize = 4;
                extraSpawning = 400;
            } else {
                extraSpawning = 300;
            }
        }
        Random rand = new Random();
        Vec3 playerAdjPos = Vec3.func_72443_a((double)entP.field_70165_t, (double)this.pos.field_72448_b, (double)entP.field_70161_v);
        double maxSpawnDistFromPlayer = 512.0;
        if (this.manager.getWorld().func_82737_E() % (long)(delay + ConfigMisc.Cloud_ParticleSpawnDelay) == 0L) {
            for (i2 = 0; i2 < loopSize; ++i2) {
                if (this.listParticlesCloud.size() >= this.size + extraSpawning) continue;
                spawnRad = this.size;
                if (this.layer != 0) {
                    spawnRad = this.size * 5;
                }
                if (!((tryPos = Vec3.func_72443_a((double)(this.pos.field_72450_a + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad), (double)layers.get(this.layer).intValue(), (double)(this.pos.field_72449_c + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad))).func_72438_d(playerAdjPos) < maxSpawnDistFromPlayer)) continue;
                particle = this.spawnFogParticle(tryPos.field_72450_a, tryPos.field_72448_b, tryPos.field_72449_c, 2);
                this.listParticlesCloud.add(particle);
            }
        }
        if (this.levelCurIntensityStage >= STATE_HIGHWIND) {
            for (i2 = 0; i2 < (this.stormType == TYPE_WATER ? 50 : 3); ++i2) {
                if (this.listParticlesGround.size() >= (this.stormType == TYPE_WATER ? 600 : 150)) continue;
                spawnRad = this.size / 4 * 3;
                if (this.stormType == TYPE_WATER) {
                    spawnRad = this.size * 3;
                }
                if (!((tryPos = Vec3.func_72443_a((double)(this.pos.field_72450_a + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad), (double)this.posGround.field_72448_b, (double)(this.pos.field_72449_c + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad))).func_72438_d(playerAdjPos) < maxSpawnDistFromPlayer)) continue;
                int groundY = this.manager.getWorld().func_72976_f((int)tryPos.field_72450_a, (int)tryPos.field_72449_c);
                EntityRotFX particle2 = this.spawnFogParticle(tryPos.field_72450_a, groundY + 3, tryPos.field_72449_c, 2);
                particle2.setScale(100.0f);
                particle2.field_70177_z = rand.nextInt(360);
                particle2.field_70125_A = rand.nextInt(360);
                this.listParticlesGround.add(particle2);
            }
        }
        delay = 1;
        loopSize = 2;
        double spawnRad2 = this.size / 48;
        if (this.levelCurIntensityStage >= STATE_STAGE5) {
            spawnRad2 = 200.0;
            loopSize = 10;
            this.sizeMaxFunnelParticles = 1200;
        } else if (this.levelCurIntensityStage >= STATE_STAGE4) {
            spawnRad2 = 150.0;
            loopSize = 8;
            this.sizeMaxFunnelParticles = 1000;
        } else if (this.levelCurIntensityStage >= STATE_STAGE3) {
            spawnRad2 = 100.0;
            loopSize = 6;
            this.sizeMaxFunnelParticles = 800;
        } else if (this.levelCurIntensityStage >= STATE_STAGE2) {
            spawnRad2 = 50.0;
            loopSize = 4;
            this.sizeMaxFunnelParticles = 600;
        } else {
            this.sizeMaxFunnelParticles = 600;
        }
        if ((this.isTornadoFormingOrGreater() || this.attrib_waterSpout) && this.manager.getWorld().func_82737_E() % (long)(delay + ConfigMisc.Storm_ParticleSpawnDelay) == 0L) {
            for (i = 0; i < loopSize; ++i) {
                if (this.listParticlesFunnel.size() >= this.sizeMaxFunnelParticles) {
                    this.listParticlesFunnel.get(0).func_70106_y();
                    this.listParticlesFunnel.remove(0);
                }
                if (this.listParticlesFunnel.size() >= this.sizeMaxFunnelParticles || !((tryPos = Vec3.func_72443_a((double)(this.pos.field_72450_a + rand.nextDouble() * spawnRad2 - rand.nextDouble() * spawnRad2), (double)this.pos.field_72448_b, (double)(this.pos.field_72449_c + rand.nextDouble() * spawnRad2 - rand.nextDouble() * spawnRad2))).func_72438_d(playerAdjPos) < maxSpawnDistFromPlayer)) continue;
                particle = this.spawnFogParticle(tryPos.field_72450_a, this.posBaseFormationPos.field_72448_b, tryPos.field_72449_c, 3);
                particle.setMaxAge(150 + (this.levelCurIntensityStage - 1) * 100 + rand.nextInt(100));
                float baseBright = 0.3f;
                float randFloat = rand.nextFloat() * 0.6f;
                particle.field_70177_z = rand.nextInt(360);
                float finalBright = Math.min(1.0f, baseBright + randFloat);
                if (this.levelCurIntensityStage == STATE_HIGHWIND) {
                    particle.setScale(150.0f);
                    particle.func_70538_b(finalBright - 0.2f, finalBright - 0.2f, finalBright);
                } else {
                    particle.setScale(250.0f);
                    particle.func_70538_b(finalBright, finalBright, finalBright);
                }
                this.listParticlesFunnel.add(particle);
            }
        }
        for (i = 0; i < this.listParticlesFunnel.size(); ++i) {
            int fadingDistStart;
            ent = this.listParticlesFunnel.get(i);
            if (ent.field_70128_L) {
                this.listParticlesFunnel.remove(ent);
                continue;
            }
            if (ent.field_70163_u > this.pos.field_72448_b) {
                ent.func_70106_y();
                this.listParticlesFunnel.remove(ent);
                continue;
            }
            double var16 = this.pos.field_72450_a - ent.field_70165_t;
            double var18 = this.pos.field_72449_c - ent.field_70161_v;
            ent.field_70177_z = (float)(Math.atan2(var18, var16) * 180.0 / Math.PI) - 90.0f;
            ent.field_70177_z += (float)(ent.func_145782_y() % 90);
            ent.field_70125_A = -30.0f;
            if (this.levelCurIntensityStage == STATE_HIGHWIND && ent.field_70163_u > this.posGround.field_72448_b + (double)(fadingDistStart = 30)) {
                float maxVal = ent.func_70535_g();
                float fadeRate = 0.002f;
                ent.func_70538_b(Math.min(maxVal, ent.func_70534_d() + fadeRate), Math.min(maxVal, ent.func_70542_f() + fadeRate), maxVal);
            }
            this.spinEntity((Entity)ent);
        }
        for (i = 0; i < this.listParticlesCloud.size(); ++i) {
            ent = this.listParticlesCloud.get(i);
            if (ent.field_70128_L) {
                this.listParticlesCloud.remove(ent);
                continue;
            }
            double curSpeed = Math.sqrt(ent.field_70159_w * ent.field_70159_w + ent.field_70181_x * ent.field_70181_x + ent.field_70179_y * ent.field_70179_y);
            double curDist = ent.func_70011_f(this.pos.field_72450_a, ent.field_70163_u, this.pos.field_72449_c);
            float dropDownRange = 15.0f;
            float extraDropCalc = 0.0f;
            if (curDist < 200.0 && ent.func_145782_y() % 20 < 5) {
                extraDropCalc = (float)(ent.func_145782_y() % 20) * dropDownRange;
                if (this.isCycloneFormingOrGreater()) {
                    extraDropCalc = (float)(ent.func_145782_y() % 20) * dropDownRange * 5.0f;
                }
            }
            if (this.isSpinning()) {
                double speed = this.spinSpeed + rand.nextDouble() * 0.01;
                double distt = this.size;
                double vecX = ent.field_70165_t - this.pos.field_72450_a;
                double vecZ = ent.field_70161_v - this.pos.field_72449_c;
                float angle = (float)(Math.atan2(vecZ, vecX) * 180.0 / Math.PI);
                angle = (float)((double)angle + speed * 50.0);
                angle = (float)((double)angle - (double)(ent.func_145782_y() % 10) * 3.0);
                angle += (float)(rand.nextInt(10) - rand.nextInt(10));
                if (curDist > distt) {
                    angle += 40.0f;
                }
                if (ent.func_145782_y() % 20 < 5) {
                    if (this.levelCurIntensityStage >= STATE_FORMING) {
                        if (this.stormType == TYPE_WATER) {
                            angle += (float)(40 + ent.func_145782_y() % 5 * 4);
                            if (curDist > (double)(150.0f + ((float)this.levelCurIntensityStage - levelStormIntensityFormingStartVal + 1.0f) * 30.0f)) {
                                angle += 10.0f;
                            }
                        } else {
                            angle += (float)(30 + ent.func_145782_y() % 5 * 4);
                        }
                    } else if (curDist > 150.0) {
                        angle += (float)(50 + ent.func_145782_y() % 5 * 4);
                    }
                    double var16 = this.pos.field_72450_a - ent.field_70165_t;
                    double var18 = this.pos.field_72449_c - ent.field_70161_v;
                    ent.field_70177_z = (float)(Math.atan2(var18, var16) * 180.0 / Math.PI) - 90.0f;
                    ent.field_70125_A = -20.0f - (float)(ent.func_145782_y() % 10);
                }
                if (curSpeed < speed * 20.0) {
                    ent.field_70159_w += -Math.sin(Math.toRadians(angle)) * speed;
                    ent.field_70179_y += Math.cos(Math.toRadians(angle)) * speed;
                }
            } else {
                float cloudMoveAmp = 0.2f * (float)(1 + this.layer);
                float speed = this.getAdjustedSpeed() * cloudMoveAmp;
                float angle = this.getAdjustedAngle();
                dropDownRange = 5.0f;
                if (ent.func_145782_y() % 20 < 5) {
                    extraDropCalc = (float)(ent.func_145782_y() % 20) * dropDownRange;
                }
                if (curSpeed < (double)speed * 1.0) {
                    ent.field_70159_w += -Math.sin(Math.toRadians(angle)) * (double)speed;
                    ent.field_70179_y += Math.cos(Math.toRadians(angle)) * (double)speed;
                }
            }
            if (Math.abs(ent.field_70163_u - (this.pos.field_72448_b - (double)extraDropCalc)) > 2.0) {
                ent.field_70181_x = ent.field_70163_u < this.pos.field_72448_b - (double)extraDropCalc ? (ent.field_70181_x += 0.1) : (ent.field_70181_x -= 0.1);
            }
            float dropDownSpeedMax = 0.15f;
            if (this.isCycloneFormingOrGreater()) {
                dropDownSpeedMax = 0.9f;
            }
            if (ent.field_70181_x < (double)(-dropDownSpeedMax)) {
                ent.field_70181_x = -dropDownSpeedMax;
            }
            if (!(ent.field_70181_x > (double)dropDownSpeedMax)) continue;
            ent.field_70181_x = dropDownSpeedMax;
        }
        for (i = 0; i < this.listParticlesGround.size(); ++i) {
            ent = this.listParticlesGround.get(i);
            double curDist = ent.func_70011_f(this.pos.field_72450_a, ent.field_70163_u, this.pos.field_72449_c);
            if (ent.field_70128_L) {
                this.listParticlesGround.remove(ent);
                continue;
            }
            double curSpeed = Math.sqrt(ent.field_70159_w * ent.field_70159_w + ent.field_70181_x * ent.field_70181_x + ent.field_70179_y * ent.field_70179_y);
            double speed = Math.max((double)0.2f, 5.0 * this.spinSpeed) + rand.nextDouble() * 0.01;
            double distt = this.size;
            double vecX = ent.field_70165_t - this.pos.field_72450_a;
            double vecZ = ent.field_70161_v - this.pos.field_72449_c;
            float angle = (float)(Math.atan2(vecZ, vecX) * 180.0 / Math.PI);
            angle += 85.0f;
            int maxParticleSize = 60;
            if (this.stormType == TYPE_WATER) {
                maxParticleSize = 150;
                speed /= 5.0;
            }
            ent.setScale((float)Math.min((double)maxParticleSize, curDist * 2.0));
            if (curDist < 20.0) {
                ent.func_70106_y();
            }
            double var16 = this.pos.field_72450_a - ent.field_70165_t;
            double var18 = this.pos.field_72449_c - ent.field_70161_v;
            if (!(curSpeed < speed * 20.0)) continue;
            ent.field_70159_w += -Math.sin(Math.toRadians(angle)) * speed;
            ent.field_70179_y += Math.cos(Math.toRadians(angle)) * speed;
        }
    }

    public float getAdjustedSpeed() {
        return this.manager.windMan.getWindSpeedForClouds();
    }

    public float getAdjustedAngle() {
        float angle = this.manager.windMan.getWindAngleForClouds();
        float angleAdjust = Math.max(10.0f, Math.min(45.0f, 45.0f * this.levelTemperature * 0.2f));
        float targetYaw = 0.0f;
        targetYaw = this.levelTemperature > 0.0f ? 180.0f : 0.0f;
        float bestMove = MathHelper.func_76142_g((float)(targetYaw - angle));
        if (Math.abs(bestMove) < 180.0f) {
            if (bestMove > 0.0f) {
                angle -= angleAdjust;
            }
            if (bestMove < 0.0f) {
                angle += angleAdjust;
            }
        }
        return angle;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void spinEntity(Entity entity1) {
        long lastPullTime;
        double adjPull;
        float f;
        float f1;
        StormObject entT = this;
        StormObject entity = this;
        WeatherEntityConfig conf = this.getWeatherEntityConfigForStorm();
        Random rand = new Random();
        boolean forTornado = true;
        double radius = 10.0;
        double scale = conf.tornadoWidthScale;
        double d1 = entity.pos.field_72450_a - entity1.field_70165_t;
        double d2 = entity.pos.field_72449_c - entity1.field_70161_v;
        if (conf.type == WeatherEntityConfig.TYPE_SPOUT) {
            float range = 30.0f * (float)Math.sin(Math.toRadians(((float)entity1.field_70170_p.func_82737_E() * 0.5f + (float)(this.ID * 50L)) % 360.0f));
            float heightPercent = (float)(1.0 - (entity1.field_70163_u - this.posGround.field_72448_b) / (this.pos.field_72448_b - this.posGround.field_72448_b));
            float posOffsetX = (float)Math.sin(Math.toRadians(heightPercent * 360.0f));
            float posOffsetZ = (float)(-Math.cos(Math.toRadians(heightPercent * 360.0f)));
            d1 += (double)(range * posOffsetX);
            d2 += (double)(range * posOffsetZ);
        }
        for (f1 = f = (float)(Math.atan2(d2, d1) * 180.0 / Math.PI) - 90.0f; f1 < -180.0f; f1 += 360.0f) {
        }
        while (f1 >= 180.0f) {
            f1 -= 360.0f;
        }
        double distY = entity.pos.field_72448_b - entity1.field_70163_u;
        double distXZ = Math.sqrt(Math.abs(d1)) + Math.sqrt(Math.abs(d2));
        distY = entity1.field_70163_u - entity.pos.field_72448_b < 0.0 ? 1.0 : entity1.field_70163_u - entity.pos.field_72448_b;
        if (distY > (double)this.maxHeight) {
            distY = this.maxHeight;
        }
        double grab = 10.0 / (double)WeatherUtilEntity.getWeight(entity1, forTornado) * (Math.abs((double)this.maxHeight - distY) / (double)this.maxHeight);
        float pullY = 0.0f;
        if (rand.nextInt(5) != 0) {
            // empty if block
        }
        if (distXZ > 5.0) {
            grab *= radius / distXZ;
        }
        pullY += conf.tornadoLiftRate / (WeatherUtilEntity.getWeight(entity1, forTornado) / 2.0f);
        if (entity1 instanceof EntityPlayer) {
            adjPull = 0.2 / ((double)WeatherUtilEntity.getWeight(entity1, forTornado) * ((distXZ + 1.0) / radius));
            pullY = (float)((double)pullY + adjPull);
            double adjGrab = 10.0 * (double)((float)(((double)WeatherUtilEntity.playerInAirTime + 1.0) / 400.0));
            if (adjGrab > 50.0) {
                adjGrab = 50.0;
            }
            if (adjGrab < -50.0) {
                adjGrab = -50.0;
            }
            grab -= adjGrab;
            if (entity1.field_70181_x > -0.8) {
                entity1.field_70143_R = 0.0f;
            } else if (!(entity1.field_70181_x > -1.5)) {
                // empty if block
            }
        } else if (entity1 instanceof EntityLivingBase) {
            adjPull = 0.005 / ((double)WeatherUtilEntity.getWeight(entity1, forTornado) * ((distXZ + 1.0) / radius));
            pullY = (float)((double)pullY + adjPull);
            int airTime = entity1.getEntityData().func_74762_e("timeInAir");
            double adjGrab = 10.0 * (double)((float)(((double)airTime + 1.0) / 400.0));
            if (adjGrab > 50.0) {
                adjGrab = 50.0;
            }
            if (adjGrab < -50.0) {
                adjGrab = -50.0;
            }
            grab -= adjGrab;
            if (entity1.field_70181_x > -1.5) {
                entity1.field_70143_R = 0.0f;
            }
            if (entity1.field_70181_x > (double)0.3f) {
                entity1.field_70181_x = 0.3f;
            }
            if (forTornado) {
                entity1.field_70122_E = false;
            }
        }
        double profileAngle = Math.max(1.0, 75.0 + (grab += (double)conf.relTornadoSize) - 10.0 * scale);
        f1 = (float)((double)f1 + profileAngle);
        if (entT != null && entT.scale != 1.0f) {
            f1 += 20.0f - 20.0f * entT.scale;
        }
        float f3 = (float)Math.cos(-f1 * 0.01745329f - (float)Math.PI);
        float f4 = (float)Math.sin(-f1 * 0.01745329f - (float)Math.PI);
        float f5 = conf.tornadoPullRate * 1.0f;
        if (entT != null && entT.scale != 1.0f) {
            f5 *= entT.scale * 1.2f;
        }
        if (entity1 instanceof EntityLivingBase) {
            f5 = (float)((double)f5 / ((double)WeatherUtilEntity.getWeight(entity1, forTornado) * ((distXZ + 1.0) / radius)));
        }
        if (entity1 instanceof EntityPlayer && conf.type != 0) {
            f5 = entity1.field_70122_E ? (f5 *= 10.5f) : (f5 *= 5.0f);
        } else if (entity1 instanceof EntityLivingBase && conf.type != 0) {
            f5 *= 1.5f;
        }
        if (conf.type == WeatherEntityConfig.TYPE_SPOUT && entity1 instanceof EntityLivingBase) {
            f5 *= 0.3f;
        }
        float moveX = f3 * f5;
        float moveZ = f4 * f5;
        float str = 1.0f;
        str = this.strength;
        if (conf.type == WeatherEntityConfig.TYPE_SPOUT && entity1 instanceof EntityLivingBase) {
            str *= 0.3f;
        }
        pullY *= str / 100.0f;
        if (entT != null && entT.scale != 1.0f) {
            pullY *= entT.scale * 1.0f;
            pullY += 0.002f;
        }
        if ((lastPullTime = entity1.getEntityData().func_74763_f("lastPullTime")) == entity1.field_70170_p.func_82737_E()) {
            pullY = 0.0f;
        }
        entity1.getEntityData().func_74772_a("lastPullTime", entity1.field_70170_p.func_82737_E());
        this.setVel(entity1, -moveX, pullY, moveZ);
    }

    public void setVel(Entity entity, float f, float f1, float f2) {
        entity.field_70159_w += (double)f;
        entity.field_70181_x += (double)f1;
        entity.field_70179_y += (double)f2;
        if (entity instanceof EntitySquid) {
            entity.func_70107_b(entity.field_70165_t + entity.field_70159_w * 5.0, entity.field_70163_u, entity.field_70161_v + entity.field_70179_y * 5.0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EntityRotFX spawnFogParticle(double x, double y, double z, int parRenderOrder) {
        double speed = 0.0;
        Random rand = new Random();
        EntityRotFX entityfx = this.particleBehaviorFog.spawnNewParticleIconFX((World)Minecraft.func_71410_x().field_71441_e, ParticleRegistry.cloud256, x, y, z, (rand.nextDouble() - rand.nextDouble()) * speed, 0.0, (rand.nextDouble() - rand.nextDouble()) * speed, parRenderOrder);
        this.particleBehaviorFog.initParticle(entityfx);
        entityfx.field_70145_X = true;
        entityfx.callUpdatePB = false;
        boolean debug = false;
        if (debug) {
            // empty if block
        }
        if (this.levelCurIntensityStage == STATE_NORMAL) {
            entityfx.setMaxAge(300 + rand.nextInt(100));
        } else {
            entityfx.setMaxAge(this.size / 2 + rand.nextInt(100));
        }
        if (entityfx.func_145782_y() % 20 < 5 && this.isSpinning()) {
            entityfx.renderOrder = 3;
            entityfx.setMaxAge(this.size + rand.nextInt(100));
        }
        float randFloat = rand.nextFloat() * 0.6f;
        float baseBright = 0.7f;
        if (this.levelCurIntensityStage > STATE_NORMAL) {
            baseBright = 0.2f;
        } else if (this.attrib_precipitation) {
            baseBright = 0.2f;
        } else if (this.manager.isVanillaRainActiveOnServer) {
            baseBright = 0.2f;
        } else {
            float adj = Math.min(1.0f, (float)(this.levelWater / this.levelWaterStartRaining)) * 0.6f;
            baseBright -= adj;
        }
        if (this.layer == 1) {
            baseBright = 0.1f;
        }
        float finalBright = Math.min(1.0f, baseBright + randFloat);
        entityfx.func_70538_b(finalBright, finalBright, finalBright);
        if (debug) {
            if (this.levelTemperature < 0.0f) {
                entityfx.func_70538_b(0.0f, 0.0f, finalBright);
            } else if (this.levelTemperature > 0.0f) {
                entityfx.func_70538_b(finalBright, 0.0f, 0.0f);
            }
        }
        ExtendedRenderer.rotEffRenderer.addEffect((EntityFX)entityfx);
        this.particleBehaviorFog.particles.add(entityfx);
        return entityfx;
    }

    public void reset() {
        this.setDead();
    }

    public void setDead() {
        this.isDead = true;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.cleanupClient();
        }
        this.cleanup();
    }

    public void cleanup() {
        this.manager = null;
        if (this.tornadoHelper != null) {
            this.tornadoHelper.storm = null;
        }
        this.tornadoHelper = null;
    }

    @SideOnly(value=Side.CLIENT)
    public void cleanupClient() {
        this.listParticlesCloud.clear();
        this.listParticlesFunnel.clear();
        if (this.particleBehaviorFog != null && this.particleBehaviorFog.particles != null) {
            this.particleBehaviorFog.particles.clear();
        }
        this.particleBehaviorFog = null;
    }

    public float getTemperatureMCToWeatherSys(float parOrigVal) {
        parOrigVal = (float)((double)parOrigVal - 0.7);
        return parOrigVal *= 2.0f;
    }

    public void addWeatherEffectLightning(EntityLightningBolt parEnt) {
        this.manager.getWorld().field_73007_j.add(parEnt);
        ((WeatherManagerServer)this.manager).syncLightningNew(parEnt);
    }

    public class CachedNBTTagCompound {
        private NBTTagCompound newData;
        private NBTTagCompound cachedData;
        private boolean forced = false;

        public CachedNBTTagCompound() {
            this(new NBTTagCompound());
        }

        public CachedNBTTagCompound(NBTTagCompound newData) {
            this.newData = newData;
        }

        public void setCachedNBT(NBTTagCompound cachedData) {
            if (cachedData == null) {
                cachedData = new NBTTagCompound();
            }
            this.cachedData = cachedData;
        }

        public NBTTagCompound getCachedNBT() {
            return this.cachedData;
        }

        public NBTTagCompound getNewNBT() {
            return this.newData;
        }

        public void setUpdateForced(boolean forced) {
            this.forced = forced;
        }

        public long getLong(String key) {
            if (!this.newData.func_74764_b(key)) {
                this.newData.func_74772_a(key, this.cachedData.func_74763_f(key));
            }
            return this.newData.func_74763_f(key);
        }

        public void setLong(String key, long newVal) {
            if (!this.cachedData.func_74764_b(key) || this.cachedData.func_74763_f(key) != newVal || this.forced) {
                this.newData.func_74772_a(key, newVal);
            }
            this.cachedData.func_74772_a(key, newVal);
        }

        public int getInteger(String key) {
            if (!this.newData.func_74764_b(key)) {
                this.newData.func_74768_a(key, this.cachedData.func_74762_e(key));
            }
            return this.newData.func_74762_e(key);
        }

        public void setInteger(String key, int newVal) {
            if (!this.cachedData.func_74764_b(key) || this.cachedData.func_74762_e(key) != newVal || this.forced) {
                this.newData.func_74768_a(key, newVal);
            }
            this.cachedData.func_74768_a(key, newVal);
        }

        public short getShort(String key) {
            if (!this.newData.func_74764_b(key)) {
                this.newData.func_74777_a(key, this.cachedData.func_74765_d(key));
            }
            return this.newData.func_74765_d(key);
        }

        public void setShort(String key, short newVal) {
            if (!this.cachedData.func_74764_b(key) || this.cachedData.func_74765_d(key) != newVal || this.forced) {
                this.newData.func_74777_a(key, newVal);
            }
            this.cachedData.func_74777_a(key, newVal);
        }

        public boolean getBoolean(String key) {
            if (!this.newData.func_74764_b(key)) {
                this.newData.func_74757_a(key, this.cachedData.func_74767_n(key));
            }
            return this.newData.func_74767_n(key);
        }

        public void setBoolean(String key, boolean newVal) {
            if (!this.cachedData.func_74764_b(key) || this.cachedData.func_74767_n(key) != newVal || this.forced) {
                this.newData.func_74757_a(key, newVal);
            }
            this.cachedData.func_74757_a(key, newVal);
        }

        public float getFloat(String key) {
            if (!this.newData.func_74764_b(key)) {
                this.newData.func_74776_a(key, this.cachedData.func_74760_g(key));
            }
            return this.newData.func_74760_g(key);
        }

        public void setFloat(String key, float newVal) {
            if (!this.cachedData.func_74764_b(key) || this.cachedData.func_74760_g(key) != newVal || this.forced) {
                this.newData.func_74776_a(key, newVal);
            }
            this.cachedData.func_74776_a(key, newVal);
        }
    }
}

