/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.enderman;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.EffectHelper;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.SpecialMobData;
import toast.specialMobs.entity.enderman.Entity_SpecialEnderman;

public class EntityMirageEnderman
extends Entity_SpecialEnderman {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "enderman/mirage.png"), new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "enderman/mirage_eyes.png")};
    public boolean isFake = false;
    private int ticksAlive = 0;

    public EntityMirageEnderman(World world) {
        super(world);
        this.getSpecialData().setTextures(TEXTURES);
        this.field_70728_aV += 2;
    }

    public void setFake() {
        this.isFake = true;
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
        this.field_70728_aV = 0;
    }

    @Override
    public void adjustTypeAttributes() {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 20.0);
    }

    @Override
    protected void onTypeAttack(Entity target) {
        block1: {
            if (this.isFake) break block1;
            int i = 64;
            while (i-- > 0 && !this.func_70820_n()) {
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.isFake && this.ticksAlive++ > 200) {
            this.func_70106_y();
        }
    }

    @Override
    protected void func_70628_a(boolean hit, int looting) {
        if (!this.isFake) {
            super.func_70628_a(hit, looting);
            if (hit && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
                this.func_70099_a(new ItemStack(Blocks.field_150418_aU, 1, this.field_70146_Z.nextInt(3)), 0.0f);
            }
        }
    }

    protected void func_70600_l(int superRare) {
        if (!this.isFake) {
            ItemStack drop = new ItemStack(Items.field_151013_M);
            EffectHelper.setItemName(drop, "Ender Scythe", 13);
            drop.func_77966_a(Enchantment.field_77335_o, 5);
            this.func_70099_a(drop, 0.0f);
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (this.isFake) {
            this.func_70606_j(0.0f);
            return true;
        }
        return super.func_70097_a(damageSource, damage);
    }

    protected boolean func_70825_j(double x, double y, double z) {
        EntityMirageEnderman mirage = null;
        double xI = 0.0;
        double yI = 0.0;
        double zI = 0.0;
        if (!this.isFake && this.field_70789_a != null) {
            mirage = new EntityMirageEnderman(this.field_70170_p);
            mirage.setFake();
            mirage.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e());
            mirage.func_70606_j(this.func_110143_aJ());
            mirage.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            mirage.func_70784_b(this.field_70789_a);
            xI = this.field_70165_t;
            yI = this.field_70163_u;
            zI = this.field_70161_v;
        }
        if (super.func_70825_j(x, y, z)) {
            if (mirage != null) {
                if (this.field_70146_Z.nextInt(2) == 0) {
                    mirage.func_70107_b(x, y, z);
                    this.func_70107_b(xI, yI, zI);
                }
                this.field_70170_p.func_72838_d((Entity)mirage);
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74757_a("IsFake", this.isFake);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_74767_n("IsFake")) {
            this.setFake();
        } else if (tag.func_74767_n("IsFake")) {
            this.setFake();
        }
    }
}

