/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs;

import java.util.ArrayList;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.SpecialMobData;

public class DataWatcherHelper {
    public static final byte MAX_KEYS = 32;
    public static DataWatcherHelper instance;
    public final EntityDataRoot GENERIC = new EntityDataRoot("specialmob", 0, 1, 6, 7, 8, 9, 10, 11).needs(1);
    public final EntityData BLAZE = new EntityData("blaze", this.GENERIC, 16);
    public final EntityData CAVE_SPIDER = new EntityData("cavespider", this.GENERIC, new int[0]);
    public final EntityData CREEPER = new EntityData("creeper", this.GENERIC, 16, 17, 18).needs(1);
    public final EntityData ENDERMAN = new EntityData("enderman", this.GENERIC, 16, 17, 18);
    public final EntityData GHAST = new EntityData("ghast", this.GENERIC, 16);
    public final EntityData PIG_ZOMBIE = new EntityData("pigzombie", this.GENERIC, new int[0]);
    public final EntityData SILVERFISH = new EntityData("silverfish", this.GENERIC, new int[0]);
    public final EntityData SKELETON = new EntityData("skeleton", this.GENERIC, 13).needs(1);
    public final EntityData SLIME = new EntityData("slime", this.GENERIC, 16);
    public final EntityData SPIDER = new EntityData("spider", this.GENERIC, 16);
    public final EntityData WITCH = new EntityData("witch", this.GENERIC, 21);
    public final EntityData ZOMBIE = new EntityData("zombie", this.GENERIC, 12, 13, 14);
    public final EntityData PIG_ZOMBIE_FISHING = new EntityData("pigzombie-fishing", this.PIG_ZOMBIE, new int[0]).needs(1);
    public final EntityData SKELETON_NINJA = new EntityData("skeleton-ninja", this.SKELETON, new int[0]).needs(3);
    public final EntityData ZOMBIE_FISHING = new EntityData("zombie-fishing", this.ZOMBIE, new int[0]).needs(1);

    public static void init() {
        instance = new DataWatcherHelper();
        DataWatcherHelper.instance.GENERIC.init();
        SpecialMobData.init();
    }

    public static void verify() {
        DataWatcherHelper.instance.GENERIC.verify();
        instance = null;
    }

    public static class EntityData {
        private final String id;
        private final EntityData parent;
        private final ArrayList<EntityData> children = new ArrayList();
        private final int initialKeysUsed;
        private int keysUsed;
        private byte[] autoKeys;
        private byte autoKeyIndex = 0;

        public EntityData(String id, EntityData parent, int ... initialKeys) {
            this.id = id;
            if (parent == null) {
                throw new IllegalArgumentException("Error in " + this.id + " - Parent must be non-null!");
            }
            this.parent = parent;
            parent.children.add(this);
            this.keysUsed = parent.initialKeysUsed;
            this.addKeys(initialKeys);
            this.initialKeysUsed = this.keysUsed;
        }

        public byte nextKey() {
            byte by = this.autoKeyIndex;
            this.autoKeyIndex = (byte)(by + 1);
            return this.autoKeys[by];
        }

        public EntityData needs(int keys) {
            this.autoKeys = new byte[keys];
            return this;
        }

        protected EntityData(String id, int ... initialKeys) {
            this.id = id;
            this.parent = null;
            this.keysUsed = 0;
            this.addKeys(initialKeys);
            this.initialKeysUsed = this.keysUsed;
        }

        private void addKeys(int ... newKeys) {
            if (this.parent != null) {
                this.parent.addKeys(newKeys);
            }
            for (int key : newKeys) {
                this.keysUsed = this.addKey(this.keysUsed, (byte)key);
            }
        }

        protected void generateNeededKeys(int newKeys) {
            this.keysUsed |= newKeys;
            if (this.autoKeys != null) {
                int index = 0;
                for (byte key = 0; index < this.autoKeys.length && key < 32; key = (byte)(key + 1)) {
                    if (!this.isKeyUnused(key)) continue;
                    newKeys = this.addKey(newKeys, key);
                    this.autoKeys[index++] = key;
                }
                if (index < this.autoKeys.length) {
                    _SpecialMobs.debugException("Not enough data watcher keys available for " + this.id + "! (" + (this.autoKeys.length - index) + " more needed)");
                }
                this.keysUsed |= newKeys;
            }
            for (EntityData child : this.children) {
                child.generateNeededKeys(newKeys);
            }
        }

        private boolean isKeyUnused(byte key) {
            return (this.keysUsed & 1 << key) == 0;
        }

        private int addKey(int keys, byte newKey) {
            return keys | 1 << newKey;
        }

        protected void verifyNeededKeys() {
            if (this.autoKeys != null && this.autoKeyIndex < this.autoKeys.length) {
                _SpecialMobs.debugException("Too many data watcher keys requested for " + this.id + "! (" + (this.autoKeys.length - this.autoKeyIndex) + " extras)");
            }
            for (EntityData child : this.children) {
                child.verifyNeededKeys();
            }
        }
    }

    public static class EntityDataRoot
    extends EntityData {
        public EntityDataRoot(String id, int ... initialKeys) {
            super(id + "(root)", initialKeys);
        }

        @Override
        public EntityDataRoot needs(int keys) {
            super.needs(keys);
            return this;
        }

        public void init() {
            this.generateNeededKeys(0);
        }

        public void verify() {
            this.verifyNeededKeys();
        }
    }
}

