/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.util;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import li.cil.oc.util.GameTimeFormatter;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GameTimeFormatter$ {
    public static final GameTimeFormatter$ MODULE$;
    private final String[] li$cil$oc$util$GameTimeFormatter$$weekDays;
    private final String[] li$cil$oc$util$GameTimeFormatter$$shortWeekDays;
    private final String[] li$cil$oc$util$GameTimeFormatter$$months;
    private final String[] li$cil$oc$util$GameTimeFormatter$$shortMonths;
    private final String[] li$cil$oc$util$GameTimeFormatter$$amPm;
    private final Map<Object, Function1<GameTimeFormatter.DateTime, String>> specifiers;

    static {
        new GameTimeFormatter$();
    }

    public String[] li$cil$oc$util$GameTimeFormatter$$weekDays() {
        return this.li$cil$oc$util$GameTimeFormatter$$weekDays;
    }

    public String[] li$cil$oc$util$GameTimeFormatter$$shortWeekDays() {
        return this.li$cil$oc$util$GameTimeFormatter$$shortWeekDays;
    }

    public String[] li$cil$oc$util$GameTimeFormatter$$months() {
        return this.li$cil$oc$util$GameTimeFormatter$$months;
    }

    public String[] li$cil$oc$util$GameTimeFormatter$$shortMonths() {
        return this.li$cil$oc$util$GameTimeFormatter$$shortMonths;
    }

    public String[] li$cil$oc$util$GameTimeFormatter$$amPm() {
        return this.li$cil$oc$util$GameTimeFormatter$$amPm;
    }

    private Map<Object, Function1<GameTimeFormatter.DateTime, String>> specifiers() {
        return this.specifiers;
    }

    public GameTimeFormatter.DateTime parse(double time) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis((long)(time * (double)1000));
        return new GameTimeFormatter.DateTime(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(7), calendar.get(6), calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public String format(String format2, GameTimeFormatter.DateTime time) {
        StringBuilder result2 = new StringBuilder();
        Iterator iterator = new StringOps(Predef$.MODULE$.augmentString(format2)).iterator();
        while (iterator.hasNext()) {
            char c = BoxesRunTime.unboxToChar((Object)iterator.next());
            switch (c) {
                case '%': {
                    StringBuilder stringBuilder;
                    if (iterator.hasNext()) {
                        BoxedUnit boxedUnit;
                        Option option = this.specifiers().get(iterator.next());
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Function1 specifier = (Function1)some.x();
                            boxedUnit = result2.append((String)specifier.apply((Object)time));
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        stringBuilder = boxedUnit;
                        break;
                    }
                }
                default: {
                    StringBuilder stringBuilder = result2.append(c);
                }
            }
        }
        return result2.toString();
    }

    public Option<Object> mktime(int year, int mon, int mday, int hour, int min2, int sec) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.set(1, year);
        calendar.set(2, mon - 1);
        calendar.set(5, mday);
        calendar.set(11, hour);
        calendar.set(12, min2);
        calendar.set(13, sec);
        return Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)(calendar.getTimeInMillis() / 1000L))));
    }

    private GameTimeFormatter$() {
        MODULE$ = this;
        this.li$cil$oc$util$GameTimeFormatter$$weekDays = (String[])((Object[])new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"});
        this.li$cil$oc$util$GameTimeFormatter$$shortWeekDays = (String[])((Object[])new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"});
        this.li$cil$oc$util$GameTimeFormatter$$months = (String[])((Object[])new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"});
        this.li$cil$oc$util$GameTimeFormatter$$shortMonths = (String[])((Object[])new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"});
        this.li$cil$oc$util$GameTimeFormatter$$amPm = (String[])((Object[])new String[]{"AM", "PM"});
        this.specifiers = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'a')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                return GameTimeFormatter$.MODULE$.li$cil$oc$util$GameTimeFormatter$$shortWeekDays()[t.weekDay() - 1];
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'A')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                return GameTimeFormatter$.MODULE$.li$cil$oc$util$GameTimeFormatter$$weekDays()[t.weekDay() - 1];
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'b')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                return GameTimeFormatter$.MODULE$.li$cil$oc$util$GameTimeFormatter$$shortMonths()[t.month() - 1];
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'B')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                return GameTimeFormatter$.MODULE$.li$cil$oc$util$GameTimeFormatter$$months()[t.month() - 1];
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'c')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                return GameTimeFormatter$.MODULE$.format("%a %b %e %H:%M:%S %Y", t);
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'C')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                int arg$macro$14 = t.year() / 100;
                return new StringOps("%02d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$14)}));
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'d')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                int arg$macro$15 = t.day();
                return new StringOps("%02d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$15)}));
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'D')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                return GameTimeFormatter$.MODULE$.format("%m/%d/%y", t);
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'e')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                int arg$macro$16 = t.day();
                return new StringOps("%2d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$16)}));
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'F')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                return GameTimeFormatter$.MODULE$.format("%Y-%m-%d", t);
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'h')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                return GameTimeFormatter$.MODULE$.format("%b", t);
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'H')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                int arg$macro$17 = t.hour();
                return new StringOps("%02d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$17)}));
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'I')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                int arg$macro$18 = (t.hour() + 11) % 12 + 1;
                return new StringOps("%02d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$18)}));
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'j')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                int arg$macro$19 = t.yearDay();
                return new StringOps("%03d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$19)}));
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'m')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                int arg$macro$20 = t.month();
                return new StringOps("%02d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$20)}));
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'M')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                int arg$macro$21 = t.minute();
                return new StringOps("%02d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$21)}));
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'n')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                return "\n";
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'p')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                return GameTimeFormatter$.MODULE$.li$cil$oc$util$GameTimeFormatter$$amPm()[t.hour() < 12 ? 0 : 1];
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'r')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                return GameTimeFormatter$.MODULE$.format("%I:%M:%S %p", t);
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'R')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                return GameTimeFormatter$.MODULE$.format("%H:%M", t);
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'S')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                int arg$macro$22 = t.second();
                return new StringOps("%02d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$22)}));
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'t')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                return "\t";
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'T')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                return GameTimeFormatter$.MODULE$.format("%H:%M:%S", t);
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'w')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(t.weekDay() - 1))}));
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'x')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                return GameTimeFormatter$.MODULE$.format("%D", t);
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'X')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                return GameTimeFormatter$.MODULE$.format("%T", t);
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'y')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                int arg$macro$23 = t.year() % 100;
                return new StringOps("%02d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$23)}));
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'Y')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                int arg$macro$24 = t.year();
                return new StringOps("%04d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$24)}));
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'%')), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GameTimeFormatter.DateTime t) {
                return "%";
            }
        })}));
    }
}

