/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx;

import java.awt.GraphicsEnvironment;
import java.util.concurrent.atomic.AtomicBoolean;
import me.eigenraven.lwjgl3ify.client.MainThreadExec;
import me.eigenraven.lwjgl3ify.core.Config;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.Version;
import org.lwjgl.sdl.SDLClipboard;
import org.lwjgl.sdl.SDLHints;
import org.lwjgl.sdl.SDLInit;
import org.lwjgl.sdl.SDLMessageBox;
import org.lwjgl.sdl.SDLMisc;
import org.lwjgl.sdl.SDLStdinc;
import org.lwjgl.sdl.SDLTimer;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Pointer;
import org.lwjglx.SDLException;
import org.lwjglx.opengl.Display;

public class Sys {
    private static final AtomicBoolean isFirstInit = new AtomicBoolean(true);

    private static void firstTimeInit() {
        Configuration.OPENGL_EXPLICIT_INIT.set((Object)true);
        Configuration.HARFBUZZ_LIBRARY_NAME.set((Object)"freetype");
        if (Platform.get() == Platform.MACOSX && !GraphicsEnvironment.isHeadless()) {
            throw new IllegalStateException("java.awt.headless must be set to true on macOS, this is normally set by RFB!");
        }
        MainThreadExec.ensureInitialised();
        MainThreadExec.runOnMainThread(() -> {
            SDLStdinc.SDL_SetMemoryFunctions(MemoryUtil::nmemAllocChecked, MemoryUtil::nmemCallocChecked, MemoryUtil::nmemReallocChecked, MemoryUtil::nmemFree);
            Sys.checkSdl(SDLInit.SDL_SetAppMetadata((CharSequence)"Lwjgl3ify Minecraft", (CharSequence)"1.7.10", (CharSequence)Config.APP_ID));
            Sys.checkSdl(SDLInit.SDL_SetAppMetadataProperty((CharSequence)"SDL.app.metadata.url", (CharSequence)"https://github.com/GTNewHorizons/lwjgl3ify"));
            Sys.checkSdl(SDLInit.SDL_SetAppMetadataProperty((CharSequence)"SDL.app.metadata.creator", (CharSequence)"Mojang, GTNH Team"));
            Sys.checkSdl(SDLInit.SDL_SetAppMetadataProperty((CharSequence)"SDL.app.metadata.copyright", (CharSequence)"https://www.minecraft.net/en-us/eula"));
            Sys.checkSdl(SDLInit.SDL_SetAppMetadataProperty((CharSequence)"SDL.app.metadata.type", (CharSequence)"game"));
            if (!SDLInit.SDL_Init((int)61984)) {
                throw new SDLException("Could not initialize SDL.");
            }
            if (Platform.get() == Platform.MACOSX) {
                SDLHints.SDL_SetHint((CharSequence)"SDL_MAC_OPENGL_ASYNC_DISPATCH", (CharSequence)"1");
            }
        });
    }

    public static void initialize() {
        if (!isFirstInit.compareAndSet(true, false)) {
            return;
        }
        Sys.firstTimeInit();
    }

    public static String getVersion() {
        return Version.getVersion();
    }

    public static long getTimerResolution() {
        return 1000000L;
    }

    public static long getTime() {
        return SDLTimer.SDL_GetTicksNS() / 1000L;
    }

    public static long getNanoTime() {
        return SDLTimer.SDL_GetTicksNS();
    }

    public static boolean openURL(String url) {
        return MainThreadExec.runOnMainThread(() -> SDLMisc.SDL_OpenURL((CharSequence)url));
    }

    public static void alert(String title, String message) {
        MainThreadExec.runOnMainThread(() -> SDLMessageBox.SDL_ShowSimpleMessageBox((int)32, (CharSequence)title, (CharSequence)message, (long)Display.getWindow()));
    }

    public static boolean is64Bit() {
        return Pointer.BITS64;
    }

    public static String getClipboard() {
        return MainThreadExec.runOnMainThread(SDLClipboard::SDL_GetClipboardText);
    }

    public static void checkSdl(boolean result) {
        if (!result) {
            throw new SDLException();
        }
    }

    @NotNull
    public static <T> T checkSdl(@Nullable T result) {
        if (result == null) {
            throw new SDLException();
        }
        return result;
    }

    public static int checkSdl(int result) {
        if ((long)result == 0L) {
            throw new SDLException();
        }
        return result;
    }

    public static long checkSdl(long result) {
        if (result == 0L) {
            throw new SDLException();
        }
        return result;
    }
}

