/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.relauncher;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.launchwrapper.Launch;

public class RelauncherConfig {
    public static ConfigObject config = new ConfigObject();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static void load() {
        Path gamePath = Launch.minecraftHome == null ? Paths.get(".", new String[0]) : Launch.minecraftHome.toPath();
        Path earlyConfigPath = gamePath.resolve("config").resolve("lwjgl3ify-relauncher.json");
        if (Files.exists(earlyConfigPath, new LinkOption[0])) {
            try {
                String configContents = new String(Files.readAllBytes(earlyConfigPath), StandardCharsets.UTF_8);
                config = (ConfigObject)gson.fromJson(configContents, ConfigObject.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (RelauncherConfig.config.javaInstallationsCache.length > 0) {
            RelauncherConfig.config.javaInstallation = Math.max(0, Math.min(RelauncherConfig.config.javaInstallation, RelauncherConfig.config.javaInstallationsCache.length - 1));
        }
        RelauncherConfig.save();
    }

    public static void save() {
        Path gamePath = Launch.minecraftHome == null ? Paths.get(".", new String[0]) : Launch.minecraftHome.toPath();
        Path earlyConfigPath = gamePath.resolve("config").resolve("lwjgl3ify-relauncher.json");
        String jsonCfg = gson.toJson((Object)config);
        try {
            if (!Files.isDirectory(earlyConfigPath.getParent(), new LinkOption[0])) {
                Files.createDirectories(earlyConfigPath.getParent(), new FileAttribute[0]);
            }
            Files.write(earlyConfigPath, jsonCfg.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ConfigObject {
        public String[] javaInstallationsCache = new String[0];
        public int javaInstallation = 0;
        public int minMemoryMB = 512;
        public int maxMemoryMB = 4096;
        public GCOption garbageCollector = GCOption.G1GC;
        public String[] customOptions = new String[0];
        public boolean hideSettingsOnLaunch = false;
        public boolean forwardLogs = false;
        public boolean allowDebugger = false;
        public boolean waitForDebugger = false;
        public boolean mixinDebug = false;
        public boolean mixinDebugExport = false;
        public boolean mixinDebugCount = false;
        public boolean fmlDebugAts = false;
        public boolean rfbDumpClasses = false;
        public boolean rfbDumpPerTransformer = false;

        public void setCustomOptionsFromQuotedString(String input) {
            ArrayList<String> tokens = new ArrayList<String>();
            StringBuilder tokenBuilder = new StringBuilder();
            boolean inQuotes = false;
            for (int i = 0; i < input.length(); ++i) {
                char peek;
                char c = input.charAt(i);
                char c2 = peek = i == input.length() - 1 ? (char)'\u0000' : input.charAt(i + 1);
                if (!inQuotes && Character.isWhitespace(c)) {
                    if (tokenBuilder.length() == 0) continue;
                    tokens.add(tokenBuilder.toString());
                    tokenBuilder.delete(0, tokenBuilder.length());
                    continue;
                }
                if (c == '\\' && peek != '\u0000') {
                    tokenBuilder.append(peek);
                    ++i;
                    continue;
                }
                if (c == '\"') {
                    inQuotes = !inQuotes;
                    continue;
                }
                tokenBuilder.append(c);
            }
            if (tokenBuilder.length() != 0) {
                tokens.add(tokenBuilder.toString());
                tokenBuilder.delete(0, tokenBuilder.length());
            }
            this.customOptions = tokens.toArray(new String[0]);
        }

        public String customOptionsToQuotedString() {
            StringBuilder out = new StringBuilder();
            for (String arg : this.customOptions) {
                String escaped = arg.replace("\\", "\\\\").replace("\"", "\\\"");
                if (escaped.chars().anyMatch(Character::isWhitespace)) {
                    out.append('\"');
                    out.append(escaped);
                    out.append('\"');
                } else {
                    out.append(escaped);
                }
                out.append('\n');
            }
            return out.toString();
        }

        public List<String> toJvmArgs() {
            ArrayList<String> out = new ArrayList<String>();
            if (this.minMemoryMB > 0) {
                out.add("-Xms" + this.minMemoryMB + "M");
            }
            if (this.maxMemoryMB > 0) {
                out.add("-Xmx" + this.maxMemoryMB + "M");
            }
            out.addAll(Arrays.asList(this.garbageCollector.FLAGS));
            if (this.allowDebugger) {
                out.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=" + (this.waitForDebugger ? (char)'y' : 'n') + ",address=5005");
            }
            if (this.mixinDebug) {
                out.add("-Dmixin.debug=true");
            }
            if (this.mixinDebugExport) {
                out.add("-Dmixin.debug.export=true");
            }
            if (this.mixinDebugCount) {
                out.add("-Dmixin.debug.countInjections=true");
            }
            if (this.fmlDebugAts) {
                out.add("-Dfml.debugAccessTransformer=true");
            }
            if (this.rfbDumpClasses) {
                out.add("-Drfb.dumpLoadedClasses=true");
            }
            if (this.rfbDumpPerTransformer) {
                out.add("-Drfb.dumpLoadedClassesPerTransformer=true");
            }
            for (String arg : this.customOptions) {
                if (arg == null || arg.trim().isEmpty()) continue;
                out.add(arg.trim());
            }
            return out;
        }
    }

    public static enum GCOption {
        G1GC(new String[]{"-XX:+UseG1GC"}),
        ZGC(new String[]{"-XX:+UseZGC"}),
        Shenandoah(new String[]{"-XX:+UseShenandoahGC"}),
        GenerationalZGC(new String[]{"-XX:+UseZGC", "-XX:+ZGenerational"}),
        Custom(new String[0]);

        public final String[] FLAGS;

        private GCOption(String[] flags) {
            this.FLAGS = flags;
        }
    }
}

