/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.client;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import me.eigenraven.lwjgl3ify.Lwjgl3ify;
import me.eigenraven.lwjgl3ify.api.InputEvents;
import me.eigenraven.lwjgl3ify.client.MainThreadExec;
import me.eigenraven.lwjgl3ify.core.Config;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.ChatAllowedCharacters;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.sdl.SDLClipboard;
import org.lwjgl.sdl.SDLKeyboard;
import org.lwjgl.system.MemoryUtil;
import org.lwjglx.opengl.Display;

public final class TextFieldHandler {
    private static int textInputDepth = 0;
    private static final WeakReference<GuiTextField> NULL_TEXT_FIELD = new WeakReference<Object>(null);
    private static WeakReference<GuiTextField> focusedTextInput = NULL_TEXT_FIELD;
    public static final StringBuilder textBuffer = new StringBuilder(8);

    public static void beginTextInput() {
        if (textInputDepth == Integer.MAX_VALUE) {
            return;
        }
        if (textInputDepth++ == 0) {
            if (Config.DEBUG_PRINT_KEY_EVENTS) {
                Lwjgl3ify.LOG.info("[DEBUG] Beginning text input");
            }
            MainThreadExec.runOnMainThread(() -> SDLKeyboard.SDL_StartTextInput((long)Display.getWindow()));
        }
    }

    public static void endTextInput(@Nullable GuiTextField textField) {
        if (textInputDepth <= 0) {
            return;
        }
        if (--textInputDepth == 0) {
            if (Config.DEBUG_PRINT_KEY_EVENTS) {
                Lwjgl3ify.LOG.info("[DEBUG] Stopping text input");
            }
            MainThreadExec.runOnMainThread(() -> SDLKeyboard.SDL_StopTextInput((long)Display.getWindow()));
        }
        if (textField != null && textField == focusedTextInput.get()) {
            focusedTextInput = NULL_TEXT_FIELD;
        }
    }

    public static void resetTextInput() {
        if (textInputDepth != 0) {
            if (Config.DEBUG_PRINT_KEY_EVENTS) {
                Lwjgl3ify.LOG.info("[DEBUG] Stopping text input (reset)");
            }
            MainThreadExec.runOnMainThread(() -> SDLKeyboard.SDL_StopTextInput((long)Display.getWindow()));
            textInputDepth = 0;
        }
        focusedTextInput = NULL_TEXT_FIELD;
    }

    public static void setFocusedTextField(GuiTextField textField) {
        if (focusedTextInput.get() != textField) {
            focusedTextInput = new WeakReference<GuiTextField>(textField);
        }
    }

    public static void onTextInput(InputEvents.TextEvent event) {
        GuiTextField textField = (GuiTextField)focusedTextInput.get();
        if (textInputDepth <= 0 || textField == null) {
            return;
        }
        if (event.text.chars().allMatch(chr -> ChatAllowedCharacters.func_71566_a((char)((char)chr)))) {
            textBuffer.append(event.text);
        }
    }

    public static String getClipboardText() {
        return MainThreadExec.runOnMainThread(SDLClipboard::SDL_GetClipboardText);
    }

    public static void setClipboardText(String newText) {
        boolean putOnStack;
        if (newText == null || newText.isEmpty()) {
            MainThreadExec.runOnMainThread(SDLClipboard::SDL_ClearClipboardData);
            return;
        }
        boolean bl = putOnStack = newText.length() < 1024;
        if (putOnStack) {
            MainThreadExec.runOnMainThread(() -> SDLClipboard.SDL_SetClipboardText((CharSequence)newText));
            return;
        }
        ByteBuffer nativeText = MemoryUtil.memUTF8((CharSequence)newText, (boolean)true);
        try {
            MainThreadExec.runOnMainThread(() -> SDLClipboard.SDL_SetClipboardText((ByteBuffer)nativeText));
        }
        finally {
            MemoryUtil.memFree((ByteBuffer)nativeText);
        }
    }
}

