/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lumi.internal.world;

import com.falsepattern.lumi.api.world.LumiWorld;
import com.falsepattern.lumi.api.world.LumiWorldProvider;
import com.falsepattern.lumi.api.world.LumiWorldProviderRegistry;
import com.falsepattern.lumi.internal.Lumi;
import com.falsepattern.lumi.internal.LumiDefaultValues;
import com.falsepattern.lumi.internal.event.EventPoster;
import com.falsepattern.lumi.internal.mixin.interfaces.LumiWorldRootCache;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.world.World;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WorldProviderManager
implements LumiWorldProviderRegistry {
    private static final Logger LOG = Lumi.createLogger("World Provider Manager");
    private static final WorldProviderManager INSTANCE = new WorldProviderManager();
    private final List<LumiWorldProvider> worldProviders = new ArrayList<LumiWorldProvider>();
    private boolean isRegistered = false;
    private boolean isHijacked = false;
    @Nullable
    private String hijackingMod = null;
    private static final LumiWorld[] NULL_ARR = new LumiWorld[0];

    public static WorldProviderManager worldProviderManager() {
        return INSTANCE;
    }

    public void registerWorldProviders() {
        if (this.isRegistered) {
            return;
        }
        EventPoster.postLumiWorldProviderRegistrationEvent(this);
        if (this.isHijacked && this.worldProviders.isEmpty()) {
            LOG.error("Default world providers have been hijacked by [{}], but it did not provide it's own replacements. The hijacked state has been reset, but things may not work correctly. God speed.", new Object[]{this.hijackingMod});
            this.isHijacked = false;
        }
        if (!this.isHijacked) {
            LumiDefaultValues.registerDefaultWorldProvider(this);
        }
        this.isRegistered = true;
    }

    @Override
    public void hijackDefaultWorldProviders(@NotNull String modName) {
        if (this.isRegistered) {
            LOG.error("Cannot hijack default world providers post registration", (Throwable)new IllegalStateException());
            return;
        }
        if (this.isHijacked) {
            LOG.warn("Default world providers has already been hijacked by: [{}], but {} has tried to hijack it again. Things will probably work fine.", new Object[]{this.hijackingMod, modName});
            return;
        }
        if (modName != null) {
            this.hijackingMod = modName;
            LOG.info("Default world providers have been hijacked by: [{}]", new Object[]{modName});
        } else {
            this.hijackingMod = "UNKNOWN MOD";
            LOG.error("A mod attempted to hijack the default world providers, but didn't provider did not name itself. The hijack *was* performed, and things should be fine. But please report this.", (Throwable)new IllegalArgumentException());
        }
        this.isHijacked = true;
    }

    @Override
    public void registerWorldProvider(@NotNull LumiWorldProvider worldProvider) {
        if (this.isRegistered) {
            LOG.error("Cannot registration world providers post registration", (Throwable)new IllegalStateException());
            return;
        }
        if (worldProvider == null) {
            LOG.error("World provider can't be null", (Throwable)new IllegalArgumentException());
            return;
        }
        String worldProviderID = worldProvider.worldProviderID();
        if (worldProviderID == null) {
            LOG.error("World provider id can't be null", (Throwable)new IllegalArgumentException());
            return;
        }
        if (worldProviderID.isEmpty()) {
            LOG.error("World provider id can't be empty", (Throwable)new IllegalArgumentException());
            return;
        }
        if (this.worldProviders.contains(worldProvider)) {
            LOG.error(String.format("World provider [%s] already registered", worldProviderID), (Throwable)new IllegalArgumentException());
            return;
        }
        LOG.info("Registered world provider: [{}]", new Object[]{worldProviderID});
        this.worldProviders.add(worldProvider);
    }

    @NotNull
    public LumiWorld[] lumiWorldsFromBaseWorld(@Nullable World worldBase) {
        if (!this.isRegistered) {
            LOG.error("No world providers exist during registration, an empty iterable will be returned.", (Throwable)new IllegalStateException());
            return NULL_ARR;
        }
        if (worldBase == null) {
            return NULL_ARR;
        }
        LumiWorld[] worlds = ((LumiWorldRootCache)worldBase).lumi$getLumiWorlds();
        if (worlds == null) {
            worlds = this.collectProvidedWorlds(worldBase);
            ((LumiWorldRootCache)worldBase).lumi$setLumiWorlds(worlds);
        }
        return worlds;
    }

    @Nullable
    public LumiWorldProvider getWorldProviderByInternalID(int internalWorldProviderID) {
        if (internalWorldProviderID >= 0 && internalWorldProviderID < this.worldProviders.size()) {
            return this.worldProviders.get(internalWorldProviderID);
        }
        return null;
    }

    public int worldProviderCount() {
        return this.worldProviders.size();
    }

    private LumiWorld[] collectProvidedWorlds(World worldBase) {
        ArrayList<LumiWorld> worldList = new ArrayList<LumiWorld>();
        int worldProvidersSize = this.worldProviders.size();
        for (int i = 0; i < worldProvidersSize; ++i) {
            LumiWorldProvider worldProvider = this.worldProviders.get(i);
            LumiWorld lumiWorld = worldProvider.provideWorld(worldBase);
            if (lumiWorld == null) continue;
            worldList.add(lumiWorld);
        }
        return worldList.toArray(new LumiWorld[0]);
    }

    @Generated
    private WorldProviderManager() {
    }
}

